/*
 * Decompiled with CFR 0.152.
 */
package android.net.http;

import android.net.http.Connection;
import android.os.Process;
import android.os.SystemClock;
import org.apache.http.HttpHost;

class IdleCache {
    private static final int CHECK_INTERVAL = 2000;
    private static final int EMPTY_CHECK_MAX = 5;
    private static final int IDLE_CACHE_MAX = 8;
    private static final int TIMEOUT = 6000;
    private int mCached = 0;
    private int mCount = 0;
    private Entry[] mEntries = new Entry[8];
    private int mReused = 0;
    private IdleReaper mThread = null;

    IdleCache() {
        for (int i = 0; i < 8; ++i) {
            this.mEntries[i] = new Entry();
        }
    }

    static /* synthetic */ IdleReaper access$302(IdleCache idleCache, IdleReaper idleReaper) {
        idleCache.mThread = idleReaper;
        return idleReaper;
    }

    private void clearIdle() {
        synchronized (this) {
            block5: {
                if (this.mCount <= 0) break block5;
                long l = SystemClock.uptimeMillis();
                for (int i = 0; i < 8; ++i) {
                    Entry entry = this.mEntries[i];
                    if (entry.mHost == null || l <= entry.mTimeout) continue;
                    entry.mHost = null;
                    entry.mConnection.closeConnection();
                    entry.mConnection = null;
                    this.mCount = -1 + this.mCount;
                    continue;
                }
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean cacheConnection(HttpHost httpHost, Connection connection) {
        synchronized (this) {
            int n = this.mCount;
            boolean bl = false;
            if (n < 8) {
                long l = SystemClock.uptimeMillis();
                int n2 = 0;
                while (true) {
                    bl = false;
                    if (n2 >= 8) break;
                    Entry entry = this.mEntries[n2];
                    if (entry.mHost == null) {
                        entry.mHost = httpHost;
                        entry.mConnection = connection;
                        entry.mTimeout = 6000L + l;
                        this.mCount = 1 + this.mCount;
                        bl = true;
                        if (this.mThread != null) break;
                        this.mThread = new IdleReaper();
                        this.mThread.start();
                        break;
                    }
                    ++n2;
                }
            }
            return bl;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void clear() {
        synchronized (this) {
            for (int n = 0; this.mCount > 0 && n < 8; ++n) {
                Entry entry = this.mEntries[n];
                if (entry.mHost == null) continue;
                entry.mHost = null;
                entry.mConnection.closeConnection();
                entry.mConnection = null;
                this.mCount = -1 + this.mCount;
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    Connection getConnection(HttpHost httpHost) {
        synchronized (this) {
            int n = this.mCount;
            Connection connection = null;
            if (n > 0) {
                int n2 = 0;
                while (true) {
                    connection = null;
                    if (n2 >= 8) break;
                    Entry entry = this.mEntries[n2];
                    HttpHost httpHost2 = entry.mHost;
                    if (httpHost2 != null && httpHost2.equals(httpHost)) {
                        connection = entry.mConnection;
                        entry.mHost = null;
                        entry.mConnection = null;
                        this.mCount = -1 + this.mCount;
                        break;
                    }
                    ++n2;
                }
            }
            return connection;
        }
    }

    class Entry {
        Connection mConnection;
        HttpHost mHost;
        long mTimeout;

        Entry() {
        }
    }

    private class IdleReaper
    extends Thread {
        private IdleReaper() {
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            int n = 0;
            this.setName("IdleReaper");
            Process.setThreadPriority(10);
            IdleCache idleCache = IdleCache.this;
            synchronized (idleCache) {
                while (true) {
                    if (n >= 5) {
                        IdleCache.access$302(IdleCache.this, null);
                        return;
                    }
                    try {
                        IdleCache.this.wait(2000L);
                    }
                    catch (InterruptedException interruptedException) {}
                    if (IdleCache.this.mCount == 0) {
                        ++n;
                        continue;
                    }
                    IdleCache.this.clearIdle();
                    n = 0;
                }
            }
        }
    }
}

