/*
 * Decompiled with CFR 0.152.
 */
package android.net.http;

import android.content.Context;
import android.os.Bundle;
import android.text.format.DateFormat;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.TextView;
import com.android.org.bouncycastle.asn1.x509.X509Name;
import java.io.ByteArrayInputStream;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Vector;

public class SslCertificate {
    private static String ISO_8601_DATE_FORMAT = "yyyy-MM-dd HH:mm:ssZ";
    private static final String ISSUED_BY = "issued-by";
    private static final String ISSUED_TO = "issued-to";
    private static final String VALID_NOT_AFTER = "valid-not-after";
    private static final String VALID_NOT_BEFORE = "valid-not-before";
    private static final String X509_CERTIFICATE = "x509-certificate";
    private final DName mIssuedBy;
    private final DName mIssuedTo;
    private final Date mValidNotAfter;
    private final Date mValidNotBefore;
    private final X509Certificate mX509Certificate;

    @Deprecated
    public SslCertificate(String string2, String string3, String string4, String string5) {
        this(string2, string3, SslCertificate.parseDate(string4), SslCertificate.parseDate(string5), null);
    }

    @Deprecated
    public SslCertificate(String string2, String string3, Date date, Date date2) {
        this(string2, string3, date, date2, null);
    }

    private SslCertificate(String string2, String string3, Date date, Date date2, X509Certificate x509Certificate) {
        this.mIssuedTo = new DName(string2);
        this.mIssuedBy = new DName(string3);
        this.mValidNotBefore = SslCertificate.cloneDate(date);
        this.mValidNotAfter = SslCertificate.cloneDate(date2);
        this.mX509Certificate = x509Certificate;
    }

    public SslCertificate(X509Certificate x509Certificate) {
        this(x509Certificate.getSubjectDN().getName(), x509Certificate.getIssuerDN().getName(), x509Certificate.getNotBefore(), x509Certificate.getNotAfter(), x509Certificate);
    }

    private static Date cloneDate(Date date) {
        if (date == null) {
            return null;
        }
        return (Date)date.clone();
    }

    private static final String fingerprint(byte[] byArray) {
        if (byArray == null) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < byArray.length; ++i) {
            IntegralToString.appendByteAsHex((StringBuilder)stringBuilder, (byte)byArray[i], (boolean)true);
            if (i + 1 == byArray.length) continue;
            stringBuilder.append(':');
        }
        return stringBuilder.toString();
    }

    private String formatCertificateDate(Context context, Date date) {
        if (date == null) {
            return "";
        }
        return DateFormat.getDateFormat(context).format(date);
    }

    private static String formatDate(Date date) {
        if (date == null) {
            return "";
        }
        return new SimpleDateFormat(ISO_8601_DATE_FORMAT).format(date);
    }

    private static String getDigest(X509Certificate x509Certificate, String string2) {
        if (x509Certificate == null) {
            return "";
        }
        try {
            byte[] byArray = x509Certificate.getEncoded();
            String string3 = SslCertificate.fingerprint(MessageDigest.getInstance(string2).digest(byArray));
            return string3;
        }
        catch (CertificateEncodingException certificateEncodingException) {
            return "";
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            return "";
        }
    }

    private static String getSerialNumber(X509Certificate x509Certificate) {
        if (x509Certificate == null) {
            return "";
        }
        BigInteger bigInteger = x509Certificate.getSerialNumber();
        if (bigInteger == null) {
            return "";
        }
        return SslCertificate.fingerprint(bigInteger.toByteArray());
    }

    private static Date parseDate(String string2) {
        try {
            Date date = new SimpleDateFormat(ISO_8601_DATE_FORMAT).parse(string2);
            return date;
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SslCertificate restoreState(Bundle bundle) {
        X509Certificate x509Certificate;
        if (bundle == null) {
            return null;
        }
        byte[] byArray = bundle.getByteArray(X509_CERTIFICATE);
        if (byArray == null) {
            x509Certificate = null;
            return new SslCertificate(bundle.getString(ISSUED_TO), bundle.getString(ISSUED_BY), SslCertificate.parseDate(bundle.getString(VALID_NOT_BEFORE)), SslCertificate.parseDate(bundle.getString(VALID_NOT_AFTER)), x509Certificate);
        }
        try {
            x509Certificate = (X509Certificate)CertificateFactory.getInstance("X.509").generateCertificate(new ByteArrayInputStream(byArray));
            return new SslCertificate(bundle.getString(ISSUED_TO), bundle.getString(ISSUED_BY), SslCertificate.parseDate(bundle.getString(VALID_NOT_BEFORE)), SslCertificate.parseDate(bundle.getString(VALID_NOT_AFTER)), x509Certificate);
        }
        catch (CertificateException certificateException) {
            x509Certificate = null;
            return new SslCertificate(bundle.getString(ISSUED_TO), bundle.getString(ISSUED_BY), SslCertificate.parseDate(bundle.getString(VALID_NOT_BEFORE)), SslCertificate.parseDate(bundle.getString(VALID_NOT_AFTER)), x509Certificate);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Bundle saveState(SslCertificate sslCertificate) {
        if (sslCertificate == null) {
            return null;
        }
        Bundle bundle = new Bundle();
        bundle.putString(ISSUED_TO, sslCertificate.getIssuedTo().getDName());
        bundle.putString(ISSUED_BY, sslCertificate.getIssuedBy().getDName());
        bundle.putString(VALID_NOT_BEFORE, sslCertificate.getValidNotBefore());
        bundle.putString(VALID_NOT_AFTER, sslCertificate.getValidNotAfter());
        X509Certificate x509Certificate = sslCertificate.mX509Certificate;
        if (x509Certificate == null) return bundle;
        try {
            bundle.putByteArray(X509_CERTIFICATE, x509Certificate.getEncoded());
            return bundle;
        }
        catch (CertificateEncodingException certificateEncodingException) {
            return bundle;
        }
    }

    public DName getIssuedBy() {
        return this.mIssuedBy;
    }

    public DName getIssuedTo() {
        return this.mIssuedTo;
    }

    @Deprecated
    public String getValidNotAfter() {
        return SslCertificate.formatDate(this.mValidNotAfter);
    }

    public Date getValidNotAfterDate() {
        return SslCertificate.cloneDate(this.mValidNotAfter);
    }

    @Deprecated
    public String getValidNotBefore() {
        return SslCertificate.formatDate(this.mValidNotBefore);
    }

    public Date getValidNotBeforeDate() {
        return SslCertificate.cloneDate(this.mValidNotBefore);
    }

    public View inflateCertificateView(Context context) {
        View view = LayoutInflater.from(context).inflate(17367273, null);
        DName dName = this.getIssuedTo();
        if (dName != null) {
            ((TextView)view.findViewById(16909252)).setText(dName.getCName());
            ((TextView)view.findViewById(16909254)).setText(dName.getOName());
            ((TextView)view.findViewById(16909256)).setText(dName.getUName());
        }
        ((TextView)view.findViewById(16909258)).setText(SslCertificate.getSerialNumber(this.mX509Certificate));
        DName dName2 = this.getIssuedBy();
        if (dName2 != null) {
            ((TextView)view.findViewById(16909260)).setText(dName2.getCName());
            ((TextView)view.findViewById(16909262)).setText(dName2.getOName());
            ((TextView)view.findViewById(16909264)).setText(dName2.getUName());
        }
        String string2 = this.formatCertificateDate(context, this.getValidNotBeforeDate());
        ((TextView)view.findViewById(16909267)).setText(string2);
        String string3 = this.formatCertificateDate(context, this.getValidNotAfterDate());
        ((TextView)view.findViewById(16909269)).setText(string3);
        ((TextView)view.findViewById(16909272)).setText(SslCertificate.getDigest(this.mX509Certificate, "SHA256"));
        ((TextView)view.findViewById(16909274)).setText(SslCertificate.getDigest(this.mX509Certificate, "SHA1"));
        return view;
    }

    public String toString() {
        return "Issued to: " + this.mIssuedTo.getDName() + ";\n" + "Issued by: " + this.mIssuedBy.getDName() + ";\n";
    }

    public class DName {
        private String mCName;
        private String mDName;
        private String mOName;
        private String mUName;

        public DName(String string2) {
            if (string2 != null) {
                int n;
                Vector vector;
                Vector vector2;
                this.mDName = string2;
                try {
                    X509Name x509Name = new X509Name(string2);
                    vector2 = x509Name.getValues();
                    vector = x509Name.getOIDs();
                    n = 0;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
                while (true) {
                    if (n < vector.size()) {
                        if (vector.elementAt(n).equals(X509Name.CN)) {
                            if (this.mCName == null) {
                                this.mCName = (String)vector2.elementAt(n);
                            }
                        } else if (vector.elementAt(n).equals(X509Name.O) && this.mOName == null) {
                            this.mOName = (String)vector2.elementAt(n);
                        } else if (vector.elementAt(n).equals(X509Name.OU) && this.mUName == null) {
                            this.mUName = (String)vector2.elementAt(n);
                        }
                        ++n;
                        continue;
                    }
                    break;
                }
            }
        }

        public String getCName() {
            if (this.mCName != null) {
                return this.mCName;
            }
            return "";
        }

        public String getDName() {
            if (this.mDName != null) {
                return this.mDName;
            }
            return "";
        }

        public String getOName() {
            if (this.mOName != null) {
                return this.mOName;
            }
            return "";
        }

        public String getUName() {
            if (this.mUName != null) {
                return this.mUName;
            }
            return "";
        }
    }
}

