/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi;

import android.content.Context;
import android.net.DhcpInfo;
import android.net.wifi.BatchedScanResult;
import android.net.wifi.BatchedScanSettings;
import android.net.wifi.IWifiManager;
import android.net.wifi.RssiPacketCountInfo;
import android.net.wifi.ScanResult;
import android.net.wifi.ScanSettings;
import android.net.wifi.WifiActivityEnergyInfo;
import android.net.wifi.WifiChannel;
import android.net.wifi.WifiConfiguration;
import android.net.wifi.WifiConnectionStatistics;
import android.net.wifi.WifiInfo;
import android.net.wifi.WpsInfo;
import android.net.wifi.WpsResult;
import android.os.Binder;
import android.os.Build;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.Messenger;
import android.os.RemoteException;
import android.os.WorkSource;
import android.util.Log;
import android.util.SparseArray;
import com.android.internal.util.AsyncChannel;
import com.asus.cta.CtaChecker;
import java.net.InetAddress;
import java.util.List;
import java.util.concurrent.CountDownLatch;

public class WifiManager {
    public static final String ACTION_DISMISS_WIFI_AP_SWITCH_DIALOG = "com.asus.wifi.dismissapswitchdialog";
    public static final String ACTION_DISMISS_WIFI_DECISION_DIALOG = "com.asus.wifi.dismissdecisiondialog";
    public static final String ACTION_PICK_WIFI_NETWORK = "android.net.wifi.PICK_WIFI_NETWORK";
    public static final String ACTION_REQUEST_SCAN_ALWAYS_AVAILABLE = "android.net.wifi.action.REQUEST_SCAN_ALWAYS_AVAILABLE";
    public static final String ACTION_WIFI_AP_SWITCH_DIALOG = "com.asus.wifi.apswitchdialog";
    public static final String ACTION_WIFI_DECISION_DIALOG = "com.asus.wifi.decisiondialog";
    private static final int BASE = 151552;
    public static final String BATCHED_SCAN_RESULTS_AVAILABLE_ACTION = "android.net.wifi.BATCHED_RESULTS";
    public static final int BUSY = 2;
    public static final int CANCEL_WPS = 151566;
    public static final int CANCEL_WPS_FAILED = 151567;
    public static final int CANCEL_WPS_SUCCEDED = 151568;
    public static final int CHANGE_REASON_ADDED = 0;
    public static final int CHANGE_REASON_CONFIG_CHANGE = 2;
    public static final int CHANGE_REASON_REMOVED = 1;
    public static final String CONFIGURED_NETWORKS_CHANGED_ACTION = "android.net.wifi.CONFIGURED_NETWORKS_CHANGE";
    public static final int CONNECT_NETWORK = 151553;
    public static final int CONNECT_NETWORK_FAILED = 151554;
    public static final int CONNECT_NETWORK_SUCCEEDED = 151555;
    public static final int DATA_ACTIVITY_IN = 1;
    public static final int DATA_ACTIVITY_INOUT = 3;
    public static final int DATA_ACTIVITY_NONE = 0;
    public static final int DATA_ACTIVITY_NOTIFICATION = 1;
    public static final int DATA_ACTIVITY_OUT = 2;
    public static final boolean DEFAULT_POOR_NETWORK_AVOIDANCE_ENABLED = false;
    public static final int DISABLE_NETWORK = 151569;
    public static final int DISABLE_NETWORK_FAILED = 151570;
    public static final int DISABLE_NETWORK_SUCCEEDED = 151571;
    public static final int ERROR = 0;
    public static final int ERROR_AUTHENTICATING = 1;
    public static final String EXTRA_BSSID = "bssid";
    public static final String EXTRA_CHANGE_REASON = "changeReason";
    public static final String EXTRA_LINK_PROPERTIES = "linkProperties";
    public static final String EXTRA_MULTIPLE_NETWORKS_CHANGED = "multipleChanges";
    public static final String EXTRA_NETWORK_CAPABILITIES = "networkCapabilities";
    public static final String EXTRA_NETWORK_ID = "networkId";
    public static final String EXTRA_NETWORK_INFO = "networkInfo";
    public static final String EXTRA_NEW_RSSI = "newRssi";
    public static final String EXTRA_NEW_STATE = "newState";
    public static final String EXTRA_PREVIOUS_WIFI_AP_STATE = "previous_wifi_state";
    public static final String EXTRA_PREVIOUS_WIFI_STATE = "previous_wifi_state";
    public static final String EXTRA_SCAN_AVAILABLE = "scan_enabled";
    public static final String EXTRA_SSID = "ssid";
    public static final String EXTRA_SUPPLICANT_CONNECTED = "connected";
    public static final String EXTRA_SUPPLICANT_ERROR = "supplicantError";
    public static final String EXTRA_WIFI_AP_DEVICE_ADDRESS = "device_address";
    public static final String EXTRA_WIFI_AP_IP_ADDRESS = "ip_address";
    public static final String EXTRA_WIFI_AP_STATE = "wifi_state";
    public static final String EXTRA_WIFI_AP_USER_LIST = "user_list";
    public static final String EXTRA_WIFI_CONFIGURATION = "wifiConfiguration";
    public static final String EXTRA_WIFI_DECISION_REASON = "wifiDecisionReason";
    public static final String EXTRA_WIFI_INFO = "wifiInfo";
    public static final String EXTRA_WIFI_STATE = "wifi_state";
    public static final int FORGET_NETWORK = 151556;
    public static final int FORGET_NETWORK_FAILED = 151557;
    public static final int FORGET_NETWORK_SUCCEEDED = 151558;
    public static final int INVALID_ARGS = 8;
    private static final int INVALID_KEY = 0;
    public static final int IN_PROGRESS = 1;
    public static final String LINK_CONFIGURATION_CHANGED_ACTION = "android.net.wifi.LINK_CONFIGURATION_CHANGED";
    private static final int MAX_ACTIVE_LOCKS = 50;
    private static final int MAX_RSSI = -55;
    private static final int MIN_RSSI = -100;
    public static final String NETWORK_IDS_CHANGED_ACTION = "android.net.wifi.NETWORK_IDS_CHANGED";
    public static final String NETWORK_STATE_CHANGED_ACTION = "android.net.wifi.STATE_CHANGE";
    public static final int NOT_AUTHORIZED = 9;
    public static final String RSSI_CHANGED_ACTION = "android.net.wifi.RSSI_CHANGED";
    public static final int RSSI_LEVELS = 5;
    public static final int RSSI_PKTCNT_FETCH = 151572;
    public static final int RSSI_PKTCNT_FETCH_FAILED = 151574;
    public static final int RSSI_PKTCNT_FETCH_SUCCEEDED = 151573;
    public static final int SAVE_NETWORK = 151559;
    public static final int SAVE_NETWORK_FAILED = 151560;
    public static final int SAVE_NETWORK_SUCCEEDED = 151561;
    public static final String SCAN_RESULTS_AVAILABLE_ACTION = "android.net.wifi.SCAN_RESULTS";
    private static final String SHARELINK_PACKAGE_NAME = "com.asus.sharerim";
    public static final int START_WPS = 151562;
    public static final int START_WPS_SUCCEEDED = 151563;
    public static final String SUPPLICANT_CONNECTION_CHANGE_ACTION = "android.net.wifi.supplicant.CONNECTION_CHANGE";
    public static final String SUPPLICANT_STATE_CHANGED_ACTION = "android.net.wifi.supplicant.STATE_CHANGE";
    public static final String SUPPLICANT_WAPI_EVENT = "android.net.wifi.supplicant.WAPI_EVENT";
    private static final String TAG = "WifiManager";
    public static final int WAPI_EVENT_AUTH_FAIL_CODE = 16;
    public static final int WAPI_EVENT_CERT_FAIL_CODE = 17;
    public static final String WIFI_AP_STATE_CHANGED_ACTION = "android.net.wifi.WIFI_AP_STATE_CHANGED";
    public static final int WIFI_AP_STATE_DISABLED = 11;
    public static final int WIFI_AP_STATE_DISABLING = 10;
    public static final int WIFI_AP_STATE_ENABLED = 13;
    public static final int WIFI_AP_STATE_ENABLING = 12;
    public static final int WIFI_AP_STATE_FAILED = 14;
    public static final String WIFI_AP_STA_TETHER_CONNECT_ACTION = "android.net.wifi.WIFI_AP_STA_TETHER_CONNECT";
    public static final String WIFI_AP_UPDATE_REQUEST_ACTION = "android.net.wifi.WIFI_AP_UPDATE_REQUEST_ACTION";
    public static final String WIFI_AP_USER_UPDATE_ACTION = "android.net.wifi.WIFI_AP_USER_UPDATE_ACTION";
    public static final int WIFI_DECISION_REASON_NO_NETWORK = 1;
    public static final int WIFI_DECISION_REASON_POOR_LINK = 0;
    public static final int WIFI_FEATURE_ADDITIONAL_STA = 2048;
    public static final int WIFI_FEATURE_BATCH_SCAN = 512;
    public static final int WIFI_FEATURE_D2AP_RTT = 256;
    public static final int WIFI_FEATURE_D2D_RTT = 128;
    public static final int WIFI_FEATURE_EPR = 16384;
    public static final int WIFI_FEATURE_INFRA = 1;
    public static final int WIFI_FEATURE_INFRA_5G = 2;
    public static final int WIFI_FEATURE_MOBILE_HOTSPOT = 16;
    public static final int WIFI_FEATURE_NAN = 64;
    public static final int WIFI_FEATURE_P2P = 8;
    public static final int WIFI_FEATURE_PASSPOINT = 4;
    public static final int WIFI_FEATURE_PNO = 1024;
    public static final int WIFI_FEATURE_SCANNER = 32;
    public static final int WIFI_FEATURE_TDLS = 4096;
    public static final int WIFI_FEATURE_TDLS_OFFCHANNEL = 8192;
    public static final int WIFI_FREQUENCY_BAND_2GHZ = 2;
    public static final int WIFI_FREQUENCY_BAND_5GHZ = 1;
    public static final int WIFI_FREQUENCY_BAND_AUTO = 0;
    public static final int WIFI_MODE_FULL = 1;
    public static final int WIFI_MODE_FULL_HIGH_PERF = 3;
    public static final int WIFI_MODE_SCAN_ONLY = 2;
    public static final String WIFI_SCAN_AVAILABLE = "wifi_scan_available";
    public static final String WIFI_STATE_CHANGED_ACTION = "android.net.wifi.WIFI_STATE_CHANGED";
    public static final int WIFI_STATE_DISABLED = 1;
    public static final int WIFI_STATE_DISABLING = 0;
    public static final int WIFI_STATE_ENABLED = 3;
    public static final int WIFI_STATE_ENABLING = 2;
    public static final int WIFI_STATE_UNKNOWN = 4;
    public static final int WPS_AUTH_FAILURE = 6;
    public static final int WPS_COMPLETED = 151565;
    public static final int WPS_FAILED = 151564;
    public static final int WPS_OVERLAP_ERROR = 3;
    public static final int WPS_TIMED_OUT = 7;
    public static final int WPS_TKIP_ONLY_PROHIBITED = 5;
    public static final int WPS_WEP_PROHIBITED = 4;
    private static AsyncChannel sAsyncChannel;
    private static CountDownLatch sConnected;
    private static HandlerThread sHandlerThread;
    private static int sListenerKey;
    private static final SparseArray sListenerMap;
    private static final Object sListenerMapLock;
    private static int sThreadRefCount;
    private static final Object sThreadRefLock;
    private int mActiveLockCount;
    private Context mContext;
    IWifiManager mService;

    static {
        sListenerKey = 1;
        sListenerMap = new SparseArray();
        sListenerMapLock = new Object();
        sThreadRefLock = new Object();
    }

    public WifiManager(Context context, IWifiManager iWifiManager) {
        this.mContext = context;
        this.mService = iWifiManager;
        this.init();
    }

    static /* synthetic */ AsyncChannel access$102(AsyncChannel asyncChannel) {
        sAsyncChannel = asyncChannel;
        return asyncChannel;
    }

    static /* synthetic */ int access$500(WifiManager wifiManager) {
        return wifiManager.mActiveLockCount;
    }

    static /* synthetic */ int access$508(WifiManager wifiManager) {
        int n = wifiManager.mActiveLockCount;
        wifiManager.mActiveLockCount = n + 1;
        return n;
    }

    static /* synthetic */ int access$510(WifiManager wifiManager) {
        int n = wifiManager.mActiveLockCount;
        wifiManager.mActiveLockCount = n - 1;
        return n;
    }

    private int addOrUpdateNetwork(WifiConfiguration wifiConfiguration) {
        try {
            int n = this.mService.addOrUpdateNetwork(wifiConfiguration);
            return n;
        }
        catch (RemoteException remoteException) {
            return -1;
        }
    }

    public static int calculateSignalLevel(int n, int n2) {
        if (n <= -100) {
            return 0;
        }
        if (n >= -55) {
            return n2 - 1;
        }
        return (int)((float)(n2 - 1) * (float)(n + 100) / 45.0f);
    }

    public static int compareSignalLevel(int n, int n2) {
        return n - n2;
    }

    private int getSupportedFeatures() {
        try {
            int n = this.mService.getSupportedFeatures();
            return n;
        }
        catch (RemoteException remoteException) {
            return 0;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void init() {
        Object object = sThreadRefLock;
        synchronized (object) {
            int n;
            sThreadRefCount = n = 1 + sThreadRefCount;
            if (n == 1) {
                Messenger messenger = this.getWifiServiceMessenger();
                if (messenger == null) {
                    sAsyncChannel = null;
                    return;
                }
                sHandlerThread = new HandlerThread(TAG);
                sAsyncChannel = new AsyncChannel();
                sConnected = new CountDownLatch(1);
                sHandlerThread.start();
                ServiceHandler serviceHandler = new ServiceHandler(sHandlerThread.getLooper());
                sAsyncChannel.connect(this.mContext, (Handler)serviceHandler, messenger);
                try {
                    sConnected.await();
                }
                catch (InterruptedException interruptedException) {
                    Log.e(TAG, "interrupted wait at init");
                }
            }
            return;
        }
    }

    private boolean isFeatureSupported(int n) {
        return (n & this.getSupportedFeatures()) == n;
    }

    private boolean isShareLink() {
        return this.mContext.getPackageName().equals(SHARELINK_PACKAGE_NAME);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static int putListener(Object object) {
        if (object == null) {
            return 0;
        }
        Object object2 = sListenerMapLock;
        synchronized (object2) {
            int n;
            do {
                n = sListenerKey;
                sListenerKey = n + 1;
            } while (n == 0);
            sListenerMap.put(n, object);
            return n;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Object removeListener(int n) {
        if (n == 0) {
            return null;
        }
        Object object = sListenerMapLock;
        synchronized (object) {
            Object e = sListenerMap.get(n);
            sListenerMap.remove(n);
            return e;
        }
    }

    private void validateChannel() {
        if (sAsyncChannel == null) {
            throw new IllegalStateException("No permission to access and change wifi or a bad initialization");
        }
    }

    public int addNetwork(WifiConfiguration wifiConfiguration) {
        if (wifiConfiguration == null) {
            return -1;
        }
        wifiConfiguration.networkId = -1;
        return this.addOrUpdateNetwork(wifiConfiguration);
    }

    public boolean addToBlacklist(String string2) {
        try {
            this.mService.addToBlacklist(string2);
            return true;
        }
        catch (RemoteException remoteException) {
            return false;
        }
    }

    public void cancelWps(WpsCallback wpsCallback) {
        this.validateChannel();
        sAsyncChannel.sendMessage(151566, 0, WifiManager.putListener(wpsCallback));
    }

    public boolean clearBlacklist() {
        try {
            this.mService.clearBlacklist();
            return true;
        }
        catch (RemoteException remoteException) {
            return false;
        }
    }

    public boolean configureWlanRTCoex() {
        if (this.mService == null) {
            return false;
        }
        try {
            this.mService.configureWlanRTCoex();
            return true;
        }
        catch (RemoteException remoteException) {
            return false;
        }
    }

    public void connect(int n, ActionListener actionListener) {
        if (n < 0) {
            throw new IllegalArgumentException("Network id cannot be negative");
        }
        this.validateChannel();
        sAsyncChannel.sendMessage(151553, n, WifiManager.putListener(actionListener));
    }

    public void connect(WifiConfiguration wifiConfiguration, ActionListener actionListener) {
        if (wifiConfiguration == null) {
            throw new IllegalArgumentException("config cannot be null");
        }
        this.validateChannel();
        sAsyncChannel.sendMessage(151553, -1, WifiManager.putListener(actionListener), wifiConfiguration);
    }

    public MulticastLock createMulticastLock(String string2) {
        return new MulticastLock(string2);
    }

    public WifiLock createWifiLock(int n, String string2) {
        return new WifiLock(n, string2);
    }

    public WifiLock createWifiLock(String string2) {
        return new WifiLock(1, string2);
    }

    public void disable(int n, ActionListener actionListener) {
        if (n < 0) {
            throw new IllegalArgumentException("Network id cannot be negative");
        }
        this.validateChannel();
        sAsyncChannel.sendMessage(151569, n, WifiManager.putListener(actionListener));
    }

    public boolean disableNetwork(int n) {
        try {
            boolean bl = this.mService.disableNetwork(n);
            return bl;
        }
        catch (RemoteException remoteException) {
            return false;
        }
    }

    public boolean disconnect() {
        try {
            this.mService.disconnect();
            return true;
        }
        catch (RemoteException remoteException) {
            return false;
        }
    }

    public void enableAggressiveHandover(int n) {
        try {
            this.mService.enableAggressiveHandover(n);
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    public boolean enableNetwork(int n, boolean bl) {
        try {
            boolean bl2 = this.mService.enableNetwork(n, bl);
            return bl2;
        }
        catch (RemoteException remoteException) {
            return false;
        }
    }

    public void enableVerboseLogging(int n) {
        try {
            this.mService.enableVerboseLogging(n);
            return;
        }
        catch (Exception exception) {
            Log.e(TAG, "enableVerboseLogging " + exception.toString());
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void finalize() throws Throwable {
        try {
            Object object = sThreadRefLock;
            synchronized (object) {
                int n;
                sThreadRefCount = n = -1 + sThreadRefCount;
                if (n == 0 && sAsyncChannel != null) {
                    sAsyncChannel.disconnect();
                }
            }
        }
        catch (Throwable throwable) {
            super.finalize();
            throw throwable;
        }
        super.finalize();
    }

    public void forget(int n, ActionListener actionListener) {
        if (n < 0) {
            throw new IllegalArgumentException("Network id cannot be negative");
        }
        this.validateChannel();
        sAsyncChannel.sendMessage(151556, n, WifiManager.putListener(actionListener));
    }

    public int getAggressiveHandover() {
        try {
            int n = this.mService.getAggressiveHandover();
            return n;
        }
        catch (RemoteException remoteException) {
            return 0;
        }
    }

    public int getAllowScansWithTraffic() {
        try {
            int n = this.mService.getAllowScansWithTraffic();
            return n;
        }
        catch (RemoteException remoteException) {
            return 0;
        }
    }

    public List<BatchedScanResult> getBatchedScanResults() {
        try {
            List<BatchedScanResult> list = this.mService.getBatchedScanResults(this.mContext.getOpPackageName());
            return list;
        }
        catch (RemoteException remoteException) {
            return null;
        }
    }

    public List<WifiChannel> getChannelList() {
        try {
            List<WifiChannel> list = this.mService.getChannelList();
            return list;
        }
        catch (RemoteException remoteException) {
            return null;
        }
    }

    public String getConfigFile() {
        try {
            String string2 = this.mService.getConfigFile();
            return string2;
        }
        catch (RemoteException remoteException) {
            return null;
        }
    }

    public List<WifiConfiguration> getConfiguredNetworks() {
        try {
            List<WifiConfiguration> list = this.mService.getConfiguredNetworks();
            return list;
        }
        catch (RemoteException remoteException) {
            return null;
        }
    }

    public WifiInfo getConnectionInfo() {
        try {
            WifiInfo wifiInfo = this.mService.getConnectionInfo();
            return wifiInfo;
        }
        catch (RemoteException remoteException) {
            return null;
        }
    }

    public WifiConnectionStatistics getConnectionStatistics() {
        try {
            WifiConnectionStatistics wifiConnectionStatistics = this.mService.getConnectionStatistics();
            return wifiConnectionStatistics;
        }
        catch (RemoteException remoteException) {
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public WifiActivityEnergyInfo getControllerActivityEnergyInfo(int n) {
        if (this.mService == null) {
            return null;
        }
        try {
            if (!this.isEnhancedPowerReportingSupported()) {
                return null;
            }
            synchronized (this) {
            }
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "getControllerActivityEnergyInfo: " + remoteException);
            return null;
        }
        {
            WifiActivityEnergyInfo wifiActivityEnergyInfo = this.mService.reportActivityInfo();
            if (wifiActivityEnergyInfo.isValid()) {
                return wifiActivityEnergyInfo;
            }
            return null;
        }
    }

    public DhcpInfo getDhcpInfo() {
        try {
            DhcpInfo dhcpInfo = this.mService.getDhcpInfo();
            return dhcpInfo;
        }
        catch (RemoteException remoteException) {
            return null;
        }
    }

    public int getFrequencyBand() {
        try {
            int n = this.mService.getFrequencyBand();
            return n;
        }
        catch (RemoteException remoteException) {
            return -1;
        }
    }

    public List<WifiConfiguration> getPrivilegedConfiguredNetworks() {
        try {
            List<WifiConfiguration> list = this.mService.getPrivilegedConfiguredNetworks();
            return list;
        }
        catch (RemoteException remoteException) {
            return null;
        }
    }

    public List<ScanResult> getScanResults() {
        try {
            List<ScanResult> list = this.mService.getScanResults(this.mContext.getOpPackageName());
            return list;
        }
        catch (RemoteException remoteException) {
            return null;
        }
    }

    public void getTxPacketCount(TxPacketCountListener txPacketCountListener) {
        this.validateChannel();
        sAsyncChannel.sendMessage(151572, 0, WifiManager.putListener(txPacketCountListener));
    }

    public int getVerboseLoggingLevel() {
        try {
            int n = this.mService.getVerboseLoggingLevel();
            return n;
        }
        catch (RemoteException remoteException) {
            return 0;
        }
    }

    public WifiConfiguration getWifiApConfiguration() {
        try {
            WifiConfiguration wifiConfiguration = this.mService.getWifiApConfiguration();
            return wifiConfiguration;
        }
        catch (RemoteException remoteException) {
            return null;
        }
    }

    public int getWifiApState() {
        try {
            int n = this.mService.getWifiApEnabledState();
            return n;
        }
        catch (RemoteException remoteException) {
            return 14;
        }
    }

    public int getWifiSafeChannelBitmap() {
        if (this.mService == null) {
            return 0;
        }
        try {
            int n = this.mService.getWifiSafeChannelBitmap();
            return n;
        }
        catch (RemoteException remoteException) {
            return 0;
        }
    }

    public Messenger getWifiServiceMessenger() {
        try {
            Messenger messenger = this.mService.getWifiServiceMessenger();
            return messenger;
        }
        catch (RemoteException remoteException) {
            return null;
        }
        catch (SecurityException securityException) {
            return null;
        }
    }

    public int getWifiState() {
        try {
            int n = this.mService.getWifiEnabledState();
            return n;
        }
        catch (RemoteException remoteException) {
            return 4;
        }
    }

    public String getWpsNfcConfigurationToken(int n) {
        try {
            String string2 = this.mService.getWpsNfcConfigurationToken(n);
            return string2;
        }
        catch (RemoteException remoteException) {
            return null;
        }
    }

    public boolean initializeMulticastFiltering() {
        try {
            this.mService.initializeMulticastFiltering();
            return true;
        }
        catch (RemoteException remoteException) {
            return false;
        }
    }

    public boolean is5GHzBandSupported() {
        return this.isFeatureSupported(2);
    }

    public boolean isAdditionalStaSupported() {
        return this.isFeatureSupported(2048);
    }

    public boolean isBatchedScanSupported() {
        try {
            boolean bl = this.mService.isBatchedScanSupported();
            return bl;
        }
        catch (RemoteException remoteException) {
            return false;
        }
    }

    public boolean isDeviceToApRttSupported() {
        return this.isFeatureSupported(256);
    }

    public boolean isDeviceToDeviceRttSupported() {
        return this.isFeatureSupported(128);
    }

    public boolean isDualBandSupported() {
        try {
            boolean bl = this.mService.isDualBandSupported();
            return bl;
        }
        catch (RemoteException remoteException) {
            return false;
        }
    }

    public boolean isEnhancedPowerReportingSupported() {
        return this.isFeatureSupported(16384);
    }

    public boolean isMulticastEnabled() {
        try {
            boolean bl = this.mService.isMulticastEnabled();
            return bl;
        }
        catch (RemoteException remoteException) {
            return false;
        }
    }

    public boolean isNanSupported() {
        return this.isFeatureSupported(64);
    }

    public boolean isOffChannelTdlsSupported() {
        return this.isFeatureSupported(8192);
    }

    public boolean isP2pSupported() {
        return this.isFeatureSupported(8);
    }

    public boolean isPasspointSupported() {
        return this.isFeatureSupported(4);
    }

    public boolean isPortableHotspotSupported() {
        return this.isFeatureSupported(16);
    }

    public boolean isPreferredNetworkOffloadSupported() {
        return this.isFeatureSupported(1024);
    }

    public boolean isScanAlwaysAvailable() {
        try {
            boolean bl = this.mService.isScanAlwaysAvailable();
            return bl;
        }
        catch (RemoteException remoteException) {
            return false;
        }
    }

    public boolean isTdlsSupported() {
        return this.isFeatureSupported(4096);
    }

    public boolean isWifiApEnabled() {
        return this.getWifiApState() == 13;
    }

    public boolean isWifiEnabled() {
        return this.getWifiState() == 3;
    }

    public boolean isWifiScannerSupported() {
        return this.isFeatureSupported(32);
    }

    public boolean pingSupplicant() {
        if (this.mService == null) {
            return false;
        }
        try {
            boolean bl = this.mService.pingSupplicant();
            return bl;
        }
        catch (RemoteException remoteException) {
            return false;
        }
    }

    public void pollBatchedScan() {
        try {
            this.mService.pollBatchedScan();
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    public boolean reassociate() {
        try {
            this.mService.reassociate();
            return true;
        }
        catch (RemoteException remoteException) {
            return false;
        }
    }

    public boolean reconnect() {
        try {
            this.mService.reconnect();
            return true;
        }
        catch (RemoteException remoteException) {
            return false;
        }
    }

    public boolean removeNetwork(int n) {
        try {
            boolean bl = this.mService.removeNetwork(n);
            return bl;
        }
        catch (RemoteException remoteException) {
            return false;
        }
    }

    public boolean requestBatchedScan(BatchedScanSettings batchedScanSettings) {
        try {
            boolean bl = this.mService.requestBatchedScan(batchedScanSettings, new Binder(), null);
            return bl;
        }
        catch (RemoteException remoteException) {
            return false;
        }
    }

    public boolean requestBatchedScan(BatchedScanSettings batchedScanSettings, WorkSource workSource) {
        try {
            boolean bl = this.mService.requestBatchedScan(batchedScanSettings, new Binder(), workSource);
            return bl;
        }
        catch (RemoteException remoteException) {
            return false;
        }
    }

    public void save(WifiConfiguration wifiConfiguration, ActionListener actionListener) {
        if (wifiConfiguration == null) {
            throw new IllegalArgumentException("config cannot be null");
        }
        this.validateChannel();
        sAsyncChannel.sendMessage(151559, 0, WifiManager.putListener(actionListener), wifiConfiguration);
    }

    public boolean saveConfiguration() {
        try {
            boolean bl = this.mService.saveConfiguration();
            return bl;
        }
        catch (RemoteException remoteException) {
            return false;
        }
    }

    public void setAllowScansWithTraffic(int n) {
        try {
            this.mService.setAllowScansWithTraffic(n);
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    public void setCountryCode(String string2, boolean bl) {
        try {
            this.mService.setCountryCode(string2, bl);
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    public void setFrequencyBand(int n, boolean bl) {
        try {
            this.mService.setFrequencyBand(n, bl);
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    public boolean setRTCoexMode(int n, int n2) {
        if (this.mService == null) {
            return false;
        }
        try {
            this.mService.setRTCoexMode(n, n2);
            return true;
        }
        catch (RemoteException remoteException) {
            return false;
        }
    }

    public boolean setSafeChannel(int n) {
        if (this.mService == null) {
            return false;
        }
        try {
            this.mService.setSafeChannel(n);
            return true;
        }
        catch (RemoteException remoteException) {
            return false;
        }
    }

    public void setTdlsEnabled(InetAddress inetAddress, boolean bl) {
        try {
            this.mService.enableTdls(inetAddress.getHostAddress(), bl);
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    public void setTdlsEnabledWithMacAddress(String string2, boolean bl) {
        try {
            this.mService.enableTdlsWithMacAddress(string2, bl);
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    public boolean setWifiApConfiguration(WifiConfiguration wifiConfiguration) {
        try {
            this.mService.setWifiApConfiguration(wifiConfiguration);
            return true;
        }
        catch (RemoteException remoteException) {
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean setWifiApEnabled(WifiConfiguration wifiConfiguration, boolean bl) {
        try {
            if (this.isShareLink() && bl) {
                Log.d(TAG, "ShareLink try enabling SoftAP");
                Binder binder = new Binder();
                this.mService.setWifiApEnabledWithBinder(binder, wifiConfiguration, bl);
                return true;
            }
            this.mService.setWifiApEnabled(wifiConfiguration, bl);
            return true;
        }
        catch (RemoteException remoteException) {
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean setWifiEnabled(boolean bl) {
        if (Build.CTA && bl) {
            CtaChecker ctaChecker = new CtaChecker(null);
            if (this.getWifiState() != 3 && this.getWifiState() != 12 && !ctaChecker.checkPermission(9, this.mContext.getPackageName())) {
                try {
                    this.mService.setWifiEnabled(false);
                    return false;
                }
                catch (RemoteException remoteException) {
                    return false;
                }
            }
        }
        try {
            return this.mService.setWifiEnabled(bl);
        }
        catch (RemoteException remoteException) {
            return false;
        }
    }

    public boolean startCustomizedScan(ScanSettings scanSettings) {
        try {
            this.mService.startScan(scanSettings, null);
            return true;
        }
        catch (RemoteException remoteException) {
            return false;
        }
    }

    public boolean startCustomizedScan(ScanSettings scanSettings, WorkSource workSource) {
        try {
            this.mService.startScan(scanSettings, workSource);
            return true;
        }
        catch (RemoteException remoteException) {
            return false;
        }
    }

    public boolean startScan() {
        try {
            this.mService.startScan(null, null);
            return true;
        }
        catch (RemoteException remoteException) {
            return false;
        }
    }

    public boolean startScan(WorkSource workSource) {
        try {
            this.mService.startScan(null, workSource);
            return true;
        }
        catch (RemoteException remoteException) {
            return false;
        }
    }

    public boolean startWifi() {
        try {
            this.mService.startWifi();
            return true;
        }
        catch (RemoteException remoteException) {
            return false;
        }
    }

    public void startWps(WpsInfo wpsInfo, WpsCallback wpsCallback) {
        if (wpsInfo == null) {
            throw new IllegalArgumentException("config cannot be null");
        }
        this.validateChannel();
        sAsyncChannel.sendMessage(151562, 0, WifiManager.putListener(wpsCallback), wpsInfo);
    }

    public void stopBatchedScan(BatchedScanSettings batchedScanSettings) {
        try {
            this.mService.stopBatchedScan(batchedScanSettings);
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    public boolean stopWifi() {
        try {
            this.mService.stopWifi();
            return true;
        }
        catch (RemoteException remoteException) {
            return false;
        }
    }

    public int updateNetwork(WifiConfiguration wifiConfiguration) {
        if (wifiConfiguration == null || wifiConfiguration.networkId < 0) {
            return -1;
        }
        return this.addOrUpdateNetwork(wifiConfiguration);
    }

    public static interface ActionListener {
        public void onFailure(int var1);

        public void onSuccess();
    }

    public class MulticastLock {
        private final IBinder mBinder;
        private boolean mHeld;
        private int mRefCount;
        private boolean mRefCounted;
        private String mTag;

        private MulticastLock(String string2) {
            this.mTag = string2;
            this.mBinder = new Binder();
            this.mRefCount = 0;
            this.mRefCounted = true;
            this.mHeld = false;
        }

        /*
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void acquire() {
            var1_1 = this.mBinder;
            synchronized (var1_1) {
                block16: {
                    if (!this.mRefCounted) break block16;
                    this.mRefCount = var8_2 = 1 + this.mRefCount;
                    if (var8_2 != 1) ** GOTO lbl20
lbl6:
                    // 2 sources

                    while (true) {
                        block14: {
                            try {
                                WifiManager.this.mService.acquireMulticastLock(this.mBinder, this.mTag);
                                var5_3 = WifiManager.this;
                                synchronized (var5_3) {
                                }
                            }
                            catch (RemoteException var4_4) lbl-1000:
                            // 2 sources

                            {
                                while (true) {
                                    this.mHeld = true;
                                    break block14;
                                    break;
                                }
                            }
                            {
                                if (WifiManager.access$500(WifiManager.this) >= 50) {
                                    WifiManager.this.mService.releaseMulticastLock();
                                    throw new UnsupportedOperationException("Exceeded maximum number of wifi locks");
                                }
                                ** break block15
                            }
                        }
                        return;
                    }
                }
                if (var3_5 = this.mHeld) ** continue;
                ** continue;
lbl-1000:
                // 1 sources

                {
                    WifiManager.access$508(WifiManager.this);
                }
                ** continue;
            }
        }

        protected void finalize() throws Throwable {
            super.finalize();
            this.setReferenceCounted(false);
            this.release();
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public boolean isHeld() {
            IBinder iBinder = this.mBinder;
            synchronized (iBinder) {
                return this.mHeld;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        public void release() {
            block13: {
                block14: {
                    block12: {
                        int n;
                        IBinder iBinder = this.mBinder;
                        // MONITORENTER : iBinder
                        if (!this.mRefCounted) break block12;
                        this.mRefCount = n = -1 + this.mRefCount;
                        if (n != 0) break block13;
                        break block14;
                    }
                    boolean bl = this.mHeld;
                    if (!bl) break block13;
                }
                try {
                    WifiManager.this.mService.releaseMulticastLock();
                    WifiManager wifiManager = WifiManager.this;
                    // MONITORENTER : wifiManager
                }
                catch (RemoteException remoteException) {}
                WifiManager.access$510(WifiManager.this);
                // MONITOREXIT : wifiManager
                this.mHeld = false;
            }
            if (this.mRefCount < 0) {
                throw new RuntimeException("MulticastLock under-locked " + this.mTag);
            }
            // MONITOREXIT : iBinder
        }

        public void setReferenceCounted(boolean bl) {
            this.mRefCounted = bl;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public String toString() {
            IBinder iBinder = this.mBinder;
            synchronized (iBinder) {
                String string2 = Integer.toHexString(System.identityHashCode(this));
                String string3 = this.mHeld ? "held; " : "";
                String string4 = this.mRefCounted ? "refcounted: refcount = " + this.mRefCount : "not refcounted";
                return "MulticastLock{ " + string2 + "; " + string3 + string4 + " }";
            }
        }
    }

    private static class ServiceHandler
    extends Handler {
        ServiceHandler(Looper looper) {
            super(looper);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        @Override
        public void handleMessage(Message message) {
            Object object = WifiManager.removeListener(message.arg2);
            switch (message.what) {
                default: {
                    return;
                }
                case 69632: {
                    if (message.arg1 == 0) {
                        sAsyncChannel.sendMessage(69633);
                    } else {
                        Log.e(WifiManager.TAG, "Failed to set up channel connection");
                        WifiManager.access$102(null);
                    }
                    sConnected.countDown();
                    return;
                }
                case 69636: {
                    Log.e(WifiManager.TAG, "Channel connection lost");
                    WifiManager.access$102(null);
                    this.getLooper().quit();
                    return;
                }
                case 151554: 
                case 151557: 
                case 151560: 
                case 151570: {
                    if (object == null) return;
                    ((ActionListener)object).onFailure(message.arg1);
                    return;
                }
                case 151555: 
                case 151558: 
                case 151561: 
                case 151571: {
                    if (object == null) return;
                    ((ActionListener)object).onSuccess();
                    return;
                }
                case 151563: {
                    if (object == null) return;
                    WpsResult wpsResult = (WpsResult)message.obj;
                    ((WpsCallback)object).onStarted(wpsResult.pin);
                    Object object2 = sListenerMapLock;
                    // MONITORENTER : object2
                    sListenerMap.put(message.arg2, object);
                    // MONITOREXIT : object2
                    return;
                }
                case 151565: {
                    if (object == null) return;
                    ((WpsCallback)object).onSucceeded();
                    return;
                }
                case 151564: {
                    if (object == null) return;
                    ((WpsCallback)object).onFailed(message.arg1);
                    return;
                }
                case 151568: {
                    if (object == null) return;
                    ((WpsCallback)object).onSucceeded();
                    return;
                }
                case 151567: {
                    if (object == null) return;
                    ((WpsCallback)object).onFailed(message.arg1);
                    return;
                }
                case 151573: {
                    if (object == null) return;
                    RssiPacketCountInfo rssiPacketCountInfo = (RssiPacketCountInfo)message.obj;
                    if (rssiPacketCountInfo != null) {
                        ((TxPacketCountListener)object).onSuccess(rssiPacketCountInfo.txgood + rssiPacketCountInfo.txbad);
                        return;
                    }
                    ((TxPacketCountListener)object).onFailure(0);
                    return;
                }
                case 151574: 
            }
            if (object == null) return;
            ((TxPacketCountListener)object).onFailure(message.arg1);
        }
    }

    public static interface TxPacketCountListener {
        public void onFailure(int var1);

        public void onSuccess(int var1);
    }

    public class WifiLock {
        private final IBinder mBinder;
        private boolean mHeld;
        int mLockType;
        private int mRefCount;
        private boolean mRefCounted;
        private String mTag;
        private WorkSource mWorkSource;

        private WifiLock(int n, String string2) {
            this.mTag = string2;
            this.mLockType = n;
            this.mBinder = new Binder();
            this.mRefCount = 0;
            this.mRefCounted = true;
            this.mHeld = false;
        }

        /*
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void acquire() {
            var1_1 = this.mBinder;
            synchronized (var1_1) {
                block16: {
                    if (!this.mRefCounted) break block16;
                    this.mRefCount = var10_2 = 1 + this.mRefCount;
                    if (var10_2 != 1) ** GOTO lbl22
lbl6:
                    // 2 sources

                    while (true) {
                        block14: {
                            try {
                                WifiManager.this.mService.acquireWifiLock(this.mBinder, this.mLockType, this.mTag, this.mWorkSource);
                                var6_3 = WifiManager.this;
                                synchronized (var6_3) {
                                }
                            }
                            catch (RemoteException var4_4) lbl-1000:
                            // 2 sources

                            {
                                while (true) {
                                    this.mHeld = true;
                                    break block14;
                                    break;
                                }
                            }
                            {
                                if (WifiManager.access$500(WifiManager.this) >= 50) {
                                    WifiManager.this.mService.releaseWifiLock(this.mBinder);
                                    throw new UnsupportedOperationException("Exceeded maximum number of wifi locks");
                                }
                                ** break block15
                            }
                        }
                        return;
                    }
                }
                if (var3_5 = this.mHeld) ** continue;
                ** continue;
lbl-1000:
                // 1 sources

                {
                    WifiManager.access$508(WifiManager.this);
                }
                ** continue;
            }
        }

        /*
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        protected void finalize() throws Throwable {
            super.finalize();
            IBinder iBinder = this.mBinder;
            // MONITORENTER : iBinder
            boolean bl = this.mHeld;
            if (bl) {
                WifiManager.this.mService.releaseWifiLock(this.mBinder);
                WifiManager wifiManager = WifiManager.this;
                // MONITORENTER : wifiManager
                WifiManager.access$510(WifiManager.this);
                // MONITOREXIT : wifiManager
            }
            // MONITOREXIT : iBinder
            return;
            catch (RemoteException remoteException) {
                return;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public boolean isHeld() {
            IBinder iBinder = this.mBinder;
            synchronized (iBinder) {
                return this.mHeld;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        public void release() {
            block13: {
                block14: {
                    block12: {
                        int n;
                        IBinder iBinder = this.mBinder;
                        // MONITORENTER : iBinder
                        if (!this.mRefCounted) break block12;
                        this.mRefCount = n = -1 + this.mRefCount;
                        if (n != 0) break block13;
                        break block14;
                    }
                    boolean bl = this.mHeld;
                    if (!bl) break block13;
                }
                try {
                    WifiManager.this.mService.releaseWifiLock(this.mBinder);
                    WifiManager wifiManager = WifiManager.this;
                    // MONITORENTER : wifiManager
                }
                catch (RemoteException remoteException) {}
                WifiManager.access$510(WifiManager.this);
                // MONITOREXIT : wifiManager
                this.mHeld = false;
            }
            if (this.mRefCount < 0) {
                throw new RuntimeException("WifiLock under-locked " + this.mTag);
            }
            // MONITOREXIT : iBinder
        }

        public void setReferenceCounted(boolean bl) {
            this.mRefCounted = bl;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void setWorkSource(WorkSource workSource) {
            IBinder iBinder = this.mBinder;
            synchronized (iBinder) {
                boolean bl;
                if (workSource != null && workSource.size() == 0) {
                    workSource = null;
                }
                boolean bl2 = true;
                if (workSource == null) {
                    this.mWorkSource = null;
                } else {
                    workSource.clearNames();
                    if (this.mWorkSource == null) {
                        bl2 = this.mWorkSource != null;
                        this.mWorkSource = new WorkSource(workSource);
                    } else {
                        bl2 = this.mWorkSource.diff(workSource);
                        if (bl2) {
                            this.mWorkSource.set(workSource);
                        }
                    }
                }
                if (bl2 && (bl = this.mHeld)) {
                    try {
                        WifiManager.this.mService.updateWifiLockWorkSource(this.mBinder, this.mWorkSource);
                    }
                    catch (RemoteException remoteException) {}
                }
                return;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public String toString() {
            IBinder iBinder = this.mBinder;
            synchronized (iBinder) {
                String string2 = Integer.toHexString(System.identityHashCode(this));
                String string3 = this.mHeld ? "held; " : "";
                String string4 = this.mRefCounted ? "refcounted: refcount = " + this.mRefCount : "not refcounted";
                return "WifiLock{ " + string2 + "; " + string3 + string4 + " }";
            }
        }
    }

    public static abstract class WpsCallback {
        public abstract void onFailed(int var1);

        public abstract void onStarted(String var1);

        public abstract void onSucceeded();
    }
}

