/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi.p2p;

import android.os.Parcel;
import android.os.Parcelable;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class WifiP2pInfo
implements Parcelable {
    public static final Parcelable.Creator<WifiP2pInfo> CREATOR = new Parcelable.Creator<WifiP2pInfo>(){

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public WifiP2pInfo createFromParcel(Parcel parcel) {
            WifiP2pInfo wifiP2pInfo = new WifiP2pInfo();
            boolean bl = parcel.readByte() == 1;
            wifiP2pInfo.groupFormed = bl;
            byte by = parcel.readByte();
            boolean bl2 = false;
            if (by == 1) {
                bl2 = true;
            }
            wifiP2pInfo.isGroupOwner = bl2;
            if (parcel.readByte() != 1) return wifiP2pInfo;
            try {
                wifiP2pInfo.groupOwnerAddress = InetAddress.getByAddress(parcel.createByteArray());
                return wifiP2pInfo;
            }
            catch (UnknownHostException unknownHostException) {
                return wifiP2pInfo;
            }
        }

        public WifiP2pInfo[] newArray(int n) {
            return new WifiP2pInfo[n];
        }
    };
    public boolean groupFormed;
    public InetAddress groupOwnerAddress;
    public boolean isGroupOwner;

    public WifiP2pInfo() {
    }

    public WifiP2pInfo(WifiP2pInfo wifiP2pInfo) {
        if (wifiP2pInfo != null) {
            this.groupFormed = wifiP2pInfo.groupFormed;
            this.isGroupOwner = wifiP2pInfo.isGroupOwner;
            this.groupOwnerAddress = wifiP2pInfo.groupOwnerAddress;
        }
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("groupFormed: ").append(this.groupFormed).append(" isGroupOwner: ").append(this.isGroupOwner).append(" groupOwnerAddress: ").append(this.groupOwnerAddress);
        return stringBuffer.toString();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void writeToParcel(Parcel parcel, int n) {
        byte by = this.groupFormed ? (byte)1 : 0;
        parcel.writeByte(by);
        byte by2 = this.isGroupOwner ? (byte)1 : 0;
        parcel.writeByte(by2);
        if (this.groupOwnerAddress != null) {
            parcel.writeByte((byte)1);
            parcel.writeByteArray(this.groupOwnerAddress.getAddress());
            return;
        }
        parcel.writeByte((byte)0);
    }
}

