/*
 * Decompiled with CFR 0.152.
 */
package android.nfc.tech;

import android.nfc.Tag;
import android.nfc.tech.BasicTagTechnology;
import android.os.Bundle;
import android.os.RemoteException;
import android.util.Log;
import java.io.IOException;

public final class NfcF
extends BasicTagTechnology {
    public static final String EXTRA_PMM = "pmm";
    public static final String EXTRA_SC = "systemcode";
    private static final String TAG = "NFC";
    private byte[] mManufacturer = null;
    private byte[] mSystemCode = null;

    public NfcF(Tag tag) throws RemoteException {
        super(tag, 4);
        Bundle bundle = tag.getTechExtras(4);
        if (bundle != null) {
            this.mSystemCode = bundle.getByteArray(EXTRA_SC);
            this.mManufacturer = bundle.getByteArray(EXTRA_PMM);
        }
    }

    public static NfcF get(Tag tag) {
        if (!tag.hasTech(4)) {
            return null;
        }
        try {
            NfcF nfcF = new NfcF(tag);
            return nfcF;
        }
        catch (RemoteException remoteException) {
            return null;
        }
    }

    public byte[] getManufacturer() {
        return this.mManufacturer;
    }

    public int getMaxTransceiveLength() {
        return this.getMaxTransceiveLengthInternal();
    }

    public byte[] getSystemCode() {
        return this.mSystemCode;
    }

    public int getTimeout() {
        try {
            int n = this.mTag.getTagService().getTimeout(4);
            return n;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "NFC service dead", remoteException);
            return 0;
        }
    }

    public void setTimeout(int n) {
        try {
            if (this.mTag.getTagService().setTimeout(4, n) != 0) {
                throw new IllegalArgumentException("The supplied timeout is not valid");
            }
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "NFC service dead", remoteException);
        }
    }

    public byte[] transceive(byte[] byArray) throws IOException {
        return this.transceive(byArray, true);
    }
}

