/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.os.SystemProperties;
import android.text.TextUtils;
import android.util.Slog;
import dalvik.system.VMRuntime;

public class Build {
    public static final String ASUSSKU;
    public static final String BOARD;
    public static final String BOOTLOADER;
    public static final String BRAND;
    public static final String COUNTRYCODE;
    @Deprecated
    public static final String CPU_ABI;
    @Deprecated
    public static final String CPU_ABI2;
    public static final boolean CTA = false;
    public static final String DEVICE;
    public static final String DISPLAY;
    public static final String FINGERPRINT;
    public static final String HARDWARE;
    public static final String HOST;
    public static final String ID;
    public static final boolean IS_DEBUGGABLE = false;
    public static final String MANUFACTURER;
    public static final String MODEL;
    public static final String PRODUCT;
    @Deprecated
    public static final String RADIO;
    public static final String SERIAL;
    public static final String[] SUPPORTED_32_BIT_ABIS;
    public static final String[] SUPPORTED_64_BIT_ABIS;
    public static final String[] SUPPORTED_ABIS;
    private static final String TAG = "Build";
    public static final String TAGS;
    public static final long TIME = 0L;
    public static final String TYPE;
    public static final String UNKNOWN = "unknown";
    public static final String USER;

    /*
     * Enabled aggressive block sorting
     */
    static {
        int n = 1;
        ID = Build.getString("ro.build.id");
        DISPLAY = Build.getString("ro.build.display.id");
        PRODUCT = Build.getString("ro.product.name");
        DEVICE = Build.getString("ro.product.device");
        BOARD = Build.getString("ro.product.board");
        MANUFACTURER = Build.getString("ro.product.manufacturer");
        BRAND = Build.getString("ro.product.brand");
        MODEL = Build.getString("ro.product.model");
        BOOTLOADER = Build.getString("ro.bootloader");
        ASUSSKU = Build.getString("ro.build.asus.sku", "WW");
        COUNTRYCODE = Build.getString("ro.config.versatility", "WW");
        RADIO = Build.getString("gsm.version.baseband");
        HARDWARE = Build.getString("ro.hardware");
        SERIAL = Build.getString("ro.serialno");
        SUPPORTED_ABIS = Build.getStringList("ro.product.cpu.abilist", ",");
        SUPPORTED_32_BIT_ABIS = Build.getStringList("ro.product.cpu.abilist32", ",");
        SUPPORTED_64_BIT_ABIS = Build.getStringList("ro.product.cpu.abilist64", ",");
        String[] stringArray = VMRuntime.getRuntime().is64Bit() ? SUPPORTED_64_BIT_ABIS : SUPPORTED_32_BIT_ABIS;
        CPU_ABI = stringArray[0];
        CPU_ABI2 = stringArray.length > n ? stringArray[n] : "";
        TYPE = Build.getString("ro.build.type");
        TAGS = Build.getString("ro.build.tags");
        FINGERPRINT = Build.deriveFingerprint();
        CTA = SystemProperties.getBoolean("persist.sys.cta.security", false);
        TIME = 1000L * Build.getLong("ro.build.date.utc");
        USER = Build.getString("ro.build.user");
        HOST = Build.getString("ro.build.host");
        if (SystemProperties.getInt("ro.debuggable", 0) != n) {
            n = 0;
        }
        IS_DEBUGGABLE = n;
    }

    private static String deriveFingerprint() {
        String string2 = SystemProperties.get("ro.build.fingerprint");
        if (TextUtils.isEmpty(string2)) {
            string2 = Build.getString("ro.product.brand") + '/' + Build.getString("ro.product.name") + '/' + Build.getString("ro.product.device") + ':' + Build.getString("ro.build.version.release") + '/' + Build.getString("ro.build.id") + '/' + Build.getString("ro.build.version.incremental") + ':' + Build.getString("ro.build.type") + '/' + Build.getString("ro.build.tags");
        }
        return string2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void ensureFingerprintProperty() {
        if (!TextUtils.isEmpty(SystemProperties.get("ro.build.fingerprint"))) return;
        try {
            SystemProperties.set("ro.build.fingerprint", FINGERPRINT);
            return;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Slog.e(TAG, "Failed to set fingerprint property", illegalArgumentException);
            return;
        }
    }

    private static long getLong(String string2) {
        try {
            long l = Long.parseLong(SystemProperties.get(string2));
            return l;
        }
        catch (NumberFormatException numberFormatException) {
            return -1L;
        }
    }

    public static String getRadioVersion() {
        return SystemProperties.get("gsm.version.baseband", null);
    }

    private static String getString(String string2) {
        return SystemProperties.get(string2, UNKNOWN);
    }

    private static String getString(String string2, String string3) {
        return SystemProperties.get(string2, string3);
    }

    private static String[] getStringList(String string2, String string3) {
        String string4 = SystemProperties.get(string2);
        if (string4.isEmpty()) {
            return new String[0];
        }
        return string4.split(string3);
    }

    public static class FEATURES {
        public static final boolean HAS_ASUS_THEME = true;
        public static boolean HAS_GLOVE_MODE = false;
        public static boolean HAS_TOUCHPAD = false;
        public static boolean HAS_TRANSCOVER = false;
        public static boolean SAVE_MORE_RAM_ON_1G_DEVICE = true;
    }

    public static class VERSION {
        public static final String[] ACTIVE_CODENAMES;
        private static final String[] ALL_CODENAMES;
        public static final String CODENAME;
        public static final String INCREMENTAL;
        public static final String RELEASE;
        public static final int RESOURCES_SDK_INT;
        @Deprecated
        public static final String SDK;
        public static final int SDK_INT;

        /*
         * Enabled aggressive block sorting
         */
        static {
            INCREMENTAL = Build.getString("ro.build.version.incremental");
            RELEASE = Build.getString("ro.build.version.release");
            SDK = Build.getString("ro.build.version.sdk");
            SDK_INT = SystemProperties.getInt("ro.build.version.sdk", 0);
            CODENAME = Build.getString("ro.build.version.codename");
            ALL_CODENAMES = Build.getStringList("ro.build.version.all_codenames", ",");
            String[] stringArray = "REL".equals(ALL_CODENAMES[0]) ? new String[]{} : ALL_CODENAMES;
            ACTIVE_CODENAMES = stringArray;
            RESOURCES_SDK_INT = SDK_INT + ACTIVE_CODENAMES.length;
        }
    }

    public static class VERSION_CODES {
        public static final int BASE = 1;
        public static final int BASE_1_1 = 2;
        public static final int CUPCAKE = 3;
        public static final int CUR_DEVELOPMENT = 10000;
        public static final int DONUT = 4;
        public static final int ECLAIR = 5;
        public static final int ECLAIR_0_1 = 6;
        public static final int ECLAIR_MR1 = 7;
        public static final int FROYO = 8;
        public static final int GINGERBREAD = 9;
        public static final int GINGERBREAD_MR1 = 10;
        public static final int HONEYCOMB = 11;
        public static final int HONEYCOMB_MR1 = 12;
        public static final int HONEYCOMB_MR2 = 13;
        public static final int ICE_CREAM_SANDWICH = 14;
        public static final int ICE_CREAM_SANDWICH_MR1 = 15;
        public static final int JELLY_BEAN = 16;
        public static final int JELLY_BEAN_MR1 = 17;
        public static final int JELLY_BEAN_MR2 = 18;
        public static final int KITKAT = 19;
        public static final int KITKAT_WATCH = 20;
        public static final int L = 21;
        public static final int LOLLIPOP = 21;
    }
}

