/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.os.Parcel;
import android.os.ParcelFileDescriptor;
import android.os.Parcelable;
import android.os.RemoteException;
import com.android.internal.os.IDropBoxManagerService;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;

public class DropBoxManager {
    public static final String ACTION_DROPBOX_ENTRY_ADDED = "android.intent.action.DROPBOX_ENTRY_ADDED";
    public static final String EXTRA_TAG = "tag";
    public static final String EXTRA_TIME = "time";
    private static final int HAS_BYTE_ARRAY = 8;
    public static final int IS_EMPTY = 1;
    public static final int IS_GZIPPED = 4;
    public static final int IS_TEXT = 2;
    private static final String TAG = "DropBoxManager";
    private final IDropBoxManagerService mService;

    protected DropBoxManager() {
        this.mService = null;
    }

    public DropBoxManager(IDropBoxManagerService iDropBoxManagerService) {
        this.mService = iDropBoxManagerService;
    }

    public void addData(String string2, byte[] byArray, int n) {
        if (byArray == null) {
            throw new NullPointerException("data == null");
        }
        try {
            this.mService.add(new Entry(string2, 0L, byArray, n));
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    public void addFile(String string2, File file, int n) throws IOException {
        if (file == null) {
            throw new NullPointerException("file == null");
        }
        Entry entry = new Entry(string2, 0L, file, n);
        try {
            this.mService.add(entry);
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
        finally {
            entry.close();
        }
    }

    public void addText(String string2, String string3) {
        try {
            this.mService.add(new Entry(string2, 0L, string3));
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    public Entry getNextEntry(String string2, long l) {
        try {
            Entry entry = this.mService.getNextEntry(string2, l);
            return entry;
        }
        catch (RemoteException remoteException) {
            return null;
        }
    }

    public boolean isTagEnabled(String string2) {
        try {
            boolean bl = this.mService.isTagEnabled(string2);
            return bl;
        }
        catch (RemoteException remoteException) {
            return false;
        }
    }

    public static class Entry
    implements Parcelable,
    Closeable {
        public static final Parcelable.Creator<Entry> CREATOR = new Parcelable.Creator(){

            public Entry createFromParcel(Parcel parcel) {
                String string2 = parcel.readString();
                long l = parcel.readLong();
                int n = parcel.readInt();
                if ((n & 8) != 0) {
                    return new Entry(string2, l, parcel.createByteArray(), n & 0xFFFFFFF7);
                }
                return new Entry(string2, l, parcel.readFileDescriptor(), n);
            }

            public Entry[] newArray(int n) {
                return new Entry[n];
            }
        };
        private final byte[] mData;
        private final ParcelFileDescriptor mFileDescriptor;
        private final int mFlags;
        private final String mTag;
        private final long mTimeMillis;

        public Entry(String string2, long l) {
            if (string2 == null) {
                throw new NullPointerException("tag == null");
            }
            this.mTag = string2;
            this.mTimeMillis = l;
            this.mData = null;
            this.mFileDescriptor = null;
            this.mFlags = 1;
        }

        /*
         * Enabled aggressive block sorting
         */
        public Entry(String string2, long l, ParcelFileDescriptor parcelFileDescriptor, int n) {
            boolean bl = true;
            if (string2 == null) {
                throw new NullPointerException("tag == null");
            }
            boolean bl2 = (n & 1) != 0 ? bl : false;
            if (parcelFileDescriptor != null) {
                bl = false;
            }
            if (bl2 != bl) {
                throw new IllegalArgumentException("Bad flags: " + n);
            }
            this.mTag = string2;
            this.mTimeMillis = l;
            this.mData = null;
            this.mFileDescriptor = parcelFileDescriptor;
            this.mFlags = n;
        }

        public Entry(String string2, long l, File file, int n) throws IOException {
            if (string2 == null) {
                throw new NullPointerException("tag == null");
            }
            if ((n & 1) != 0) {
                throw new IllegalArgumentException("Bad flags: " + n);
            }
            this.mTag = string2;
            this.mTimeMillis = l;
            this.mData = null;
            this.mFileDescriptor = ParcelFileDescriptor.open(file, 0x10000000);
            this.mFlags = n;
        }

        public Entry(String string2, long l, String string3) {
            if (string2 == null) {
                throw new NullPointerException("tag == null");
            }
            if (string3 == null) {
                throw new NullPointerException("text == null");
            }
            this.mTag = string2;
            this.mTimeMillis = l;
            this.mData = string3.getBytes();
            this.mFileDescriptor = null;
            this.mFlags = 2;
        }

        /*
         * Enabled aggressive block sorting
         */
        public Entry(String string2, long l, byte[] byArray, int n) {
            boolean bl = true;
            if (string2 == null) {
                throw new NullPointerException("tag == null");
            }
            boolean bl2 = (n & 1) != 0 ? bl : false;
            if (byArray != null) {
                bl = false;
            }
            if (bl2 != bl) {
                throw new IllegalArgumentException("Bad flags: " + n);
            }
            this.mTag = string2;
            this.mTimeMillis = l;
            this.mData = byArray;
            this.mFileDescriptor = null;
            this.mFlags = n;
        }

        @Override
        public void close() {
            try {
                if (this.mFileDescriptor != null) {
                    this.mFileDescriptor.close();
                }
                return;
            }
            catch (IOException iOException) {
                return;
            }
        }

        @Override
        public int describeContents() {
            if (this.mFileDescriptor != null) {
                return 1;
            }
            return 0;
        }

        public int getFlags() {
            return 0xFFFFFFFB & this.mFlags;
        }

        /*
         * WARNING - void declaration
         * Enabled aggressive block sorting
         */
        public InputStream getInputStream() throws IOException {
            void var1_4;
            if (this.mData != null) {
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.mData);
            } else {
                if (this.mFileDescriptor == null) {
                    return null;
                }
                ParcelFileDescriptor.AutoCloseInputStream autoCloseInputStream = new ParcelFileDescriptor.AutoCloseInputStream(this.mFileDescriptor);
            }
            if ((4 & this.mFlags) != 0) {
                void var1_2;
                GZIPInputStream gZIPInputStream = new GZIPInputStream((InputStream)var1_2);
            }
            return var1_4;
        }

        public String getTag() {
            return this.mTag;
        }

        /*
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public String getText(int n) {
            InputStream inputStream;
            block15: {
                InputStream inputStream2;
                if ((2 & this.mFlags) == 0) {
                    return null;
                }
                if (this.mData != null) {
                    return new String(this.mData, 0, Math.min(n, this.mData.length));
                }
                inputStream = null;
                inputStream = inputStream2 = this.getInputStream();
                if (inputStream != null) break block15;
                if (inputStream == null) return null;
                try {
                    inputStream.close();
                    return null;
                }
                catch (IOException iOException) {
                    return null;
                }
            }
            byte[] byArray = new byte[n];
            int n2 = 0;
            int n3 = 0;
            while (n3 >= 0 && (n2 += n3) < n) {
                n3 = inputStream.read(byArray, n2, n - n2);
            }
            String string2 = new String(byArray, 0, n2);
            if (inputStream == null) return string2;
            inputStream.close();
            return string2;
            {
                catch (IOException iOException) {
                    return string2;
                }
            }
            catch (IOException iOException) {
                if (inputStream == null) return null;
                try {
                    inputStream.close();
                    return null;
                }
                catch (IOException iOException2) {
                    return null;
                }
            }
            catch (Throwable throwable) {
                if (inputStream == null) throw throwable;
                try {}
                catch (IOException iOException) {
                    throw throwable;
                }
                inputStream.close();
                throw throwable;
            }
        }

        public long getTimeMillis() {
            return this.mTimeMillis;
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            parcel.writeString(this.mTag);
            parcel.writeLong(this.mTimeMillis);
            if (this.mFileDescriptor != null) {
                parcel.writeInt(0xFFFFFFF7 & this.mFlags);
                this.mFileDescriptor.writeToParcel(parcel, n);
                return;
            }
            parcel.writeInt(8 | this.mFlags);
            parcel.writeByteArray(this.mData);
        }
    }
}

