/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.util.Log;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class MemoryFile {
    private static final int PROT_READ = 1;
    private static final int PROT_WRITE = 2;
    private static String TAG = "MemoryFile";
    private long mAddress;
    private boolean mAllowPurging = false;
    private FileDescriptor mFD;
    private int mLength;

    public MemoryFile(String string2, int n) throws IOException {
        this.mLength = n;
        if (n >= 0) {
            this.mFD = MemoryFile.native_open(string2, n);
            if (n > 0) {
                this.mAddress = MemoryFile.native_mmap(this.mFD, n, 3);
                return;
            }
        } else {
            throw new IOException("Invalid length: " + n);
        }
        this.mAddress = 0L;
    }

    public static int getSize(FileDescriptor fileDescriptor) throws IOException {
        return MemoryFile.native_get_size(fileDescriptor);
    }

    private boolean isClosed() {
        return !this.mFD.valid();
    }

    private boolean isDeactivated() {
        return this.mAddress == 0L;
    }

    private static native void native_close(FileDescriptor var0);

    private static native int native_get_size(FileDescriptor var0) throws IOException;

    private static native long native_mmap(FileDescriptor var0, int var1, int var2) throws IOException;

    private static native void native_munmap(long var0, int var2) throws IOException;

    private static native FileDescriptor native_open(String var0, int var1) throws IOException;

    private static native void native_pin(FileDescriptor var0, boolean var1) throws IOException;

    private static native int native_read(FileDescriptor var0, long var1, byte[] var3, int var4, int var5, int var6, boolean var7) throws IOException;

    private static native void native_write(FileDescriptor var0, long var1, byte[] var3, int var4, int var5, int var6, boolean var7) throws IOException;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean allowPurging(boolean bl) throws IOException {
        synchronized (this) {
            boolean bl2 = this.mAllowPurging;
            if (bl2 != bl) {
                FileDescriptor fileDescriptor = this.mFD;
                boolean bl3 = !bl;
                MemoryFile.native_pin(fileDescriptor, bl3);
                this.mAllowPurging = bl;
            }
            return bl2;
        }
    }

    public void close() {
        this.deactivate();
        if (!this.isClosed()) {
            MemoryFile.native_close(this.mFD);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void deactivate() {
        if (this.isDeactivated()) return;
        try {
            MemoryFile.native_munmap(this.mAddress, this.mLength);
            this.mAddress = 0L;
            return;
        }
        catch (IOException iOException) {
            Log.e(TAG, iOException.toString());
            return;
        }
    }

    protected void finalize() {
        if (!this.isClosed()) {
            Log.e(TAG, "MemoryFile.finalize() called while ashmem still open");
            this.close();
        }
    }

    public FileDescriptor getFileDescriptor() throws IOException {
        return this.mFD;
    }

    public InputStream getInputStream() {
        return new MemoryInputStream();
    }

    public OutputStream getOutputStream() {
        return new MemoryOutputStream();
    }

    public boolean isPurgingAllowed() {
        return this.mAllowPurging;
    }

    public int length() {
        return this.mLength;
    }

    public int readBytes(byte[] byArray, int n, int n2, int n3) throws IOException {
        if (this.isDeactivated()) {
            throw new IOException("Can't read from deactivated memory file.");
        }
        if (n2 < 0 || n2 > byArray.length || n3 < 0 || n3 > byArray.length - n2 || n < 0 || n > this.mLength || n3 > this.mLength - n) {
            throw new IndexOutOfBoundsException();
        }
        return MemoryFile.native_read(this.mFD, this.mAddress, byArray, n, n2, n3, this.mAllowPurging);
    }

    public void writeBytes(byte[] byArray, int n, int n2, int n3) throws IOException {
        if (this.isDeactivated()) {
            throw new IOException("Can't write to deactivated memory file.");
        }
        if (n < 0 || n > byArray.length || n3 < 0 || n3 > byArray.length - n || n2 < 0 || n2 > this.mLength || n3 > this.mLength - n2) {
            throw new IndexOutOfBoundsException();
        }
        MemoryFile.native_write(this.mFD, this.mAddress, byArray, n, n2, n3, this.mAllowPurging);
    }

    private class MemoryInputStream
    extends InputStream {
        private int mMark = 0;
        private int mOffset = 0;
        private byte[] mSingleByte;

        private MemoryInputStream() {
        }

        @Override
        public int available() throws IOException {
            if (this.mOffset >= MemoryFile.this.mLength) {
                return 0;
            }
            return MemoryFile.this.mLength - this.mOffset;
        }

        @Override
        public void mark(int n) {
            this.mMark = this.mOffset;
        }

        @Override
        public boolean markSupported() {
            return true;
        }

        @Override
        public int read() throws IOException {
            if (this.mSingleByte == null) {
                this.mSingleByte = new byte[1];
            }
            if (this.read(this.mSingleByte, 0, 1) != 1) {
                return -1;
            }
            return this.mSingleByte[0];
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public int read(byte[] byArray, int n, int n2) throws IOException {
            if (n < 0) throw new IndexOutOfBoundsException();
            if (n2 < 0) throw new IndexOutOfBoundsException();
            if (n + n2 > byArray.length) {
                throw new IndexOutOfBoundsException();
            }
            int n3 = Math.min(n2, this.available());
            if (n3 < 1) {
                return -1;
            }
            int n4 = MemoryFile.this.readBytes(byArray, this.mOffset, n, n3);
            if (n4 <= 0) return n4;
            this.mOffset = n4 + this.mOffset;
            return n4;
        }

        @Override
        public void reset() throws IOException {
            this.mOffset = this.mMark;
        }

        @Override
        public long skip(long l) throws IOException {
            if (l + (long)this.mOffset > (long)MemoryFile.this.mLength) {
                l = MemoryFile.this.mLength - this.mOffset;
            }
            this.mOffset = (int)(l + (long)this.mOffset);
            return l;
        }
    }

    private class MemoryOutputStream
    extends OutputStream {
        private int mOffset = 0;
        private byte[] mSingleByte;

        private MemoryOutputStream() {
        }

        @Override
        public void write(int n) throws IOException {
            if (this.mSingleByte == null) {
                this.mSingleByte = new byte[1];
            }
            this.mSingleByte[0] = (byte)n;
            this.write(this.mSingleByte, 0, 1);
        }

        @Override
        public void write(byte[] byArray, int n, int n2) throws IOException {
            MemoryFile.this.writeBytes(byArray, n, this.mOffset, n2);
            this.mOffset = n2 + this.mOffset;
        }
    }
}

