/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.os.Handler;
import android.os.Looper;
import android.os.MemoryFile;
import android.os.Message;
import android.os.Parcel;
import android.os.Parcelable;
import android.system.ErrnoException;
import android.system.Os;
import android.system.OsConstants;
import android.system.StructStat;
import android.util.Log;
import dalvik.system.CloseGuard;
import java.io.Closeable;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.DatagramSocket;
import java.net.Socket;
import java.nio.ByteOrder;
import libcore.io.IoUtils;
import libcore.io.Memory;

public class ParcelFileDescriptor
implements Parcelable,
Closeable {
    public static final Parcelable.Creator<ParcelFileDescriptor> CREATOR = new Parcelable.Creator<ParcelFileDescriptor>(){

        @Override
        public ParcelFileDescriptor createFromParcel(Parcel parcel) {
            FileDescriptor fileDescriptor = parcel.readRawFileDescriptor();
            int n = parcel.readInt();
            FileDescriptor fileDescriptor2 = null;
            if (n != 0) {
                fileDescriptor2 = parcel.readRawFileDescriptor();
            }
            return new ParcelFileDescriptor(fileDescriptor, fileDescriptor2);
        }

        public ParcelFileDescriptor[] newArray(int n) {
            return new ParcelFileDescriptor[n];
        }
    };
    private static final int MAX_STATUS = 1024;
    public static final int MODE_APPEND = 0x2000000;
    public static final int MODE_CREATE = 0x8000000;
    public static final int MODE_READ_ONLY = 0x10000000;
    public static final int MODE_READ_WRITE = 0x30000000;
    public static final int MODE_TRUNCATE = 0x4000000;
    @Deprecated
    public static final int MODE_WORLD_READABLE = 1;
    @Deprecated
    public static final int MODE_WORLD_WRITEABLE = 2;
    public static final int MODE_WRITE_ONLY = 0x20000000;
    private static final String TAG = "ParcelFileDescriptor";
    private volatile boolean mClosed;
    private FileDescriptor mCommFd;
    private final FileDescriptor mFd;
    private final CloseGuard mGuard = CloseGuard.get();
    private Status mStatus;
    private byte[] mStatusBuf;
    private final ParcelFileDescriptor mWrapped;

    public ParcelFileDescriptor(ParcelFileDescriptor parcelFileDescriptor) {
        this.mWrapped = parcelFileDescriptor;
        this.mFd = null;
        this.mCommFd = null;
        this.mClosed = true;
    }

    public ParcelFileDescriptor(FileDescriptor fileDescriptor) {
        this(fileDescriptor, null);
    }

    public ParcelFileDescriptor(FileDescriptor fileDescriptor, FileDescriptor fileDescriptor2) {
        if (fileDescriptor == null) {
            throw new NullPointerException("FileDescriptor must not be null");
        }
        this.mWrapped = null;
        this.mFd = fileDescriptor;
        this.mCommFd = fileDescriptor2;
        this.mGuard.open("close");
    }

    public static ParcelFileDescriptor adoptFd(int n) {
        FileDescriptor fileDescriptor = new FileDescriptor();
        fileDescriptor.setInt$(n);
        return new ParcelFileDescriptor(fileDescriptor);
    }

    private void closeWithStatus(int n, String string2) {
        if (this.mClosed) {
            return;
        }
        this.mClosed = true;
        this.mGuard.close();
        this.writeCommStatusAndClose(n, string2);
        IoUtils.closeQuietly((FileDescriptor)this.mFd);
        this.releaseResources();
    }

    private static FileDescriptor[] createCommSocketPair() throws IOException {
        try {
            FileDescriptor fileDescriptor = new FileDescriptor();
            FileDescriptor fileDescriptor2 = new FileDescriptor();
            Os.socketpair(OsConstants.AF_UNIX, OsConstants.SOCK_STREAM, 0, fileDescriptor, fileDescriptor2);
            IoUtils.setBlocking((FileDescriptor)fileDescriptor, (boolean)false);
            IoUtils.setBlocking((FileDescriptor)fileDescriptor2, (boolean)false);
            FileDescriptor[] fileDescriptorArray = new FileDescriptor[]{fileDescriptor, fileDescriptor2};
            return fileDescriptorArray;
        }
        catch (ErrnoException errnoException) {
            throw errnoException.rethrowAsIOException();
        }
    }

    public static ParcelFileDescriptor[] createPipe() throws IOException {
        try {
            FileDescriptor[] fileDescriptorArray = Os.pipe();
            ParcelFileDescriptor[] parcelFileDescriptorArray = new ParcelFileDescriptor[]{new ParcelFileDescriptor(fileDescriptorArray[0]), new ParcelFileDescriptor(fileDescriptorArray[1])};
            return parcelFileDescriptorArray;
        }
        catch (ErrnoException errnoException) {
            throw errnoException.rethrowAsIOException();
        }
    }

    public static ParcelFileDescriptor[] createReliablePipe() throws IOException {
        try {
            FileDescriptor[] fileDescriptorArray = ParcelFileDescriptor.createCommSocketPair();
            FileDescriptor[] fileDescriptorArray2 = Os.pipe();
            ParcelFileDescriptor[] parcelFileDescriptorArray = new ParcelFileDescriptor[]{new ParcelFileDescriptor(fileDescriptorArray2[0], fileDescriptorArray[0]), new ParcelFileDescriptor(fileDescriptorArray2[1], fileDescriptorArray[1])};
            return parcelFileDescriptorArray;
        }
        catch (ErrnoException errnoException) {
            throw errnoException.rethrowAsIOException();
        }
    }

    public static ParcelFileDescriptor[] createReliableSocketPair() throws IOException {
        try {
            FileDescriptor[] fileDescriptorArray = ParcelFileDescriptor.createCommSocketPair();
            FileDescriptor fileDescriptor = new FileDescriptor();
            FileDescriptor fileDescriptor2 = new FileDescriptor();
            Os.socketpair(OsConstants.AF_UNIX, OsConstants.SOCK_STREAM, 0, fileDescriptor, fileDescriptor2);
            ParcelFileDescriptor[] parcelFileDescriptorArray = new ParcelFileDescriptor[]{new ParcelFileDescriptor(fileDescriptor, fileDescriptorArray[0]), new ParcelFileDescriptor(fileDescriptor2, fileDescriptorArray[1])};
            return parcelFileDescriptorArray;
        }
        catch (ErrnoException errnoException) {
            throw errnoException.rethrowAsIOException();
        }
    }

    public static ParcelFileDescriptor[] createSocketPair() throws IOException {
        try {
            FileDescriptor fileDescriptor = new FileDescriptor();
            FileDescriptor fileDescriptor2 = new FileDescriptor();
            Os.socketpair(OsConstants.AF_UNIX, OsConstants.SOCK_STREAM, 0, fileDescriptor, fileDescriptor2);
            ParcelFileDescriptor[] parcelFileDescriptorArray = new ParcelFileDescriptor[]{new ParcelFileDescriptor(fileDescriptor), new ParcelFileDescriptor(fileDescriptor2)};
            return parcelFileDescriptorArray;
        }
        catch (ErrnoException errnoException) {
            throw errnoException.rethrowAsIOException();
        }
    }

    public static ParcelFileDescriptor dup(FileDescriptor fileDescriptor) throws IOException {
        try {
            ParcelFileDescriptor parcelFileDescriptor = new ParcelFileDescriptor(Os.dup(fileDescriptor));
            return parcelFileDescriptor;
        }
        catch (ErrnoException errnoException) {
            throw errnoException.rethrowAsIOException();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Deprecated
    public static ParcelFileDescriptor fromData(byte[] byArray, String string2) throws IOException {
        FileDescriptor fileDescriptor;
        block5: {
            block4: {
                if (byArray == null) break block4;
                MemoryFile memoryFile = new MemoryFile(string2, byArray.length);
                if (byArray.length > 0) {
                    memoryFile.writeBytes(byArray, 0, 0, byArray.length);
                }
                memoryFile.deactivate();
                fileDescriptor = memoryFile.getFileDescriptor();
                if (fileDescriptor != null) break block5;
            }
            return null;
        }
        return new ParcelFileDescriptor(fileDescriptor);
    }

    public static ParcelFileDescriptor fromDatagramSocket(DatagramSocket datagramSocket) {
        FileDescriptor fileDescriptor = datagramSocket.getFileDescriptor$();
        if (fileDescriptor != null) {
            return new ParcelFileDescriptor(fileDescriptor);
        }
        return null;
    }

    public static ParcelFileDescriptor fromFd(int n) throws IOException {
        FileDescriptor fileDescriptor = new FileDescriptor();
        fileDescriptor.setInt$(n);
        try {
            ParcelFileDescriptor parcelFileDescriptor = new ParcelFileDescriptor(Os.dup(fileDescriptor));
            return parcelFileDescriptor;
        }
        catch (ErrnoException errnoException) {
            throw errnoException.rethrowAsIOException();
        }
    }

    public static ParcelFileDescriptor fromSocket(Socket socket) {
        FileDescriptor fileDescriptor = socket.getFileDescriptor$();
        if (fileDescriptor != null) {
            return new ParcelFileDescriptor(fileDescriptor);
        }
        return null;
    }

    private byte[] getOrCreateStatusBuffer() {
        if (this.mStatusBuf == null) {
            this.mStatusBuf = new byte[1024];
        }
        return this.mStatusBuf;
    }

    public static ParcelFileDescriptor open(File file, int n) throws FileNotFoundException {
        FileDescriptor fileDescriptor = ParcelFileDescriptor.openInternal(file, n);
        if (fileDescriptor == null) {
            return null;
        }
        return new ParcelFileDescriptor(fileDescriptor);
    }

    public static ParcelFileDescriptor open(File file, int n, Handler handler, OnCloseListener onCloseListener) throws IOException {
        if (handler == null) {
            throw new IllegalArgumentException("Handler must not be null");
        }
        if (onCloseListener == null) {
            throw new IllegalArgumentException("Listener must not be null");
        }
        FileDescriptor fileDescriptor = ParcelFileDescriptor.openInternal(file, n);
        if (fileDescriptor == null) {
            return null;
        }
        FileDescriptor[] fileDescriptorArray = ParcelFileDescriptor.createCommSocketPair();
        ParcelFileDescriptor parcelFileDescriptor = new ParcelFileDescriptor(fileDescriptor, fileDescriptorArray[0]);
        IoUtils.setBlocking((FileDescriptor)fileDescriptorArray[1], (boolean)true);
        new ListenerBridge(fileDescriptorArray[1], handler.getLooper(), onCloseListener).start();
        return parcelFileDescriptor;
    }

    private static FileDescriptor openInternal(File file, int n) throws FileNotFoundException {
        if ((0x30000000 & n) == 0) {
            throw new IllegalArgumentException("Must specify MODE_READ_ONLY, MODE_WRITE_ONLY, or MODE_READ_WRITE");
        }
        return Parcel.openFileDescriptor(file.getPath(), n);
    }

    public static int parseMode(String string2) {
        if ("r".equals(string2)) {
            return 0x10000000;
        }
        if ("w".equals(string2) || "wt".equals(string2)) {
            return 0x2C000000;
        }
        if ("wa".equals(string2)) {
            return 0x2A000000;
        }
        if ("rw".equals(string2)) {
            return 0x38000000;
        }
        if ("rwt".equals(string2)) {
            return 0x3C000000;
        }
        throw new IllegalArgumentException("Bad mode '" + string2 + "'");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Status readCommStatus(FileDescriptor fileDescriptor, byte[] byArray) {
        try {
            int n = Os.read(fileDescriptor, byArray, 0, byArray.length);
            if (n == 0) {
                return new Status(-2);
            }
            int n2 = Memory.peekInt((byte[])byArray, (int)0, (ByteOrder)ByteOrder.BIG_ENDIAN);
            if (n2 != 1) return new Status(n2);
            return new Status(n2, new String(byArray, 4, n - 4));
        }
        catch (ErrnoException errnoException) {
            if (errnoException.errno == OsConstants.EAGAIN) {
                return null;
            }
        }
        catch (InterruptedIOException interruptedIOException) {
            Log.d(TAG, "Failed to read status; assuming dead: " + interruptedIOException);
            return new Status(-2);
        }
        Log.d(TAG, "Failed to read status; assuming dead: " + errnoException);
        return new Status(-2);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void writeCommStatusAndClose(int n, String string2) {
        block12: {
            if (this.mCommFd == null) {
                if (string2 == null) return;
                Log.w(TAG, "Unable to inform peer: " + string2);
                return;
            }
            if (n == 2) {
                Log.w(TAG, "Peer expected signal when closed; unable to deliver after detach");
            }
            if (n == -1) {
                IoUtils.closeQuietly((FileDescriptor)this.mCommFd);
                this.mCommFd = null;
                return;
            }
            Status status = this.mStatus = ParcelFileDescriptor.readCommStatus(this.mCommFd, this.getOrCreateStatusBuffer());
            if (status == null) break block12;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
            IoUtils.closeQuietly((FileDescriptor)this.mCommFd);
            this.mCommFd = null;
            return;
        }
        try {
            byte[] byArray = this.getOrCreateStatusBuffer();
            Memory.pokeInt((byte[])byArray, (int)0, (int)n, (ByteOrder)ByteOrder.BIG_ENDIAN);
            int n2 = 0 + 4;
            if (string2 != null) {
                byte[] byArray2 = string2.getBytes();
                int n3 = Math.min(byArray2.length, -4 + byArray.length);
                System.arraycopy((byte[])byArray2, (int)0, (byte[])byArray, (int)n2, (int)n3);
                n2 = n3 + 4;
            }
            Os.write(this.mCommFd, byArray, 0, n2);
            return;
        }
        catch (ErrnoException errnoException) {
            Log.w(TAG, "Failed to report status: " + errnoException);
            return;
        }
        catch (InterruptedIOException interruptedIOException) {
            Log.w(TAG, "Failed to report status: " + interruptedIOException);
            return;
        }
        finally {
            IoUtils.closeQuietly((FileDescriptor)this.mCommFd);
            this.mCommFd = null;
        }
    }

    public boolean canDetectErrors() {
        if (this.mWrapped != null) {
            return this.mWrapped.canDetectErrors();
        }
        return this.mCommFd != null;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void checkError() throws IOException {
        if (this.mWrapped != null) {
            this.mWrapped.checkError();
            return;
        } else {
            if (this.mStatus == null) {
                if (this.mCommFd == null) {
                    Log.w(TAG, "Peer didn't provide a comm channel; unable to check for errors");
                    return;
                }
                this.mStatus = ParcelFileDescriptor.readCommStatus(this.mCommFd, this.getOrCreateStatusBuffer());
            }
            if (this.mStatus == null || this.mStatus.status == 0) return;
            throw this.mStatus.asIOException();
        }
    }

    @Override
    public void close() throws IOException {
        if (this.mWrapped != null) {
            try {
                this.mWrapped.close();
                return;
            }
            finally {
                this.releaseResources();
            }
        }
        this.closeWithStatus(0, null);
    }

    public void closeWithError(String string2) throws IOException {
        if (this.mWrapped != null) {
            try {
                this.mWrapped.closeWithError(string2);
                return;
            }
            finally {
                this.releaseResources();
            }
        }
        if (string2 == null) {
            throw new IllegalArgumentException("Message must not be null");
        }
        this.closeWithStatus(1, string2);
    }

    @Override
    public int describeContents() {
        if (this.mWrapped != null) {
            return this.mWrapped.describeContents();
        }
        return 1;
    }

    public int detachFd() {
        if (this.mWrapped != null) {
            return this.mWrapped.detachFd();
        }
        if (this.mClosed) {
            throw new IllegalStateException("Already closed");
        }
        int n = this.getFd();
        Parcel.clearFileDescriptor(this.mFd);
        this.writeCommStatusAndClose(2, null);
        return n;
    }

    public ParcelFileDescriptor dup() throws IOException {
        if (this.mWrapped != null) {
            return this.mWrapped.dup();
        }
        return ParcelFileDescriptor.dup(this.getFileDescriptor());
    }

    protected void finalize() throws Throwable {
        if (this.mWrapped != null) {
            this.releaseResources();
        }
        if (this.mGuard != null) {
            this.mGuard.warnIfOpen();
        }
        try {
            if (!this.mClosed) {
                this.closeWithStatus(3, null);
            }
            return;
        }
        finally {
            super.finalize();
        }
    }

    public int getFd() {
        if (this.mWrapped != null) {
            return this.mWrapped.getFd();
        }
        if (this.mClosed) {
            throw new IllegalStateException("Already closed");
        }
        return this.mFd.getInt$();
    }

    public FileDescriptor getFileDescriptor() {
        if (this.mWrapped != null) {
            return this.mWrapped.getFileDescriptor();
        }
        return this.mFd;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public long getStatSize() {
        long l = -1L;
        if (this.mWrapped != null) {
            return this.mWrapped.getStatSize();
        }
        try {
            StructStat structStat = Os.fstat(this.mFd);
            if (OsConstants.S_ISREG(structStat.st_mode)) return structStat.st_size;
            if (!OsConstants.S_ISLNK(structStat.st_mode)) return l;
            return structStat.st_size;
        }
        catch (ErrnoException errnoException) {
            Log.w(TAG, "fstat() failed: " + errnoException);
            return l;
        }
    }

    public void releaseResources() {
    }

    public long seekTo(long l) throws IOException {
        if (this.mWrapped != null) {
            return this.mWrapped.seekTo(l);
        }
        try {
            long l2 = Os.lseek(this.mFd, l, OsConstants.SEEK_SET);
            return l2;
        }
        catch (ErrnoException errnoException) {
            throw errnoException.rethrowAsIOException();
        }
    }

    public String toString() {
        if (this.mWrapped != null) {
            return this.mWrapped.toString();
        }
        return "{ParcelFileDescriptor: " + this.mFd + "}";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void writeToParcel(Parcel parcel, int n) {
        if (this.mWrapped != null) {
            try {
                this.mWrapped.writeToParcel(parcel, n);
                return;
            }
            finally {
                this.releaseResources();
            }
        }
        parcel.writeFileDescriptor(this.mFd);
        if (this.mCommFd != null) {
            parcel.writeInt(1);
            parcel.writeFileDescriptor(this.mCommFd);
        } else {
            parcel.writeInt(0);
        }
        if ((n & 1) == 0) return;
        if (this.mClosed) return;
        this.closeWithStatus(-1, null);
    }

    public static class AutoCloseInputStream
    extends FileInputStream {
        private final ParcelFileDescriptor mPfd;

        public AutoCloseInputStream(ParcelFileDescriptor parcelFileDescriptor) {
            super(parcelFileDescriptor.getFileDescriptor());
            this.mPfd = parcelFileDescriptor;
        }

        @Override
        public void close() throws IOException {
            try {
                this.mPfd.close();
                return;
            }
            finally {
                super.close();
            }
        }
    }

    public static class AutoCloseOutputStream
    extends FileOutputStream {
        private final ParcelFileDescriptor mPfd;

        public AutoCloseOutputStream(ParcelFileDescriptor parcelFileDescriptor) {
            super(parcelFileDescriptor.getFileDescriptor());
            this.mPfd = parcelFileDescriptor;
        }

        @Override
        public void close() throws IOException {
            try {
                this.mPfd.close();
                return;
            }
            finally {
                super.close();
            }
        }
    }

    public static class FileDescriptorDetachedException
    extends IOException {
        private static final long serialVersionUID = 955542466045L;

        public FileDescriptorDetachedException() {
            super("Remote side is detached");
        }
    }

    private static final class ListenerBridge
    extends Thread {
        private FileDescriptor mCommFd;
        private final Handler mHandler;

        public ListenerBridge(FileDescriptor fileDescriptor, Looper looper, final OnCloseListener onCloseListener) {
            this.mCommFd = fileDescriptor;
            this.mHandler = new Handler(looper){

                /*
                 * Enabled aggressive block sorting
                 */
                @Override
                public void handleMessage(Message message) {
                    Status status = (Status)message.obj;
                    OnCloseListener onCloseListener2 = onCloseListener;
                    IOException iOException = status != null ? status.asIOException() : null;
                    onCloseListener2.onClose(iOException);
                }
            };
        }

        @Override
        public void run() {
            try {
                byte[] byArray = new byte[1024];
                Status status = ParcelFileDescriptor.readCommStatus(this.mCommFd, byArray);
                this.mHandler.obtainMessage(0, status).sendToTarget();
                return;
            }
            finally {
                IoUtils.closeQuietly((FileDescriptor)this.mCommFd);
                this.mCommFd = null;
            }
        }
    }

    public static interface OnCloseListener {
        public void onClose(IOException var1);
    }

    private static class Status {
        public static final int DEAD = -2;
        public static final int DETACHED = 2;
        public static final int ERROR = 1;
        public static final int LEAKED = 3;
        public static final int OK = 0;
        public static final int SILENCE = -1;
        public final String msg;
        public final int status;

        public Status(int n) {
            this(n, null);
        }

        public Status(int n, String string2) {
            this.status = n;
            this.msg = string2;
        }

        public IOException asIOException() {
            switch (this.status) {
                default: {
                    return new IOException("Unknown status: " + this.status);
                }
                case -2: {
                    return new IOException("Remote side is dead");
                }
                case 0: {
                    return null;
                }
                case 1: {
                    return new IOException("Remote error: " + this.msg);
                }
                case 2: {
                    return new FileDescriptorDetachedException();
                }
                case 3: 
            }
            return new IOException("Remote side was leaked");
        }
    }
}

