/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.os.Binder;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.Process;
import android.util.SparseArray;
import java.io.PrintWriter;

public final class UserHandle
implements Parcelable {
    public static final UserHandle ALL = new UserHandle(-1);
    public static final Parcelable.Creator<UserHandle> CREATOR;
    public static final UserHandle CURRENT;
    public static final UserHandle CURRENT_OR_SELF;
    public static final boolean MU_ENABLED = true;
    public static final UserHandle OWNER;
    public static final int PER_USER_RANGE = 100000;
    public static final int USER_ALL = -1;
    public static final int USER_CURRENT = -2;
    public static final int USER_CURRENT_OR_SELF = -3;
    public static final int USER_NULL = -10000;
    public static final int USER_OWNER;
    private static final SparseArray<UserHandle> userHandles;
    final int mHandle;

    static {
        CURRENT = new UserHandle(-2);
        CURRENT_OR_SELF = new UserHandle(-3);
        OWNER = new UserHandle(0);
        userHandles = new SparseArray();
        CREATOR = new Parcelable.Creator<UserHandle>(){

            @Override
            public UserHandle createFromParcel(Parcel parcel) {
                return new UserHandle(parcel);
            }

            public UserHandle[] newArray(int n) {
                return new UserHandle[n];
            }
        };
    }

    public UserHandle(int n) {
        this.mHandle = n;
    }

    public UserHandle(Parcel parcel) {
        this.mHandle = parcel.readInt();
    }

    public static void formatUid(PrintWriter printWriter, int n) {
        if (n < 10000) {
            printWriter.print(n);
            return;
        }
        printWriter.print('u');
        printWriter.print(UserHandle.getUserId(n));
        int n2 = UserHandle.getAppId(n);
        if (n2 >= 99000 && n2 <= 99999) {
            printWriter.print('i');
            printWriter.print(n2 - 99000);
            return;
        }
        if (n2 >= 10000) {
            printWriter.print('a');
            printWriter.print(n2 - 10000);
            return;
        }
        printWriter.print('s');
        printWriter.print(n2);
    }

    public static void formatUid(StringBuilder stringBuilder, int n) {
        if (n < 10000) {
            stringBuilder.append(n);
            return;
        }
        stringBuilder.append('u');
        stringBuilder.append(UserHandle.getUserId(n));
        int n2 = UserHandle.getAppId(n);
        if (n2 >= 99000 && n2 <= 99999) {
            stringBuilder.append('i');
            stringBuilder.append(n2 - 99000);
            return;
        }
        if (n2 >= 10000) {
            stringBuilder.append('a');
            stringBuilder.append(n2 - 10000);
            return;
        }
        stringBuilder.append('s');
        stringBuilder.append(n2);
    }

    public static final int getAppId(int n) {
        return n % 100000;
    }

    public static final UserHandle getCallingUserHandle() {
        int n = UserHandle.getUserId(Binder.getCallingUid());
        UserHandle userHandle = userHandles.get(n);
        if (userHandle == null) {
            userHandle = new UserHandle(n);
            userHandles.put(n, userHandle);
        }
        return userHandle;
    }

    public static final int getCallingUserId() {
        return UserHandle.getUserId(Binder.getCallingUid());
    }

    public static final int getSharedAppGid(int n) {
        return -10000 + (50000 + n % 100000);
    }

    public static final int getUid(int n, int n2) {
        return n * 100000 + n2 % 100000;
    }

    public static final int getUserGid(int n) {
        return UserHandle.getUid(n, 9997);
    }

    public static final int getUserId(int n) {
        return n / 100000;
    }

    public static boolean isApp(int n) {
        boolean bl = false;
        if (n > 0) {
            int n2 = UserHandle.getAppId(n);
            bl = false;
            if (n2 >= 10000) {
                bl = false;
                if (n2 <= 19999) {
                    bl = true;
                }
            }
        }
        return bl;
    }

    public static final boolean isIsolated(int n) {
        boolean bl = false;
        if (n > 0) {
            int n2 = UserHandle.getAppId(n);
            bl = false;
            if (n2 >= 99000) {
                bl = false;
                if (n2 <= 99999) {
                    bl = true;
                }
            }
        }
        return bl;
    }

    public static final boolean isSameApp(int n, int n2) {
        return UserHandle.getAppId(n) == UserHandle.getAppId(n2);
    }

    public static final boolean isSameUser(int n, int n2) {
        return UserHandle.getUserId(n) == UserHandle.getUserId(n2);
    }

    public static final int myUserId() {
        return UserHandle.getUserId(Process.myUid());
    }

    public static UserHandle readFromParcel(Parcel parcel) {
        int n = parcel.readInt();
        if (n != -10000) {
            return new UserHandle(n);
        }
        return null;
    }

    public static void writeToParcel(UserHandle userHandle, Parcel parcel) {
        if (userHandle != null) {
            userHandle.writeToParcel(parcel, 0);
            return;
        }
        parcel.writeInt(-10000);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object object) {
        boolean bl = false;
        if (object == null) return bl;
        try {
            UserHandle userHandle = (UserHandle)object;
            int n = this.mHandle;
            int n2 = userHandle.mHandle;
            bl = false;
            if (n != n2) return bl;
            return true;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    public int getIdentifier() {
        return this.mHandle;
    }

    public int hashCode() {
        return this.mHandle;
    }

    public final boolean isOwner() {
        return this.equals(OWNER);
    }

    public String toString() {
        return "UserHandle{" + this.mHandle + "}";
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        parcel.writeInt(this.mHandle);
    }
}

