/*
 * Decompiled with CFR 0.152.
 */
package android.preference;

import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.preference.PreferenceManager;
import android.preference.PreferenceScreen;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.AbsSavedState;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import com.android.internal.R;
import com.android.internal.util.CharSequences;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class Preference
implements Comparable<Preference> {
    public static final int DEFAULT_ORDER = Integer.MAX_VALUE;
    private boolean mBaseMethodCalled;
    private boolean mCanRecycleLayout = true;
    private Context mContext;
    private Object mDefaultValue;
    private String mDependencyKey;
    private boolean mDependencyMet = true;
    private List<Preference> mDependents;
    private boolean mEnabled = true;
    private Bundle mExtras;
    private String mFragment;
    private Drawable mIcon;
    private int mIconResId;
    private long mId;
    private Intent mIntent;
    private String mKey;
    private int mLayoutResId = 17367209;
    private OnPreferenceChangeInternalListener mListener;
    private OnPreferenceChangeListener mOnChangeListener;
    private OnPreferenceClickListener mOnClickListener;
    private int mOrder = Integer.MAX_VALUE;
    private boolean mParentDependencyMet = true;
    private boolean mPersistent = true;
    private PreferenceManager mPreferenceManager;
    private boolean mRequiresKey;
    private boolean mSelectable = true;
    private boolean mShouldDisableView = true;
    private CharSequence mSummary;
    private CharSequence mTitle;
    private int mTitleRes;
    private int mWidgetLayoutResId;

    public Preference(Context context) {
        this(context, null);
    }

    public Preference(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 16842894);
    }

    public Preference(Context context, AttributeSet attributeSet, int n) {
        this(context, attributeSet, n, 0);
    }

    /*
     * Enabled aggressive block sorting
     */
    public Preference(Context context, AttributeSet attributeSet, int n, int n2) {
        this.mContext = context;
        TypedArray typedArray = context.obtainStyledAttributes(attributeSet, R.styleable.Preference, n, n2);
        block16: for (int i = typedArray.getIndexCount(); i >= 0; --i) {
            int n3 = typedArray.getIndex(i);
            switch (n3) {
                case 0: {
                    this.mIconResId = typedArray.getResourceId(n3, 0);
                    continue block16;
                }
                case 6: {
                    this.mKey = typedArray.getString(n3);
                    continue block16;
                }
                case 4: {
                    this.mTitleRes = typedArray.getResourceId(n3, 0);
                    this.mTitle = typedArray.getString(n3);
                    continue block16;
                }
                case 7: {
                    this.mSummary = typedArray.getString(n3);
                    continue block16;
                }
                case 8: {
                    this.mOrder = typedArray.getInt(n3, this.mOrder);
                    continue block16;
                }
                case 13: {
                    this.mFragment = typedArray.getString(n3);
                    continue block16;
                }
                case 3: {
                    this.mLayoutResId = typedArray.getResourceId(n3, this.mLayoutResId);
                    continue block16;
                }
                case 9: {
                    this.mWidgetLayoutResId = typedArray.getResourceId(n3, this.mWidgetLayoutResId);
                    continue block16;
                }
                case 2: {
                    this.mEnabled = typedArray.getBoolean(n3, true);
                    continue block16;
                }
                case 5: {
                    this.mSelectable = typedArray.getBoolean(n3, true);
                    continue block16;
                }
                case 1: {
                    this.mPersistent = typedArray.getBoolean(n3, this.mPersistent);
                    continue block16;
                }
                case 10: {
                    this.mDependencyKey = typedArray.getString(n3);
                    continue block16;
                }
                case 11: {
                    this.mDefaultValue = this.onGetDefaultValue(typedArray, n3);
                    continue block16;
                }
                case 12: {
                    this.mShouldDisableView = typedArray.getBoolean(n3, this.mShouldDisableView);
                    continue block16;
                }
            }
        }
        typedArray.recycle();
        if (!this.getClass().getName().startsWith("android.preference") && !this.getClass().getName().startsWith("com.android")) {
            this.mCanRecycleLayout = false;
        }
    }

    private void dispatchSetInitialValue() {
        if (!this.shouldPersist() || !this.getSharedPreferences().contains(this.mKey)) {
            if (this.mDefaultValue != null) {
                this.onSetInitialValue(false, this.mDefaultValue);
            }
            return;
        }
        this.onSetInitialValue(true, null);
    }

    private void registerDependency() {
        if (TextUtils.isEmpty(this.mDependencyKey)) {
            return;
        }
        Preference preference = this.findPreferenceInHierarchy(this.mDependencyKey);
        if (preference != null) {
            preference.registerDependent(this);
            return;
        }
        throw new IllegalStateException("Dependency \"" + this.mDependencyKey + "\" not found for preference \"" + this.mKey + "\" (title: \"" + this.mTitle + "\"");
    }

    private void registerDependent(Preference preference) {
        if (this.mDependents == null) {
            this.mDependents = new ArrayList<Preference>();
        }
        this.mDependents.add(preference);
        preference.onDependencyChanged(this, this.shouldDisableDependents());
    }

    private void setEnabledStateOnViews(View view, boolean bl) {
        view.setEnabled(bl);
        if (view instanceof ViewGroup) {
            ViewGroup viewGroup = (ViewGroup)view;
            for (int i = -1 + viewGroup.getChildCount(); i >= 0; --i) {
                this.setEnabledStateOnViews(viewGroup.getChildAt(i), bl);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void tryCommit(SharedPreferences.Editor editor) {
        if (!this.mPreferenceManager.shouldCommit()) return;
        try {
            editor.apply();
            return;
        }
        catch (AbstractMethodError abstractMethodError) {
            editor.commit();
            return;
        }
    }

    private void unregisterDependency() {
        Preference preference;
        if (this.mDependencyKey != null && (preference = this.findPreferenceInHierarchy(this.mDependencyKey)) != null) {
            preference.unregisterDependent(this);
        }
    }

    private void unregisterDependent(Preference preference) {
        if (this.mDependents != null) {
            this.mDependents.remove(preference);
        }
    }

    protected boolean callChangeListener(Object object) {
        if (this.mOnChangeListener == null) {
            return true;
        }
        return this.mOnChangeListener.onPreferenceChange(this, object);
    }

    boolean canRecycleLayout() {
        return this.mCanRecycleLayout;
    }

    @Override
    public int compareTo(Preference preference) {
        if (this.mOrder != preference.mOrder) {
            return this.mOrder - preference.mOrder;
        }
        if (this.mTitle == preference.mTitle) {
            return 0;
        }
        if (this.mTitle == null) {
            return 1;
        }
        if (preference.mTitle == null) {
            return -1;
        }
        return CharSequences.compareToIgnoreCase(this.mTitle, preference.mTitle);
    }

    void dispatchRestoreInstanceState(Bundle bundle) {
        Object t;
        if (this.hasKey() && (t = bundle.getParcelable(this.mKey)) != null) {
            this.mBaseMethodCalled = false;
            this.onRestoreInstanceState((Parcelable)t);
            if (!this.mBaseMethodCalled) {
                throw new IllegalStateException("Derived class did not call super.onRestoreInstanceState()");
            }
        }
    }

    void dispatchSaveInstanceState(Bundle bundle) {
        if (this.hasKey()) {
            this.mBaseMethodCalled = false;
            Parcelable parcelable = this.onSaveInstanceState();
            if (!this.mBaseMethodCalled) {
                throw new IllegalStateException("Derived class did not call super.onSaveInstanceState()");
            }
            if (parcelable != null) {
                bundle.putParcelable(this.mKey, parcelable);
            }
        }
    }

    protected Preference findPreferenceInHierarchy(String string2) {
        if (TextUtils.isEmpty(string2) || this.mPreferenceManager == null) {
            return null;
        }
        return this.mPreferenceManager.findPreference(string2);
    }

    public Context getContext() {
        return this.mContext;
    }

    public String getDependency() {
        return this.mDependencyKey;
    }

    public SharedPreferences.Editor getEditor() {
        if (this.mPreferenceManager == null) {
            return null;
        }
        return this.mPreferenceManager.getEditor();
    }

    public Bundle getExtras() {
        if (this.mExtras == null) {
            this.mExtras = new Bundle();
        }
        return this.mExtras;
    }

    StringBuilder getFilterableStringBuilder() {
        CharSequence charSequence;
        StringBuilder stringBuilder = new StringBuilder();
        CharSequence charSequence2 = this.getTitle();
        if (!TextUtils.isEmpty(charSequence2)) {
            stringBuilder.append(charSequence2).append(' ');
        }
        if (!TextUtils.isEmpty(charSequence = this.getSummary())) {
            stringBuilder.append(charSequence).append(' ');
        }
        if (stringBuilder.length() > 0) {
            stringBuilder.setLength(-1 + stringBuilder.length());
        }
        return stringBuilder;
    }

    public String getFragment() {
        return this.mFragment;
    }

    public Drawable getIcon() {
        return this.mIcon;
    }

    long getId() {
        return this.mId;
    }

    public Intent getIntent() {
        return this.mIntent;
    }

    public String getKey() {
        return this.mKey;
    }

    public int getLayoutResource() {
        return this.mLayoutResId;
    }

    public OnPreferenceChangeListener getOnPreferenceChangeListener() {
        return this.mOnChangeListener;
    }

    public OnPreferenceClickListener getOnPreferenceClickListener() {
        return this.mOnClickListener;
    }

    public int getOrder() {
        return this.mOrder;
    }

    protected boolean getPersistedBoolean(boolean bl) {
        if (!this.shouldPersist()) {
            return bl;
        }
        return this.mPreferenceManager.getSharedPreferences().getBoolean(this.mKey, bl);
    }

    protected float getPersistedFloat(float f) {
        if (!this.shouldPersist()) {
            return f;
        }
        return this.mPreferenceManager.getSharedPreferences().getFloat(this.mKey, f);
    }

    protected int getPersistedInt(int n) {
        if (!this.shouldPersist()) {
            return n;
        }
        return this.mPreferenceManager.getSharedPreferences().getInt(this.mKey, n);
    }

    protected long getPersistedLong(long l) {
        if (!this.shouldPersist()) {
            return l;
        }
        return this.mPreferenceManager.getSharedPreferences().getLong(this.mKey, l);
    }

    protected String getPersistedString(String string2) {
        if (!this.shouldPersist()) {
            return string2;
        }
        return this.mPreferenceManager.getSharedPreferences().getString(this.mKey, string2);
    }

    protected Set<String> getPersistedStringSet(Set<String> set) {
        if (!this.shouldPersist()) {
            return set;
        }
        return this.mPreferenceManager.getSharedPreferences().getStringSet(this.mKey, set);
    }

    public PreferenceManager getPreferenceManager() {
        return this.mPreferenceManager;
    }

    public SharedPreferences getSharedPreferences() {
        if (this.mPreferenceManager == null) {
            return null;
        }
        return this.mPreferenceManager.getSharedPreferences();
    }

    public boolean getShouldDisableView() {
        return this.mShouldDisableView;
    }

    public CharSequence getSummary() {
        return this.mSummary;
    }

    public CharSequence getTitle() {
        return this.mTitle;
    }

    public int getTitleRes() {
        return this.mTitleRes;
    }

    public View getView(View view, ViewGroup viewGroup) {
        if (view == null) {
            view = this.onCreateView(viewGroup);
        }
        this.onBindView(view);
        return view;
    }

    public int getWidgetLayoutResource() {
        return this.mWidgetLayoutResId;
    }

    public boolean hasKey() {
        return !TextUtils.isEmpty(this.mKey);
    }

    public boolean isEnabled() {
        return this.mEnabled && this.mDependencyMet && this.mParentDependencyMet;
    }

    public boolean isPersistent() {
        return this.mPersistent;
    }

    public boolean isSelectable() {
        return this.mSelectable;
    }

    protected void notifyChanged() {
        if (this.mListener != null) {
            this.mListener.onPreferenceChange(this);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void notifyDependencyChange(boolean bl) {
        List<Preference> list = this.mDependents;
        if (list != null) {
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                list.get(i).onDependencyChanged(this, bl);
            }
        }
    }

    protected void notifyHierarchyChanged() {
        if (this.mListener != null) {
            this.mListener.onPreferenceHierarchyChange(this);
        }
    }

    protected void onAttachedToActivity() {
        this.registerDependency();
    }

    protected void onAttachedToHierarchy(PreferenceManager preferenceManager) {
        this.mPreferenceManager = preferenceManager;
        this.mId = preferenceManager.getNextId();
        this.dispatchSetInitialValue();
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void onBindView(View view) {
        View view2;
        ImageView imageView;
        TextView textView;
        TextView textView2 = (TextView)view.findViewById(16908310);
        if (textView2 != null) {
            CharSequence charSequence = this.getTitle();
            if (!TextUtils.isEmpty(charSequence)) {
                textView2.setText(charSequence);
                textView2.setVisibility(0);
            } else {
                textView2.setVisibility(8);
            }
        }
        if ((textView = (TextView)view.findViewById(0x1020010)) != null) {
            CharSequence charSequence = this.getSummary();
            if (!TextUtils.isEmpty(charSequence)) {
                textView.setText(charSequence);
                textView.setVisibility(0);
            } else {
                textView.setVisibility(8);
            }
        }
        if ((imageView = (ImageView)view.findViewById(16908294)) != null) {
            if (this.mIconResId != 0 || this.mIcon != null) {
                if (this.mIcon == null) {
                    this.mIcon = this.getContext().getDrawable(this.mIconResId);
                }
                if (this.mIcon != null) {
                    imageView.setImageDrawable(this.mIcon);
                }
            }
            int n = this.mIcon != null ? 0 : 8;
            imageView.setVisibility(n);
        }
        if ((view2 = view.findViewById(16909207)) != null) {
            Drawable drawable2 = this.mIcon;
            int n = 0;
            if (drawable2 == null) {
                n = 8;
            }
            view2.setVisibility(n);
        }
        if (this.mShouldDisableView) {
            this.setEnabledStateOnViews(view, this.isEnabled());
        }
    }

    protected void onClick() {
    }

    protected View onCreateView(ViewGroup viewGroup) {
        ViewGroup viewGroup2;
        View view;
        block3: {
            block2: {
                LayoutInflater layoutInflater = (LayoutInflater)this.mContext.getSystemService("layout_inflater");
                view = layoutInflater.inflate(this.mLayoutResId, viewGroup, false);
                viewGroup2 = (ViewGroup)view.findViewById(16908312);
                if (viewGroup2 == null) break block2;
                if (this.mWidgetLayoutResId == 0) break block3;
                layoutInflater.inflate(this.mWidgetLayoutResId, viewGroup2);
            }
            return view;
        }
        viewGroup2.setVisibility(8);
        return view;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void onDependencyChanged(Preference preference, boolean bl) {
        if (this.mDependencyMet == bl) {
            boolean bl2 = !bl;
            this.mDependencyMet = bl2;
            this.notifyDependencyChange(this.shouldDisableDependents());
            this.notifyChanged();
        }
    }

    protected Object onGetDefaultValue(TypedArray typedArray, int n) {
        return null;
    }

    public boolean onKey(View view, int n, KeyEvent keyEvent) {
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void onParentChanged(Preference preference, boolean bl) {
        if (this.mParentDependencyMet == bl) {
            boolean bl2 = !bl;
            this.mParentDependencyMet = bl2;
            this.notifyDependencyChange(this.shouldDisableDependents());
            this.notifyChanged();
        }
    }

    protected void onPrepareForRemoval() {
        this.unregisterDependency();
    }

    protected void onRestoreInstanceState(Parcelable parcelable) {
        this.mBaseMethodCalled = true;
        if (parcelable != BaseSavedState.EMPTY_STATE && parcelable != null) {
            throw new IllegalArgumentException("Wrong state class -- expecting Preference State");
        }
    }

    protected Parcelable onSaveInstanceState() {
        this.mBaseMethodCalled = true;
        return BaseSavedState.EMPTY_STATE;
    }

    protected void onSetInitialValue(boolean bl, Object object) {
    }

    public Bundle peekExtras() {
        return this.mExtras;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void performClick(PreferenceScreen preferenceScreen) {
        block4: {
            block2: {
                block3: {
                    if (!this.isEnabled()) break block2;
                    this.onClick();
                    if (this.mOnClickListener != null && this.mOnClickListener.onPreferenceClick(this)) break block2;
                    PreferenceManager preferenceManager = this.getPreferenceManager();
                    if (preferenceManager == null) break block3;
                    PreferenceManager.OnPreferenceTreeClickListener onPreferenceTreeClickListener = preferenceManager.getOnPreferenceTreeClickListener();
                    if (preferenceScreen != null && onPreferenceTreeClickListener != null && onPreferenceTreeClickListener.onPreferenceTreeClick(preferenceScreen, this)) break block2;
                }
                if (this.mIntent != null) break block4;
            }
            return;
        }
        this.getContext().startActivity(this.mIntent);
    }

    protected boolean persistBoolean(boolean bl) {
        if (this.shouldPersist()) {
            boolean bl2 = false;
            if (!bl) {
                bl2 = true;
            }
            if (bl == this.getPersistedBoolean(bl2)) {
                return true;
            }
            SharedPreferences.Editor editor = this.mPreferenceManager.getEditor();
            editor.putBoolean(this.mKey, bl);
            this.tryCommit(editor);
            return true;
        }
        return false;
    }

    protected boolean persistFloat(float f) {
        if (this.shouldPersist()) {
            if (f == this.getPersistedFloat(Float.NaN)) {
                return true;
            }
            SharedPreferences.Editor editor = this.mPreferenceManager.getEditor();
            editor.putFloat(this.mKey, f);
            this.tryCommit(editor);
            return true;
        }
        return false;
    }

    protected boolean persistInt(int n) {
        if (this.shouldPersist()) {
            if (n == this.getPersistedInt(~n)) {
                return true;
            }
            SharedPreferences.Editor editor = this.mPreferenceManager.getEditor();
            editor.putInt(this.mKey, n);
            this.tryCommit(editor);
            return true;
        }
        return false;
    }

    protected boolean persistLong(long l) {
        if (this.shouldPersist()) {
            if (l == this.getPersistedLong(0xFFFFFFFFFFFFFFFFL ^ l)) {
                return true;
            }
            SharedPreferences.Editor editor = this.mPreferenceManager.getEditor();
            editor.putLong(this.mKey, l);
            this.tryCommit(editor);
            return true;
        }
        return false;
    }

    protected boolean persistString(String string2) {
        if (this.shouldPersist()) {
            if (string2 == this.getPersistedString(null)) {
                return true;
            }
            SharedPreferences.Editor editor = this.mPreferenceManager.getEditor();
            editor.putString(this.mKey, string2);
            this.tryCommit(editor);
            return true;
        }
        return false;
    }

    protected boolean persistStringSet(Set<String> set) {
        if (this.shouldPersist()) {
            if (set.equals(this.getPersistedStringSet(null))) {
                return true;
            }
            SharedPreferences.Editor editor = this.mPreferenceManager.getEditor();
            editor.putStringSet(this.mKey, set);
            this.tryCommit(editor);
            return true;
        }
        return false;
    }

    void requireKey() {
        if (this.mKey == null) {
            throw new IllegalStateException("Preference does not have a key assigned.");
        }
        this.mRequiresKey = true;
    }

    public void restoreHierarchyState(Bundle bundle) {
        this.dispatchRestoreInstanceState(bundle);
    }

    public void saveHierarchyState(Bundle bundle) {
        this.dispatchSaveInstanceState(bundle);
    }

    public void setDefaultValue(Object object) {
        this.mDefaultValue = object;
    }

    public void setDependency(String string2) {
        this.unregisterDependency();
        this.mDependencyKey = string2;
        this.registerDependency();
    }

    public void setEnabled(boolean bl) {
        if (this.mEnabled != bl) {
            this.mEnabled = bl;
            this.notifyDependencyChange(this.shouldDisableDependents());
            this.notifyChanged();
        }
    }

    public void setFragment(String string2) {
        this.mFragment = string2;
    }

    public void setIcon(int n) {
        this.mIconResId = n;
        this.setIcon(this.mContext.getDrawable(n));
    }

    public void setIcon(Drawable drawable2) {
        if (drawable2 == null && this.mIcon != null || drawable2 != null && this.mIcon != drawable2) {
            this.mIcon = drawable2;
            this.notifyChanged();
        }
    }

    public void setIntent(Intent intent) {
        this.mIntent = intent;
    }

    public void setKey(String string2) {
        this.mKey = string2;
        if (this.mRequiresKey && !this.hasKey()) {
            this.requireKey();
        }
    }

    public void setLayoutResource(int n) {
        if (n != this.mLayoutResId) {
            this.mCanRecycleLayout = false;
        }
        this.mLayoutResId = n;
    }

    final void setOnPreferenceChangeInternalListener(OnPreferenceChangeInternalListener onPreferenceChangeInternalListener) {
        this.mListener = onPreferenceChangeInternalListener;
    }

    public void setOnPreferenceChangeListener(OnPreferenceChangeListener onPreferenceChangeListener) {
        this.mOnChangeListener = onPreferenceChangeListener;
    }

    public void setOnPreferenceClickListener(OnPreferenceClickListener onPreferenceClickListener) {
        this.mOnClickListener = onPreferenceClickListener;
    }

    public void setOrder(int n) {
        if (n != this.mOrder) {
            this.mOrder = n;
            this.notifyHierarchyChanged();
        }
    }

    public void setPersistent(boolean bl) {
        this.mPersistent = bl;
    }

    public void setSelectable(boolean bl) {
        if (this.mSelectable != bl) {
            this.mSelectable = bl;
            this.notifyChanged();
        }
    }

    public void setShouldDisableView(boolean bl) {
        this.mShouldDisableView = bl;
        this.notifyChanged();
    }

    public void setSummary(int n) {
        this.setSummary(this.mContext.getString(n));
    }

    public void setSummary(CharSequence charSequence) {
        if (charSequence == null && this.mSummary != null || charSequence != null && !charSequence.equals(this.mSummary)) {
            this.mSummary = charSequence;
            this.notifyChanged();
        }
    }

    public void setTitle(int n) {
        this.setTitle(this.mContext.getString(n));
        this.mTitleRes = n;
    }

    public void setTitle(CharSequence charSequence) {
        if (charSequence == null && this.mTitle != null || charSequence != null && !charSequence.equals(this.mTitle)) {
            this.mTitleRes = 0;
            this.mTitle = charSequence;
            this.notifyChanged();
        }
    }

    public void setWidgetLayoutResource(int n) {
        if (n != this.mWidgetLayoutResId) {
            this.mCanRecycleLayout = false;
        }
        this.mWidgetLayoutResId = n;
    }

    public boolean shouldCommit() {
        if (this.mPreferenceManager == null) {
            return false;
        }
        return this.mPreferenceManager.shouldCommit();
    }

    public boolean shouldDisableDependents() {
        return !this.isEnabled();
    }

    protected boolean shouldPersist() {
        return this.mPreferenceManager != null && this.isPersistent() && this.hasKey();
    }

    public String toString() {
        return this.getFilterableStringBuilder().toString();
    }

    public static class BaseSavedState
    extends AbsSavedState {
        public static final Parcelable.Creator<BaseSavedState> CREATOR = new Parcelable.Creator<BaseSavedState>(){

            @Override
            public BaseSavedState createFromParcel(Parcel parcel) {
                return new BaseSavedState(parcel);
            }

            public BaseSavedState[] newArray(int n) {
                return new BaseSavedState[n];
            }
        };

        public BaseSavedState(Parcel parcel) {
            super(parcel);
        }

        public BaseSavedState(Parcelable parcelable) {
            super(parcelable);
        }
    }

    static interface OnPreferenceChangeInternalListener {
        public void onPreferenceChange(Preference var1);

        public void onPreferenceHierarchyChange(Preference var1);
    }

    public static interface OnPreferenceChangeListener {
        public boolean onPreferenceChange(Preference var1, Object var2);
    }

    public static interface OnPreferenceClickListener {
        public boolean onPreferenceClick(Preference var1);
    }
}

