/*
 * Decompiled with CFR 0.152.
 */
package android.preference;

import android.graphics.drawable.Drawable;
import android.os.Handler;
import android.preference.Preference;
import android.preference.PreferenceGroup;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.FrameLayout;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class PreferenceGroupAdapter
extends BaseAdapter
implements Preference.OnPreferenceChangeInternalListener {
    private static final String TAG = "PreferenceGroupAdapter";
    private static ViewGroup.LayoutParams sWrapperLayoutParams = new ViewGroup.LayoutParams(-1, -2);
    private Handler mHandler;
    private boolean mHasReturnedViewTypeCount = false;
    private Drawable mHighlightedDrawable;
    private int mHighlightedPosition = -1;
    private volatile boolean mIsSyncing = false;
    private PreferenceGroup mPreferenceGroup;
    private ArrayList<PreferenceLayout> mPreferenceLayouts;
    private List<Preference> mPreferenceList;
    private Runnable mSyncRunnable;
    private PreferenceLayout mTempPreferenceLayout = new PreferenceLayout();

    public PreferenceGroupAdapter(PreferenceGroup preferenceGroup) {
        this.mHandler = new Handler();
        this.mSyncRunnable = new Runnable(){

            @Override
            public void run() {
                PreferenceGroupAdapter.this.syncMyPreferences();
            }
        };
        this.mPreferenceGroup = preferenceGroup;
        this.mPreferenceGroup.setOnPreferenceChangeInternalListener(this);
        this.mPreferenceList = new ArrayList<Preference>();
        this.mPreferenceLayouts = new ArrayList();
        this.syncMyPreferences();
    }

    private void addPreferenceClassName(Preference preference) {
        PreferenceLayout preferenceLayout = this.createPreferenceLayout(preference, null);
        int n = Collections.binarySearch(this.mPreferenceLayouts, preferenceLayout);
        if (n < 0) {
            int n2 = -1 + n * -1;
            this.mPreferenceLayouts.add(n2, preferenceLayout);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private PreferenceLayout createPreferenceLayout(Preference preference, PreferenceLayout preferenceLayout) {
        PreferenceLayout preferenceLayout2 = preferenceLayout != null ? preferenceLayout : new PreferenceLayout();
        PreferenceLayout.access$202(preferenceLayout2, preference.getClass().getName());
        PreferenceLayout.access$302(preferenceLayout2, preference.getLayoutResource());
        PreferenceLayout.access$402(preferenceLayout2, preference.getWidgetLayoutResource());
        return preferenceLayout2;
    }

    private void flattenPreferenceGroup(List<Preference> list, PreferenceGroup preferenceGroup) {
        preferenceGroup.sortPreferences();
        int n = preferenceGroup.getPreferenceCount();
        for (int i = 0; i < n; ++i) {
            PreferenceGroup preferenceGroup2;
            Preference preference = preferenceGroup.getPreference(i);
            list.add(preference);
            if (!this.mHasReturnedViewTypeCount && preference.canRecycleLayout()) {
                this.addPreferenceClassName(preference);
            }
            if (preference instanceof PreferenceGroup && (preferenceGroup2 = (PreferenceGroup)preference).isOnSameScreenAsChildren()) {
                this.flattenPreferenceGroup(list, preferenceGroup2);
            }
            preference.setOnPreferenceChangeInternalListener(this);
        }
    }

    private int getHighlightItemViewType() {
        return -1 + this.getViewTypeCount();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void syncMyPreferences() {
        synchronized (this) {
            if (this.mIsSyncing) {
                return;
            }
            this.mIsSyncing = true;
        }
        ArrayList<Preference> arrayList = new ArrayList<Preference>(this.mPreferenceList.size());
        this.flattenPreferenceGroup(arrayList, this.mPreferenceGroup);
        this.mPreferenceList = arrayList;
        this.notifyDataSetChanged();
        synchronized (this) {
            this.mIsSyncing = false;
            this.notifyAll();
            return;
        }
    }

    @Override
    public boolean areAllItemsEnabled() {
        return false;
    }

    @Override
    public int getCount() {
        return this.mPreferenceList.size();
    }

    @Override
    public Preference getItem(int n) {
        if (n < 0 || n >= this.getCount()) {
            return null;
        }
        return this.mPreferenceList.get(n);
    }

    @Override
    public long getItemId(int n) {
        if (n < 0 || n >= this.getCount()) {
            return Long.MIN_VALUE;
        }
        return this.getItem(n).getId();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int getItemViewType(int n) {
        Preference preference;
        if (n == this.mHighlightedPosition) {
            return this.getHighlightItemViewType();
        }
        if (!this.mHasReturnedViewTypeCount) {
            this.mHasReturnedViewTypeCount = true;
        }
        if (!(preference = this.getItem(n)).canRecycleLayout()) {
            return -1;
        }
        this.mTempPreferenceLayout = this.createPreferenceLayout(preference, this.mTempPreferenceLayout);
        int n2 = Collections.binarySearch(this.mPreferenceLayouts, this.mTempPreferenceLayout);
        if (n2 >= 0) return n2;
        return -1;
    }

    @Override
    public View getView(int n, View view, ViewGroup viewGroup) {
        Preference preference = this.getItem(n);
        this.mTempPreferenceLayout = this.createPreferenceLayout(preference, this.mTempPreferenceLayout);
        if (Collections.binarySearch(this.mPreferenceLayouts, this.mTempPreferenceLayout) < 0 || this.getItemViewType(n) == this.getHighlightItemViewType()) {
            view = null;
        }
        View view2 = preference.getView(view, viewGroup);
        if (n == this.mHighlightedPosition && this.mHighlightedDrawable != null) {
            FrameLayout frameLayout = new FrameLayout(viewGroup.getContext());
            frameLayout.setLayoutParams(sWrapperLayoutParams);
            frameLayout.setBackgroundDrawable(this.mHighlightedDrawable);
            frameLayout.addView(view2);
            view2 = frameLayout;
        }
        return view2;
    }

    @Override
    public int getViewTypeCount() {
        if (!this.mHasReturnedViewTypeCount) {
            this.mHasReturnedViewTypeCount = true;
        }
        return 1 + Math.max(1, this.mPreferenceLayouts.size());
    }

    @Override
    public boolean hasStableIds() {
        return true;
    }

    @Override
    public boolean isEnabled(int n) {
        if (n < 0 || n >= this.getCount()) {
            return true;
        }
        return this.getItem(n).isSelectable();
    }

    @Override
    public void onPreferenceChange(Preference preference) {
        this.notifyDataSetChanged();
    }

    @Override
    public void onPreferenceHierarchyChange(Preference preference) {
        this.mHandler.removeCallbacks(this.mSyncRunnable);
        this.mHandler.post(this.mSyncRunnable);
    }

    public void setHighlighted(int n) {
        this.mHighlightedPosition = n;
    }

    public void setHighlightedDrawable(Drawable drawable2) {
        this.mHighlightedDrawable = drawable2;
    }

    private static class PreferenceLayout
    implements Comparable<PreferenceLayout> {
        private String name;
        private int resId;
        private int widgetResId;

        private PreferenceLayout() {
        }

        static /* synthetic */ String access$202(PreferenceLayout preferenceLayout, String string2) {
            preferenceLayout.name = string2;
            return string2;
        }

        static /* synthetic */ int access$302(PreferenceLayout preferenceLayout, int n) {
            preferenceLayout.resId = n;
            return n;
        }

        static /* synthetic */ int access$402(PreferenceLayout preferenceLayout, int n) {
            preferenceLayout.widgetResId = n;
            return n;
        }

        @Override
        public int compareTo(PreferenceLayout preferenceLayout) {
            block3: {
                block4: {
                    int n;
                    block2: {
                        n = this.name.compareTo(preferenceLayout.name);
                        if (n != 0) break block2;
                        if (this.resId != preferenceLayout.resId) break block3;
                        if (this.widgetResId != preferenceLayout.widgetResId) break block4;
                        n = 0;
                    }
                    return n;
                }
                return this.widgetResId - preferenceLayout.widgetResId;
            }
            return this.resId - preferenceLayout.resId;
        }
    }
}

