/*
 * Decompiled with CFR 0.152.
 */
package android.provider;

import android.content.ContentResolver;
import android.content.ContentUris;
import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.DatabaseUtils;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import android.net.Uri;
import android.os.Environment;
import android.os.ParcelFileDescriptor;
import android.provider.BaseColumns;
import android.util.Log;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public final class MediaStore {
    public static final String ACTION_IMAGE_CAPTURE = "android.media.action.IMAGE_CAPTURE";
    public static final String ACTION_IMAGE_CAPTURE_SECURE = "android.media.action.IMAGE_CAPTURE_SECURE";
    public static final String ACTION_MTP_SESSION_END = "android.provider.action.MTP_SESSION_END";
    public static final String ACTION_VIDEO_CAPTURE = "android.media.action.VIDEO_CAPTURE";
    public static final String AUTHORITY = "media";
    private static final String CONTENT_AUTHORITY_SLASH = "content://media/";
    public static final String EXTRA_DURATION_LIMIT = "android.intent.extra.durationLimit";
    public static final String EXTRA_FINISH_ON_COMPLETION = "android.intent.extra.finishOnCompletion";
    public static final String EXTRA_FULL_SCREEN = "android.intent.extra.fullScreen";
    public static final String EXTRA_MEDIA_ALBUM = "android.intent.extra.album";
    public static final String EXTRA_MEDIA_ARTIST = "android.intent.extra.artist";
    public static final String EXTRA_MEDIA_FOCUS = "android.intent.extra.focus";
    public static final String EXTRA_MEDIA_GENRE = "android.intent.extra.genre";
    public static final String EXTRA_MEDIA_PLAYLIST = "android.intent.extra.playlist";
    public static final String EXTRA_MEDIA_RADIO_CHANNEL = "android.intent.extra.radio_channel";
    public static final String EXTRA_MEDIA_TITLE = "android.intent.extra.title";
    public static final String EXTRA_OUTPUT = "output";
    public static final String EXTRA_SCREEN_ORIENTATION = "android.intent.extra.screenOrientation";
    public static final String EXTRA_SHOW_ACTION_ICONS = "android.intent.extra.showActionIcons";
    public static final String EXTRA_SIZE_LIMIT = "android.intent.extra.sizeLimit";
    public static final String EXTRA_VIDEO_QUALITY = "android.intent.extra.videoQuality";
    public static final String INTENT_ACTION_MEDIA_PLAY_FROM_SEARCH = "android.media.action.MEDIA_PLAY_FROM_SEARCH";
    public static final String INTENT_ACTION_MEDIA_SEARCH = "android.intent.action.MEDIA_SEARCH";
    @Deprecated
    public static final String INTENT_ACTION_MUSIC_PLAYER = "android.intent.action.MUSIC_PLAYER";
    public static final String INTENT_ACTION_STILL_IMAGE_CAMERA = "android.media.action.STILL_IMAGE_CAMERA";
    public static final String INTENT_ACTION_STILL_IMAGE_CAMERA_SECURE = "android.media.action.STILL_IMAGE_CAMERA_SECURE";
    public static final String INTENT_ACTION_TEXT_OPEN_FROM_SEARCH = "android.media.action.TEXT_OPEN_FROM_SEARCH";
    public static final String INTENT_ACTION_VIDEO_CAMERA = "android.media.action.VIDEO_CAMERA";
    public static final String INTENT_ACTION_VIDEO_PLAY_FROM_SEARCH = "android.media.action.VIDEO_PLAY_FROM_SEARCH";
    public static final String MEDIA_IGNORE_FILENAME = ".nomedia";
    public static final String MEDIA_SCANNER_VOLUME = "volume";
    public static final String PARAM_DELETE_DATA = "deletedata";
    private static final String TAG = "MediaStore";
    public static final String UNHIDE_CALL = "unhide";
    public static final String UNKNOWN_STRING = "<unknown>";

    public static Uri getMediaScannerUri() {
        return Uri.parse("content://media/none/media_scanner");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getVersion(Context context) {
        Cursor cursor;
        block2: {
            cursor = context.getContentResolver().query(Uri.parse("content://media/none/version"), null, null, null, null);
            String string2 = null;
            if (cursor == null) return string2;
            try {
                String string3;
                if (!cursor.moveToFirst()) break block2;
                string2 = string3 = cursor.getString(0);
                cursor.close();
            }
            catch (Throwable throwable) {
                cursor.close();
                throw throwable;
            }
            return string2;
        }
        cursor.close();
        return null;
    }

    public static final class Audio {
        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public static String keyFor(String string2) {
            String string3;
            String string4;
            if (string2 == null) return null;
            if (string2.equals(MediaStore.UNKNOWN_STRING)) {
                return "\u0001";
            }
            boolean bl = string2.startsWith("\u0001");
            boolean bl2 = false;
            if (bl) {
                bl2 = true;
            }
            if ((string4 = string2.trim().toLowerCase()).startsWith("the ")) {
                string4 = string4.substring(4);
            }
            if (string4.startsWith("an ")) {
                string4 = string4.substring(3);
            }
            if (string4.startsWith("a ")) {
                string4 = string4.substring(2);
            }
            if (string4.endsWith(", the") || string4.endsWith(",the") || string4.endsWith(", an") || string4.endsWith(",an") || string4.endsWith(", a") || string4.endsWith(",a")) {
                string4 = string4.substring(0, string4.lastIndexOf(44));
            }
            if ((string3 = string4.replaceAll("[\\[\\]\\(\\)\"'.,?!]", "").trim()).length() <= 0) return "";
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append('.');
            int n = string3.length();
            for (int i = 0; i < n; ++i) {
                stringBuilder.append(string3.charAt(i));
                stringBuilder.append('.');
            }
            String string5 = DatabaseUtils.getCollationKey(stringBuilder.toString());
            if (!bl2) return string5;
            return "\u0001" + string5;
        }

        public static interface AlbumColumns {
            public static final String ALBUM = "album";
            public static final String ALBUM_ART = "album_art";
            public static final String ALBUM_ID = "album_id";
            public static final String ALBUM_KEY = "album_key";
            public static final String ARTIST = "artist";
            public static final String FIRST_YEAR = "minyear";
            public static final String LAST_YEAR = "maxyear";
            public static final String NUMBER_OF_SONGS = "numsongs";
            public static final String NUMBER_OF_SONGS_FOR_ARTIST = "numsongs_by_artist";
        }

        public static final class Albums
        implements BaseColumns,
        AlbumColumns {
            public static final String CONTENT_TYPE = "vnd.android.cursor.dir/albums";
            public static final String DEFAULT_SORT_ORDER = "album_key";
            public static final String ENTRY_CONTENT_TYPE = "vnd.android.cursor.item/album";
            public static final Uri EXTERNAL_CONTENT_URI;
            public static final Uri INTERNAL_CONTENT_URI;

            static {
                INTERNAL_CONTENT_URI = Albums.getContentUri("internal");
                EXTERNAL_CONTENT_URI = Albums.getContentUri("external");
            }

            public static Uri getContentUri(String string2) {
                return Uri.parse(MediaStore.CONTENT_AUTHORITY_SLASH + string2 + "/audio/albums");
            }
        }

        public static interface ArtistColumns {
            public static final String ARTIST = "artist";
            public static final String ARTIST_KEY = "artist_key";
            public static final String NUMBER_OF_ALBUMS = "number_of_albums";
            public static final String NUMBER_OF_TRACKS = "number_of_tracks";
        }

        public static final class Artists
        implements BaseColumns,
        ArtistColumns {
            public static final String CONTENT_TYPE = "vnd.android.cursor.dir/artists";
            public static final String DEFAULT_SORT_ORDER = "artist_key";
            public static final String ENTRY_CONTENT_TYPE = "vnd.android.cursor.item/artist";
            public static final Uri EXTERNAL_CONTENT_URI;
            public static final Uri INTERNAL_CONTENT_URI;

            static {
                INTERNAL_CONTENT_URI = Artists.getContentUri("internal");
                EXTERNAL_CONTENT_URI = Artists.getContentUri("external");
            }

            public static Uri getContentUri(String string2) {
                return Uri.parse(MediaStore.CONTENT_AUTHORITY_SLASH + string2 + "/audio/artists");
            }

            public static final class Albums
            implements AlbumColumns {
                public static final Uri getContentUri(String string2, long l) {
                    return Uri.parse(MediaStore.CONTENT_AUTHORITY_SLASH + string2 + "/audio/artists/" + l + "/albums");
                }
            }
        }

        public static interface AudioColumns
        extends MediaColumns {
            public static final String ALBUM = "album";
            public static final String ALBUM_ARTIST = "album_artist";
            public static final String ALBUM_ID = "album_id";
            public static final String ALBUM_KEY = "album_key";
            public static final String ARTIST = "artist";
            public static final String ARTIST_ID = "artist_id";
            public static final String ARTIST_KEY = "artist_key";
            public static final String BOOKMARK = "bookmark";
            public static final String COMPILATION = "compilation";
            public static final String COMPOSER = "composer";
            public static final String DURATION = "duration";
            public static final String GENRE = "genre";
            public static final String IS_ALARM = "is_alarm";
            public static final String IS_MUSIC = "is_music";
            public static final String IS_NOTIFICATION = "is_notification";
            public static final String IS_PODCAST = "is_podcast";
            public static final String IS_RINGTONE = "is_ringtone";
            public static final String TITLE_KEY = "title_key";
            public static final String TRACK = "track";
            public static final String YEAR = "year";
        }

        public static final class Genres
        implements BaseColumns,
        GenresColumns {
            public static final String CONTENT_TYPE = "vnd.android.cursor.dir/genre";
            public static final String DEFAULT_SORT_ORDER = "name";
            public static final String ENTRY_CONTENT_TYPE = "vnd.android.cursor.item/genre";
            public static final Uri EXTERNAL_CONTENT_URI;
            public static final Uri INTERNAL_CONTENT_URI;

            static {
                INTERNAL_CONTENT_URI = Genres.getContentUri("internal");
                EXTERNAL_CONTENT_URI = Genres.getContentUri("external");
            }

            public static Uri getContentUri(String string2) {
                return Uri.parse(MediaStore.CONTENT_AUTHORITY_SLASH + string2 + "/audio/genres");
            }

            public static Uri getContentUriForAudioId(String string2, int n) {
                return Uri.parse(MediaStore.CONTENT_AUTHORITY_SLASH + string2 + "/audio/media/" + n + "/genres");
            }

            public static final class Members
            implements AudioColumns {
                public static final String AUDIO_ID = "audio_id";
                public static final String CONTENT_DIRECTORY = "members";
                public static final String DEFAULT_SORT_ORDER = "title_key";
                public static final String GENRE_ID = "genre_id";

                public static final Uri getContentUri(String string2, long l) {
                    return Uri.parse(MediaStore.CONTENT_AUTHORITY_SLASH + string2 + "/audio/genres/" + l + "/members");
                }
            }
        }

        public static interface GenresColumns {
            public static final String NAME = "name";
        }

        public static final class Media
        implements AudioColumns {
            public static final String CONTENT_TYPE = "vnd.android.cursor.dir/audio";
            public static final String DEFAULT_SORT_ORDER = "title_key";
            public static final String ENTRY_CONTENT_TYPE = "vnd.android.cursor.item/audio";
            public static final Uri EXTERNAL_CONTENT_URI;
            private static final String[] EXTERNAL_PATHS;
            public static final String EXTRA_MAX_BYTES = "android.provider.MediaStore.extra.MAX_BYTES";
            public static final Uri INTERNAL_CONTENT_URI;
            public static final String RECORD_SOUND_ACTION = "android.provider.MediaStore.RECORD_SOUND";

            /*
             * Enabled aggressive block sorting
             */
            static {
                String string2 = System.getenv("SECONDARY_STORAGE");
                EXTERNAL_PATHS = string2 != null ? string2.split(":") : new String[0];
                INTERNAL_CONTENT_URI = Media.getContentUri("internal");
                EXTERNAL_CONTENT_URI = Media.getContentUri("external");
            }

            public static Uri getContentUri(String string2) {
                return Uri.parse(MediaStore.CONTENT_AUTHORITY_SLASH + string2 + "/audio/media");
            }

            public static Uri getContentUriForPath(String string2) {
                String[] stringArray = EXTERNAL_PATHS;
                int n = stringArray.length;
                for (int i = 0; i < n; ++i) {
                    if (!string2.startsWith(stringArray[i])) continue;
                    return EXTERNAL_CONTENT_URI;
                }
                if (string2.startsWith(Environment.getExternalStorageDirectory().getPath())) {
                    return EXTERNAL_CONTENT_URI;
                }
                return INTERNAL_CONTENT_URI;
            }
        }

        public static final class Playlists
        implements BaseColumns,
        PlaylistsColumns {
            public static final String CONTENT_TYPE = "vnd.android.cursor.dir/playlist";
            public static final String DEFAULT_SORT_ORDER = "name";
            public static final String ENTRY_CONTENT_TYPE = "vnd.android.cursor.item/playlist";
            public static final Uri EXTERNAL_CONTENT_URI;
            public static final Uri INTERNAL_CONTENT_URI;

            static {
                INTERNAL_CONTENT_URI = Playlists.getContentUri("internal");
                EXTERNAL_CONTENT_URI = Playlists.getContentUri("external");
            }

            public static Uri getContentUri(String string2) {
                return Uri.parse(MediaStore.CONTENT_AUTHORITY_SLASH + string2 + "/audio/playlists");
            }

            public static final class Members
            implements AudioColumns {
                public static final String AUDIO_ID = "audio_id";
                public static final String CONTENT_DIRECTORY = "members";
                public static final String DEFAULT_SORT_ORDER = "play_order";
                public static final String PLAYLIST_ID = "playlist_id";
                public static final String PLAY_ORDER = "play_order";
                public static final String _ID = "_id";

                public static final Uri getContentUri(String string2, long l) {
                    return Uri.parse(MediaStore.CONTENT_AUTHORITY_SLASH + string2 + "/audio/playlists/" + l + "/members");
                }

                public static final boolean moveItem(ContentResolver contentResolver, long l, int n, int n2) {
                    Uri uri = Members.getContentUri("external", l).buildUpon().appendEncodedPath(String.valueOf(n)).appendQueryParameter("move", "true").build();
                    ContentValues contentValues = new ContentValues();
                    contentValues.put("play_order", n2);
                    return contentResolver.update(uri, contentValues, null, null) != 0;
                }
            }
        }

        public static interface PlaylistsColumns {
            public static final String DATA = "_data";
            public static final String DATE_ADDED = "date_added";
            public static final String DATE_MODIFIED = "date_modified";
            public static final String NAME = "name";
        }

        public static final class Radio {
            public static final String ENTRY_CONTENT_TYPE = "vnd.android.cursor.item/radio";

            private Radio() {
            }
        }
    }

    public static final class Files {
        public static Uri getContentUri(String string2) {
            return Uri.parse(MediaStore.CONTENT_AUTHORITY_SLASH + string2 + "/file");
        }

        public static final Uri getContentUri(String string2, long l) {
            return Uri.parse(MediaStore.CONTENT_AUTHORITY_SLASH + string2 + "/file/" + l);
        }

        public static Uri getMtpObjectsUri(String string2) {
            return Uri.parse(MediaStore.CONTENT_AUTHORITY_SLASH + string2 + "/object");
        }

        public static final Uri getMtpObjectsUri(String string2, long l) {
            return Uri.parse(MediaStore.CONTENT_AUTHORITY_SLASH + string2 + "/object/" + l);
        }

        public static final Uri getMtpReferencesUri(String string2, long l) {
            return Uri.parse(MediaStore.CONTENT_AUTHORITY_SLASH + string2 + "/object/" + l + "/references");
        }

        public static interface FileColumns
        extends MediaColumns {
            public static final String FORMAT = "format";
            public static final String MEDIA_TYPE = "media_type";
            public static final int MEDIA_TYPE_AUDIO = 2;
            public static final int MEDIA_TYPE_IMAGE = 1;
            public static final int MEDIA_TYPE_NONE = 0;
            public static final int MEDIA_TYPE_PLAYLIST = 4;
            public static final int MEDIA_TYPE_VIDEO = 3;
            public static final String MIME_TYPE = "mime_type";
            public static final String PARENT = "parent";
            public static final String STORAGE_ID = "storage_id";
            public static final String TITLE = "title";
        }
    }

    public static final class Images {

        public static interface ImageColumns
        extends MediaColumns {
            public static final String BUCKET_DISPLAY_NAME = "bucket_display_name";
            public static final String BUCKET_ID = "bucket_id";
            public static final String DATE_TAKEN = "datetaken";
            public static final String DESCRIPTION = "description";
            public static final String IS_PRIVATE = "isprivate";
            public static final String LATITUDE = "latitude";
            public static final String LONGITUDE = "longitude";
            public static final String MINI_THUMB_MAGIC = "mini_thumb_magic";
            public static final String ORIENTATION = "orientation";
            public static final String PICASA_ID = "picasa_id";
        }

        public static final class Media
        implements ImageColumns {
            public static final String CONTENT_TYPE = "vnd.android.cursor.dir/image";
            public static final String DEFAULT_SORT_ORDER = "bucket_display_name";
            public static final Uri EXTERNAL_CONTENT_URI;
            public static final Uri INTERNAL_CONTENT_URI;

            static {
                INTERNAL_CONTENT_URI = Media.getContentUri("internal");
                EXTERNAL_CONTENT_URI = Media.getContentUri("external");
            }

            private static final Bitmap StoreThumbnail(ContentResolver contentResolver, Bitmap bitmap, long l, float f, float f2, int n) {
                Matrix matrix = new Matrix();
                matrix.setScale(f / (float)bitmap.getWidth(), f2 / (float)bitmap.getHeight());
                Bitmap bitmap2 = Bitmap.createBitmap(bitmap, 0, 0, bitmap.getWidth(), bitmap.getHeight(), matrix, true);
                ContentValues contentValues = new ContentValues(4);
                contentValues.put("kind", n);
                contentValues.put("image_id", (int)l);
                contentValues.put("height", bitmap2.getHeight());
                contentValues.put("width", bitmap2.getWidth());
                Uri uri = contentResolver.insert(Thumbnails.EXTERNAL_CONTENT_URI, contentValues);
                try {
                    OutputStream outputStream = contentResolver.openOutputStream(uri);
                    bitmap2.compress(Bitmap.CompressFormat.JPEG, 100, outputStream);
                    outputStream.close();
                    return bitmap2;
                }
                catch (FileNotFoundException fileNotFoundException) {
                    return null;
                }
                catch (IOException iOException) {
                    return null;
                }
            }

            public static final Bitmap getBitmap(ContentResolver contentResolver, Uri uri) throws FileNotFoundException, IOException {
                InputStream inputStream = contentResolver.openInputStream(uri);
                Bitmap bitmap = BitmapFactory.decodeStream(inputStream);
                inputStream.close();
                return bitmap;
            }

            public static Uri getContentUri(String string2) {
                return Uri.parse(MediaStore.CONTENT_AUTHORITY_SLASH + string2 + "/images/media");
            }

            /*
             * Unable to fully structure code
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public static final String insertImage(ContentResolver var0, Bitmap var1_1, String var2_2, String var3_3) {
                block7: {
                    var4_4 = new ContentValues();
                    var4_4.put("title", var2_2);
                    var4_4.put("description", var3_3);
                    var4_4.put("mime_type", "image/jpeg");
                    var5_5 = null;
                    var5_5 = var0.insert(Media.EXTERNAL_CONTENT_URI, var4_4);
                    if (var1_1 == null) ** GOTO lbl23
                    var10_6 = var0.openOutputStream(var5_5);
                    var1_1.compress(Bitmap.CompressFormat.JPEG, 50, var10_6);
                    var10_6.close();
                    var13_7 = ContentUris.parseId(var5_5);
                    Media.StoreThumbnail(var0, Thumbnails.getThumbnail(var0, var13_7, 1, null), var13_7, 50.0f, 50.0f, 3);
                    catch (Throwable var11_9) {
                        var10_6.close();
                        throw var11_9;
lbl23:
                        // 1 sources

                        try {
                            Log.e("MediaStore", "Failed to create thumbnail, removing original");
                            var0.delete(var5_5, null, null);
                            return null;
                        }
                        catch (Exception var6_10) {
                            Log.e("MediaStore", "Failed to insert image", var6_10);
                            if (var5_5 == null) break block7;
                            var0.delete(var5_5, null, null);
                            return null;
                        }
                    }
                }
                var9_8 = null;
                if (var5_5 == null) return var9_8;
                return var5_5.toString();
            }

            public static final String insertImage(ContentResolver contentResolver, String string2, String string3, String string4) throws FileNotFoundException {
                FileInputStream fileInputStream = new FileInputStream(string2);
                try {
                    Bitmap bitmap = BitmapFactory.decodeFile(string2);
                    String string5 = Media.insertImage(contentResolver, bitmap, string3, string4);
                    bitmap.recycle();
                    return string5;
                }
                finally {
                    fileInputStream.close();
                }
            }

            public static final Cursor query(ContentResolver contentResolver, Uri uri, String[] stringArray) {
                return contentResolver.query(uri, stringArray, null, null, DEFAULT_SORT_ORDER);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public static final Cursor query(ContentResolver contentResolver, Uri uri, String[] stringArray, String string2, String string3) {
                String string4;
                if (string3 == null) {
                    string4 = DEFAULT_SORT_ORDER;
                    return contentResolver.query(uri, stringArray, string2, null, string4);
                }
                string4 = string3;
                return contentResolver.query(uri, stringArray, string2, null, string4);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public static final Cursor query(ContentResolver contentResolver, Uri uri, String[] stringArray, String string2, String[] stringArray2, String string3) {
                String string4;
                if (string3 == null) {
                    string4 = DEFAULT_SORT_ORDER;
                    return contentResolver.query(uri, stringArray, string2, stringArray2, string4);
                }
                string4 = string3;
                return contentResolver.query(uri, stringArray, string2, stringArray2, string4);
            }
        }

        public static class Thumbnails
        implements BaseColumns {
            public static final String DATA = "_data";
            public static final String DEFAULT_SORT_ORDER = "image_id ASC";
            public static final Uri EXTERNAL_CONTENT_URI;
            public static final int FULL_SCREEN_KIND = 2;
            public static final String HEIGHT = "height";
            public static final String IMAGE_ID = "image_id";
            public static final Uri INTERNAL_CONTENT_URI;
            public static final String KIND = "kind";
            public static final int MICRO_KIND = 3;
            public static final int MINI_KIND = 1;
            public static final String THUMB_DATA = "thumb_data";
            public static final String WIDTH = "width";

            static {
                INTERNAL_CONTENT_URI = Thumbnails.getContentUri("internal");
                EXTERNAL_CONTENT_URI = Thumbnails.getContentUri("external");
            }

            public static void cancelThumbnailRequest(ContentResolver contentResolver, long l) {
                InternalThumbnails.cancelThumbnailRequest(contentResolver, l, EXTERNAL_CONTENT_URI, 0L);
            }

            public static void cancelThumbnailRequest(ContentResolver contentResolver, long l, long l2) {
                InternalThumbnails.cancelThumbnailRequest(contentResolver, l, EXTERNAL_CONTENT_URI, l2);
            }

            public static Uri getContentUri(String string2) {
                return Uri.parse(MediaStore.CONTENT_AUTHORITY_SLASH + string2 + "/images/thumbnails");
            }

            public static Bitmap getThumbnail(ContentResolver contentResolver, long l, int n, BitmapFactory.Options options) {
                return InternalThumbnails.getThumbnail(contentResolver, l, 0L, n, options, EXTERNAL_CONTENT_URI, false);
            }

            public static Bitmap getThumbnail(ContentResolver contentResolver, long l, long l2, int n, BitmapFactory.Options options) {
                return InternalThumbnails.getThumbnail(contentResolver, l, l2, n, options, EXTERNAL_CONTENT_URI, false);
            }

            public static final Cursor query(ContentResolver contentResolver, Uri uri, String[] stringArray) {
                return contentResolver.query(uri, stringArray, null, null, DEFAULT_SORT_ORDER);
            }

            public static final Cursor queryMiniThumbnail(ContentResolver contentResolver, long l, int n, String[] stringArray) {
                return contentResolver.query(EXTERNAL_CONTENT_URI, stringArray, "image_id = " + l + " AND " + KIND + " = " + n, null, null);
            }

            public static final Cursor queryMiniThumbnails(ContentResolver contentResolver, Uri uri, int n, String[] stringArray) {
                return contentResolver.query(uri, stringArray, "kind = " + n, null, DEFAULT_SORT_ORDER);
            }
        }
    }

    private static class InternalThumbnails
    implements BaseColumns {
        static final int DEFAULT_GROUP_ID = 0;
        private static final int FULL_SCREEN_KIND = 2;
        private static final int MICRO_KIND = 3;
        private static final int MINI_KIND = 1;
        private static final String[] PROJECTION = new String[]{"_id", "_data"};
        private static byte[] sThumbBuf;
        private static final Object sThumbBufLock;

        static {
            sThumbBufLock = new Object();
        }

        private InternalThumbnails() {
        }

        static void cancelThumbnailRequest(ContentResolver contentResolver, long l, Uri uri, long l2) {
            Uri uri2 = uri.buildUpon().appendQueryParameter("cancel", "1").appendQueryParameter("orig_id", String.valueOf(l)).appendQueryParameter("group_id", String.valueOf(l2)).build();
            try {
                Cursor cursor = contentResolver.query(uri2, PROJECTION, null, null, null);
                if (cursor != null) {
                    cursor.close();
                }
                return;
            }
            catch (Throwable throwable) {
                if (false) {
                    ((Cursor)null).close();
                }
                throw throwable;
            }
        }

        private static Bitmap getMiniThumbFromFile(Cursor cursor, Uri uri, ContentResolver contentResolver, BitmapFactory.Options options) {
            Bitmap bitmap = null;
            Uri uri2 = null;
            try {
                long l = cursor.getLong(0);
                cursor.getString(1);
                uri2 = ContentUris.withAppendedId(uri, l);
                ParcelFileDescriptor parcelFileDescriptor = contentResolver.openFileDescriptor(uri2, "r");
                bitmap = BitmapFactory.decodeFileDescriptor(parcelFileDescriptor.getFileDescriptor(), null, options);
                parcelFileDescriptor.close();
                return bitmap;
            }
            catch (FileNotFoundException fileNotFoundException) {
                Log.e(MediaStore.TAG, "couldn't open thumbnail " + uri2 + "; " + fileNotFoundException);
                return bitmap;
            }
            catch (IOException iOException) {
                Log.e(MediaStore.TAG, "couldn't open thumbnail " + uri2 + "; " + iOException);
                return bitmap;
            }
            catch (OutOfMemoryError outOfMemoryError) {
                Log.e(MediaStore.TAG, "failed to allocate memory for thumbnail " + uri2 + "; " + outOfMemoryError);
                return bitmap;
            }
        }

        /*
         * Exception decompiling
         */
        static Bitmap getThumbnail(ContentResolver var0, long var1_1, long var3_2, int var5_3, BitmapFactory.Options var6_4, Uri var7_5, boolean var8_6) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 5[TRYBLOCK] [9 : 158->161)] java.lang.Throwable
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }

    public static interface MediaColumns
    extends BaseColumns {
        public static final String DATA = "_data";
        public static final String DATE_ADDED = "date_added";
        public static final String DATE_MODIFIED = "date_modified";
        public static final String DISPLAY_NAME = "_display_name";
        public static final String HEIGHT = "height";
        public static final String IS_DRM = "is_drm";
        public static final String MEDIA_SCANNER_NEW_OBJECT_ID = "media_scanner_new_object_id";
        public static final String MIME_TYPE = "mime_type";
        public static final String SIZE = "_size";
        public static final String TITLE = "title";
        public static final String WIDTH = "width";
    }

    public static final class Video {
        public static final String DEFAULT_SORT_ORDER = "_display_name";

        public static final Cursor query(ContentResolver contentResolver, Uri uri, String[] stringArray) {
            return contentResolver.query(uri, stringArray, null, null, DEFAULT_SORT_ORDER);
        }

        public static final class Media
        implements VideoColumns {
            public static final String CONTENT_TYPE = "vnd.android.cursor.dir/video";
            public static final String DEFAULT_SORT_ORDER = "title";
            public static final Uri EXTERNAL_CONTENT_URI;
            public static final Uri INTERNAL_CONTENT_URI;

            static {
                INTERNAL_CONTENT_URI = Media.getContentUri("internal");
                EXTERNAL_CONTENT_URI = Media.getContentUri("external");
            }

            public static Uri getContentUri(String string2) {
                return Uri.parse(MediaStore.CONTENT_AUTHORITY_SLASH + string2 + "/video/media");
            }
        }

        public static class Thumbnails
        implements BaseColumns {
            public static final String DATA = "_data";
            public static final String DEFAULT_SORT_ORDER = "video_id ASC";
            public static final Uri EXTERNAL_CONTENT_URI;
            public static final int FULL_SCREEN_KIND = 2;
            public static final String HEIGHT = "height";
            public static final Uri INTERNAL_CONTENT_URI;
            public static final String KIND = "kind";
            public static final int MICRO_KIND = 3;
            public static final int MINI_KIND = 1;
            public static final String VIDEO_ID = "video_id";
            public static final String WIDTH = "width";

            static {
                INTERNAL_CONTENT_URI = Thumbnails.getContentUri("internal");
                EXTERNAL_CONTENT_URI = Thumbnails.getContentUri("external");
            }

            public static void cancelThumbnailRequest(ContentResolver contentResolver, long l) {
                InternalThumbnails.cancelThumbnailRequest(contentResolver, l, EXTERNAL_CONTENT_URI, 0L);
            }

            public static void cancelThumbnailRequest(ContentResolver contentResolver, long l, long l2) {
                InternalThumbnails.cancelThumbnailRequest(contentResolver, l, EXTERNAL_CONTENT_URI, l2);
            }

            public static Uri getContentUri(String string2) {
                return Uri.parse(MediaStore.CONTENT_AUTHORITY_SLASH + string2 + "/video/thumbnails");
            }

            public static Bitmap getThumbnail(ContentResolver contentResolver, long l, int n, BitmapFactory.Options options) {
                return InternalThumbnails.getThumbnail(contentResolver, l, 0L, n, options, EXTERNAL_CONTENT_URI, true);
            }

            public static Bitmap getThumbnail(ContentResolver contentResolver, long l, long l2, int n, BitmapFactory.Options options) {
                return InternalThumbnails.getThumbnail(contentResolver, l, l2, n, options, EXTERNAL_CONTENT_URI, true);
            }
        }

        public static interface VideoColumns
        extends MediaColumns {
            public static final String ALBUM = "album";
            public static final String ARTIST = "artist";
            public static final String BOOKMARK = "bookmark";
            public static final String BUCKET_DISPLAY_NAME = "bucket_display_name";
            public static final String BUCKET_ID = "bucket_id";
            public static final String CATEGORY = "category";
            public static final String DATE_TAKEN = "datetaken";
            public static final String DESCRIPTION = "description";
            public static final String DURATION = "duration";
            public static final String IS_PRIVATE = "isprivate";
            public static final String LANGUAGE = "language";
            public static final String LATITUDE = "latitude";
            public static final String LONGITUDE = "longitude";
            public static final String MINI_THUMB_MAGIC = "mini_thumb_magic";
            public static final String RESOLUTION = "resolution";
            public static final String TAGS = "tags";
        }
    }
}

