/*
 * Decompiled with CFR 0.152.
 */
package android.renderscript;

import android.renderscript.BaseObj;
import android.renderscript.RSIllegalArgumentException;
import android.renderscript.RenderScript;

public class Element
extends BaseObj {
    int[] mArraySizes;
    String[] mElementNames;
    Element[] mElements;
    DataKind mKind;
    boolean mNormalized;
    int[] mOffsetInBytes;
    int mSize;
    DataType mType;
    int mVectorSize;
    int[] mVisibleElementMap;

    Element(long l, RenderScript renderScript) {
        super(l, renderScript);
    }

    /*
     * Enabled aggressive block sorting
     */
    Element(long l, RenderScript renderScript, DataType dataType, DataKind dataKind, boolean bl, int n) {
        super(l, renderScript);
        this.mSize = dataType != DataType.UNSIGNED_5_6_5 && dataType != DataType.UNSIGNED_4_4_4_4 && dataType != DataType.UNSIGNED_5_5_5_1 ? (n == 3 ? 4 * dataType.mSize : n * dataType.mSize) : dataType.mSize;
        this.mType = dataType;
        this.mKind = dataKind;
        this.mNormalized = bl;
        this.mVectorSize = n;
    }

    Element(long l, RenderScript renderScript, Element[] elementArray, String[] stringArray, int[] nArray) {
        super(l, renderScript);
        this.mSize = 0;
        this.mVectorSize = 1;
        this.mElements = elementArray;
        this.mElementNames = stringArray;
        this.mArraySizes = nArray;
        this.mType = DataType.NONE;
        this.mKind = DataKind.USER;
        this.mOffsetInBytes = new int[this.mElements.length];
        for (int i = 0; i < this.mElements.length; ++i) {
            this.mOffsetInBytes[i] = this.mSize;
            this.mSize += this.mElements[i].mSize * this.mArraySizes[i];
        }
        this.updateVisibleSubElements();
    }

    public static Element ALLOCATION(RenderScript renderScript) {
        if (renderScript.mElement_ALLOCATION == null) {
            renderScript.mElement_ALLOCATION = Element.createUser(renderScript, DataType.RS_ALLOCATION);
        }
        return renderScript.mElement_ALLOCATION;
    }

    public static Element A_8(RenderScript renderScript) {
        if (renderScript.mElement_A_8 == null) {
            renderScript.mElement_A_8 = Element.createPixel(renderScript, DataType.UNSIGNED_8, DataKind.PIXEL_A);
        }
        return renderScript.mElement_A_8;
    }

    public static Element BOOLEAN(RenderScript renderScript) {
        if (renderScript.mElement_BOOLEAN == null) {
            renderScript.mElement_BOOLEAN = Element.createUser(renderScript, DataType.BOOLEAN);
        }
        return renderScript.mElement_BOOLEAN;
    }

    public static Element ELEMENT(RenderScript renderScript) {
        if (renderScript.mElement_ELEMENT == null) {
            renderScript.mElement_ELEMENT = Element.createUser(renderScript, DataType.RS_ELEMENT);
        }
        return renderScript.mElement_ELEMENT;
    }

    public static Element F32(RenderScript renderScript) {
        if (renderScript.mElement_F32 == null) {
            renderScript.mElement_F32 = Element.createUser(renderScript, DataType.FLOAT_32);
        }
        return renderScript.mElement_F32;
    }

    public static Element F32_2(RenderScript renderScript) {
        if (renderScript.mElement_FLOAT_2 == null) {
            renderScript.mElement_FLOAT_2 = Element.createVector(renderScript, DataType.FLOAT_32, 2);
        }
        return renderScript.mElement_FLOAT_2;
    }

    public static Element F32_3(RenderScript renderScript) {
        if (renderScript.mElement_FLOAT_3 == null) {
            renderScript.mElement_FLOAT_3 = Element.createVector(renderScript, DataType.FLOAT_32, 3);
        }
        return renderScript.mElement_FLOAT_3;
    }

    public static Element F32_4(RenderScript renderScript) {
        if (renderScript.mElement_FLOAT_4 == null) {
            renderScript.mElement_FLOAT_4 = Element.createVector(renderScript, DataType.FLOAT_32, 4);
        }
        return renderScript.mElement_FLOAT_4;
    }

    public static Element F64(RenderScript renderScript) {
        if (renderScript.mElement_F64 == null) {
            renderScript.mElement_F64 = Element.createUser(renderScript, DataType.FLOAT_64);
        }
        return renderScript.mElement_F64;
    }

    public static Element F64_2(RenderScript renderScript) {
        if (renderScript.mElement_DOUBLE_2 == null) {
            renderScript.mElement_DOUBLE_2 = Element.createVector(renderScript, DataType.FLOAT_64, 2);
        }
        return renderScript.mElement_DOUBLE_2;
    }

    public static Element F64_3(RenderScript renderScript) {
        if (renderScript.mElement_DOUBLE_3 == null) {
            renderScript.mElement_DOUBLE_3 = Element.createVector(renderScript, DataType.FLOAT_64, 3);
        }
        return renderScript.mElement_DOUBLE_3;
    }

    public static Element F64_4(RenderScript renderScript) {
        if (renderScript.mElement_DOUBLE_4 == null) {
            renderScript.mElement_DOUBLE_4 = Element.createVector(renderScript, DataType.FLOAT_64, 4);
        }
        return renderScript.mElement_DOUBLE_4;
    }

    public static Element FONT(RenderScript renderScript) {
        if (renderScript.mElement_FONT == null) {
            renderScript.mElement_FONT = Element.createUser(renderScript, DataType.RS_FONT);
        }
        return renderScript.mElement_FONT;
    }

    public static Element I16(RenderScript renderScript) {
        if (renderScript.mElement_I16 == null) {
            renderScript.mElement_I16 = Element.createUser(renderScript, DataType.SIGNED_16);
        }
        return renderScript.mElement_I16;
    }

    public static Element I16_2(RenderScript renderScript) {
        if (renderScript.mElement_SHORT_2 == null) {
            renderScript.mElement_SHORT_2 = Element.createVector(renderScript, DataType.SIGNED_16, 2);
        }
        return renderScript.mElement_SHORT_2;
    }

    public static Element I16_3(RenderScript renderScript) {
        if (renderScript.mElement_SHORT_3 == null) {
            renderScript.mElement_SHORT_3 = Element.createVector(renderScript, DataType.SIGNED_16, 3);
        }
        return renderScript.mElement_SHORT_3;
    }

    public static Element I16_4(RenderScript renderScript) {
        if (renderScript.mElement_SHORT_4 == null) {
            renderScript.mElement_SHORT_4 = Element.createVector(renderScript, DataType.SIGNED_16, 4);
        }
        return renderScript.mElement_SHORT_4;
    }

    public static Element I32(RenderScript renderScript) {
        if (renderScript.mElement_I32 == null) {
            renderScript.mElement_I32 = Element.createUser(renderScript, DataType.SIGNED_32);
        }
        return renderScript.mElement_I32;
    }

    public static Element I32_2(RenderScript renderScript) {
        if (renderScript.mElement_INT_2 == null) {
            renderScript.mElement_INT_2 = Element.createVector(renderScript, DataType.SIGNED_32, 2);
        }
        return renderScript.mElement_INT_2;
    }

    public static Element I32_3(RenderScript renderScript) {
        if (renderScript.mElement_INT_3 == null) {
            renderScript.mElement_INT_3 = Element.createVector(renderScript, DataType.SIGNED_32, 3);
        }
        return renderScript.mElement_INT_3;
    }

    public static Element I32_4(RenderScript renderScript) {
        if (renderScript.mElement_INT_4 == null) {
            renderScript.mElement_INT_4 = Element.createVector(renderScript, DataType.SIGNED_32, 4);
        }
        return renderScript.mElement_INT_4;
    }

    public static Element I64(RenderScript renderScript) {
        if (renderScript.mElement_I64 == null) {
            renderScript.mElement_I64 = Element.createUser(renderScript, DataType.SIGNED_64);
        }
        return renderScript.mElement_I64;
    }

    public static Element I64_2(RenderScript renderScript) {
        if (renderScript.mElement_LONG_2 == null) {
            renderScript.mElement_LONG_2 = Element.createVector(renderScript, DataType.SIGNED_64, 2);
        }
        return renderScript.mElement_LONG_2;
    }

    public static Element I64_3(RenderScript renderScript) {
        if (renderScript.mElement_LONG_3 == null) {
            renderScript.mElement_LONG_3 = Element.createVector(renderScript, DataType.SIGNED_64, 3);
        }
        return renderScript.mElement_LONG_3;
    }

    public static Element I64_4(RenderScript renderScript) {
        if (renderScript.mElement_LONG_4 == null) {
            renderScript.mElement_LONG_4 = Element.createVector(renderScript, DataType.SIGNED_64, 4);
        }
        return renderScript.mElement_LONG_4;
    }

    public static Element I8(RenderScript renderScript) {
        if (renderScript.mElement_I8 == null) {
            renderScript.mElement_I8 = Element.createUser(renderScript, DataType.SIGNED_8);
        }
        return renderScript.mElement_I8;
    }

    public static Element I8_2(RenderScript renderScript) {
        if (renderScript.mElement_CHAR_2 == null) {
            renderScript.mElement_CHAR_2 = Element.createVector(renderScript, DataType.SIGNED_8, 2);
        }
        return renderScript.mElement_CHAR_2;
    }

    public static Element I8_3(RenderScript renderScript) {
        if (renderScript.mElement_CHAR_3 == null) {
            renderScript.mElement_CHAR_3 = Element.createVector(renderScript, DataType.SIGNED_8, 3);
        }
        return renderScript.mElement_CHAR_3;
    }

    public static Element I8_4(RenderScript renderScript) {
        if (renderScript.mElement_CHAR_4 == null) {
            renderScript.mElement_CHAR_4 = Element.createVector(renderScript, DataType.SIGNED_8, 4);
        }
        return renderScript.mElement_CHAR_4;
    }

    public static Element MATRIX4X4(RenderScript renderScript) {
        return Element.MATRIX_4X4(renderScript);
    }

    public static Element MATRIX_2X2(RenderScript renderScript) {
        if (renderScript.mElement_MATRIX_2X2 == null) {
            renderScript.mElement_MATRIX_2X2 = Element.createUser(renderScript, DataType.MATRIX_2X2);
        }
        return renderScript.mElement_MATRIX_2X2;
    }

    public static Element MATRIX_3X3(RenderScript renderScript) {
        if (renderScript.mElement_MATRIX_3X3 == null) {
            renderScript.mElement_MATRIX_3X3 = Element.createUser(renderScript, DataType.MATRIX_3X3);
        }
        return renderScript.mElement_MATRIX_3X3;
    }

    public static Element MATRIX_4X4(RenderScript renderScript) {
        if (renderScript.mElement_MATRIX_4X4 == null) {
            renderScript.mElement_MATRIX_4X4 = Element.createUser(renderScript, DataType.MATRIX_4X4);
        }
        return renderScript.mElement_MATRIX_4X4;
    }

    public static Element MESH(RenderScript renderScript) {
        if (renderScript.mElement_MESH == null) {
            renderScript.mElement_MESH = Element.createUser(renderScript, DataType.RS_MESH);
        }
        return renderScript.mElement_MESH;
    }

    public static Element PROGRAM_FRAGMENT(RenderScript renderScript) {
        if (renderScript.mElement_PROGRAM_FRAGMENT == null) {
            renderScript.mElement_PROGRAM_FRAGMENT = Element.createUser(renderScript, DataType.RS_PROGRAM_FRAGMENT);
        }
        return renderScript.mElement_PROGRAM_FRAGMENT;
    }

    public static Element PROGRAM_RASTER(RenderScript renderScript) {
        if (renderScript.mElement_PROGRAM_RASTER == null) {
            renderScript.mElement_PROGRAM_RASTER = Element.createUser(renderScript, DataType.RS_PROGRAM_RASTER);
        }
        return renderScript.mElement_PROGRAM_RASTER;
    }

    public static Element PROGRAM_STORE(RenderScript renderScript) {
        if (renderScript.mElement_PROGRAM_STORE == null) {
            renderScript.mElement_PROGRAM_STORE = Element.createUser(renderScript, DataType.RS_PROGRAM_STORE);
        }
        return renderScript.mElement_PROGRAM_STORE;
    }

    public static Element PROGRAM_VERTEX(RenderScript renderScript) {
        if (renderScript.mElement_PROGRAM_VERTEX == null) {
            renderScript.mElement_PROGRAM_VERTEX = Element.createUser(renderScript, DataType.RS_PROGRAM_VERTEX);
        }
        return renderScript.mElement_PROGRAM_VERTEX;
    }

    public static Element RGBA_4444(RenderScript renderScript) {
        if (renderScript.mElement_RGBA_4444 == null) {
            renderScript.mElement_RGBA_4444 = Element.createPixel(renderScript, DataType.UNSIGNED_4_4_4_4, DataKind.PIXEL_RGBA);
        }
        return renderScript.mElement_RGBA_4444;
    }

    public static Element RGBA_5551(RenderScript renderScript) {
        if (renderScript.mElement_RGBA_5551 == null) {
            renderScript.mElement_RGBA_5551 = Element.createPixel(renderScript, DataType.UNSIGNED_5_5_5_1, DataKind.PIXEL_RGBA);
        }
        return renderScript.mElement_RGBA_5551;
    }

    public static Element RGBA_8888(RenderScript renderScript) {
        if (renderScript.mElement_RGBA_8888 == null) {
            renderScript.mElement_RGBA_8888 = Element.createPixel(renderScript, DataType.UNSIGNED_8, DataKind.PIXEL_RGBA);
        }
        return renderScript.mElement_RGBA_8888;
    }

    public static Element RGB_565(RenderScript renderScript) {
        if (renderScript.mElement_RGB_565 == null) {
            renderScript.mElement_RGB_565 = Element.createPixel(renderScript, DataType.UNSIGNED_5_6_5, DataKind.PIXEL_RGB);
        }
        return renderScript.mElement_RGB_565;
    }

    public static Element RGB_888(RenderScript renderScript) {
        if (renderScript.mElement_RGB_888 == null) {
            renderScript.mElement_RGB_888 = Element.createPixel(renderScript, DataType.UNSIGNED_8, DataKind.PIXEL_RGB);
        }
        return renderScript.mElement_RGB_888;
    }

    public static Element SAMPLER(RenderScript renderScript) {
        if (renderScript.mElement_SAMPLER == null) {
            renderScript.mElement_SAMPLER = Element.createUser(renderScript, DataType.RS_SAMPLER);
        }
        return renderScript.mElement_SAMPLER;
    }

    public static Element SCRIPT(RenderScript renderScript) {
        if (renderScript.mElement_SCRIPT == null) {
            renderScript.mElement_SCRIPT = Element.createUser(renderScript, DataType.RS_SCRIPT);
        }
        return renderScript.mElement_SCRIPT;
    }

    public static Element TYPE(RenderScript renderScript) {
        if (renderScript.mElement_TYPE == null) {
            renderScript.mElement_TYPE = Element.createUser(renderScript, DataType.RS_TYPE);
        }
        return renderScript.mElement_TYPE;
    }

    public static Element U16(RenderScript renderScript) {
        if (renderScript.mElement_U16 == null) {
            renderScript.mElement_U16 = Element.createUser(renderScript, DataType.UNSIGNED_16);
        }
        return renderScript.mElement_U16;
    }

    public static Element U16_2(RenderScript renderScript) {
        if (renderScript.mElement_USHORT_2 == null) {
            renderScript.mElement_USHORT_2 = Element.createVector(renderScript, DataType.UNSIGNED_16, 2);
        }
        return renderScript.mElement_USHORT_2;
    }

    public static Element U16_3(RenderScript renderScript) {
        if (renderScript.mElement_USHORT_3 == null) {
            renderScript.mElement_USHORT_3 = Element.createVector(renderScript, DataType.UNSIGNED_16, 3);
        }
        return renderScript.mElement_USHORT_3;
    }

    public static Element U16_4(RenderScript renderScript) {
        if (renderScript.mElement_USHORT_4 == null) {
            renderScript.mElement_USHORT_4 = Element.createVector(renderScript, DataType.UNSIGNED_16, 4);
        }
        return renderScript.mElement_USHORT_4;
    }

    public static Element U32(RenderScript renderScript) {
        if (renderScript.mElement_U32 == null) {
            renderScript.mElement_U32 = Element.createUser(renderScript, DataType.UNSIGNED_32);
        }
        return renderScript.mElement_U32;
    }

    public static Element U32_2(RenderScript renderScript) {
        if (renderScript.mElement_UINT_2 == null) {
            renderScript.mElement_UINT_2 = Element.createVector(renderScript, DataType.UNSIGNED_32, 2);
        }
        return renderScript.mElement_UINT_2;
    }

    public static Element U32_3(RenderScript renderScript) {
        if (renderScript.mElement_UINT_3 == null) {
            renderScript.mElement_UINT_3 = Element.createVector(renderScript, DataType.UNSIGNED_32, 3);
        }
        return renderScript.mElement_UINT_3;
    }

    public static Element U32_4(RenderScript renderScript) {
        if (renderScript.mElement_UINT_4 == null) {
            renderScript.mElement_UINT_4 = Element.createVector(renderScript, DataType.UNSIGNED_32, 4);
        }
        return renderScript.mElement_UINT_4;
    }

    public static Element U64(RenderScript renderScript) {
        if (renderScript.mElement_U64 == null) {
            renderScript.mElement_U64 = Element.createUser(renderScript, DataType.UNSIGNED_64);
        }
        return renderScript.mElement_U64;
    }

    public static Element U64_2(RenderScript renderScript) {
        if (renderScript.mElement_ULONG_2 == null) {
            renderScript.mElement_ULONG_2 = Element.createVector(renderScript, DataType.UNSIGNED_64, 2);
        }
        return renderScript.mElement_ULONG_2;
    }

    public static Element U64_3(RenderScript renderScript) {
        if (renderScript.mElement_ULONG_3 == null) {
            renderScript.mElement_ULONG_3 = Element.createVector(renderScript, DataType.UNSIGNED_64, 3);
        }
        return renderScript.mElement_ULONG_3;
    }

    public static Element U64_4(RenderScript renderScript) {
        if (renderScript.mElement_ULONG_4 == null) {
            renderScript.mElement_ULONG_4 = Element.createVector(renderScript, DataType.UNSIGNED_64, 4);
        }
        return renderScript.mElement_ULONG_4;
    }

    public static Element U8(RenderScript renderScript) {
        if (renderScript.mElement_U8 == null) {
            renderScript.mElement_U8 = Element.createUser(renderScript, DataType.UNSIGNED_8);
        }
        return renderScript.mElement_U8;
    }

    public static Element U8_2(RenderScript renderScript) {
        if (renderScript.mElement_UCHAR_2 == null) {
            renderScript.mElement_UCHAR_2 = Element.createVector(renderScript, DataType.UNSIGNED_8, 2);
        }
        return renderScript.mElement_UCHAR_2;
    }

    public static Element U8_3(RenderScript renderScript) {
        if (renderScript.mElement_UCHAR_3 == null) {
            renderScript.mElement_UCHAR_3 = Element.createVector(renderScript, DataType.UNSIGNED_8, 3);
        }
        return renderScript.mElement_UCHAR_3;
    }

    public static Element U8_4(RenderScript renderScript) {
        if (renderScript.mElement_UCHAR_4 == null) {
            renderScript.mElement_UCHAR_4 = Element.createVector(renderScript, DataType.UNSIGNED_8, 4);
        }
        return renderScript.mElement_UCHAR_4;
    }

    public static Element YUV(RenderScript renderScript) {
        if (renderScript.mElement_YUV == null) {
            renderScript.mElement_YUV = Element.createPixel(renderScript, DataType.UNSIGNED_8, DataKind.PIXEL_YUV);
        }
        return renderScript.mElement_YUV;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static Element createPixel(RenderScript renderScript, DataType dataType, DataKind dataKind) {
        if (dataKind != DataKind.PIXEL_L && dataKind != DataKind.PIXEL_A && dataKind != DataKind.PIXEL_LA && dataKind != DataKind.PIXEL_RGB && dataKind != DataKind.PIXEL_RGBA && dataKind != DataKind.PIXEL_DEPTH && dataKind != DataKind.PIXEL_YUV) {
            throw new RSIllegalArgumentException("Unsupported DataKind");
        }
        if (dataType != DataType.UNSIGNED_8 && dataType != DataType.UNSIGNED_16 && dataType != DataType.UNSIGNED_5_6_5 && dataType != DataType.UNSIGNED_4_4_4_4 && dataType != DataType.UNSIGNED_5_5_5_1) {
            throw new RSIllegalArgumentException("Unsupported DataType");
        }
        if (dataType == DataType.UNSIGNED_5_6_5 && dataKind != DataKind.PIXEL_RGB) {
            throw new RSIllegalArgumentException("Bad kind and type combo");
        }
        if (dataType == DataType.UNSIGNED_5_5_5_1 && dataKind != DataKind.PIXEL_RGBA) {
            throw new RSIllegalArgumentException("Bad kind and type combo");
        }
        if (dataType == DataType.UNSIGNED_4_4_4_4 && dataKind != DataKind.PIXEL_RGBA) {
            throw new RSIllegalArgumentException("Bad kind and type combo");
        }
        if (dataType == DataType.UNSIGNED_16 && dataKind != DataKind.PIXEL_DEPTH) {
            throw new RSIllegalArgumentException("Bad kind and type combo");
        }
        int n = 1;
        switch (dataKind) {
            case PIXEL_LA: {
                n = 2;
                return new Element(renderScript.nElementCreate(dataType.mID, dataKind.mID, true, n), renderScript, dataType, dataKind, true, n);
            }
            case PIXEL_RGB: {
                n = 3;
                return new Element(renderScript.nElementCreate(dataType.mID, dataKind.mID, true, n), renderScript, dataType, dataKind, true, n);
            }
            case PIXEL_RGBA: {
                n = 4;
                return new Element(renderScript.nElementCreate(dataType.mID, dataKind.mID, true, n), renderScript, dataType, dataKind, true, n);
            }
            case PIXEL_DEPTH: {
                n = 2;
                return new Element(renderScript.nElementCreate(dataType.mID, dataKind.mID, true, n), renderScript, dataType, dataKind, true, n);
            }
        }
        return new Element(renderScript.nElementCreate(dataType.mID, dataKind.mID, true, n), renderScript, dataType, dataKind, true, n);
    }

    static Element createUser(RenderScript renderScript, DataType dataType) {
        DataKind dataKind = DataKind.USER;
        return new Element(renderScript.nElementCreate(dataType.mID, dataKind.mID, false, 1), renderScript, dataType, dataKind, false, 1);
    }

    public static Element createVector(RenderScript renderScript, DataType dataType, int n) {
        if (n < 2 || n > 4) {
            throw new RSIllegalArgumentException("Vector size out of range 2-4.");
        }
        switch (1.$SwitchMap$android$renderscript$Element$DataType[dataType.ordinal()]) {
            default: {
                throw new RSIllegalArgumentException("Cannot create vector of non-primitive type.");
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
        }
        DataKind dataKind = DataKind.USER;
        return new Element(renderScript.nElementCreate(dataType.mID, dataKind.mID, false, n), renderScript, dataType, dataKind, false, n);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void updateVisibleSubElements() {
        if (this.mElements != null) {
            int n = 0;
            int n2 = this.mElementNames.length;
            for (int i = 0; i < n2; ++i) {
                if (this.mElementNames[i].charAt(0) == '#') continue;
                ++n;
            }
            this.mVisibleElementMap = new int[n];
            int n3 = 0;
            for (int i = 0; i < n2; ++i) {
                int n4;
                if (this.mElementNames[i].charAt(0) != '#') {
                    int[] nArray = this.mVisibleElementMap;
                    n4 = n3 + 1;
                    nArray[n3] = i;
                } else {
                    n4 = n3;
                }
                n3 = n4;
            }
        }
    }

    public int getBytesSize() {
        return this.mSize;
    }

    public DataKind getDataKind() {
        return this.mKind;
    }

    public DataType getDataType() {
        return this.mType;
    }

    public Element getSubElement(int n) {
        if (this.mVisibleElementMap == null) {
            throw new RSIllegalArgumentException("Element contains no sub-elements");
        }
        if (n < 0 || n >= this.mVisibleElementMap.length) {
            throw new RSIllegalArgumentException("Illegal sub-element index");
        }
        return this.mElements[this.mVisibleElementMap[n]];
    }

    public int getSubElementArraySize(int n) {
        if (this.mVisibleElementMap == null) {
            throw new RSIllegalArgumentException("Element contains no sub-elements");
        }
        if (n < 0 || n >= this.mVisibleElementMap.length) {
            throw new RSIllegalArgumentException("Illegal sub-element index");
        }
        return this.mArraySizes[this.mVisibleElementMap[n]];
    }

    public int getSubElementCount() {
        if (this.mVisibleElementMap == null) {
            return 0;
        }
        return this.mVisibleElementMap.length;
    }

    public String getSubElementName(int n) {
        if (this.mVisibleElementMap == null) {
            throw new RSIllegalArgumentException("Element contains no sub-elements");
        }
        if (n < 0 || n >= this.mVisibleElementMap.length) {
            throw new RSIllegalArgumentException("Illegal sub-element index");
        }
        return this.mElementNames[this.mVisibleElementMap[n]];
    }

    public int getSubElementOffsetBytes(int n) {
        if (this.mVisibleElementMap == null) {
            throw new RSIllegalArgumentException("Element contains no sub-elements");
        }
        if (n < 0 || n >= this.mVisibleElementMap.length) {
            throw new RSIllegalArgumentException("Illegal sub-element index");
        }
        return this.mOffsetInBytes[this.mVisibleElementMap[n]];
    }

    public int getVectorSize() {
        return this.mVectorSize;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean isCompatible(Element element) {
        return this.equals(element) || this.mSize == element.mSize && this.mType != DataType.NONE && this.mType == element.mType && this.mVectorSize == element.mVectorSize;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean isComplex() {
        if (this.mElements != null) {
            for (int i = 0; i < this.mElements.length; ++i) {
                if (this.mElements[i].mElements == null) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    void updateFromNative() {
        super.updateFromNative();
        int[] nArray = new int[5];
        this.mRS.nElementGetNativeData(this.getID(this.mRS), nArray);
        boolean bl = nArray[2] == 1;
        this.mNormalized = bl;
        this.mVectorSize = nArray[3];
        this.mSize = 0;
        for (DataType dataType : DataType.values()) {
            if (dataType.mID != nArray[0]) continue;
            this.mType = dataType;
            this.mSize = this.mType.mSize * this.mVectorSize;
        }
        for (DataKind dataKind : DataKind.values()) {
            if (dataKind.mID != nArray[1]) continue;
            this.mKind = dataKind;
        }
        int n = nArray[4];
        if (n > 0) {
            this.mElements = new Element[n];
            this.mElementNames = new String[n];
            this.mArraySizes = new int[n];
            this.mOffsetInBytes = new int[n];
            long[] lArray = new long[n];
            this.mRS.nElementGetSubElements(this.getID(this.mRS), lArray, this.mElementNames, this.mArraySizes);
            for (int i = 0; i < n; this.mSize += this.mElements[i].mSize * this.mArraySizes[i], ++i) {
                this.mElements[i] = new Element(lArray[i], this.mRS);
                this.mElements[i].updateFromNative();
                this.mOffsetInBytes[i] = this.mSize;
            }
        }
        this.updateVisibleSubElements();
    }

    public static class Builder {
        int[] mArraySizes;
        int mCount;
        String[] mElementNames;
        Element[] mElements;
        RenderScript mRS;
        int mSkipPadding;

        public Builder(RenderScript renderScript) {
            this.mRS = renderScript;
            this.mCount = 0;
            this.mElements = new Element[8];
            this.mElementNames = new String[8];
            this.mArraySizes = new int[8];
        }

        public Builder add(Element element, String string2) {
            return this.add(element, string2, 1);
        }

        /*
         * Enabled aggressive block sorting
         */
        public Builder add(Element element, String string2, int n) {
            if (n < 1) {
                throw new RSIllegalArgumentException("Array size cannot be less than 1.");
            }
            if (this.mSkipPadding != 0 && string2.startsWith("#padding_")) {
                this.mSkipPadding = 0;
                return this;
            }
            this.mSkipPadding = element.mVectorSize == 3 ? 1 : 0;
            if (this.mCount == this.mElements.length) {
                Element[] elementArray = new Element[8 + this.mCount];
                String[] stringArray = new String[8 + this.mCount];
                int[] nArray = new int[8 + this.mCount];
                System.arraycopy(this.mElements, 0, elementArray, 0, this.mCount);
                System.arraycopy(this.mElementNames, 0, stringArray, 0, this.mCount);
                System.arraycopy((int[])this.mArraySizes, (int)0, (int[])nArray, (int)0, (int)this.mCount);
                this.mElements = elementArray;
                this.mElementNames = stringArray;
                this.mArraySizes = nArray;
            }
            this.mElements[this.mCount] = element;
            this.mElementNames[this.mCount] = string2;
            this.mArraySizes[this.mCount] = n;
            this.mCount = 1 + this.mCount;
            return this;
        }

        public Element create() {
            this.mRS.validate();
            Element[] elementArray = new Element[this.mCount];
            String[] stringArray = new String[this.mCount];
            int[] nArray = new int[this.mCount];
            System.arraycopy(this.mElements, 0, elementArray, 0, this.mCount);
            System.arraycopy(this.mElementNames, 0, stringArray, 0, this.mCount);
            System.arraycopy((int[])this.mArraySizes, (int)0, (int[])nArray, (int)0, (int)this.mCount);
            long[] lArray = new long[elementArray.length];
            for (int i = 0; i < elementArray.length; ++i) {
                lArray[i] = elementArray[i].getID(this.mRS);
            }
            return new Element(this.mRS.nElementCreate2(lArray, stringArray, nArray), this.mRS, elementArray, stringArray, nArray);
        }
    }

    public static final class DataKind
    extends Enum<DataKind> {
        private static final /* synthetic */ DataKind[] $VALUES;
        public static final /* enum */ DataKind PIXEL_A;
        public static final /* enum */ DataKind PIXEL_DEPTH;
        public static final /* enum */ DataKind PIXEL_L;
        public static final /* enum */ DataKind PIXEL_LA;
        public static final /* enum */ DataKind PIXEL_RGB;
        public static final /* enum */ DataKind PIXEL_RGBA;
        public static final /* enum */ DataKind PIXEL_YUV;
        public static final /* enum */ DataKind USER;
        int mID;

        static {
            USER = new DataKind(0);
            PIXEL_L = new DataKind(7);
            PIXEL_A = new DataKind(8);
            PIXEL_LA = new DataKind(9);
            PIXEL_RGB = new DataKind(10);
            PIXEL_RGBA = new DataKind(11);
            PIXEL_DEPTH = new DataKind(12);
            PIXEL_YUV = new DataKind(13);
            DataKind[] dataKindArray = new DataKind[]{USER, PIXEL_L, PIXEL_A, PIXEL_LA, PIXEL_RGB, PIXEL_RGBA, PIXEL_DEPTH, PIXEL_YUV};
            $VALUES = dataKindArray;
        }

        private DataKind(int n2) {
            this.mID = n2;
        }

        public static DataKind valueOf(String string2) {
            return Enum.valueOf(DataKind.class, string2);
        }

        public static DataKind[] values() {
            return (DataKind[])$VALUES.clone();
        }
    }

    public static final class DataType
    extends Enum<DataType> {
        private static final /* synthetic */ DataType[] $VALUES;
        public static final /* enum */ DataType BOOLEAN;
        public static final /* enum */ DataType FLOAT_32;
        public static final /* enum */ DataType FLOAT_64;
        public static final /* enum */ DataType MATRIX_2X2;
        public static final /* enum */ DataType MATRIX_3X3;
        public static final /* enum */ DataType MATRIX_4X4;
        public static final /* enum */ DataType NONE;
        public static final /* enum */ DataType RS_ALLOCATION;
        public static final /* enum */ DataType RS_ELEMENT;
        public static final /* enum */ DataType RS_FONT;
        public static final /* enum */ DataType RS_MESH;
        public static final /* enum */ DataType RS_PROGRAM_FRAGMENT;
        public static final /* enum */ DataType RS_PROGRAM_RASTER;
        public static final /* enum */ DataType RS_PROGRAM_STORE;
        public static final /* enum */ DataType RS_PROGRAM_VERTEX;
        public static final /* enum */ DataType RS_SAMPLER;
        public static final /* enum */ DataType RS_SCRIPT;
        public static final /* enum */ DataType RS_TYPE;
        public static final /* enum */ DataType SIGNED_16;
        public static final /* enum */ DataType SIGNED_32;
        public static final /* enum */ DataType SIGNED_64;
        public static final /* enum */ DataType SIGNED_8;
        public static final /* enum */ DataType UNSIGNED_16;
        public static final /* enum */ DataType UNSIGNED_32;
        public static final /* enum */ DataType UNSIGNED_4_4_4_4;
        public static final /* enum */ DataType UNSIGNED_5_5_5_1;
        public static final /* enum */ DataType UNSIGNED_5_6_5;
        public static final /* enum */ DataType UNSIGNED_64;
        public static final /* enum */ DataType UNSIGNED_8;
        int mID;
        int mSize;

        static {
            NONE = new DataType(0, 0);
            FLOAT_32 = new DataType(2, 4);
            FLOAT_64 = new DataType(3, 8);
            SIGNED_8 = new DataType(4, 1);
            SIGNED_16 = new DataType(5, 2);
            SIGNED_32 = new DataType(6, 4);
            SIGNED_64 = new DataType(7, 8);
            UNSIGNED_8 = new DataType(8, 1);
            UNSIGNED_16 = new DataType(9, 2);
            UNSIGNED_32 = new DataType(10, 4);
            UNSIGNED_64 = new DataType(11, 8);
            BOOLEAN = new DataType(12, 1);
            UNSIGNED_5_6_5 = new DataType(13, 2);
            UNSIGNED_5_5_5_1 = new DataType(14, 2);
            UNSIGNED_4_4_4_4 = new DataType(15, 2);
            MATRIX_4X4 = new DataType(16, 64);
            MATRIX_3X3 = new DataType(17, 36);
            MATRIX_2X2 = new DataType(18, 16);
            RS_ELEMENT = new DataType(1000);
            RS_TYPE = new DataType(1001);
            RS_ALLOCATION = new DataType(1002);
            RS_SAMPLER = new DataType(1003);
            RS_SCRIPT = new DataType(1004);
            RS_MESH = new DataType(1005);
            RS_PROGRAM_FRAGMENT = new DataType(1006);
            RS_PROGRAM_VERTEX = new DataType(1007);
            RS_PROGRAM_RASTER = new DataType(1008);
            RS_PROGRAM_STORE = new DataType(1009);
            RS_FONT = new DataType(1010);
            DataType[] dataTypeArray = new DataType[]{NONE, FLOAT_32, FLOAT_64, SIGNED_8, SIGNED_16, SIGNED_32, SIGNED_64, UNSIGNED_8, UNSIGNED_16, UNSIGNED_32, UNSIGNED_64, BOOLEAN, UNSIGNED_5_6_5, UNSIGNED_5_5_5_1, UNSIGNED_4_4_4_4, MATRIX_4X4, MATRIX_3X3, MATRIX_2X2, RS_ELEMENT, RS_TYPE, RS_ALLOCATION, RS_SAMPLER, RS_SCRIPT, RS_MESH, RS_PROGRAM_FRAGMENT, RS_PROGRAM_VERTEX, RS_PROGRAM_RASTER, RS_PROGRAM_STORE, RS_FONT};
            $VALUES = dataTypeArray;
        }

        private DataType(int n2) {
            this.mID = n2;
            this.mSize = 4;
            if (RenderScript.sPointerSize == 8) {
                this.mSize = 32;
            }
        }

        private DataType(int n2, int n3) {
            this.mID = n2;
            this.mSize = n3;
        }

        public static DataType valueOf(String string2) {
            return Enum.valueOf(DataType.class, string2);
        }

        public static DataType[] values() {
            return (DataType[])$VALUES.clone();
        }
    }
}

