/*
 * Decompiled with CFR 0.152.
 */
package android.sax;

import android.sax.BadXmlException;
import android.sax.Children;
import android.sax.Element;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class RootElement
extends Element {
    final Handler handler = new Handler();

    public RootElement(String string2) {
        this("", string2);
    }

    public RootElement(String string2, String string3) {
        super(null, string2, string3, 0);
    }

    public ContentHandler getContentHandler() {
        return this.handler;
    }

    class Handler
    extends DefaultHandler {
        StringBuilder bodyBuilder = null;
        Element current = null;
        int depth = -1;
        Locator locator;

        Handler() {
        }

        @Override
        public void characters(char[] cArray, int n, int n2) throws SAXException {
            if (this.bodyBuilder != null) {
                this.bodyBuilder.append(cArray, n, n2);
            }
        }

        @Override
        public void endElement(String string2, String string3, String string4) throws SAXException {
            Element element = this.current;
            if (this.depth == element.depth) {
                element.checkRequiredChildren(this.locator);
                if (element.endElementListener != null) {
                    element.endElementListener.end();
                }
                if (this.bodyBuilder != null) {
                    String string5 = this.bodyBuilder.toString();
                    this.bodyBuilder = null;
                    element.endTextElementListener.end(string5);
                }
                this.current = element.parent;
            }
            this.depth = -1 + this.depth;
        }

        @Override
        public void setDocumentLocator(Locator locator) {
            this.locator = locator;
        }

        void start(Element element, Attributes attributes) {
            this.current = element;
            if (element.startElementListener != null) {
                element.startElementListener.start(attributes);
            }
            if (element.endTextElementListener != null) {
                this.bodyBuilder = new StringBuilder();
            }
            element.resetRequiredChildren();
            element.visited = true;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void startElement(String string2, String string3, String string4, Attributes attributes) throws SAXException {
            int n;
            this.depth = n = 1 + this.depth;
            if (n == 0) {
                this.startRoot(string2, string3, attributes);
                return;
            } else {
                Element element;
                Children children;
                if (this.bodyBuilder != null) {
                    throw new BadXmlException("Encountered mixed content within text element named " + this.current + ".", this.locator);
                }
                if (n != 1 + this.current.depth || (children = this.current.children) == null || (element = children.get(string2, string3)) == null) return;
                this.start(element, attributes);
                return;
            }
        }

        void startRoot(String string2, String string3, Attributes attributes) throws SAXException {
            RootElement rootElement = RootElement.this;
            if (rootElement.uri.compareTo(string2) != 0 || rootElement.localName.compareTo(string3) != 0) {
                throw new BadXmlException("Root element name does not match. Expected: " + rootElement + ", Got: " + Element.toString(string2, string3), this.locator);
            }
            this.start(rootElement, attributes);
        }
    }
}

