/*
 * Decompiled with CFR 0.152.
 */
package android.security;

import android.security.Credentials;
import android.security.KeyStore;
import android.security.KeyStoreParameter;
import android.util.Log;
import com.android.org.conscrypt.OpenSSLEngine;
import com.android.org.conscrypt.OpenSSLKeyHolder;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.KeyStoreSpi;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class AndroidKeyStore
extends KeyStoreSpi {
    public static final String NAME = "AndroidKeyStore";
    private KeyStore mKeyStore;

    private Date getModificationDate(String string2) {
        long l = this.mKeyStore.getmtime(string2);
        if (l == -1L) {
            return null;
        }
        return new Date(l);
    }

    /*
     * Enabled aggressive block sorting
     */
    private Set<String> getUniqueAliases() {
        String[] stringArray = this.mKeyStore.saw("");
        if (stringArray == null) {
            return new HashSet<String>();
        }
        HashSet<String> hashSet = new HashSet(stringArray.length);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string2 = stringArray[n2];
            int n3 = string2.indexOf(95);
            if (n3 == -1 || string2.length() <= n3) {
                Log.e(NAME, "invalid alias: " + string2);
            } else {
                hashSet.add(new String(string2.substring(n3 + 1)));
            }
            ++n2;
        }
        return hashSet;
    }

    private boolean isCertificateEntry(String string2) {
        if (string2 == null) {
            throw new NullPointerException("alias == null");
        }
        return this.mKeyStore.contains("CACERT_" + string2);
    }

    private boolean isKeyEntry(String string2) {
        if (string2 == null) {
            throw new NullPointerException("alias == null");
        }
        return this.mKeyStore.contains("USRPKEY_" + string2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void setPrivateKeyEntry(String string2, PrivateKey privateKey, Certificate[] certificateArray, KeyStoreParameter keyStoreParameter) throws KeyStoreException {
        byte[] byArray;
        byte[] byArray2;
        boolean bl;
        byte[] byArray3;
        block22: {
            int n;
            int n2;
            int n3;
            byte[][] byArrayArray;
            X509Certificate[] x509CertificateArray;
            block21: {
                block20: {
                    byArray3 = null;
                    String string3 = privateKey instanceof OpenSSLKeyHolder ? ((OpenSSLKeyHolder)privateKey).getOpenSSLKey().getAlias() : null;
                    if (string3 != null && string3.startsWith("USRPKEY_")) {
                        String string4 = string3.substring("USRPKEY_".length());
                        if (!string2.equals(string4)) {
                            throw new KeyStoreException("Can only replace keys with same alias: " + string2 + " != " + string4);
                        }
                        bl = false;
                    } else {
                        String string5 = privateKey.getFormat();
                        if (string5 == null || !"PKCS#8".equals(string5)) {
                            throw new KeyStoreException("Only PrivateKeys that can be encoded into PKCS#8 are supported");
                        }
                        byArray3 = privateKey.getEncoded();
                        if (byArray3 == null) {
                            throw new KeyStoreException("PrivateKey has no encoding");
                        }
                        bl = true;
                    }
                    if (certificateArray == null || certificateArray.length == 0) {
                        throw new KeyStoreException("Must supply at least one Certificate with PrivateKey");
                    }
                    x509CertificateArray = new X509Certificate[certificateArray.length];
                    for (int i = 0; i < certificateArray.length; ++i) {
                        if (!"X.509".equals(certificateArray[i].getType())) {
                            throw new KeyStoreException("Certificates must be in X.509 format: invalid cert #" + i);
                        }
                        if (!(certificateArray[i] instanceof X509Certificate)) {
                            throw new KeyStoreException("Certificates must be in X.509 format: invalid cert #" + i);
                        }
                        x509CertificateArray[i] = (X509Certificate)certificateArray[i];
                    }
                    try {
                        byArray2 = x509CertificateArray[0].getEncoded();
                    }
                    catch (CertificateEncodingException certificateEncodingException) {
                        KeyStoreException keyStoreException = new KeyStoreException("Couldn't encode certificate #1", certificateEncodingException);
                        throw keyStoreException;
                    }
                    if (certificateArray.length <= 1) break block20;
                    byArrayArray = new byte[-1 + x509CertificateArray.length][];
                    n3 = 0;
                    break block21;
                }
                byArray = null;
                break block22;
            }
            for (int i = 0; i < byArrayArray.length; n3 += n2, ++i) {
                int n4 = i + 1;
                try {
                    byArrayArray[i] = x509CertificateArray[n4].getEncoded();
                    n2 = byArrayArray[i].length;
                    continue;
                }
                catch (CertificateEncodingException certificateEncodingException) {
                    KeyStoreException keyStoreException = new KeyStoreException("Can't encode Certificate #" + i, certificateEncodingException);
                    throw keyStoreException;
                }
            }
            byArray = new byte[n3];
            int n5 = 0;
            for (int i = 0; i < byArrayArray.length; n5 += n, ++i) {
                n = byArrayArray[i].length;
                System.arraycopy((byte[])byArrayArray[i], (int)0, (byte[])byArray, (int)n5, (int)n);
                byArrayArray[i] = null;
            }
        }
        if (bl) {
            Credentials.deleteAllTypesForAlias(this.mKeyStore, string2);
        } else {
            Credentials.deleteCertificateTypesForAlias(this.mKeyStore, string2);
        }
        int n = keyStoreParameter == null ? 0 : keyStoreParameter.getFlags();
        if (bl && !this.mKeyStore.importKey("USRPKEY_" + string2, byArray3, -1, n)) {
            Credentials.deleteAllTypesForAlias(this.mKeyStore, string2);
            throw new KeyStoreException("Couldn't put private key in keystore");
        }
        if (!this.mKeyStore.put("USRCERT_" + string2, byArray2, -1, n)) {
            Credentials.deleteAllTypesForAlias(this.mKeyStore, string2);
            throw new KeyStoreException("Couldn't put certificate #1 in keystore");
        }
        if (byArray != null && !this.mKeyStore.put("CACERT_" + string2, byArray, -1, n)) {
            Credentials.deleteAllTypesForAlias(this.mKeyStore, string2);
            throw new KeyStoreException("Couldn't put certificate chain in keystore");
        }
    }

    private static X509Certificate toCertificate(byte[] byArray) {
        try {
            X509Certificate x509Certificate = (X509Certificate)CertificateFactory.getInstance("X.509").generateCertificate(new ByteArrayInputStream(byArray));
            return x509Certificate;
        }
        catch (CertificateException certificateException) {
            Log.w(NAME, "Couldn't parse certificate in keystore", certificateException);
            return null;
        }
    }

    private static Collection<X509Certificate> toCertificates(byte[] byArray) {
        try {
            Collection<? extends Certificate> collection = CertificateFactory.getInstance("X.509").generateCertificates(new ByteArrayInputStream(byArray));
            return collection;
        }
        catch (CertificateException certificateException) {
            Log.w(NAME, "Couldn't parse certificates in keystore", certificateException);
            return new ArrayList<X509Certificate>();
        }
    }

    @Override
    public Enumeration<String> engineAliases() {
        return Collections.enumeration(this.getUniqueAliases());
    }

    @Override
    public boolean engineContainsAlias(String string2) {
        if (string2 == null) {
            throw new NullPointerException("alias == null");
        }
        return this.mKeyStore.contains("USRPKEY_" + string2) || this.mKeyStore.contains("USRCERT_" + string2) || this.mKeyStore.contains("CACERT_" + string2);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void engineDeleteEntry(String string2) throws KeyStoreException {
        if (!this.isKeyEntry(string2) && !this.isCertificateEntry(string2) || Credentials.deleteAllTypesForAlias(this.mKeyStore, string2)) {
            return;
        }
        throw new KeyStoreException("No such entry " + string2);
    }

    @Override
    public Certificate engineGetCertificate(String string2) {
        if (string2 == null) {
            throw new NullPointerException("alias == null");
        }
        byte[] byArray = this.mKeyStore.get("USRCERT_" + string2);
        if (byArray != null) {
            return AndroidKeyStore.toCertificate(byArray);
        }
        byte[] byArray2 = this.mKeyStore.get("CACERT_" + string2);
        if (byArray2 != null) {
            return AndroidKeyStore.toCertificate(byArray2);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public String engineGetCertificateAlias(Certificate certificate) {
        if (certificate == null) {
            return null;
        }
        HashSet<String> hashSet = new HashSet<String>();
        String[] stringArray = this.mKeyStore.saw("USRCERT_");
        if (stringArray != null) {
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String string2 = stringArray[i];
                byte[] byArray = this.mKeyStore.get("USRCERT_" + string2);
                if (byArray == null) continue;
                X509Certificate x509Certificate = AndroidKeyStore.toCertificate(byArray);
                hashSet.add(string2);
                if (!certificate.equals(x509Certificate)) continue;
                return string2;
            }
        }
        String[] stringArray2 = this.mKeyStore.saw("CACERT_");
        if (stringArray != null) {
            for (String string3 : stringArray2) {
                if (hashSet.contains(string3) || this.mKeyStore.get("CACERT_" + string3) == null || !certificate.equals(AndroidKeyStore.toCertificate(this.mKeyStore.get("CACERT_" + string3)))) continue;
                return string3;
            }
        }
        return null;
    }

    @Override
    public Certificate[] engineGetCertificateChain(String string2) {
        Certificate[] certificateArray;
        if (string2 == null) {
            throw new NullPointerException("alias == null");
        }
        X509Certificate x509Certificate = (X509Certificate)this.engineGetCertificate(string2);
        if (x509Certificate == null) {
            return null;
        }
        byte[] byArray = this.mKeyStore.get("CACERT_" + string2);
        if (byArray != null) {
            Collection<X509Certificate> collection = AndroidKeyStore.toCertificates(byArray);
            certificateArray = new Certificate[1 + collection.size()];
            Iterator<X509Certificate> iterator = collection.iterator();
            int n = 1;
            while (iterator.hasNext()) {
                int n2 = n + 1;
                certificateArray[n] = iterator.next();
                n = n2;
            }
        } else {
            certificateArray = new Certificate[]{x509Certificate};
        }
        return certificateArray;
    }

    @Override
    public Date engineGetCreationDate(String string2) {
        if (string2 == null) {
            throw new NullPointerException("alias == null");
        }
        Date date = this.getModificationDate("USRPKEY_" + string2);
        if (date != null) {
            return date;
        }
        Date date2 = this.getModificationDate("USRCERT_" + string2);
        if (date2 != null) {
            return date2;
        }
        return this.getModificationDate("CACERT_" + string2);
    }

    @Override
    public Key engineGetKey(String string2, char[] cArray) throws NoSuchAlgorithmException, UnrecoverableKeyException {
        if (!this.isKeyEntry(string2)) {
            return null;
        }
        OpenSSLEngine openSSLEngine = OpenSSLEngine.getInstance((String)"keystore");
        try {
            PrivateKey privateKey = openSSLEngine.getPrivateKeyById("USRPKEY_" + string2);
            return privateKey;
        }
        catch (InvalidKeyException invalidKeyException) {
            UnrecoverableKeyException unrecoverableKeyException = new UnrecoverableKeyException("Can't get key");
            unrecoverableKeyException.initCause(invalidKeyException);
            throw unrecoverableKeyException;
        }
    }

    @Override
    public boolean engineIsCertificateEntry(String string2) {
        return !this.isKeyEntry(string2) && this.isCertificateEntry(string2);
    }

    @Override
    public boolean engineIsKeyEntry(String string2) {
        return this.isKeyEntry(string2);
    }

    @Override
    public void engineLoad(InputStream inputStream, char[] cArray) throws IOException, NoSuchAlgorithmException, CertificateException {
        if (inputStream != null) {
            throw new IllegalArgumentException("InputStream not supported");
        }
        if (cArray != null) {
            throw new IllegalArgumentException("password not supported");
        }
        this.mKeyStore = KeyStore.getInstance();
    }

    @Override
    public void engineSetCertificateEntry(String string2, Certificate certificate) throws KeyStoreException {
        if (this.isKeyEntry(string2)) {
            throw new KeyStoreException("Entry exists and is not a trusted certificate");
        }
        if (certificate == null) {
            throw new NullPointerException("cert == null");
        }
        try {
            byte[] byArray = certificate.getEncoded();
            if (!this.mKeyStore.put("CACERT_" + string2, byArray, -1, 0)) {
                throw new KeyStoreException("Couldn't insert certificate; is KeyStore initialized?");
            }
        }
        catch (CertificateEncodingException certificateEncodingException) {
            throw new KeyStoreException(certificateEncodingException);
        }
    }

    @Override
    public void engineSetEntry(String string2, KeyStore.Entry entry, KeyStore.ProtectionParameter protectionParameter) throws KeyStoreException {
        if (entry == null) {
            throw new KeyStoreException("entry == null");
        }
        if (this.engineContainsAlias(string2)) {
            this.engineDeleteEntry(string2);
        }
        if (entry instanceof KeyStore.TrustedCertificateEntry) {
            this.engineSetCertificateEntry(string2, ((KeyStore.TrustedCertificateEntry)entry).getTrustedCertificate());
            return;
        }
        if (protectionParameter != null && !(protectionParameter instanceof KeyStoreParameter)) {
            throw new KeyStoreException("protParam should be android.security.KeyStoreParameter; was: " + protectionParameter.getClass().getName());
        }
        if (entry instanceof KeyStore.PrivateKeyEntry) {
            KeyStore.PrivateKeyEntry privateKeyEntry = (KeyStore.PrivateKeyEntry)entry;
            this.setPrivateKeyEntry(string2, privateKeyEntry.getPrivateKey(), privateKeyEntry.getCertificateChain(), (KeyStoreParameter)protectionParameter);
            return;
        }
        throw new KeyStoreException("Entry must be a PrivateKeyEntry or TrustedCertificateEntry; was " + entry);
    }

    @Override
    public void engineSetKeyEntry(String string2, Key key, char[] cArray, Certificate[] certificateArray) throws KeyStoreException {
        if (cArray != null && cArray.length > 0) {
            throw new KeyStoreException("entries cannot be protected with passwords");
        }
        if (key instanceof PrivateKey) {
            this.setPrivateKeyEntry(string2, (PrivateKey)key, certificateArray, null);
            return;
        }
        throw new KeyStoreException("Only PrivateKeys are supported");
    }

    @Override
    public void engineSetKeyEntry(String string2, byte[] byArray, Certificate[] certificateArray) throws KeyStoreException {
        throw new KeyStoreException("Operation not supported because key encoding is unknown");
    }

    @Override
    public int engineSize() {
        return this.getUniqueAliases().size();
    }

    @Override
    public void engineStore(OutputStream outputStream, char[] cArray) throws IOException, NoSuchAlgorithmException, CertificateException {
        throw new UnsupportedOperationException("Can not serialize AndroidKeyStore to OutputStream");
    }
}

