/*
 * Decompiled with CFR 0.152.
 */
package android.speech.tts;

import android.speech.tts.PlaybackQueueItem;
import java.util.Iterator;
import java.util.concurrent.LinkedBlockingQueue;

class AudioPlaybackHandler {
    private static final boolean DBG = false;
    private static final String TAG = "TTS.AudioPlaybackHandler";
    private volatile PlaybackQueueItem mCurrentWorkItem = null;
    private final Thread mHandlerThread;
    private final LinkedBlockingQueue<PlaybackQueueItem> mQueue = new LinkedBlockingQueue();

    AudioPlaybackHandler() {
        this.mHandlerThread = new Thread(new MessageLoop(), "TTS.AudioPlaybackThread");
    }

    static /* synthetic */ PlaybackQueueItem access$202(AudioPlaybackHandler audioPlaybackHandler, PlaybackQueueItem playbackQueueItem) {
        audioPlaybackHandler.mCurrentWorkItem = playbackQueueItem;
        return playbackQueueItem;
    }

    private void removeAllMessages() {
        this.mQueue.clear();
    }

    private void removeWorkItemsFor(Object object) {
        Iterator<PlaybackQueueItem> iterator = this.mQueue.iterator();
        while (iterator.hasNext()) {
            if (iterator.next().getCallerIdentity() != object) continue;
            iterator.remove();
        }
    }

    private void stop(PlaybackQueueItem playbackQueueItem) {
        if (playbackQueueItem == null) {
            return;
        }
        playbackQueueItem.stop(-2);
    }

    public void enqueue(PlaybackQueueItem playbackQueueItem) {
        try {
            this.mQueue.put(playbackQueueItem);
            return;
        }
        catch (InterruptedException interruptedException) {
            return;
        }
    }

    public boolean isSpeaking() {
        return this.mQueue.peek() != null || this.mCurrentWorkItem != null;
    }

    public void quit() {
        this.removeAllMessages();
        this.stop(this.mCurrentWorkItem);
        this.mHandlerThread.interrupt();
    }

    public void start() {
        this.mHandlerThread.start();
    }

    public void stop() {
        this.removeAllMessages();
        this.stop(this.mCurrentWorkItem);
    }

    public void stopForApp(Object object) {
        this.removeWorkItemsFor(object);
        PlaybackQueueItem playbackQueueItem = this.mCurrentWorkItem;
        if (playbackQueueItem != null && playbackQueueItem.getCallerIdentity() == object) {
            this.stop(playbackQueueItem);
        }
    }

    private final class MessageLoop
    implements Runnable {
        private MessageLoop() {
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            while (true) {
                PlaybackQueueItem playbackQueueItem;
                try {
                    playbackQueueItem = (PlaybackQueueItem)AudioPlaybackHandler.this.mQueue.take();
                }
                catch (InterruptedException interruptedException) {
                    return;
                }
                AudioPlaybackHandler.access$202(AudioPlaybackHandler.this, playbackQueueItem);
                playbackQueueItem.run();
                AudioPlaybackHandler.access$202(AudioPlaybackHandler.this, null);
            }
        }
    }
}

