/*
 * Decompiled with CFR 0.152.
 */
package android.telephony;

import android.content.Context;
import android.content.Intent;
import android.database.Cursor;
import android.location.CountryDetector;
import android.net.Uri;
import android.os.SystemProperties;
import android.telephony.JapanesePhoneNumberFormatter;
import android.telephony.Rlog;
import android.telephony.SubscriptionManager;
import android.telephony.TelephonyManager;
import android.text.Editable;
import android.text.SpannableStringBuilder;
import android.text.TextUtils;
import android.util.SparseIntArray;
import com.android.i18n.phonenumbers.NumberParseException;
import com.android.i18n.phonenumbers.PhoneNumberUtil;
import com.android.i18n.phonenumbers.Phonenumber;
import com.android.i18n.phonenumbers.ShortNumberUtil;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PhoneNumberUtils {
    private static final int CCC_LENGTH = 0;
    private static final String CLIR_OFF = "#31#";
    private static final String CLIR_ON = "*31#";
    private static final boolean[] COUNTRY_CALLING_CALL;
    private static final boolean DBG = false;
    public static final int FORMAT_JAPAN = 2;
    public static final int FORMAT_NANP = 1;
    public static final int FORMAT_UNKNOWN = 0;
    private static final Pattern GLOBAL_PHONE_NUMBER_PATTERN;
    private static final SparseIntArray KEYPAD_MAP;
    static final String LOG_TAG = "PhoneNumberUtils";
    static final int MIN_MATCH = 0;
    private static final String[] NANP_COUNTRIES;
    private static final String NANP_IDP_STRING = "011";
    private static final int NANP_LENGTH = 10;
    private static final int NANP_STATE_DASH = 4;
    private static final int NANP_STATE_DIGIT = 1;
    private static final int NANP_STATE_ONE = 3;
    private static final int NANP_STATE_PLUS = 2;
    public static final char PAUSE = ',';
    private static final char PLUS_SIGN_CHAR = '+';
    private static final String PLUS_SIGN_STRING = "+";
    public static final int TOA_International = 145;
    public static final int TOA_Unknown = 129;
    public static final char WAIT = ';';
    public static final char WILD = 'N';

    /*
     * Enabled aggressive block sorting
     */
    static {
        GLOBAL_PHONE_NUMBER_PATTERN = Pattern.compile("[\\+]?[0-9.-]+");
        NANP_COUNTRIES = new String[]{"US", "CA", "AS", "AI", "AG", "BS", "BB", "BM", "VG", "KY", "DM", "DO", "GD", "GU", "JM", "PR", "MS", "MP", "KN", "LC", "VC", "TT", "TC", "VI"};
        int n = SystemProperties.get("ro.build.asus.sku", "").equals("CN") || SystemProperties.get("ro.build.asus.sku", "").equals("CTA") ? 11 : 7;
        MIN_MATCH = n;
        KEYPAD_MAP = new SparseIntArray();
        KEYPAD_MAP.put(97, 50);
        KEYPAD_MAP.put(98, 50);
        KEYPAD_MAP.put(99, 50);
        KEYPAD_MAP.put(65, 50);
        KEYPAD_MAP.put(66, 50);
        KEYPAD_MAP.put(67, 50);
        KEYPAD_MAP.put(100, 51);
        KEYPAD_MAP.put(101, 51);
        KEYPAD_MAP.put(102, 51);
        KEYPAD_MAP.put(68, 51);
        KEYPAD_MAP.put(69, 51);
        KEYPAD_MAP.put(70, 51);
        KEYPAD_MAP.put(103, 52);
        KEYPAD_MAP.put(104, 52);
        KEYPAD_MAP.put(105, 52);
        KEYPAD_MAP.put(71, 52);
        KEYPAD_MAP.put(72, 52);
        KEYPAD_MAP.put(73, 52);
        KEYPAD_MAP.put(106, 53);
        KEYPAD_MAP.put(107, 53);
        KEYPAD_MAP.put(108, 53);
        KEYPAD_MAP.put(74, 53);
        KEYPAD_MAP.put(75, 53);
        KEYPAD_MAP.put(76, 53);
        KEYPAD_MAP.put(109, 54);
        KEYPAD_MAP.put(110, 54);
        KEYPAD_MAP.put(111, 54);
        KEYPAD_MAP.put(77, 54);
        KEYPAD_MAP.put(78, 54);
        KEYPAD_MAP.put(79, 54);
        KEYPAD_MAP.put(112, 55);
        KEYPAD_MAP.put(113, 55);
        KEYPAD_MAP.put(114, 55);
        KEYPAD_MAP.put(115, 55);
        KEYPAD_MAP.put(80, 55);
        KEYPAD_MAP.put(81, 55);
        KEYPAD_MAP.put(82, 55);
        KEYPAD_MAP.put(83, 55);
        KEYPAD_MAP.put(116, 56);
        KEYPAD_MAP.put(117, 56);
        KEYPAD_MAP.put(118, 56);
        KEYPAD_MAP.put(84, 56);
        KEYPAD_MAP.put(85, 56);
        KEYPAD_MAP.put(86, 56);
        KEYPAD_MAP.put(119, 57);
        KEYPAD_MAP.put(120, 57);
        KEYPAD_MAP.put(121, 57);
        KEYPAD_MAP.put(122, 57);
        KEYPAD_MAP.put(87, 57);
        KEYPAD_MAP.put(88, 57);
        KEYPAD_MAP.put(89, 57);
        KEYPAD_MAP.put(90, 57);
        COUNTRY_CALLING_CALL = new boolean[]{true, true, false, false, false, false, false, true, false, false, false, false, false, false, false, false, false, false, false, false, true, false, false, false, false, false, false, true, true, false, true, true, true, true, true, false, true, false, false, true, true, false, false, true, true, true, true, true, true, true, false, true, true, true, true, true, true, true, true, false, true, true, true, true, true, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, true, true, false, true, false, false, true, true, true, true, true, true, true, false, false, true, false};
        CCC_LENGTH = COUNTRY_CALLING_CALL.length;
    }

    private static String appendPwCharBackToOrigDialStr(int n, String string2, String string3) {
        if (n == 1) {
            return string2 + string3.charAt(0);
        }
        return string2.concat(string3.substring(0, n));
    }

    private static char bcdToChar(byte by) {
        if (by < 10) {
            return (char)(by + 48);
        }
        switch (by) {
            default: {
                return '\u0000';
            }
            case 10: {
                return '*';
            }
            case 11: {
                return '#';
            }
            case 12: {
                return ',';
            }
            case 13: 
        }
        return 'N';
    }

    public static String calledPartyBCDFragmentToString(byte[] byArray, int n, int n2) {
        StringBuilder stringBuilder = new StringBuilder(n2 * 2);
        PhoneNumberUtils.internalCalledPartyBCDFragmentToString(stringBuilder, byArray, n, n2);
        return stringBuilder.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String calledPartyBCDToString(byte[] byArray, int n, int n2) {
        String string2;
        StringBuilder stringBuilder;
        block10: {
            Matcher matcher;
            block11: {
                block9: {
                    stringBuilder = new StringBuilder(1 + n2 * 2);
                    if (n2 < 2) {
                        return "";
                    }
                    int n3 = 0xF0 & byArray[n];
                    boolean bl = false;
                    if (n3 == 144) {
                        bl = true;
                    }
                    PhoneNumberUtils.internalCalledPartyBCDFragmentToString(stringBuilder, byArray, n + 1, n2 - 1);
                    if (bl && stringBuilder.length() == 0) {
                        return "";
                    }
                    if (!bl) break block9;
                    string2 = stringBuilder.toString();
                    matcher = Pattern.compile("(^[#*])(.*)([#*])(.*)(#)$").matcher(string2);
                    if (!matcher.matches()) break block10;
                    if (!"".equals(matcher.group(2))) break block11;
                    stringBuilder = new StringBuilder();
                    stringBuilder.append(matcher.group(1));
                    stringBuilder.append(matcher.group(3));
                    stringBuilder.append(matcher.group(4));
                    stringBuilder.append(matcher.group(5));
                    stringBuilder.append(PLUS_SIGN_STRING);
                }
                return stringBuilder.toString();
            }
            stringBuilder = new StringBuilder();
            stringBuilder.append(matcher.group(1));
            stringBuilder.append(matcher.group(2));
            stringBuilder.append(matcher.group(3));
            stringBuilder.append(PLUS_SIGN_STRING);
            stringBuilder.append(matcher.group(4));
            stringBuilder.append(matcher.group(5));
            return stringBuilder.toString();
        }
        Matcher matcher = Pattern.compile("(^[#*])(.*)([#*])(.*)").matcher(string2);
        if (matcher.matches()) {
            stringBuilder = new StringBuilder();
            stringBuilder.append(matcher.group(1));
            stringBuilder.append(matcher.group(2));
            stringBuilder.append(matcher.group(3));
            stringBuilder.append(PLUS_SIGN_STRING);
            stringBuilder.append(matcher.group(4));
            return stringBuilder.toString();
        }
        stringBuilder = new StringBuilder();
        stringBuilder.append('+');
        stringBuilder.append(string2);
        return stringBuilder.toString();
    }

    public static String cdmaCheckAndProcessPlusCode(String string2) {
        if (!TextUtils.isEmpty(string2) && PhoneNumberUtils.isReallyDialable(string2.charAt(0)) && PhoneNumberUtils.isNonSeparator(string2)) {
            String string3 = SystemProperties.get("gsm.operator.iso-country", "");
            String string4 = SystemProperties.get("gsm.sim.operator.iso-country", "");
            if (!TextUtils.isEmpty(string3) && !TextUtils.isEmpty(string4)) {
                string2 = PhoneNumberUtils.cdmaCheckAndProcessPlusCodeByNumberFormat(string2, PhoneNumberUtils.getFormatTypeFromCountryCode(string3), PhoneNumberUtils.getFormatTypeFromCountryCode(string4));
            }
        }
        return string2;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static String cdmaCheckAndProcessPlusCodeByNumberFormat(String string2, int n, int n2) {
        String string3 = string2;
        boolean bl = n == n2 && n == 1;
        if (string2 != null && string2.lastIndexOf(PLUS_SIGN_STRING) != -1) {
            String string4;
            String string5 = string2;
            string3 = null;
            do {
                String string6;
                String string7;
                if (TextUtils.isEmpty(string7 = PhoneNumberUtils.processPlusCode(string6 = bl ? PhoneNumberUtils.extractNetworkPortion(string5) : PhoneNumberUtils.extractNetworkPortionAlt(string5), bl))) {
                    Rlog.e("checkAndProcessPlusCode: null newDialStr", string7);
                    return string2;
                }
                string3 = string3 == null ? string7 : string3.concat(string7);
                string4 = PhoneNumberUtils.extractPostDialPortion(string5);
                if (TextUtils.isEmpty(string4)) continue;
                int n3 = PhoneNumberUtils.findDialableIndexFromPostDialStr(string4);
                if (n3 >= 1) {
                    string3 = PhoneNumberUtils.appendPwCharBackToOrigDialStr(n3, string3, string4);
                    string5 = string4.substring(n3);
                    continue;
                }
                if (n3 < 0) {
                    string4 = "";
                }
                Rlog.e("wrong postDialStr=", string4);
            } while (!TextUtils.isEmpty(string4) && !TextUtils.isEmpty(string5));
        }
        return string3;
    }

    public static String cdmaCheckAndProcessPlusCodeForSms(String string2) {
        String string3;
        if (!TextUtils.isEmpty(string2) && PhoneNumberUtils.isReallyDialable(string2.charAt(0)) && PhoneNumberUtils.isNonSeparator(string2) && !TextUtils.isEmpty(string3 = SystemProperties.get("gsm.sim.operator.iso-country", ""))) {
            int n = PhoneNumberUtils.getFormatTypeFromCountryCode(string3);
            string2 = PhoneNumberUtils.cdmaCheckAndProcessPlusCodeByNumberFormat(string2, n, n);
        }
        return string2;
    }

    private static int charToBCD(char c) {
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        if (c == '*') {
            return 10;
        }
        if (c == '#') {
            return 11;
        }
        if (c == ',') {
            return 12;
        }
        if (c == 'N') {
            return 13;
        }
        throw new RuntimeException("invalid char for BCD " + c);
    }

    /*
     * Enabled aggressive block sorting
     */
    private static boolean checkPrefixIsIgnorable(String string2, int n, int n2) {
        boolean bl = false;
        while (n2 >= n) {
            if (PhoneNumberUtils.tryGetISODigit(string2.charAt(n2)) >= 0) {
                if (bl) {
                    return false;
                }
                bl = true;
            } else if (PhoneNumberUtils.isDialable(string2.charAt(n2))) {
                return false;
            }
            --n2;
        }
        return true;
    }

    public static boolean compare(Context context, String string2, String string3) {
        return PhoneNumberUtils.compare(string2, string3, context.getResources().getBoolean(17956909));
    }

    public static boolean compare(String string2, String string3) {
        return PhoneNumberUtils.compare(string2, string3, false);
    }

    public static boolean compare(String string2, String string3, boolean bl) {
        if (bl) {
            return PhoneNumberUtils.compareStrictly(string2, string3);
        }
        return PhoneNumberUtils.compareLoosely(string2, string3);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static boolean compareLoosely(String string2, String string3) {
        int n = 0;
        int n2 = 0;
        if (string2 == null || string3 == null) {
            if (string2 == string3) return true;
            return false;
        }
        if (string2.length() == 0 || string3.length() == 0) {
            return false;
        }
        int n3 = PhoneNumberUtils.indexOfLastNetworkChar(string2);
        int n4 = PhoneNumberUtils.indexOfLastNetworkChar(string3);
        int n5 = 0;
        while (true) {
            block13: {
                block12: {
                    char c;
                    if (n3 < 0 || n4 < 0) break block12;
                    char c2 = string2.charAt(n3);
                    boolean bl = PhoneNumberUtils.isDialable(c2);
                    boolean bl2 = false;
                    if (!bl) {
                        --n3;
                        bl2 = true;
                        ++n;
                    }
                    if (!PhoneNumberUtils.isDialable(c = string3.charAt(n4))) {
                        --n4;
                        bl2 = true;
                        ++n2;
                    }
                    if (bl2) continue;
                    if (c == c2 || c2 == 'N' || c == 'N') break block13;
                }
                if (n5 >= MIN_MATCH) break;
                int n6 = string2.length() - n;
                if (n6 == string3.length() - n2 && n6 == n5) return true;
                return false;
            }
            --n3;
            --n4;
            ++n5;
        }
        if (!(n5 >= MIN_MATCH && (n3 < 0 || n4 < 0) || PhoneNumberUtils.matchIntlPrefix(string2, n3 + 1) && PhoneNumberUtils.matchIntlPrefix(string3, n4 + 1) || PhoneNumberUtils.matchTrunkPrefix(string2, n3 + 1) && PhoneNumberUtils.matchIntlPrefixAndCC(string3, n4 + 1)) && (!PhoneNumberUtils.matchTrunkPrefix(string3, n4 + 1) || !PhoneNumberUtils.matchIntlPrefixAndCC(string2, n3 + 1))) return false;
        return true;
    }

    public static boolean compareStrictly(String string2, String string3) {
        return PhoneNumberUtils.compareStrictly(string2, string3, true);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static boolean compareStrictly(String string2, String string3, boolean bl) {
        int n;
        int n2;
        boolean bl2;
        if (string2 == null || string3 == null) {
            return string2 == string3;
        }
        if (string2.length() == 0 && string3.length() == 0) {
            return false;
        }
        CountryCallingCodeAndNewIndex countryCallingCodeAndNewIndex = PhoneNumberUtils.tryGetCountryCallingCodeAndNewIndex(string2, bl);
        CountryCallingCodeAndNewIndex countryCallingCodeAndNewIndex2 = PhoneNumberUtils.tryGetCountryCallingCodeAndNewIndex(string3, bl);
        boolean bl3 = true;
        boolean bl4 = false;
        boolean bl5 = false;
        if (countryCallingCodeAndNewIndex != null && countryCallingCodeAndNewIndex2 != null) {
            if (countryCallingCodeAndNewIndex.countryCallingCode != countryCallingCodeAndNewIndex2.countryCallingCode) {
                return false;
            }
            bl3 = false;
            bl2 = true;
            n2 = countryCallingCodeAndNewIndex.newIndex;
            n = countryCallingCodeAndNewIndex2.newIndex;
        } else if (countryCallingCodeAndNewIndex == null && countryCallingCodeAndNewIndex2 == null) {
            bl2 = false;
            n2 = 0;
            n = 0;
            bl3 = false;
            bl4 = false;
            bl5 = false;
        } else {
            if (countryCallingCodeAndNewIndex != null) {
                n2 = countryCallingCodeAndNewIndex.newIndex;
            } else {
                int n3 = PhoneNumberUtils.tryGetTrunkPrefixOmittedIndex(string3, 0);
                n2 = 0;
                bl4 = false;
                if (n3 >= 0) {
                    n2 = n3;
                    bl4 = true;
                }
            }
            if (countryCallingCodeAndNewIndex2 != null) {
                n = countryCallingCodeAndNewIndex2.newIndex;
                bl2 = false;
                bl5 = false;
            } else {
                int n4 = PhoneNumberUtils.tryGetTrunkPrefixOmittedIndex(string3, 0);
                bl2 = false;
                n = 0;
                bl5 = false;
                if (n4 >= 0) {
                    n = n4;
                    bl5 = true;
                    bl2 = false;
                }
            }
        }
        int n5 = -1 + string2.length();
        int n6 = -1 + string3.length();
        while (n5 >= n2 && n6 >= n) {
            char c = string2.charAt(n5);
            char c2 = string3.charAt(n6);
            boolean bl6 = PhoneNumberUtils.isSeparator(c);
            boolean bl7 = false;
            if (bl6) {
                --n5;
                bl7 = true;
            }
            if (PhoneNumberUtils.isSeparator(c2)) {
                --n6;
                bl7 = true;
            }
            if (bl7) continue;
            if (c != c2) {
                return false;
            }
            --n5;
            --n6;
        }
        if (bl3) {
            if (bl4 && n2 <= n5 || !PhoneNumberUtils.checkPrefixIsIgnorable(string2, n2, n5)) {
                if (!bl) return false;
                return PhoneNumberUtils.compare(string2, string3, false);
            }
            if ((!bl5 || n > n6) && PhoneNumberUtils.checkPrefixIsIgnorable(string3, n2, n6)) return true;
            if (!bl) return false;
            return PhoneNumberUtils.compare(string2, string3, false);
        }
        boolean bl8 = !bl2;
        while (n5 >= n2) {
            char c = string2.charAt(n5);
            if (PhoneNumberUtils.isDialable(c)) {
                if (!bl8 || PhoneNumberUtils.tryGetISODigit(c) != 1) return false;
                bl8 = false;
            }
            --n5;
        }
        while (n6 >= n) {
            char c = string3.charAt(n6);
            if (PhoneNumberUtils.isDialable(c)) {
                if (!bl8 || PhoneNumberUtils.tryGetISODigit(c) != 1) return false;
                bl8 = false;
            }
            --n6;
        }
        return true;
    }

    public static String convertAndStrip(String string2) {
        return PhoneNumberUtils.stripSeparators(PhoneNumberUtils.convertKeypadLettersToDigits(string2));
    }

    /*
     * Enabled aggressive block sorting
     */
    public static String convertKeypadLettersToDigits(String string2) {
        int n;
        if (string2 == null || (n = string2.length()) == 0) {
            return string2;
        }
        char[] cArray = string2.toCharArray();
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            cArray[n2] = (char)KEYPAD_MAP.get(c, c);
            ++n2;
        }
        return new String(cArray);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static String convertPreDial(String string2) {
        if (string2 == null) {
            return null;
        }
        int n = string2.length();
        StringBuilder stringBuilder = new StringBuilder(n);
        int n2 = 0;
        while (n2 < n) {
            int n3 = string2.charAt(n2);
            if (PhoneNumberUtils.isPause((char)n3)) {
                n3 = 44;
            } else if (PhoneNumberUtils.isToneWait((char)n3)) {
                n3 = 59;
            }
            stringBuilder.append((char)n3);
            ++n2;
        }
        return stringBuilder.toString();
    }

    /*
     * Enabled aggressive block sorting
     */
    public static String extractNetworkPortion(String string2) {
        if (string2 == null) {
            return null;
        }
        int n = string2.length();
        StringBuilder stringBuilder = new StringBuilder(n);
        for (int i = 0; i < n; ++i) {
            char c = string2.charAt(i);
            int n2 = Character.digit(c, 10);
            if (n2 != -1) {
                stringBuilder.append(n2);
                continue;
            }
            if (c == '+') {
                String string3 = stringBuilder.toString();
                if (string3.length() != 0 && !string3.equals(CLIR_ON) && !string3.equals(CLIR_OFF)) continue;
                stringBuilder.append(c);
                continue;
            }
            if (PhoneNumberUtils.isDialable(c)) {
                stringBuilder.append(c);
                continue;
            }
            if (PhoneNumberUtils.isStartsPostDial(c)) break;
        }
        return stringBuilder.toString();
    }

    /*
     * Enabled aggressive block sorting
     */
    public static String extractNetworkPortionAlt(String string2) {
        if (string2 == null) {
            return null;
        }
        int n = string2.length();
        StringBuilder stringBuilder = new StringBuilder(n);
        boolean bl = false;
        for (int i = 0; i < n; ++i) {
            char c = string2.charAt(i);
            if (c == '+') {
                if (bl) continue;
                bl = true;
            }
            if (PhoneNumberUtils.isDialable(c)) {
                stringBuilder.append(c);
                continue;
            }
            if (PhoneNumberUtils.isStartsPostDial(c)) break;
        }
        return stringBuilder.toString();
    }

    public static String extractPostDialPortion(String string2) {
        if (string2 == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        int n = string2.length();
        for (int i = 1 + PhoneNumberUtils.indexOfLastNetworkChar(string2); i < n; ++i) {
            char c = string2.charAt(i);
            if (!PhoneNumberUtils.isNonSeparator(c)) continue;
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    private static int findDialableIndexFromPostDialStr(String string2) {
        for (int i = 0; i < string2.length(); ++i) {
            if (!PhoneNumberUtils.isReallyDialable(string2.charAt(i))) continue;
            return i;
        }
        return -1;
    }

    public static void formatJapaneseNumber(Editable editable) {
        JapanesePhoneNumberFormatter.format(editable);
    }

    /*
     * Unable to fully structure code
     */
    public static void formatNanpNumber(Editable var0) {
        block19: {
            var1_1 = var0.length();
            if (var1_1 > "+1-nnn-nnn-nnnn".length()) lbl-1000:
            // 3 sources

            {
                return;
            }
            if (var1_1 <= 5) ** GOTO lbl-1000
            var2_2 = var0.subSequence(0, var1_1);
            PhoneNumberUtils.removeDashes(var0);
            var3_3 = var0.length();
            var4_4 = new int[3];
            var5_5 = 1;
            var6_6 = 0;
            var8_8 = 0;
            block7: for (var7_7 = 0; var7_7 < var3_3; ++var7_7) {
                block0 : switch (var0.charAt(var7_7)) lbl-1000:
                // 2 sources

                {
                    default: {
                        var0.replace(0, var3_3, var2_2);
                        return;
                    }
                    case '1': {
                        if (var6_6 == 0 || var5_5 == 2) {
                            var5_5 = 3;
                            var15_9 = var8_8;
lbl23:
                            // 1 sources

                            while (true) {
                                var8_8 = var15_9;
                                continue block7;
                                break;
                            }
                        }
                    }
                    case '0': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': {
                        if (var5_5 == 2) {
                            var0.replace(0, var3_3, var2_2);
                            return;
                        }
                        if (var5_5 == 3) {
                            var15_9 = var8_8 + 1;
                            var4_4[var8_8] = var7_7;
lbl34:
                            // 3 sources

                            while (true) {
                                var5_5 = 1;
                                ++var6_6;
                                break block0;
                                break;
                            }
                        }
                        if (var5_5 == 4 || var6_6 != 3 && var6_6 != 6) break block19;
                        var15_9 = var8_8 + 1;
                        var4_4[var8_8] = var7_7;
                        ** GOTO lbl34
                    }
                    case '-': {
                        var5_5 = 4;
                        var15_9 = var8_8;
                        break;
                    }
                    case '+': {
                        if (var7_7 != 0) ** GOTO lbl-1000
                        var5_5 = 2;
                        var15_9 = var8_8;
                        break;
                    }
                }
                ** continue;
            }
            if (var6_6 == 7) {
                var9_10 = var8_8 - 1;
lbl54:
                // 2 sources

                while (true) {
                    for (var10_11 = 0; var10_11 < var9_10; ++var10_11) {
                        var13_12 = var4_4[var10_11];
                        var0.replace(var13_12 + var10_11, var13_12 + var10_11, "-");
                    }
                    var11_13 = var0.length();
                    while (true) {
                        if (var11_13 > 0 && var0.charAt(var11_13 - 1) == '-') ** break;
                        ** continue;
                        var0.delete(var11_13 - 1, var11_13);
                        --var11_13;
                    }
                    break;
                }
            }
            var9_10 = var8_8;
            ** while (true)
        }
        var15_9 = var8_8;
        ** while (true)
    }

    public static String formatNumber(String string2) {
        SpannableStringBuilder spannableStringBuilder = new SpannableStringBuilder(string2);
        PhoneNumberUtils.formatNumber(spannableStringBuilder, PhoneNumberUtils.getFormatTypeForLocale(Locale.getDefault()));
        return spannableStringBuilder.toString();
    }

    public static String formatNumber(String string2, int n) {
        SpannableStringBuilder spannableStringBuilder = new SpannableStringBuilder(string2);
        PhoneNumberUtils.formatNumber(spannableStringBuilder, n);
        return spannableStringBuilder.toString();
    }

    public static String formatNumber(String string2, String string3) {
        if (string2.startsWith("#") || string2.startsWith("*")) {
            return string2;
        }
        PhoneNumberUtil phoneNumberUtil = PhoneNumberUtil.getInstance();
        try {
            String string4 = phoneNumberUtil.formatInOriginalFormat(phoneNumberUtil.parseAndKeepRawInput(string2, string3), string3);
            return string4;
        }
        catch (NumberParseException numberParseException) {
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String formatNumber(String string2, String string3, String string4) {
        String string5;
        int n = string2.length();
        for (int i = 0; i < n; ++i) {
            if (PhoneNumberUtils.isDialable(string2.charAt(i))) continue;
            return string2;
        }
        PhoneNumberUtil phoneNumberUtil = PhoneNumberUtil.getInstance();
        if (string3 != null && string3.length() >= 2 && string3.charAt(0) == '+') {
            try {
                int n2;
                String string6 = phoneNumberUtil.getRegionCodeForNumber(phoneNumberUtil.parse(string3, "ZZ"));
                if (!TextUtils.isEmpty(string6) && (n2 = PhoneNumberUtils.normalizeNumber(string2).indexOf(string3.substring(1))) <= 0) {
                    string4 = string6;
                }
            }
            catch (NumberParseException numberParseException) {}
        }
        if ((string5 = PhoneNumberUtils.formatNumber(string2, string4)) == null) return string2;
        return string5;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void formatNumber(Editable editable, int n) {
        int n2 = n;
        if (editable.length() > 2 && editable.charAt(0) == '+') {
            n2 = editable.charAt(1) == '1' ? 1 : (editable.length() >= 3 && editable.charAt(1) == '8' && editable.charAt(2) == '1' ? 2 : 0);
        }
        switch (n2) {
            default: {
                return;
            }
            case 1: {
                PhoneNumberUtils.formatNanpNumber(editable);
                return;
            }
            case 2: {
                PhoneNumberUtils.formatJapaneseNumber(editable);
                return;
            }
            case 0: 
        }
        PhoneNumberUtils.removeDashes(editable);
    }

    public static String formatNumberToE164(String string2, String string3) {
        String string4;
        block3: {
            String string5;
            Phonenumber.PhoneNumber phoneNumber;
            PhoneNumberUtil phoneNumberUtil = PhoneNumberUtil.getInstance();
            try {
                phoneNumber = phoneNumberUtil.parse(string2, string3);
                boolean bl = phoneNumberUtil.isValidNumber(phoneNumber);
                string4 = null;
                if (!bl) break block3;
            }
            catch (NumberParseException numberParseException) {
                return null;
            }
            string4 = string5 = phoneNumberUtil.format(phoneNumber, PhoneNumberUtil.PhoneNumberFormat.E164);
        }
        return string4;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String getCurrentIdp(boolean bl) {
        String string2;
        if (bl) {
            string2 = NANP_IDP_STRING;
            return SystemProperties.get("gsm.operator.idpstring", string2);
        }
        string2 = PLUS_SIGN_STRING;
        return SystemProperties.get("gsm.operator.idpstring", string2);
    }

    private static long getDefaultVoiceSubId() {
        return SubscriptionManager.getDefaultVoiceSubId();
    }

    public static int getFormatTypeForLocale(Locale locale) {
        return PhoneNumberUtils.getFormatTypeFromCountryCode(locale.getCountry());
    }

    private static int getFormatTypeFromCountryCode(String string2) {
        int n = NANP_COUNTRIES.length;
        for (int i = 0; i < n; ++i) {
            if (NANP_COUNTRIES[i].compareToIgnoreCase(string2) != 0) continue;
            return 1;
        }
        if ("jp".compareToIgnoreCase(string2) == 0) {
            return 2;
        }
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getNumberFromIntent(Intent intent, Context context) {
        String string2;
        Uri uri = intent.getData();
        if (uri == null) return null;
        String string3 = uri.getScheme();
        if (string3.equals("tel") || string3.equals("sip")) {
            return uri.getSchemeSpecificPart();
        }
        if (context == null) {
            return null;
        }
        intent.resolveType(context);
        String string4 = uri.getAuthority();
        if ("contacts".equals(string4)) {
            string2 = "number";
        } else {
            boolean bl = "com.android.contacts".equals(string4);
            string2 = null;
            if (bl) {
                string2 = "data1";
            }
        }
        Cursor cursor = context.getContentResolver().query(uri, new String[]{string2}, null, null, null);
        String string5 = null;
        if (cursor == null) return string5;
        try {
            boolean bl = cursor.moveToFirst();
            string5 = null;
            if (bl) {
                String string6;
                string5 = string6 = cursor.getString(cursor.getColumnIndex(string2));
            }
            cursor.close();
            return string5;
        }
        catch (Throwable throwable) {
            cursor.close();
            throw throwable;
        }
    }

    public static String getStrippedReversed(String string2) {
        String string3 = PhoneNumberUtils.extractNetworkPortionAlt(string2);
        if (string3 == null) {
            return null;
        }
        return PhoneNumberUtils.internalGetStrippedReversed(string3, string3.length());
    }

    public static String getUsernameFromUriNumber(String string2) {
        int n = string2.indexOf(64);
        if (n < 0) {
            n = string2.indexOf("%40");
        }
        if (n < 0) {
            Rlog.w(LOG_TAG, "getUsernameFromUriNumber: no delimiter found in SIP addr '" + string2 + "'");
            n = string2.length();
        }
        return string2.substring(0, n);
    }

    private static int indexOfLastNetworkChar(String string2) {
        int n = string2.length();
        int n2 = PhoneNumberUtils.minPositive(string2.indexOf(44), string2.indexOf(59));
        if (n2 < 0) {
            return n - 1;
        }
        return n2 - 1;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void internalCalledPartyBCDFragmentToString(StringBuilder stringBuilder, byte[] byArray, int n, int n2) {
        int n3 = n;
        while (true) {
            char c;
            block4: {
                block3: {
                    char c2;
                    if (n3 >= n2 + n || (c2 = PhoneNumberUtils.bcdToChar((byte)(0xF & byArray[n3]))) == '\u0000') break block3;
                    stringBuilder.append(c2);
                    byte by = (byte)(0xF & byArray[n3] >> 4);
                    if ((by != 15 || n3 + 1 != n2 + n) && (c = PhoneNumberUtils.bcdToChar(by)) != '\u0000') break block4;
                }
                return;
            }
            stringBuilder.append(c);
            ++n3;
        }
    }

    private static String internalGetStrippedReversed(String string2, int n) {
        if (string2 == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder(n);
        int n2 = string2.length();
        for (int i = n2 - 1; i >= 0 && n2 - i <= n; --i) {
            stringBuilder.append(string2.charAt(i));
        }
        return stringBuilder.toString();
    }

    public static final boolean is12Key(char c) {
        return c >= '0' && c <= '9' || c == '*' || c == '#';
    }

    private static boolean isCountryCallingCode(int n) {
        return n > 0 && n < CCC_LENGTH && COUNTRY_CALLING_CALL[n];
    }

    public static final boolean isDialable(char c) {
        return c >= '0' && c <= '9' || c == '*' || c == '#' || c == '+' || c == 'N';
    }

    private static boolean isDialable(String string2) {
        int n = string2.length();
        for (int i = 0; i < n; ++i) {
            if (PhoneNumberUtils.isDialable(string2.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isEmergencyNumber(long l, String string2) {
        return PhoneNumberUtils.isEmergencyNumberInternal(l, string2, true);
    }

    public static boolean isEmergencyNumber(long l, String string2, String string3) {
        return PhoneNumberUtils.isEmergencyNumberInternal(l, string2, string3, true);
    }

    public static boolean isEmergencyNumber(String string2) {
        return PhoneNumberUtils.isEmergencyNumber(PhoneNumberUtils.getDefaultVoiceSubId(), string2);
    }

    public static boolean isEmergencyNumber(String string2, String string3) {
        return PhoneNumberUtils.isEmergencyNumber(PhoneNumberUtils.getDefaultVoiceSubId(), string2, string3);
    }

    /*
     * Enabled aggressive block sorting
     */
    private static boolean isEmergencyNumberInternal(long l, String string2, String string3, boolean bl) {
        if (string2 == null) {
            return false;
        }
        if (PhoneNumberUtils.isUriNumber(string2)) {
            return false;
        }
        String string4 = PhoneNumberUtils.extractNetworkPortionAlt(string2);
        int n = SubscriptionManager.getSlotId(l);
        String string5 = n <= 0 ? "ril.ecclist" : "ril.ecclist" + n;
        String string6 = SystemProperties.get(string5);
        if (TextUtils.isEmpty(string6)) {
            string6 = SystemProperties.get("ro.ril.ecclist");
        }
        if (TextUtils.isEmpty(string6)) {
            Rlog.d(LOG_TAG, "System property doesn't provide any emergency numbers. Use embedded logic for determining ones.");
            if (string3 != null) {
                ShortNumberUtil shortNumberUtil = new ShortNumberUtil();
                if (bl) {
                    return shortNumberUtil.isEmergencyNumber(string4, string3);
                }
                return shortNumberUtil.connectsToEmergencyNumber(string4, string3);
            }
            if (bl) {
                return string4.equals("112") || string4.equals("911");
            }
            return string4.startsWith("112") || string4.startsWith("911");
        }
        String[] stringArray = string6.split(",");
        int n2 = stringArray.length;
        int n3 = 0;
        while (n3 < n2) {
            String string7 = stringArray[n3];
            if (bl || "BR".equalsIgnoreCase(string3) ? string4.equals(string7) : string4.startsWith(string7)) {
                return true;
            }
            ++n3;
        }
        return false;
    }

    private static boolean isEmergencyNumberInternal(long l, String string2, boolean bl) {
        return PhoneNumberUtils.isEmergencyNumberInternal(l, string2, null, bl);
    }

    private static boolean isEmergencyNumberInternal(String string2, String string3, boolean bl) {
        return PhoneNumberUtils.isEmergencyNumberInternal(PhoneNumberUtils.getDefaultVoiceSubId(), string2, string3, bl);
    }

    private static boolean isEmergencyNumberInternal(String string2, boolean bl) {
        return PhoneNumberUtils.isEmergencyNumberInternal(PhoneNumberUtils.getDefaultVoiceSubId(), string2, bl);
    }

    public static boolean isGlobalPhoneNumber(String string2) {
        if (TextUtils.isEmpty(string2)) {
            return false;
        }
        return GLOBAL_PHONE_NUMBER_PATTERN.matcher(string2).matches();
    }

    public static boolean isISODigit(char c) {
        return c >= '0' && c <= '9';
    }

    public static boolean isLocalEmergencyNumber(Context context, long l, String string2) {
        return PhoneNumberUtils.isLocalEmergencyNumberInternal(l, string2, context, true);
    }

    public static boolean isLocalEmergencyNumber(Context context, String string2) {
        return PhoneNumberUtils.isLocalEmergencyNumber(context, PhoneNumberUtils.getDefaultVoiceSubId(), string2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean isLocalEmergencyNumberInternal(long l, String string2, Context context, boolean bl) {
        String string3;
        CountryDetector countryDetector = (CountryDetector)context.getSystemService("country_detector");
        if (countryDetector != null && countryDetector.detectCountry() != null) {
            string3 = countryDetector.detectCountry().getCountryIso();
            return PhoneNumberUtils.isEmergencyNumberInternal(l, string2, string3, bl);
        }
        string3 = context.getResources().getConfiguration().locale.getCountry();
        Rlog.w(LOG_TAG, "No CountryDetector; falling back to countryIso based on locale: " + string3);
        return PhoneNumberUtils.isEmergencyNumberInternal(l, string2, string3, bl);
    }

    private static boolean isLocalEmergencyNumberInternal(String string2, Context context, boolean bl) {
        return PhoneNumberUtils.isLocalEmergencyNumberInternal(PhoneNumberUtils.getDefaultVoiceSubId(), string2, context, bl);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isNanp(String string2) {
        if (string2 != null) {
            int n = string2.length();
            boolean bl = false;
            if (n != 10) return bl;
            boolean bl2 = PhoneNumberUtils.isTwoToNine(string2.charAt(0));
            bl = false;
            if (!bl2) return bl;
            boolean bl3 = PhoneNumberUtils.isTwoToNine(string2.charAt(3));
            bl = false;
            if (!bl3) return bl;
            bl = true;
            int n2 = 1;
            while (n2 < 10) {
                if (!PhoneNumberUtils.isISODigit(string2.charAt(n2))) {
                    return false;
                }
                ++n2;
            }
            return bl;
        }
        Rlog.e("isNanp: null dialStr passed in", string2);
        return false;
    }

    public static final boolean isNonSeparator(char c) {
        return c >= '0' && c <= '9' || c == '*' || c == '#' || c == '+' || c == 'N' || c == ';' || c == ',';
    }

    private static boolean isNonSeparator(String string2) {
        int n = string2.length();
        for (int i = 0; i < n; ++i) {
            if (PhoneNumberUtils.isNonSeparator(string2.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private static boolean isOneNanp(String string2) {
        if (string2 != null) {
            String string3 = string2.substring(1);
            char c = string2.charAt(0);
            boolean bl = false;
            if (c == '1') {
                boolean bl2 = PhoneNumberUtils.isNanp(string3);
                bl = false;
                if (bl2) {
                    bl = true;
                }
            }
            return bl;
        }
        Rlog.e("isOneNanp: null dialStr passed in", string2);
        return false;
    }

    private static boolean isPause(char c) {
        return c == 'p' || c == 'P';
    }

    public static boolean isPotentialEmergencyNumber(long l, String string2) {
        return PhoneNumberUtils.isEmergencyNumberInternal(l, string2, false);
    }

    public static boolean isPotentialEmergencyNumber(long l, String string2, String string3) {
        return PhoneNumberUtils.isEmergencyNumberInternal(l, string2, string3, false);
    }

    public static boolean isPotentialEmergencyNumber(String string2) {
        return PhoneNumberUtils.isPotentialEmergencyNumber(PhoneNumberUtils.getDefaultVoiceSubId(), string2);
    }

    public static boolean isPotentialEmergencyNumber(String string2, String string3) {
        return PhoneNumberUtils.isPotentialEmergencyNumber(PhoneNumberUtils.getDefaultVoiceSubId(), string2, string3);
    }

    public static boolean isPotentialLocalEmergencyNumber(Context context, long l, String string2) {
        return PhoneNumberUtils.isLocalEmergencyNumberInternal(l, string2, context, false);
    }

    public static boolean isPotentialLocalEmergencyNumber(Context context, String string2) {
        return PhoneNumberUtils.isPotentialLocalEmergencyNumber(context, PhoneNumberUtils.getDefaultVoiceSubId(), string2);
    }

    public static final boolean isReallyDialable(char c) {
        return c >= '0' && c <= '9' || c == '*' || c == '#' || c == '+';
    }

    private static boolean isSeparator(char c) {
        return !(PhoneNumberUtils.isDialable(c) || 'a' <= c && c <= 'z' || 'A' <= c && c <= 'Z');
    }

    public static final boolean isStartsPostDial(char c) {
        return c == ',' || c == ';';
    }

    private static boolean isToneWait(char c) {
        return c == 'w' || c == 'W';
    }

    private static boolean isTwoToNine(char c) {
        return c >= '2' && c <= '9';
    }

    public static boolean isUriNumber(String string2) {
        return string2 != null && (string2.contains("@") || string2.contains("%40"));
    }

    public static boolean isVoiceMailNumber(long l, String string2) {
        String string3;
        try {
            string3 = TelephonyManager.getDefault().getVoiceMailNumber(l);
        }
        catch (SecurityException securityException) {
            return false;
        }
        String string4 = PhoneNumberUtils.extractNetworkPortionAlt(string2);
        boolean bl = TextUtils.isEmpty(string4);
        boolean bl2 = false;
        if (!bl) {
            boolean bl3 = PhoneNumberUtils.compare(string4, string3);
            bl2 = false;
            if (bl3) {
                bl2 = true;
            }
        }
        return bl2;
    }

    public static boolean isVoiceMailNumber(String string2) {
        return PhoneNumberUtils.isVoiceMailNumber(SubscriptionManager.getDefaultSubId(), string2);
    }

    public static boolean isWellFormedSmsAddress(String string2) {
        String string3 = PhoneNumberUtils.extractNetworkPortion(string2);
        return !string3.equals(PLUS_SIGN_STRING) && !TextUtils.isEmpty(string3) && PhoneNumberUtils.isDialable(string3);
    }

    private static void log(String string2) {
        Rlog.d(LOG_TAG, string2);
    }

    /*
     * Enabled aggressive block sorting
     */
    private static boolean matchIntlPrefix(String string2, int n) {
        int n2 = 0;
        block5: for (int i = 0; i < n; ++i) {
            char c = string2.charAt(i);
            switch (n2) {
                default: {
                    if (!PhoneNumberUtils.isNonSeparator(c)) continue block5;
                    return false;
                }
                case 0: {
                    if (c == '+') {
                        n2 = 1;
                        continue block5;
                    }
                    if (c == '0') {
                        n2 = 2;
                        continue block5;
                    }
                    if (!PhoneNumberUtils.isNonSeparator(c)) continue block5;
                    return false;
                }
                case 2: {
                    if (c == '0') {
                        n2 = 3;
                        continue block5;
                    }
                    if (c == '1') {
                        n2 = 4;
                        continue block5;
                    }
                    if (!PhoneNumberUtils.isNonSeparator(c)) continue block5;
                    return false;
                }
                case 4: {
                    if (c == '1') {
                        n2 = 5;
                        continue block5;
                    }
                    if (!PhoneNumberUtils.isNonSeparator(c)) continue block5;
                    return false;
                }
            }
        }
        if (n2 == true || n2 == 3 || n2 == 5) return true;
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static boolean matchIntlPrefixAndCC(String string2, int n) {
        int n2 = 0;
        block7: for (int i = 0; i < n; ++i) {
            char c = string2.charAt(i);
            switch (n2) {
                default: {
                    if (!PhoneNumberUtils.isNonSeparator(c)) continue block7;
                    return false;
                }
                case 0: {
                    if (c == '+') {
                        n2 = 1;
                        continue block7;
                    }
                    if (c == '0') {
                        n2 = 2;
                        continue block7;
                    }
                    if (!PhoneNumberUtils.isNonSeparator(c)) continue block7;
                    return false;
                }
                case 2: {
                    if (c == '0') {
                        n2 = 3;
                        continue block7;
                    }
                    if (c == '1') {
                        n2 = 4;
                        continue block7;
                    }
                    if (!PhoneNumberUtils.isNonSeparator(c)) continue block7;
                    return false;
                }
                case 4: {
                    if (c == '1') {
                        n2 = 5;
                        continue block7;
                    }
                    if (!PhoneNumberUtils.isNonSeparator(c)) continue block7;
                    return false;
                }
                case 1: 
                case 3: 
                case 5: {
                    if (PhoneNumberUtils.isISODigit(c)) {
                        n2 = 6;
                        continue block7;
                    }
                    if (!PhoneNumberUtils.isNonSeparator(c)) continue block7;
                    return false;
                }
                case 6: 
                case 7: {
                    if (PhoneNumberUtils.isISODigit(c)) {
                        ++n2;
                        continue block7;
                    }
                    if (!PhoneNumberUtils.isNonSeparator(c)) continue block7;
                    return false;
                }
            }
        }
        if (n2 == 6 || n2 == 7 || n2 == 8) return true;
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static boolean matchTrunkPrefix(String string2, int n) {
        boolean bl = false;
        int n2 = 0;
        while (n2 < n) {
            char c = string2.charAt(n2);
            if (c == '0' && !bl) {
                bl = true;
            } else if (PhoneNumberUtils.isNonSeparator(c)) {
                return false;
            }
            ++n2;
        }
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static int minPositive(int n, int n2) {
        if (n >= 0 && n2 >= 0) {
            if (n < n2) return n;
            return n2;
        }
        if (n >= 0) {
            return n;
        }
        if (n2 < 0) return -1;
        return n2;
    }

    public static byte[] networkPortionToCalledPartyBCD(String string2) {
        return PhoneNumberUtils.numberToCalledPartyBCDHelper(PhoneNumberUtils.extractNetworkPortion(string2), false);
    }

    public static byte[] networkPortionToCalledPartyBCDWithLength(String string2) {
        return PhoneNumberUtils.numberToCalledPartyBCDHelper(PhoneNumberUtils.extractNetworkPortion(string2), true);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static String normalizeNumber(String string2) {
        if (TextUtils.isEmpty(string2)) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        int n = string2.length();
        int n2 = 0;
        while (n2 < n) {
            char c = string2.charAt(n2);
            int n3 = Character.digit(c, 10);
            if (n3 != -1) {
                stringBuilder.append(n3);
            } else if (n2 == 0 && c == '+') {
                stringBuilder.append(c);
            } else if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z') {
                return PhoneNumberUtils.normalizeNumber(PhoneNumberUtils.convertKeypadLettersToDigits(string2));
            }
            ++n2;
        }
        return stringBuilder.toString();
    }

    public static byte[] numberToCalledPartyBCD(String string2) {
        return PhoneNumberUtils.numberToCalledPartyBCDHelper(string2, false);
    }

    /*
     * Enabled aggressive block sorting
     */
    private static byte[] numberToCalledPartyBCDHelper(String string2, boolean bl) {
        int n;
        int n2 = n = string2.length();
        boolean bl2 = string2.indexOf(43) != -1;
        if (bl2) {
            --n2;
        }
        if (n2 == 0) {
            return null;
        }
        int n3 = (n2 + 1) / 2;
        int n4 = 1;
        if (bl) {
            ++n4;
        }
        int n5 = n3 + n4;
        byte[] byArray = new byte[n5];
        int n6 = 0;
        for (int i = 0; i < n; ++i) {
            char c = string2.charAt(i);
            if (c == '+') continue;
            int n7 = (n6 & 1) == 1 ? 4 : 0;
            int n8 = n4 + (n6 >> 1);
            byArray[n8] = (byte)(byArray[n8] | (byte)((0xF & PhoneNumberUtils.charToBCD(c)) << n7));
            ++n6;
        }
        if (n6 & true) {
            int n9 = n4 + (n6 >> 1);
            byArray[n9] = (byte)(0xF0 | byArray[n9]);
        }
        int n10 = 0;
        if (bl) {
            int n11 = 0 + 1;
            byArray[0] = (byte)(n5 - 1);
            n10 = n11;
        }
        int n12 = bl2 ? 145 : 129;
        byArray[n10] = (byte)n12;
        return byArray;
    }

    private static String processPlusCode(String string2, boolean bl) {
        block3: {
            String string3;
            block2: {
                string3 = string2;
                if (string2 == null || string2.charAt(0) != '+' || string2.length() <= 1) break block2;
                String string4 = string2.substring(1);
                if (!bl || !PhoneNumberUtils.isOneNanp(string4)) break block3;
                string3 = string4;
            }
            return string3;
        }
        return string2.replaceFirst("[+]", PhoneNumberUtils.getCurrentIdp(bl));
    }

    private static void removeDashes(Editable editable) {
        int n = 0;
        while (n < editable.length()) {
            if (editable.charAt(n) == '-') {
                editable.delete(n, n + 1);
                continue;
            }
            ++n;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public static String replaceUnicodeDigits(String string2) {
        StringBuilder stringBuilder = new StringBuilder(string2.length());
        char[] cArray = string2.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            int n3 = Character.digit(c, 10);
            if (n3 != -1) {
                stringBuilder.append(n3);
            } else {
                stringBuilder.append(c);
            }
            ++n2;
        }
        return stringBuilder.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String stringFromStringAndTOA(String string2, int n) {
        if (string2 == null) {
            return null;
        }
        if (n != 145) return string2;
        if (string2.length() <= 0) return string2;
        if (string2.charAt(0) == '+') return string2;
        return PLUS_SIGN_STRING + string2;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static String stripSeparators(String string2) {
        if (string2 == null) {
            return null;
        }
        int n = string2.length();
        StringBuilder stringBuilder = new StringBuilder(n);
        int n2 = 0;
        while (n2 < n) {
            char c = string2.charAt(n2);
            int n3 = Character.digit(c, 10);
            if (n3 != -1) {
                stringBuilder.append(n3);
            } else if (PhoneNumberUtils.isNonSeparator(c)) {
                stringBuilder.append(c);
            }
            ++n2;
        }
        return stringBuilder.toString();
    }

    public static String toCallerIDMinMatch(String string2) {
        return PhoneNumberUtils.internalGetStrippedReversed(PhoneNumberUtils.extractNetworkPortionAlt(string2), MIN_MATCH);
    }

    public static int toaFromString(String string2) {
        if (string2 != null && string2.length() > 0 && string2.charAt(0) == '+') {
            return 145;
        }
        return 129;
    }

    /*
     * Unable to fully structure code
     */
    private static CountryCallingCodeAndNewIndex tryGetCountryCallingCodeAndNewIndex(String var0, boolean var1_1) {
        var2_2 = 0;
        var3_3 = 0;
        var4_4 = var0.length();
        var5_5 = 0;
        block8: while (true) {
            if (var5_5 >= var4_4) ** GOTO lbl-1000
            var6_6 = var0.charAt(var5_5);
            switch (var2_2) lbl-1000:
            // 2 sources

            {
                default: lbl-1000:
                // 3 sources

                {
                    return null;
                }
                case 0: {
                    if (var6_6 == '+') {
                        var2_2 = 1;
lbl15:
                        // 14 sources

                        while (true) {
                            ++var5_5;
                            continue block8;
                            break;
                        }
                    }
                    if (var6_6 != '0') ** GOTO lbl21
                    var2_2 = 2;
                    ** GOTO lbl15
lbl21:
                    // 1 sources

                    if (var6_6 != '1') ** GOTO lbl25
                    if (!var1_1) ** GOTO lbl-1000
                    var2_2 = 8;
                    ** GOTO lbl15
lbl25:
                    // 1 sources

                    if (!PhoneNumberUtils.isDialable(var6_6)) ** GOTO lbl15
                    return null;
                }
                case 2: {
                    if (var6_6 != '0') ** GOTO lbl31
                    var2_2 = 3;
                    ** GOTO lbl15
lbl31:
                    // 1 sources

                    if (var6_6 != '1') ** GOTO lbl34
                    var2_2 = 4;
                    ** GOTO lbl15
lbl34:
                    // 1 sources

                    if (!PhoneNumberUtils.isDialable(var6_6)) ** GOTO lbl15
                    return null;
                }
                case 4: {
                    if (var6_6 != '1') ** GOTO lbl40
                    var2_2 = 5;
                    ** GOTO lbl15
lbl40:
                    // 1 sources

                    if (!PhoneNumberUtils.isDialable(var6_6)) ** GOTO lbl15
                    return null;
                }
                case 1: 
                case 3: 
                case 5: 
                case 6: 
                case 7: {
                    var7_7 = PhoneNumberUtils.tryGetISODigit(var6_6);
                    if (var7_7 <= 0) ** GOTO lbl52
                    if ((var3_3 = var7_7 + var3_3 * 10) >= 100 || PhoneNumberUtils.isCountryCallingCode(var3_3)) {
                        return new CountryCallingCodeAndNewIndex(var3_3, var5_5 + 1);
                    }
                    if (var2_2 != 1 && var2_2 != 3 && var2_2 != 5) ** GOTO lbl50
                    var2_2 = 6;
                    ** GOTO lbl15
lbl50:
                    // 1 sources

                    ++var2_2;
                    ** GOTO lbl15
lbl52:
                    // 1 sources

                    if (!PhoneNumberUtils.isDialable(var6_6)) ** GOTO lbl15
                    return null;
                }
                case 8: {
                    if (var6_6 != '6') ** GOTO lbl58
                    var2_2 = 9;
                    ** GOTO lbl15
lbl58:
                    // 1 sources

                    if (PhoneNumberUtils.isDialable(var6_6)) ** break;
                    ** continue;
                    return null;
                }
                case 9: 
            }
            break;
        }
        ** while (var6_6 != '6')
lbl63:
        // 1 sources

        return new CountryCallingCodeAndNewIndex(66, var5_5 + 1);
    }

    private static int tryGetISODigit(char c) {
        if ('0' <= c && c <= '9') {
            return c - 48;
        }
        return -1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static int tryGetTrunkPrefixOmittedIndex(String string2, int n) {
        int n2 = -1;
        int n3 = string2.length();
        int n4 = n;
        while (n4 < n3) {
            char c = string2.charAt(n4);
            if (PhoneNumberUtils.tryGetISODigit(c) >= 0) {
                return n4 + 1;
            }
            if (PhoneNumberUtils.isDialable(c)) return n2;
            ++n4;
        }
        return n2;
    }

    private static class CountryCallingCodeAndNewIndex {
        public final int countryCallingCode;
        public final int newIndex;

        public CountryCallingCodeAndNewIndex(int n, int n2) {
            this.countryCallingCode = n;
            this.newIndex = n2;
        }
    }
}

