/*
 * Decompiled with CFR 0.152.
 */
package android.text;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.text.Editable;
import android.text.GetChars;
import android.text.GraphicsOperations;
import android.text.InputFilter;
import android.text.NoCopySpan;
import android.text.Selection;
import android.text.SpanWatcher;
import android.text.Spannable;
import android.text.Spanned;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.util.Log;
import com.android.internal.util.ArrayUtils;
import com.android.internal.util.GrowingArrayUtils;
import java.lang.reflect.Array;
import libcore.util.EmptyArray;

public class SpannableStringBuilder
implements CharSequence,
GetChars,
Spannable,
Editable,
Appendable,
GraphicsOperations {
    private static final int END_MASK = 15;
    private static final int MARK = 1;
    private static final InputFilter[] NO_FILTERS = new InputFilter[0];
    private static final int PARAGRAPH = 3;
    private static final int POINT = 2;
    private static final int SPAN_END_AT_END = 32768;
    private static final int SPAN_END_AT_START = 16384;
    private static final int SPAN_START_AT_END = 8192;
    private static final int SPAN_START_AT_START = 4096;
    private static final int SPAN_START_END_MASK = 61440;
    private static final int START_MASK = 240;
    private static final int START_SHIFT = 4;
    private static final String TAG = "SpannableStringBuilder";
    private InputFilter[] mFilters = NO_FILTERS;
    private int mGapLength;
    private int mGapStart;
    private int mSpanCount;
    private int mSpanCountBeforeAdd;
    private int[] mSpanEnds;
    private int[] mSpanFlags;
    private int[] mSpanStarts;
    private Object[] mSpans;
    private char[] mText;

    public SpannableStringBuilder() {
        this("");
    }

    public SpannableStringBuilder(CharSequence charSequence) {
        this(charSequence, 0, charSequence.length());
    }

    /*
     * Enabled aggressive block sorting
     */
    public SpannableStringBuilder(CharSequence charSequence, int n, int n2) {
        int n3 = n2 - n;
        if (n3 < 0) {
            throw new StringIndexOutOfBoundsException();
        }
        this.mText = ArrayUtils.newUnpaddedCharArray(GrowingArrayUtils.growSize(n3));
        this.mGapStart = n3;
        this.mGapLength = this.mText.length - n3;
        TextUtils.getChars(charSequence, n, n2, this.mText, 0);
        this.mSpanCount = 0;
        this.mSpans = EmptyArray.OBJECT;
        this.mSpanStarts = EmptyArray.INT;
        this.mSpanEnds = EmptyArray.INT;
        this.mSpanFlags = EmptyArray.INT;
        if (charSequence instanceof Spanned) {
            Spanned spanned = (Spanned)charSequence;
            Object[] objectArray = spanned.getSpans(n, n2, Object.class);
            for (int i = 0; i < objectArray.length; ++i) {
                if (objectArray[i] instanceof NoCopySpan) continue;
                int n4 = spanned.getSpanStart(objectArray[i]) - n;
                int n5 = spanned.getSpanEnd(objectArray[i]) - n;
                int n6 = spanned.getSpanFlags(objectArray[i]);
                if (n4 < 0) {
                    n4 = 0;
                }
                if (n4 > n2 - n) {
                    n4 = n2 - n;
                }
                if (n5 < 0) {
                    n5 = 0;
                }
                if (n5 > n2 - n) {
                    n5 = n2 - n;
                }
                this.setSpan(false, objectArray[i], n4, n5, n6);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void change(int n, int n2, CharSequence charSequence, int n3, int n4) {
        boolean bl;
        int n5;
        int n6;
        block24: {
            int n7;
            int n8;
            n6 = n2 - n;
            int n9 = n4 - n3;
            n5 = n9 - n6;
            int n10 = -1 + this.mSpanCount;
            while (true) {
                int n11;
                int n12;
                int n13;
                block26: {
                    int n14;
                    int n15;
                    int n16;
                    block27: {
                        block28: {
                            block25: {
                                if (n10 < 0) break block25;
                                n13 = this.mSpanStarts[n10];
                                if (n13 > this.mGapStart) {
                                    n13 -= this.mGapLength;
                                }
                                if ((n12 = this.mSpanEnds[n10]) > this.mGapStart) {
                                    n12 -= this.mGapLength;
                                }
                                if ((0x33 & this.mSpanFlags[n10]) != 51) break block26;
                                n16 = n13;
                                n15 = n12;
                                n14 = this.length();
                                if (n13 <= n || n13 > n2) break block27;
                                break block28;
                            }
                            this.moveGapTo(n2);
                            if (n5 >= this.mGapLength) {
                                this.resizeFor(n5 + this.mText.length - this.mGapLength);
                            }
                            bl = n9 == 0;
                            if (n6 > 0) {
                                n8 = 0;
                                break;
                            }
                            break block24;
                        }
                        for (n13 = n2; n13 < n14 && (n13 <= n2 || this.charAt(n13 - 1) != '\n'); ++n13) {
                        }
                    }
                    if (n12 > n && n12 <= n2) {
                        for (n12 = n2; n12 < n14 && (n12 <= n2 || this.charAt(n12 - 1) != '\n'); ++n12) {
                        }
                    }
                    if (n13 != n16 || n12 != n15) {
                        this.setSpan(false, this.mSpans[n10], n13, n12, this.mSpanFlags[n10]);
                    }
                }
                if (n13 == n) {
                    n11 = 0 | 0x1000;
                } else {
                    int n17 = n2 + n5;
                    n11 = 0;
                    if (n13 == n17) {
                        n11 = 0 | 0x2000;
                    }
                }
                if (n12 == n) {
                    n11 = 0x4000 | n11;
                } else if (n12 == n2 + n5) {
                    n11 |= 0x8000;
                }
                int[] nArray = this.mSpanFlags;
                nArray[n10] = n11 | nArray[n10];
                --n10;
            }
            while (n8 < (n7 = this.mSpanCount)) {
                if ((0x21 & this.mSpanFlags[n8]) == 33 && this.mSpanStarts[n8] >= n && this.mSpanStarts[n8] < this.mGapStart + this.mGapLength && this.mSpanEnds[n8] >= n && this.mSpanEnds[n8] < this.mGapStart + this.mGapLength && (bl || this.mSpanStarts[n8] > n || this.mSpanEnds[n8] < this.mGapStart)) {
                    this.removeSpan(n8);
                    continue;
                }
                ++n8;
            }
        }
        this.mGapStart = n5 + this.mGapStart;
        this.mGapLength -= n5;
        if (this.mGapLength < 1) {
            new Exception("mGapLength < 1").printStackTrace();
        }
        TextUtils.getChars(charSequence, n3, n4, this.mText, n);
        if (n6 > 0) {
            int n18;
            boolean bl2 = this.mGapStart + this.mGapLength == this.mText.length;
            for (int i = 0; i < (n18 = this.mSpanCount); ++i) {
                int n19 = (0xF0 & this.mSpanFlags[i]) >> 4;
                this.mSpanStarts[i] = this.updatedIntervalBound(this.mSpanStarts[i], n, n5, n19, bl2, bl);
                int n20 = 0xF & this.mSpanFlags[i];
                this.mSpanEnds[i] = this.updatedIntervalBound(this.mSpanEnds[i], n, n5, n20, bl2, bl);
            }
        }
        this.mSpanCountBeforeAdd = this.mSpanCount;
        if (charSequence instanceof Spanned) {
            int n21;
            Spanned spanned = (Spanned)charSequence;
            Object[] objectArray = spanned.getSpans(n3, n4, Object.class);
            for (int i = 0; i < (n21 = objectArray.length); ++i) {
                int n22 = spanned.getSpanStart(objectArray[i]);
                int n23 = spanned.getSpanEnd(objectArray[i]);
                if (n22 < n3) {
                    n22 = n3;
                }
                if (n23 > n4) {
                    n23 = n4;
                }
                if (this.getSpanStart(objectArray[i]) >= 0) continue;
                this.setSpan(false, objectArray[i], n + (n22 - n3), n + (n23 - n3), spanned.getSpanFlags(objectArray[i]));
            }
        }
    }

    private void checkRange(String string2, int n, int n2) {
        if (n2 < n) {
            throw new IndexOutOfBoundsException(string2 + " " + SpannableStringBuilder.region(n, n2) + " has end before start");
        }
        int n3 = this.length();
        if (n > n3 || n2 > n3) {
            throw new IndexOutOfBoundsException(string2 + " " + SpannableStringBuilder.region(n, n2) + " ends beyond length " + n3);
        }
        if (n < 0 || n2 < 0) {
            throw new IndexOutOfBoundsException(string2 + " " + SpannableStringBuilder.region(n, n2) + " starts before 0");
        }
    }

    private static boolean hasNonExclusiveExclusiveSpanAt(CharSequence charSequence, int n) {
        if (charSequence instanceof Spanned) {
            Spanned spanned = (Spanned)charSequence;
            Object[] objectArray = spanned.getSpans(n, n, Object.class);
            int n2 = objectArray.length;
            for (int i = 0; i < n2; ++i) {
                if (spanned.getSpanFlags(objectArray[i]) == 33) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void moveGapTo(int n) {
        if (n == this.mGapStart) {
            return;
        }
        boolean bl = n == this.length();
        if (n < this.mGapStart) {
            int n2 = this.mGapStart - n;
            System.arraycopy((char[])this.mText, (int)n, (char[])this.mText, (int)(this.mGapStart + this.mGapLength - n2), (int)n2);
        } else {
            int n3 = n - this.mGapStart;
            System.arraycopy((char[])this.mText, (int)(n + this.mGapLength - n3), (char[])this.mText, (int)this.mGapStart, (int)n3);
        }
        int n4 = 0;
        while (true) {
            int n5;
            int n6;
            if (n4 >= this.mSpanCount) {
                this.mGapStart = n;
                return;
            }
            int n7 = this.mSpanStarts[n4];
            int n8 = this.mSpanEnds[n4];
            if (n7 > this.mGapStart) {
                n7 -= this.mGapLength;
            }
            if (n7 > n) {
                n7 += this.mGapLength;
            } else if (n7 == n && ((n6 = (0xF0 & this.mSpanFlags[n4]) >> 4) == 2 || bl && n6 == 3)) {
                n7 += this.mGapLength;
            }
            if (n8 > this.mGapStart) {
                n8 -= this.mGapLength;
            }
            if (n8 > n) {
                n8 += this.mGapLength;
            } else if (n8 == n && ((n5 = 0xF & this.mSpanFlags[n4]) == 2 || bl && n5 == 3)) {
                n8 += this.mGapLength;
            }
            this.mSpanStarts[n4] = n7;
            this.mSpanEnds[n4] = n8;
            ++n4;
        }
    }

    private static String region(int n, int n2) {
        return "(" + n + " ... " + n2 + ")";
    }

    private void removeSpan(int n) {
        Object object = this.mSpans[n];
        int n2 = this.mSpanStarts[n];
        int n3 = this.mSpanEnds[n];
        if (n2 > this.mGapStart) {
            n2 -= this.mGapLength;
        }
        if (n3 > this.mGapStart) {
            n3 -= this.mGapLength;
        }
        int n4 = this.mSpanCount - (n + 1);
        System.arraycopy(this.mSpans, n + 1, this.mSpans, n, n4);
        System.arraycopy((int[])this.mSpanStarts, (int)(n + 1), (int[])this.mSpanStarts, (int)n, (int)n4);
        System.arraycopy((int[])this.mSpanEnds, (int)(n + 1), (int[])this.mSpanEnds, (int)n, (int)n4);
        System.arraycopy((int[])this.mSpanFlags, (int)(n + 1), (int[])this.mSpanFlags, (int)n, (int)n4);
        this.mSpanCount = -1 + this.mSpanCount;
        this.mSpans[this.mSpanCount] = null;
        this.sendSpanRemoved(object, n2, n3);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void resizeFor(int n) {
        int n2 = this.mText.length;
        if (n + 1 > n2) {
            char[] cArray = ArrayUtils.newUnpaddedCharArray(GrowingArrayUtils.growSize(n));
            System.arraycopy((char[])this.mText, (int)0, (char[])cArray, (int)0, (int)this.mGapStart);
            int n3 = cArray.length;
            int n4 = n3 - n2;
            int n5 = n2 - (this.mGapStart + this.mGapLength);
            System.arraycopy((char[])this.mText, (int)(n2 - n5), (char[])cArray, (int)(n3 - n5), (int)n5);
            this.mText = cArray;
            this.mGapLength = n4 + this.mGapLength;
            if (this.mGapLength < 1) {
                new Exception("mGapLength < 1").printStackTrace();
            }
            for (int i = 0; i < this.mSpanCount; ++i) {
                if (this.mSpanStarts[i] > this.mGapStart) {
                    int[] nArray = this.mSpanStarts;
                    nArray[i] = n4 + nArray[i];
                }
                if (this.mSpanEnds[i] <= this.mGapStart) continue;
                int[] nArray = this.mSpanEnds;
                nArray[i] = n4 + nArray[i];
            }
        }
    }

    private void sendAfterTextChanged(TextWatcher[] textWatcherArray) {
        int n = textWatcherArray.length;
        for (int i = 0; i < n; ++i) {
            textWatcherArray[i].afterTextChanged(this);
        }
    }

    private void sendBeforeTextChanged(TextWatcher[] textWatcherArray, int n, int n2, int n3) {
        int n4 = textWatcherArray.length;
        for (int i = 0; i < n4; ++i) {
            textWatcherArray[i].beforeTextChanged(this, n, n2, n3);
        }
    }

    private void sendSpanAdded(Object object, int n, int n2) {
        SpanWatcher[] spanWatcherArray = this.getSpans(n, n2, SpanWatcher.class);
        int n3 = spanWatcherArray.length;
        for (int i = 0; i < n3; ++i) {
            spanWatcherArray[i].onSpanAdded(this, object, n, n2);
        }
    }

    private void sendSpanChanged(Object object, int n, int n2, int n3, int n4) {
        SpanWatcher[] spanWatcherArray = this.getSpans(Math.min(n, n3), Math.min(Math.max(n2, n4), this.length()), SpanWatcher.class);
        int n5 = spanWatcherArray.length;
        for (int i = 0; i < n5; ++i) {
            spanWatcherArray[i].onSpanChanged(this, object, n, n2, n3, n4);
        }
    }

    private void sendSpanRemoved(Object object, int n, int n2) {
        SpanWatcher[] spanWatcherArray = this.getSpans(n, n2, SpanWatcher.class);
        int n3 = spanWatcherArray.length;
        for (int i = 0; i < n3; ++i) {
            spanWatcherArray[i].onSpanRemoved(this, object, n, n2);
        }
    }

    private void sendTextChanged(TextWatcher[] textWatcherArray, int n, int n2, int n3) {
        int n4 = textWatcherArray.length;
        for (int i = 0; i < n4; ++i) {
            textWatcherArray[i].onTextChanged(this, n, n2, n3);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void sendToSpanWatchers(int n, int n2, int n3) {
        for (int i = 0; i < this.mSpanCountBeforeAdd; ++i) {
            boolean bl;
            int n4;
            int n5;
            int n6;
            int n7;
            int n8;
            block19: {
                block21: {
                    block20: {
                        block18: {
                            n8 = this.mSpanStarts[i];
                            n7 = this.mSpanEnds[i];
                            if (n8 > this.mGapStart) {
                                n8 -= this.mGapLength;
                            }
                            if (n7 > this.mGapStart) {
                                n7 -= this.mGapLength;
                            }
                            n6 = this.mSpanFlags[i];
                            n5 = n2 + n3;
                            n4 = n8;
                            if (n8 <= n5) break block18;
                            bl = false;
                            if (n3 != 0) {
                                n4 -= n3;
                                bl = true;
                            }
                            break block19;
                        }
                        bl = false;
                        if (n8 < n) break block19;
                        if (n8 != n) break block20;
                        int n9 = n6 & 0x1000;
                        bl = false;
                        if (n9 == 4096) break block19;
                    }
                    if (n8 != n5) break block21;
                    int n10 = n6 & 0x2000;
                    bl = false;
                    if (n10 == 8192) break block19;
                }
                bl = true;
            }
            int n11 = n7;
            if (n7 > n5) {
                if (n3 != 0) {
                    n11 -= n3;
                    bl = true;
                }
            } else if (!(n7 < n || n7 == n && (n6 & 0x4000) == 16384 || n7 == n5 && (n6 & 0x8000) == 32768)) {
                bl = true;
            }
            if (bl) {
                this.sendSpanChanged(this.mSpans[i], n4, n11, n8, n7);
            }
            int[] nArray = this.mSpanFlags;
            nArray[i] = 0xFFFF0FFF & nArray[i];
        }
        int n12 = this.mSpanCountBeforeAdd;
        while (n12 < this.mSpanCount) {
            int n13 = this.mSpanStarts[n12];
            int n14 = this.mSpanEnds[n12];
            if (n13 > this.mGapStart) {
                n13 -= this.mGapLength;
            }
            if (n14 > this.mGapStart) {
                n14 -= this.mGapLength;
            }
            this.sendSpanAdded(this.mSpans[n12], n13, n14);
            ++n12;
        }
        return;
    }

    /*
     * Enabled aggressive block sorting
     * Lifted jumps to return sites
     */
    private void setSpan(boolean bl, Object object, int n, int n2, int n3) {
        int n4;
        int n5;
        int n6;
        this.checkRange("setSpan", n, n2);
        int n7 = (n3 & 0xF0) >> 4;
        if (n7 == 3 && n != 0 && n != (n6 = this.length()) && this.charAt(n - 1) != '\n') {
            throw new RuntimeException("PARAGRAPH span must start at paragraph boundary");
        }
        int n8 = n3 & 0xF;
        if (n8 == 3 && n2 != 0 && n2 != (n5 = this.length()) && this.charAt(n2 - 1) != '\n') {
            throw new RuntimeException("PARAGRAPH span must end at paragraph boundary");
        }
        if (n7 == 2 && n8 == 1 && n == n2) {
            if (!bl) return;
            Log.e(TAG, "SPAN_EXCLUSIVE_EXCLUSIVE spans cannot have a zero length");
            return;
        }
        int n9 = n;
        int n10 = n2;
        int n11 = this.mGapStart;
        if (n > n11) {
            n += this.mGapLength;
        } else {
            int n12;
            int n13 = this.mGapStart;
            if (n == n13 && (n7 == 2 || n7 == 3 && n == (n12 = this.length()))) {
                n += this.mGapLength;
            }
        }
        if (n2 > (n4 = this.mGapStart)) {
            n2 += this.mGapLength;
        } else {
            int n14;
            int n15 = this.mGapStart;
            if (n2 == n15 && (n8 == 2 || n8 == 3 && n2 == (n14 = this.length()))) {
                n2 += this.mGapLength;
            }
        }
        int n16 = this.mSpanCount;
        Object[] objectArray = this.mSpans;
        int n17 = 0;
        while (true) {
            if (n17 >= n16) {
                this.mSpans = GrowingArrayUtils.append(this.mSpans, this.mSpanCount, object);
                this.mSpanStarts = GrowingArrayUtils.append(this.mSpanStarts, this.mSpanCount, n);
                this.mSpanEnds = GrowingArrayUtils.append(this.mSpanEnds, this.mSpanCount, n2);
                this.mSpanFlags = GrowingArrayUtils.append(this.mSpanFlags, this.mSpanCount, n3);
                this.mSpanCount = 1 + this.mSpanCount;
                if (!bl) return;
                this.sendSpanAdded(object, n9, n10);
                return;
            }
            if (objectArray[n17] == object) {
                int n18 = this.mSpanStarts[n17];
                int n19 = this.mSpanEnds[n17];
                if (n18 > this.mGapStart) {
                    n18 -= this.mGapLength;
                }
                if (n19 > this.mGapStart) {
                    n19 -= this.mGapLength;
                }
                this.mSpanStarts[n17] = n;
                this.mSpanEnds[n17] = n2;
                this.mSpanFlags[n17] = n3;
                if (!bl) return;
                this.sendSpanChanged(object, n18, n19, n9, n10);
                return;
            }
            ++n17;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int updatedIntervalBound(int n, int n2, int n3, int n4, boolean bl, boolean bl2) {
        if (n < n2) return n;
        if (n >= this.mGapStart + this.mGapLength) return n;
        if (n4 == 2) {
            if (bl2) return this.mGapStart + this.mGapLength;
            if (n <= n2) return n;
            return this.mGapStart + this.mGapLength;
        }
        if (n4 == 3) {
            if (!bl) return n;
            return this.mGapStart + this.mGapLength;
        }
        if (bl2) return n2;
        if (n < this.mGapStart - n3) return n2;
        return this.mGapStart;
    }

    public static SpannableStringBuilder valueOf(CharSequence charSequence) {
        if (charSequence instanceof SpannableStringBuilder) {
            return (SpannableStringBuilder)charSequence;
        }
        return new SpannableStringBuilder(charSequence);
    }

    @Override
    public SpannableStringBuilder append(char c) {
        return this.append(String.valueOf(c));
    }

    @Override
    public SpannableStringBuilder append(CharSequence charSequence) {
        int n = this.length();
        return this.replace(n, n, charSequence, 0, charSequence.length());
    }

    @Override
    public SpannableStringBuilder append(CharSequence charSequence, int n, int n2) {
        int n3 = this.length();
        return this.replace(n3, n3, charSequence, n, n2);
    }

    public SpannableStringBuilder append(CharSequence charSequence, Object object, int n) {
        int n2 = this.length();
        this.append(charSequence);
        this.setSpan(object, n2, this.length(), n);
        return this;
    }

    @Override
    public char charAt(int n) {
        int n2 = this.length();
        if (n < 0) {
            throw new IndexOutOfBoundsException("charAt: " + n + " < 0");
        }
        if (n >= n2) {
            throw new IndexOutOfBoundsException("charAt: " + n + " >= length " + n2);
        }
        if (n >= this.mGapStart) {
            return this.mText[n + this.mGapLength];
        }
        return this.mText[n];
    }

    @Override
    public void clear() {
        this.replace(0, this.length(), "", 0, 0);
    }

    @Override
    public void clearSpans() {
        for (int i = -1 + this.mSpanCount; i >= 0; --i) {
            Object object = this.mSpans[i];
            int n = this.mSpanStarts[i];
            int n2 = this.mSpanEnds[i];
            if (n > this.mGapStart) {
                n -= this.mGapLength;
            }
            if (n2 > this.mGapStart) {
                n2 -= this.mGapLength;
            }
            this.mSpanCount = i;
            this.mSpans[i] = null;
            this.sendSpanRemoved(object, n, n2);
        }
    }

    @Override
    public SpannableStringBuilder delete(int n, int n2) {
        Editable editable = this.replace(n, n2, "", 0, 0);
        if (this.mGapLength > 2 * this.length()) {
            this.resizeFor(this.length());
        }
        return editable;
    }

    @Override
    public void drawText(Canvas canvas, int n, int n2, float f, float f2, Paint paint) {
        this.checkRange("drawText", n, n2);
        if (n2 <= this.mGapStart) {
            canvas.drawText(this.mText, n, n2 - n, f, f2, paint);
            return;
        }
        if (n >= this.mGapStart) {
            canvas.drawText(this.mText, n + this.mGapLength, n2 - n, f, f2, paint);
            return;
        }
        char[] cArray = TextUtils.obtain(n2 - n);
        this.getChars(n, n2, cArray, 0);
        canvas.drawText(cArray, 0, n2 - n, f, f2, paint);
        TextUtils.recycle(cArray);
    }

    @Override
    public void drawTextRun(Canvas canvas, int n, int n2, int n3, int n4, float f, float f2, boolean bl, Paint paint) {
        this.checkRange("drawTextRun", n, n2);
        int n5 = n4 - n3;
        int n6 = n2 - n;
        if (n4 <= this.mGapStart) {
            canvas.drawTextRun(this.mText, n, n6, n3, n5, f, f2, bl, paint);
            return;
        }
        if (n3 >= this.mGapStart) {
            canvas.drawTextRun(this.mText, n + this.mGapLength, n6, n3 + this.mGapLength, n5, f, f2, bl, paint);
            return;
        }
        char[] cArray = TextUtils.obtain(n5);
        this.getChars(n3, n4, cArray, 0);
        canvas.drawTextRun(cArray, n - n3, n6, 0, n5, f, f2, bl, paint);
        TextUtils.recycle(cArray);
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean equals(Object object) {
        Spanned spanned;
        Object[] objectArray;
        if (object instanceof Spanned && this.toString().equals(object.toString()) && this.mSpanCount == (objectArray = (spanned = (Spanned)object).getSpans(0, spanned.length(), Object.class)).length) {
            int n = 0;
            while (true) {
                if (n >= this.mSpanCount) {
                    return true;
                }
                Object object2 = this.mSpans[n];
                Object object3 = objectArray[n];
                if (object2 != this ? !object2.equals(object3) || this.getSpanStart(object2) != spanned.getSpanStart(object3) || this.getSpanEnd(object2) != spanned.getSpanEnd(object3) || this.getSpanFlags(object2) != spanned.getSpanFlags(object3) : spanned != object3 || this.getSpanStart(object2) != spanned.getSpanStart(object3) || this.getSpanEnd(object2) != spanned.getSpanEnd(object3) || this.getSpanFlags(object2) != spanned.getSpanFlags(object3)) break;
                ++n;
            }
        }
        return false;
    }

    @Override
    public void getChars(int n, int n2, char[] cArray, int n3) {
        this.checkRange("getChars", n, n2);
        if (n2 <= this.mGapStart) {
            System.arraycopy((char[])this.mText, (int)n, (char[])cArray, (int)n3, (int)(n2 - n));
            return;
        }
        if (n >= this.mGapStart) {
            System.arraycopy((char[])this.mText, (int)(n + this.mGapLength), (char[])cArray, (int)n3, (int)(n2 - n));
            return;
        }
        System.arraycopy((char[])this.mText, (int)n, (char[])cArray, (int)n3, (int)(this.mGapStart - n));
        System.arraycopy((char[])this.mText, (int)(this.mGapStart + this.mGapLength), (char[])cArray, (int)(n3 + (this.mGapStart - n)), (int)(n2 - this.mGapStart));
    }

    @Override
    public InputFilter[] getFilters() {
        return this.mFilters;
    }

    @Override
    public int getSpanEnd(Object object) {
        int n = this.mSpanCount;
        Object[] objectArray = this.mSpans;
        for (int i = n - 1; i >= 0; --i) {
            if (objectArray[i] != object) continue;
            int n2 = this.mSpanEnds[i];
            if (n2 > this.mGapStart) {
                n2 -= this.mGapLength;
            }
            return n2;
        }
        return -1;
    }

    @Override
    public int getSpanFlags(Object object) {
        int n = this.mSpanCount;
        Object[] objectArray = this.mSpans;
        for (int i = n - 1; i >= 0; --i) {
            if (objectArray[i] != object) continue;
            return this.mSpanFlags[i];
        }
        return 0;
    }

    @Override
    public int getSpanStart(Object object) {
        int n = this.mSpanCount;
        Object[] objectArray = this.mSpans;
        for (int i = n - 1; i >= 0; --i) {
            if (objectArray[i] != object) continue;
            int n2 = this.mSpanStarts[i];
            if (n2 > this.mGapStart) {
                n2 -= this.mGapLength;
            }
            return n2;
        }
        return -1;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @Override
    public <T> T[] getSpans(int var1_1, int var2_2, Class<T> var3_3) {
        if (var3_3 == null) {
            var11_4 /* !! */  = ArrayUtils.emptyArray(var3_3);
lbl3:
            // 2 sources

            return var11_4 /* !! */ ;
        }
        var4_5 = this.mSpanCount;
        var5_6 = this.mSpans;
        var6_7 = this.mSpanStarts;
        var7_8 = this.mSpanEnds;
        var8_9 = this.mSpanFlags;
        var9_10 = this.mGapStart;
        var10_11 = this.mGapLength;
        var11_4 /* !! */  = null;
        var12_12 = null;
        var14_14 = 0;
        block1: for (var13_13 = 0; var13_13 < var4_5; ++var13_13) {
            block16: {
                block15: {
                    block14: {
                        block12: {
                            block13: {
                                block11: {
                                    var17_15 = var6_7[var13_13];
                                    if (var17_15 > var9_10) {
                                        var17_15 -= var10_11;
                                    }
                                    if (var17_15 > var2_2) {
                                        var20_18 = var14_14;
lbl21:
                                        // 8 sources

                                        while (true) {
                                            var14_14 = var20_18;
                                            continue block1;
                                            break;
                                        }
                                    }
                                    var18_16 = var7_8[var13_13];
                                    if (var18_16 > var9_10) {
                                        var18_16 -= var10_11;
                                    }
                                    if (var18_16 >= var1_1) break block11;
                                    var20_18 = var14_14;
                                    ** GOTO lbl21
                                }
                                if (var17_15 == var18_16 || var1_1 == var2_2) break block12;
                                if (var17_15 != var2_2) break block13;
                                var20_18 = var14_14;
                                ** GOTO lbl21
                            }
                            if (var18_16 != var1_1) break block12;
                            var20_18 = var14_14;
                            ** GOTO lbl21
                        }
                        if (var3_3.isInstance(var5_6[var13_13])) break block14;
                        var20_18 = var14_14;
                        ** GOTO lbl21
                    }
                    if (var14_14 != 0) break block15;
                    var12_12 = var5_6[var13_13];
                    var20_18 = var14_14 + 1;
                    ** GOTO lbl21
                }
                if (var14_14 == 1) {
                    var11_4 /* !! */  = (Object[])Array.newInstance(var3_3, 1 + (var4_5 - var13_13));
                    var11_4 /* !! */ [0] = var12_12;
                }
                if ((var19_17 = 0xFF0000 & var8_9[var13_13]) == 0) break block16;
                var21_19 = 0;
                while (true) {
                    block17: {
                        if (var21_19 < var14_14 && var19_17 <= (0xFF0000 & this.getSpanFlags(var11_4 /* !! */ [var21_19]))) break block17;
                        System.arraycopy(var11_4 /* !! */ , var21_19, var11_4 /* !! */ , var21_19 + 1, var14_14 - var21_19);
                        var11_4 /* !! */ [var21_19] = var5_6[var13_13];
                        var20_18 = var14_14 + 1;
                        ** GOTO lbl21
                    }
                    ++var21_19;
                }
            }
            var20_18 = var14_14 + 1;
            var11_4 /* !! */ [var14_14] = var5_6[var13_13];
            ** continue;
        }
        if (var14_14 == 0) {
            return ArrayUtils.emptyArray(var3_3);
        }
        if (var14_14 == 1) {
            var16_20 = (Object[])Array.newInstance(var3_3, 1);
            var16_20[0] = var12_12;
            return var16_20;
        }
        ** while (var14_14 == var11_4 /* !! */ .length)
lbl74:
        // 1 sources

        var15_21 = (Object[])Array.newInstance(var3_3, var14_14);
        System.arraycopy(var11_4 /* !! */ , 0, var15_21, 0, var14_14);
        return var15_21;
    }

    @Override
    public float getTextRunAdvances(int n, int n2, int n3, int n4, boolean bl, float[] fArray, int n5, Paint paint) {
        int n6 = n4 - n3;
        int n7 = n2 - n;
        if (n2 <= this.mGapStart) {
            return paint.getTextRunAdvances(this.mText, n, n7, n3, n6, bl, fArray, n5);
        }
        if (n >= this.mGapStart) {
            return paint.getTextRunAdvances(this.mText, n + this.mGapLength, n7, n3 + this.mGapLength, n6, bl, fArray, n5);
        }
        char[] cArray = TextUtils.obtain(n6);
        this.getChars(n3, n4, cArray, 0);
        float f = paint.getTextRunAdvances(cArray, n - n3, n7, 0, n6, bl, fArray, n5);
        TextUtils.recycle(cArray);
        return f;
    }

    @Override
    @Deprecated
    public int getTextRunCursor(int n, int n2, int n3, int n4, int n5, Paint paint) {
        int n6 = n2 - n;
        if (n2 <= this.mGapStart) {
            return paint.getTextRunCursor(this.mText, n, n6, n3, n4, n5);
        }
        if (n >= this.mGapStart) {
            return paint.getTextRunCursor(this.mText, n + this.mGapLength, n6, n3, n4 + this.mGapLength, n5) - this.mGapLength;
        }
        char[] cArray = TextUtils.obtain(n6);
        this.getChars(n, n2, cArray, 0);
        int n7 = n + paint.getTextRunCursor(cArray, 0, n6, n3, n4 - n, n5);
        TextUtils.recycle(cArray);
        return n7;
    }

    @Override
    public int getTextWidths(int n, int n2, float[] fArray, Paint paint) {
        this.checkRange("getTextWidths", n, n2);
        if (n2 <= this.mGapStart) {
            return paint.getTextWidths(this.mText, n, n2 - n, fArray);
        }
        if (n >= this.mGapStart) {
            return paint.getTextWidths(this.mText, n + this.mGapLength, n2 - n, fArray);
        }
        char[] cArray = TextUtils.obtain(n2 - n);
        this.getChars(n, n2, cArray, 0);
        int n3 = paint.getTextWidths(cArray, 0, n2 - n, fArray);
        TextUtils.recycle(cArray);
        return n3;
    }

    public int hashCode() {
        int n = 31 * this.toString().hashCode() + this.mSpanCount;
        for (int i = 0; i < this.mSpanCount; ++i) {
            Object object = this.mSpans[i];
            if (object != this) {
                n = n * 31 + object.hashCode();
            }
            n = 31 * (31 * (n * 31 + this.getSpanStart(object)) + this.getSpanEnd(object)) + this.getSpanFlags(object);
        }
        return n;
    }

    @Override
    public SpannableStringBuilder insert(int n, CharSequence charSequence) {
        return this.replace(n, n, charSequence, 0, charSequence.length());
    }

    @Override
    public SpannableStringBuilder insert(int n, CharSequence charSequence, int n2, int n3) {
        return this.replace(n, n, charSequence, n2, n3);
    }

    @Override
    public int length() {
        return this.mText.length - this.mGapLength;
    }

    @Override
    public float measureText(int n, int n2, Paint paint) {
        this.checkRange("measureText", n, n2);
        if (n2 <= this.mGapStart) {
            return paint.measureText(this.mText, n, n2 - n);
        }
        if (n >= this.mGapStart) {
            return paint.measureText(this.mText, n + this.mGapLength, n2 - n);
        }
        char[] cArray = TextUtils.obtain(n2 - n);
        this.getChars(n, n2, cArray, 0);
        float f = paint.measureText(cArray, 0, n2 - n);
        TextUtils.recycle(cArray);
        return f;
    }

    @Override
    public int nextSpanTransition(int n, int n2, Class clazz) {
        int n3 = this.mSpanCount;
        Object[] objectArray = this.mSpans;
        int[] nArray = this.mSpanStarts;
        int[] nArray2 = this.mSpanEnds;
        int n4 = this.mGapStart;
        int n5 = this.mGapLength;
        if (clazz == null) {
            clazz = Object.class;
        }
        for (int i = 0; i < n3; ++i) {
            int n6 = nArray[i];
            int n7 = nArray2[i];
            if (n6 > n4) {
                n6 -= n5;
            }
            if (n7 > n4) {
                n7 -= n5;
            }
            if (n6 > n && n6 < n2 && clazz.isInstance(objectArray[i])) {
                n2 = n6;
            }
            if (n7 <= n || n7 >= n2 || !clazz.isInstance(objectArray[i])) continue;
            n2 = n7;
        }
        return n2;
    }

    @Override
    public void removeSpan(Object object) {
        int n = -1 + this.mSpanCount;
        while (true) {
            block4: {
                block3: {
                    if (n < 0) break block3;
                    if (this.mSpans[n] != object) break block4;
                    this.removeSpan(n);
                }
                return;
            }
            --n;
        }
    }

    @Override
    public SpannableStringBuilder replace(int n, int n2, CharSequence charSequence) {
        return this.replace(n, n2, charSequence, 0, charSequence.length());
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public SpannableStringBuilder replace(int n, int n2, CharSequence charSequence, int n3, int n4) {
        this.checkRange("replace", n, n2);
        int n5 = this.mFilters.length;
        for (int i = 0; i < n5; ++i) {
            CharSequence charSequence2 = this.mFilters[i].filter(charSequence, n3, n4, this, n, n2);
            if (charSequence2 == null) continue;
            charSequence = charSequence2;
            n3 = 0;
            n4 = charSequence2.length();
        }
        int n6 = n2 - n;
        int n7 = n4 - n3;
        if (n6 == 0 && n7 == 0 && !SpannableStringBuilder.hasNonExclusiveExclusiveSpanAt(charSequence, n3)) {
            return this;
        }
        TextWatcher[] textWatcherArray = this.getSpans(n, n + n6, TextWatcher.class);
        this.sendBeforeTextChanged(textWatcherArray, n, n6, n7);
        boolean bl = n6 != 0 && n7 != 0;
        int n8 = 0;
        int n9 = 0;
        if (bl) {
            n8 = Selection.getSelectionStart(this);
            n9 = Selection.getSelectionEnd(this);
        }
        this.change(n, n2, charSequence, n3, n4);
        if (bl) {
            if (n8 > n && n8 < n2) {
                int n10 = n + n7 * (n8 - n) / n6;
                this.setSpan(false, Selection.SELECTION_START, n10, n10, 34);
            }
            if (n9 > n && n9 < n2) {
                int n11 = n + n7 * (n9 - n) / n6;
                this.setSpan(false, Selection.SELECTION_END, n11, n11, 34);
            }
        }
        this.sendTextChanged(textWatcherArray, n, n6, n7);
        this.sendAfterTextChanged(textWatcherArray);
        this.sendToSpanWatchers(n, n2, n7 - n6);
        return this;
    }

    @Override
    public void setFilters(InputFilter[] inputFilterArray) {
        if (inputFilterArray == null) {
            throw new IllegalArgumentException();
        }
        this.mFilters = inputFilterArray;
    }

    @Override
    public void setSpan(Object object, int n, int n2, int n3) {
        this.setSpan(true, object, n, n2, n3);
    }

    @Override
    public CharSequence subSequence(int n, int n2) {
        return new SpannableStringBuilder(this, n, n2);
    }

    public String substring(int n, int n2) {
        char[] cArray = new char[n2 - n];
        this.getChars(n, n2, cArray, 0);
        return new String(cArray);
    }

    @Override
    public String toString() {
        int n = this.length();
        char[] cArray = new char[n];
        this.getChars(0, n, cArray, 0);
        return new String(cArray);
    }
}

