/*
 * Decompiled with CFR 0.152.
 */
package android.text;

import android.content.res.Resources;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.SystemProperties;
import android.text.AndroidCharacter;
import android.text.Annotation;
import android.text.GetChars;
import android.text.Layout;
import android.text.MeasuredText;
import android.text.ParcelableSpan;
import android.text.Spannable;
import android.text.SpannableString;
import android.text.SpannableStringBuilder;
import android.text.Spanned;
import android.text.SpannedString;
import android.text.TextDirectionHeuristic;
import android.text.TextDirectionHeuristics;
import android.text.TextPaint;
import android.text.style.AbsoluteSizeSpan;
import android.text.style.AlignmentSpan;
import android.text.style.BackgroundColorSpan;
import android.text.style.BulletSpan;
import android.text.style.CharacterStyle;
import android.text.style.EasyEditSpan;
import android.text.style.ForegroundColorSpan;
import android.text.style.LeadingMarginSpan;
import android.text.style.LocaleSpan;
import android.text.style.MetricAffectingSpan;
import android.text.style.QuoteSpan;
import android.text.style.RelativeSizeSpan;
import android.text.style.ReplacementSpan;
import android.text.style.ScaleXSpan;
import android.text.style.SpellCheckSpan;
import android.text.style.StrikethroughSpan;
import android.text.style.StyleSpan;
import android.text.style.SubscriptSpan;
import android.text.style.SuggestionRangeSpan;
import android.text.style.SuggestionSpan;
import android.text.style.SuperscriptSpan;
import android.text.style.TextAppearanceSpan;
import android.text.style.TtsSpan;
import android.text.style.TypefaceSpan;
import android.text.style.URLSpan;
import android.text.style.UnderlineSpan;
import android.util.Log;
import android.util.Printer;
import com.android.internal.util.ArrayUtils;
import java.lang.reflect.Array;
import java.util.Iterator;
import java.util.Locale;
import java.util.regex.Pattern;
import libcore.icu.ICU;

public class TextUtils {
    public static final int ABSOLUTE_SIZE_SPAN = 16;
    public static final int ALIGNMENT_SPAN = 1;
    public static final int ANNOTATION = 18;
    private static String ARAB_SCRIPT_SUBTAG;
    public static final int BACKGROUND_COLOR_SPAN = 12;
    public static final int BULLET_SPAN = 8;
    public static final int CAP_MODE_CHARACTERS = 4096;
    public static final int CAP_MODE_SENTENCES = 16384;
    public static final int CAP_MODE_WORDS = 8192;
    public static final Parcelable.Creator<CharSequence> CHAR_SEQUENCE_CREATOR;
    public static final int EASY_EDIT_SPAN = 22;
    private static String[] EMPTY_STRING_ARRAY;
    private static final char FIRST_RIGHT_TO_LEFT = '\u0590';
    public static final int FIRST_SPAN = 1;
    public static final int FOREGROUND_COLOR_SPAN = 2;
    private static String HEBR_SCRIPT_SUBTAG;
    public static final int LAST_SPAN = 24;
    public static final int LEADING_MARGIN_SPAN = 10;
    public static final int LOCALE_SPAN = 23;
    public static final int QUOTE_SPAN = 9;
    public static final int RELATIVE_SIZE_SPAN = 3;
    public static final int SCALE_X_SPAN = 4;
    public static final int SPELL_CHECK_SPAN = 20;
    public static final int STRIKETHROUGH_SPAN = 5;
    public static final int STYLE_SPAN = 7;
    public static final int SUBSCRIPT_SPAN = 15;
    public static final int SUGGESTION_RANGE_SPAN = 21;
    public static final int SUGGESTION_SPAN = 19;
    public static final int SUPERSCRIPT_SPAN = 14;
    private static final String TAG = "TextUtils";
    public static final int TEXT_APPEARANCE_SPAN = 17;
    public static final int TTS_SPAN = 24;
    public static final int TYPEFACE_SPAN = 13;
    public static final int UNDERLINE_SPAN = 6;
    public static final int URL_SPAN = 11;
    private static final char ZWNBS_CHAR = '\ufeff';
    private static Object sLock;
    private static char[] sTemp;

    static {
        CHAR_SEQUENCE_CREATOR = new Parcelable.Creator<CharSequence>(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public CharSequence createFromParcel(Parcel parcel) {
                int n = parcel.readInt();
                String string2 = parcel.readString();
                if (string2 == null) {
                    return null;
                }
                if (n == 1) return string2;
                SpannableString spannableString = new SpannableString(string2);
                int n2;
                block26: while ((n2 = parcel.readInt()) != 0) {
                    switch (n2) {
                        default: {
                            throw new RuntimeException("bogus span encoding " + n2);
                        }
                        case 1: {
                            TextUtils.readSpan(parcel, spannableString, new AlignmentSpan.Standard(parcel));
                            continue block26;
                        }
                        case 2: {
                            TextUtils.readSpan(parcel, spannableString, new ForegroundColorSpan(parcel));
                            continue block26;
                        }
                        case 3: {
                            TextUtils.readSpan(parcel, spannableString, new RelativeSizeSpan(parcel));
                            continue block26;
                        }
                        case 4: {
                            TextUtils.readSpan(parcel, spannableString, new ScaleXSpan(parcel));
                            continue block26;
                        }
                        case 5: {
                            TextUtils.readSpan(parcel, spannableString, new StrikethroughSpan(parcel));
                            continue block26;
                        }
                        case 6: {
                            TextUtils.readSpan(parcel, spannableString, new UnderlineSpan(parcel));
                            continue block26;
                        }
                        case 7: {
                            TextUtils.readSpan(parcel, spannableString, new StyleSpan(parcel));
                            continue block26;
                        }
                        case 8: {
                            TextUtils.readSpan(parcel, spannableString, new BulletSpan(parcel));
                            continue block26;
                        }
                        case 9: {
                            TextUtils.readSpan(parcel, spannableString, new QuoteSpan(parcel));
                            continue block26;
                        }
                        case 10: {
                            TextUtils.readSpan(parcel, spannableString, new LeadingMarginSpan.Standard(parcel));
                            continue block26;
                        }
                        case 11: {
                            TextUtils.readSpan(parcel, spannableString, new URLSpan(parcel));
                            continue block26;
                        }
                        case 12: {
                            TextUtils.readSpan(parcel, spannableString, new BackgroundColorSpan(parcel));
                            continue block26;
                        }
                        case 13: {
                            TextUtils.readSpan(parcel, spannableString, new TypefaceSpan(parcel));
                            continue block26;
                        }
                        case 14: {
                            TextUtils.readSpan(parcel, spannableString, new SuperscriptSpan(parcel));
                            continue block26;
                        }
                        case 15: {
                            TextUtils.readSpan(parcel, spannableString, new SubscriptSpan(parcel));
                            continue block26;
                        }
                        case 16: {
                            TextUtils.readSpan(parcel, spannableString, new AbsoluteSizeSpan(parcel));
                            continue block26;
                        }
                        case 17: {
                            TextUtils.readSpan(parcel, spannableString, new TextAppearanceSpan(parcel));
                            continue block26;
                        }
                        case 18: {
                            TextUtils.readSpan(parcel, spannableString, new Annotation(parcel));
                            continue block26;
                        }
                        case 19: {
                            TextUtils.readSpan(parcel, spannableString, new SuggestionSpan(parcel));
                            continue block26;
                        }
                        case 20: {
                            TextUtils.readSpan(parcel, spannableString, new SpellCheckSpan(parcel));
                            continue block26;
                        }
                        case 21: {
                            TextUtils.readSpan(parcel, spannableString, new SuggestionRangeSpan(parcel));
                            continue block26;
                        }
                        case 22: {
                            TextUtils.readSpan(parcel, spannableString, new EasyEditSpan(parcel));
                            continue block26;
                        }
                        case 23: {
                            TextUtils.readSpan(parcel, spannableString, new LocaleSpan(parcel));
                            continue block26;
                        }
                        case 24: 
                    }
                    TextUtils.readSpan(parcel, spannableString, new TtsSpan(parcel));
                }
                return spannableString;
            }

            public CharSequence[] newArray(int n) {
                return new CharSequence[n];
            }
        };
        sLock = new Object();
        sTemp = null;
        EMPTY_STRING_ARRAY = new String[0];
        ARAB_SCRIPT_SUBTAG = "Arab";
        HEBR_SCRIPT_SUBTAG = "Hebr";
    }

    private TextUtils() {
    }

    public static CharSequence commaEllipsize(CharSequence charSequence, TextPaint textPaint, float f, String string2, String string3) {
        return TextUtils.commaEllipsize(charSequence, textPaint, f, string2, string3, TextDirectionHeuristics.FIRSTSTRONG_LTR);
    }

    /*
     * Unable to fully structure code
     */
    public static CharSequence commaEllipsize(CharSequence var0, TextPaint var1_1, float var2_2, String var3_3, String var4_4, TextDirectionHeuristic var5_5) {
        var6_6 = MeasuredText.obtain();
        var9_7 = var0.length();
        var10_8 = TextUtils.setPara(var6_6, var1_1, var0, 0, var9_7, var5_5);
        if (var10_8 <= var2_2) {
            MeasuredText.recycle(var6_6);
            return var0;
        }
        var11_9 = var6_6.mChars;
        var12_10 = 0;
        var13_11 = 0;
        block8: while (true) {
            if (var13_11 < var9_7) {
                if (var11_9[var13_11] == ',') {
                    ++var12_10;
                }
            }
            var14_12 = var12_10 + 1;
            var15_13 = 0;
            var16_14 = "";
            var17_15 = 0;
            var18_16 = 0;
            var19_17 = var6_6.mWidths;
            var20_18 = MeasuredText.obtain();
            var21_19 = 0;
lbl28:
            // 2 sources

            while (true) {
                block14: {
                    if (var21_19 >= var9_7) ** GOTO lbl53
                    var17_15 = (int)((float)var17_15 + var19_17[var21_19]);
                    if (var11_9[var21_19] != ',') break block8;
                    ++var18_16;
                    if (--var14_12 != 1) break block14;
                    try {
                        var22_20 = " " + var3_3;
lbl37:
                        // 2 sources

                        while (true) {
                            var20_18.setPara(var22_20, 0, var22_20.length(), var5_5);
                            if (!(var20_18.addStyleRun(var1_1, var20_18.mLen, null) + (float)var17_15 <= var2_2)) break block8;
                            var15_13 = var21_19 + 1;
                            var16_14 = var22_20;
                            break block8;
                            break;
                        }
                    }
                    catch (Throwable var7_24) {
                        MeasuredText.recycle(var6_6);
                        throw var7_24;
                    }
                }
                var23_21 = new StringBuilder().append(" ");
                var24_22 = new Object[]{var14_12};
                var22_20 = var23_21.append(String.format(var4_4, var24_22)).toString();
                ** continue;
lbl53:
                // 1 sources

                MeasuredText.recycle(var20_18);
                var26_23 = new SpannableStringBuilder(var16_14);
                var26_23.insert(0, var0, 0, var15_13);
                MeasuredText.recycle(var6_6);
                return var26_23;
            }
            ++var13_11;
        }
        ++var21_19;
        ** while (true)
    }

    public static CharSequence concat(CharSequence ... charSequenceArray) {
        StringBuilder stringBuilder;
        boolean bl;
        if (charSequenceArray.length == 0) {
            return "";
        }
        if (charSequenceArray.length == 1) {
            return charSequenceArray[0];
        }
        int n = 0;
        while (true) {
            block9: {
                block8: {
                    int n2 = charSequenceArray.length;
                    bl = false;
                    if (n >= n2) break block8;
                    if (!(charSequenceArray[n] instanceof Spanned)) break block9;
                    bl = true;
                }
                stringBuilder = new StringBuilder();
                for (int i = 0; i < charSequenceArray.length; ++i) {
                    stringBuilder.append(charSequenceArray[i]);
                }
                break;
            }
            ++n;
        }
        if (!bl) {
            return stringBuilder.toString();
        }
        SpannableString spannableString = new SpannableString(stringBuilder);
        int n3 = 0;
        for (int i = 0; i < charSequenceArray.length; ++i) {
            int n4 = charSequenceArray[i].length();
            if (charSequenceArray[i] instanceof Spanned) {
                TextUtils.copySpansFrom((Spanned)charSequenceArray[i], 0, n4, Object.class, spannableString, n3);
            }
            n3 += n4;
        }
        return new SpannedString(spannableString);
    }

    public static void copySpansFrom(Spanned spanned, int n, int n2, Class clazz, Spannable spannable, int n3) {
        if (clazz == null) {
            clazz = Object.class;
        }
        Object[] objectArray = spanned.getSpans(n, n2, clazz);
        for (int i = 0; i < objectArray.length; ++i) {
            int n4 = spanned.getSpanStart(objectArray[i]);
            int n5 = spanned.getSpanEnd(objectArray[i]);
            int n6 = spanned.getSpanFlags(objectArray[i]);
            if (n4 < n) {
                n4 = n;
            }
            if (n5 > n2) {
                n5 = n2;
            }
            spannable.setSpan(objectArray[i], n3 + (n4 - n), n3 + (n5 - n), n6);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean delimitedStringContains(String string2, char c, String string3) {
        boolean bl = true;
        if (TextUtils.isEmpty(string2)) return false;
        if (TextUtils.isEmpty(string3)) {
            return false;
        }
        int n = -1;
        int n2 = string2.length();
        while ((n = string2.indexOf(string3, n + 1)) != -1) {
            if (n > 0 && string2.charAt(n - 1) != c) continue;
            int n3 = n + string3.length();
            if (n3 == n2) return bl;
            if (string2.charAt(n3) == c) return bl;
        }
        return false;
    }

    static boolean doesNotNeedBidi(CharSequence charSequence, int n, int n2) {
        for (int i = n; i < n2; ++i) {
            if (charSequence.charAt(i) < '\u0590') continue;
            return false;
        }
        return true;
    }

    static boolean doesNotNeedBidi(char[] cArray, int n, int n2) {
        int n3;
        int n4 = n3 + n2;
        for (n3 = n; n3 < n4; ++n3) {
            if (cArray[n3] < '\u0590') continue;
            return false;
        }
        return true;
    }

    public static void dumpSpans(CharSequence charSequence, Printer printer, String string2) {
        if (charSequence instanceof Spanned) {
            Spanned spanned = (Spanned)charSequence;
            Object[] objectArray = spanned.getSpans(0, charSequence.length(), Object.class);
            for (int i = 0; i < objectArray.length; ++i) {
                Object object = objectArray[i];
                printer.println(string2 + charSequence.subSequence(spanned.getSpanStart(object), spanned.getSpanEnd(object)) + ": " + Integer.toHexString(System.identityHashCode(object)) + " " + object.getClass().getCanonicalName() + " (" + spanned.getSpanStart(object) + "-" + spanned.getSpanEnd(object) + ") fl=#" + spanned.getSpanFlags(object));
            }
        } else {
            printer.println(string2 + charSequence + ": (no spans)");
        }
    }

    public static CharSequence ellipsize(CharSequence charSequence, TextPaint textPaint, float f, TruncateAt truncateAt) {
        return TextUtils.ellipsize(charSequence, textPaint, f, truncateAt, false, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CharSequence ellipsize(CharSequence charSequence, TextPaint textPaint, float f, TruncateAt truncateAt, boolean bl, EllipsizeCallback ellipsizeCallback) {
        String string2;
        if (truncateAt == TruncateAt.END_SMALL) {
            string2 = String.valueOf(Layout.ELLIPSIS_TWO_DOTS);
            return TextUtils.ellipsize(charSequence, textPaint, f, truncateAt, bl, ellipsizeCallback, TextDirectionHeuristics.FIRSTSTRONG_LTR, string2);
        }
        string2 = String.valueOf(Layout.ELLIPSIS_NORMAL);
        return TextUtils.ellipsize(charSequence, textPaint, f, truncateAt, bl, ellipsizeCallback, TextDirectionHeuristics.FIRSTSTRONG_LTR, string2);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static CharSequence ellipsize(CharSequence var0, TextPaint var1_1, float var2_2, TruncateAt var3_3, boolean var4_4, EllipsizeCallback var5_5, TextDirectionHeuristic var6_6, String var7_7) {
        block23: {
            block22: {
                block21: {
                    block19: {
                        block20: {
                            var8_8 = var0.length();
                            var9_9 = MeasuredText.obtain();
                            if (!(TextUtils.setPara(var9_9, var1_1, var0, 0, var0.length(), var6_6) <= var2_2)) break block19;
                            if (var5_5 == null) break block20;
                            var5_5.ellipsized(0, 0);
                        }
                        MeasuredText.recycle(var9_9);
                        return var0;
                    }
                    var13_10 = var2_2 - var1_1.measureText(var7_7);
                    var14_11 = var8_8;
                    if (var13_10 < 0.0f) {
                        var15_12 = 0;
                    } else {
                        if (var3_3 == TruncateAt.START) {
                            var14_11 = var8_8 - var9_9.breakText(var8_8, false, var13_10);
                            var15_12 = 0;
                            break block21;
                        }
                        if (var3_3 == TruncateAt.END || var3_3 == TruncateAt.END_SMALL) {
                            var15_12 = var9_9.breakText(var8_8, true, var13_10);
                            break block21;
                        }
                        var14_11 = var8_8 - var9_9.breakText(var8_8, false, var13_10 / 2.0f);
                        var38_13 = var13_10 - var9_9.measure(var14_11, var8_8);
                        var15_12 = var9_9.breakText(var14_11, true, var38_13);
                    }
                }
                if (var5_5 == null) ** GOTO lbl35
                var5_5.ellipsized(var15_12, var14_11);
lbl35:
                // 2 sources

                var16_14 = var9_9.mChars;
                var17_15 = var0 instanceof Spanned != false ? (Spanned)var0 : null;
                var18_16 = var8_8 - (var14_11 - var15_12);
                if (!var4_4) break block22;
                if (var18_16 <= 0) break block23;
                var32_17 = var15_12 + 1;
                var16_14[var15_12] = var7_7.charAt(0);
            }
            if (var18_16 == 0) {
                MeasuredText.recycle(var9_9);
                return "";
            }
            if (var17_15 == null) {
                var24_21 = new StringBuilder(var18_16 + var7_7.length());
                var24_21.append(var16_14, 0, var15_12);
                var24_21.append(var7_7);
                var27_22 = var8_8 - var14_11;
                var24_21.append(var16_14, var14_11, var27_22);
                var29_23 = var24_21.toString();
                MeasuredText.recycle(var9_9);
                return var29_23;
            }
            var19_24 = new SpannableStringBuilder();
            var19_24.append(var0, 0, var15_12);
            var19_24.append(var7_7);
            var19_24.append(var0, var14_11, var8_8);
            MeasuredText.recycle(var9_9);
            return var19_24;
        }
        var32_17 = var15_12;
        for (var33_18 = var32_17; var33_18 < var14_11; ++var33_18) {
            var16_14[var33_18] = 65279;
        }
        var34_19 = new String(var16_14, 0, var8_8);
        if (var17_15 == null) {
            MeasuredText.recycle(var9_9);
            return var34_19;
        }
        ** try [egrp 5[TRYBLOCK] [12 : 307->331)] { 
lbl86:
        // 1 sources

        var35_20 = new SpannableString(var34_19);
        TextUtils.copySpansFrom(var17_15, 0, var8_8, Object.class, var35_20, 0);
        return var35_20;
lbl89:
        // 1 sources

        finally {
            MeasuredText.recycle(var9_9);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public static boolean equals(CharSequence charSequence, CharSequence charSequence2) {
        if (charSequence != charSequence2) {
            int n;
            if (charSequence != null && charSequence2 != null && (n = charSequence.length()) == charSequence2.length()) {
                if (charSequence instanceof String && charSequence2 instanceof String) {
                    return charSequence.equals(charSequence2);
                }
            } else {
                return false;
            }
            for (int i = 0; i < n; ++i) {
                if (charSequence.charAt(i) == charSequence2.charAt(i)) continue;
                return false;
            }
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static CharSequence expandTemplate(CharSequence charSequence, CharSequence ... charSequenceArray) {
        if (charSequenceArray.length > 9) {
            throw new IllegalArgumentException("max of 9 values are supported");
        }
        SpannableStringBuilder spannableStringBuilder = new SpannableStringBuilder(charSequence);
        int n = 0;
        try {
            while (n < spannableStringBuilder.length()) {
                if (spannableStringBuilder.charAt(n) == '^') {
                    char c = spannableStringBuilder.charAt(n + 1);
                    if (c == '^') {
                        spannableStringBuilder.delete(n + 1, n + 2);
                        ++n;
                        continue;
                    }
                    if (Character.isDigit(c)) {
                        int n2 = -1 + Character.getNumericValue(c);
                        if (n2 < 0) {
                            throw new IllegalArgumentException("template requests value ^" + (n2 + 1));
                        }
                        if (n2 >= charSequenceArray.length) {
                            throw new IllegalArgumentException("template requests value ^" + (n2 + 1) + "; only " + charSequenceArray.length + " provided");
                        }
                        spannableStringBuilder.replace(n, n + 2, charSequenceArray[n2]);
                        int n3 = charSequenceArray[n2].length();
                        n += n3;
                        continue;
                    }
                }
                ++n;
            }
            return spannableStringBuilder;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        return spannableStringBuilder;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static int getCapsMode(CharSequence charSequence, int n, int n2) {
        char c;
        int n3;
        if (n < 0) {
            return 0;
        }
        int n4 = n2 & 0x1000;
        int n5 = 0;
        if (n4 != 0) {
            n5 = 0 | 0x1000;
        }
        if ((n2 & 0x6000) == 0) return n5;
        int n6 = n;
        while (true) {
            char c2;
            if (n6 <= 0 || (c2 = charSequence.charAt(n6 - 1)) != '\"' && c2 != '\'' && Character.getType(c2) != 21) {
                char c3;
                for (n3 = n6; n3 > 0 && ((c3 = charSequence.charAt(n3 - 1)) == ' ' || c3 == '\t'); --n3) {
                }
                break;
            }
            --n6;
        }
        if (n3 == 0) return n5 | 0x2000;
        if (charSequence.charAt(n3 - 1) == '\n') {
            return n5 | 0x2000;
        }
        if ((n2 & 0x4000) == 0) {
            if (n6 == n3) return n5;
            return n5 | 0x2000;
        }
        if (n6 == n3) return n5;
        while (true) {
            char c4;
            if (n3 <= 0 || (c4 = charSequence.charAt(n3 - 1)) != '\"' && c4 != '\'' && Character.getType(c4) != 22) {
                if (n3 <= 0) return n5;
                c = charSequence.charAt(n3 - 1);
                if (c != '.' && c != '?') {
                    if (c != '!') return n5;
                }
                break;
            }
            --n3;
        }
        if (c != '.') return n5 | 0x4000;
        int n7 = n3 - 2;
        while (n7 >= 0) {
            char c5 = charSequence.charAt(n7);
            if (c5 == '.') return n5;
            if (!Character.isLetter(c5)) return n5 | 0x4000;
            --n7;
        }
        return n5 | 0x4000;
    }

    public static void getChars(CharSequence charSequence, int n, int n2, char[] cArray, int n3) {
        Class<?> clazz = charSequence.getClass();
        if (clazz == String.class) {
            ((String)charSequence).getChars(n, n2, cArray, n3);
            return;
        }
        if (clazz == StringBuffer.class) {
            ((StringBuffer)charSequence).getChars(n, n2, cArray, n3);
            return;
        }
        if (clazz == StringBuilder.class) {
            ((StringBuilder)charSequence).getChars(n, n2, cArray, n3);
            return;
        }
        if (charSequence instanceof GetChars) {
            ((GetChars)charSequence).getChars(n, n2, cArray, n3);
            return;
        }
        int n4 = n3;
        for (int i = n; i < n2; ++i) {
            int n5 = n4 + 1;
            cArray[n4] = charSequence.charAt(i);
            n4 = n5;
        }
    }

    private static int getLayoutDirectionFromFirstChar(Locale locale) {
        switch (Character.getDirectionality(locale.getDisplayName(locale).charAt(0))) {
            default: {
                return 0;
            }
            case 1: 
            case 2: 
        }
        return 1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int getLayoutDirectionFromLocale(Locale locale) {
        int n = 1;
        if (locale != null && !locale.equals(Locale.ROOT)) {
            String string2 = ICU.addLikelySubtags((Locale)locale).getScript();
            if (string2 == null) {
                return TextUtils.getLayoutDirectionFromFirstChar(locale);
            }
            if (string2.equalsIgnoreCase(ARAB_SCRIPT_SUBTAG)) return n;
            if (string2.equalsIgnoreCase(HEBR_SCRIPT_SUBTAG)) return n;
        }
        if (SystemProperties.getBoolean("debug.force_rtl", false)) return n;
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static int getOffsetAfter(CharSequence charSequence, int n) {
        char c;
        int n2 = charSequence.length();
        if (n == n2 || n == n2 - 1) {
            return n2;
        }
        char c2 = charSequence.charAt(n);
        int n3 = c2 >= '\ud800' && c2 <= '\udbff' ? ((c = charSequence.charAt(n + 1)) >= '\udc00' && c <= '\udfff' ? n + 2 : n + 1) : n + 1;
        if (charSequence instanceof Spanned) {
            ReplacementSpan[] replacementSpanArray = ((Spanned)charSequence).getSpans(n3, n3, ReplacementSpan.class);
            for (int i = 0; i < replacementSpanArray.length; ++i) {
                int n4 = ((Spanned)charSequence).getSpanStart(replacementSpanArray[i]);
                int n5 = ((Spanned)charSequence).getSpanEnd(replacementSpanArray[i]);
                if (n4 >= n3 || n5 <= n3) continue;
                n3 = n5;
            }
        }
        return n3;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static int getOffsetBefore(CharSequence charSequence, int n) {
        char c;
        if (n == 0 || n == 1) {
            return 0;
        }
        char c2 = charSequence.charAt(n - 1);
        int n2 = c2 >= '\udc00' && c2 <= '\udfff' ? ((c = charSequence.charAt(n - 2)) >= '\ud800' && c <= '\udbff' ? n - 2 : n - 1) : n - 1;
        if (charSequence instanceof Spanned) {
            ReplacementSpan[] replacementSpanArray = ((Spanned)charSequence).getSpans(n2, n2, ReplacementSpan.class);
            for (int i = 0; i < replacementSpanArray.length; ++i) {
                int n3 = ((Spanned)charSequence).getSpanStart(replacementSpanArray[i]);
                int n4 = ((Spanned)charSequence).getSpanEnd(replacementSpanArray[i]);
                if (n3 >= n2 || n4 <= n2) continue;
                n2 = n3;
            }
        }
        return n2;
    }

    public static CharSequence getReverse(CharSequence charSequence, int n, int n2) {
        return new Reverser(charSequence, n, n2);
    }

    public static int getTrimmedLength(CharSequence charSequence) {
        int n;
        int n2;
        int n3 = charSequence.length();
        for (n2 = 0; n2 < n3 && charSequence.charAt(n2) <= ' '; ++n2) {
        }
        for (n = n3; n > n2 && charSequence.charAt(n - 1) <= ' '; --n) {
        }
        return n - n2;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static String htmlEncode(String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        while (n < string2.length()) {
            char c = string2.charAt(n);
            switch (c) {
                default: {
                    stringBuilder.append(c);
                    break;
                }
                case '<': {
                    stringBuilder.append("&lt;");
                    break;
                }
                case '>': {
                    stringBuilder.append("&gt;");
                    break;
                }
                case '&': {
                    stringBuilder.append("&amp;");
                    break;
                }
                case '\'': {
                    stringBuilder.append("&#39;");
                    break;
                }
                case '\"': {
                    stringBuilder.append("&quot;");
                }
            }
            ++n;
        }
        return stringBuilder.toString();
    }

    public static int indexOf(CharSequence charSequence, char c) {
        return TextUtils.indexOf(charSequence, c, 0);
    }

    public static int indexOf(CharSequence charSequence, char c, int n) {
        if (charSequence.getClass() == String.class) {
            return ((String)charSequence).indexOf(c, n);
        }
        return TextUtils.indexOf(charSequence, c, n, charSequence.length());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int indexOf(CharSequence charSequence, char c, int n, int n2) {
        Class<?> clazz = charSequence.getClass();
        if (charSequence instanceof GetChars || clazz == StringBuffer.class || clazz == StringBuilder.class || clazz == String.class) {
            char[] cArray = TextUtils.obtain(500);
            while (n < n2) {
                int n3 = n + 500;
                if (n3 > n2) {
                    n3 = n2;
                }
                TextUtils.getChars(charSequence, n, n3, cArray, 0);
                int n4 = n3 - n;
                for (int i = 0; i < n4; ++i) {
                    if (cArray[i] != c) continue;
                    TextUtils.recycle(cArray);
                    return i + n;
                }
                n = n3;
            }
            TextUtils.recycle(cArray);
            return -1;
        }
        int n5 = n;
        while (n5 < n2) {
            if (charSequence.charAt(n5) == c) return n5;
            ++n5;
        }
        return -1;
    }

    public static int indexOf(CharSequence charSequence, CharSequence charSequence2) {
        return TextUtils.indexOf(charSequence, charSequence2, 0, charSequence.length());
    }

    public static int indexOf(CharSequence charSequence, CharSequence charSequence2, int n) {
        return TextUtils.indexOf(charSequence, charSequence2, n, charSequence.length());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int indexOf(CharSequence charSequence, CharSequence charSequence2, int n, int n2) {
        int n3;
        int n4 = -1;
        int n5 = charSequence2.length();
        if (n5 == 0) {
            return n;
        }
        char c = charSequence2.charAt(0);
        while ((n3 = TextUtils.indexOf(charSequence, c, n)) <= n2 - n5) {
            if (n3 < 0) return n4;
            if (TextUtils.regionMatches(charSequence, n3, charSequence2, 0, n5)) {
                return n3;
            }
            n = n3 + 1;
        }
        return n4;
    }

    public static boolean isDigitsOnly(CharSequence charSequence) {
        int n = charSequence.length();
        for (int i = 0; i < n; ++i) {
            if (Character.isDigit(charSequence.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isEmpty(CharSequence charSequence) {
        return charSequence == null || charSequence.length() == 0;
    }

    public static boolean isGraphic(char c) {
        int n = Character.getType(c);
        return n != 15 && n != 16 && n != 19 && n != 0 && n != 13 && n != 14 && n != 12;
    }

    public static boolean isGraphic(CharSequence charSequence) {
        int n = charSequence.length();
        for (int i = 0; i < n; ++i) {
            int n2 = Character.getType(charSequence.charAt(i));
            if (n2 == 15 || n2 == 16 || n2 == 19 || n2 == 0 || n2 == 13 || n2 == 14 || n2 == 12) continue;
            return true;
        }
        return false;
    }

    public static boolean isPrintableAscii(char c) {
        return ' ' <= c && c <= '~' || c == '\r' || c == '\n';
    }

    public static boolean isPrintableAsciiOnly(CharSequence charSequence) {
        int n = charSequence.length();
        for (int i = 0; i < n; ++i) {
            if (TextUtils.isPrintableAscii(charSequence.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static CharSequence join(Iterable<CharSequence> iterable) {
        return TextUtils.join(Resources.getSystem().getText(17040821), iterable);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static String join(CharSequence charSequence, Iterable iterable) {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = true;
        Iterator iterator = iterable.iterator();
        while (iterator.hasNext()) {
            Object t = iterator.next();
            if (bl) {
                bl = false;
            } else {
                stringBuilder.append(charSequence);
            }
            stringBuilder.append(t);
        }
        return stringBuilder.toString();
    }

    /*
     * Enabled aggressive block sorting
     */
    public static String join(CharSequence charSequence, Object[] objectArray) {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = true;
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            if (bl) {
                bl = false;
            } else {
                stringBuilder.append(charSequence);
            }
            stringBuilder.append(object);
            ++n2;
        }
        return stringBuilder.toString();
    }

    public static int lastIndexOf(CharSequence charSequence, char c) {
        return TextUtils.lastIndexOf(charSequence, c, -1 + charSequence.length());
    }

    public static int lastIndexOf(CharSequence charSequence, char c, int n) {
        if (charSequence.getClass() == String.class) {
            return ((String)charSequence).lastIndexOf(c, n);
        }
        return TextUtils.lastIndexOf(charSequence, c, 0, n);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int lastIndexOf(CharSequence charSequence, char c, int n, int n2) {
        if (n2 < 0) {
            return -1;
        }
        if (n2 >= charSequence.length()) {
            n2 = -1 + charSequence.length();
        }
        int n3 = n2 + 1;
        Class<?> clazz = charSequence.getClass();
        if (charSequence instanceof GetChars || clazz == StringBuffer.class || clazz == StringBuilder.class || clazz == String.class) {
            char[] cArray = TextUtils.obtain(500);
            while (n < n3) {
                int n4 = n3 - 500;
                if (n4 < n) {
                    n4 = n;
                }
                TextUtils.getChars(charSequence, n4, n3, cArray, 0);
                for (int i = -1 + (n3 - n4); i >= 0; --i) {
                    if (cArray[i] != c) continue;
                    TextUtils.recycle(cArray);
                    return i + n4;
                }
                n3 = n4;
            }
            TextUtils.recycle(cArray);
            return -1;
        }
        int n5 = n3 - 1;
        while (n5 >= n) {
            if (charSequence.charAt(n5) == c) return n5;
            --n5;
        }
        return -1;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static char[] obtain(int n) {
        char[] cArray;
        Object object = sLock;
        synchronized (object) {
            cArray = sTemp;
            sTemp = null;
        }
        if (cArray == null) return ArrayUtils.newUnpaddedCharArray(n);
        if (cArray.length >= n) return cArray;
        return ArrayUtils.newUnpaddedCharArray(n);
    }

    public static long packRangeInLong(int n, int n2) {
        return (long)n << 32 | (long)n2;
    }

    private static void readSpan(Parcel parcel, Spannable spannable, Object object) {
        spannable.setSpan(object, parcel.readInt(), parcel.readInt(), parcel.readInt());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static void recycle(char[] cArray) {
        if (cArray.length > 1000) {
            return;
        }
        Object object = sLock;
        synchronized (object) {
            sTemp = cArray;
            return;
        }
    }

    public static boolean regionMatches(CharSequence charSequence, int n, CharSequence charSequence2, int n2, int n3) {
        int n4 = n3 * 2;
        if (n4 < n3) {
            throw new IndexOutOfBoundsException();
        }
        char[] cArray = TextUtils.obtain(n4);
        TextUtils.getChars(charSequence, n, n + n3, cArray, 0);
        TextUtils.getChars(charSequence2, n2, n2 + n3, cArray, n3);
        boolean bl = true;
        int n5 = 0;
        while (true) {
            block6: {
                block5: {
                    if (n5 >= n3) break block5;
                    if (cArray[n5] == cArray[n5 + n3]) break block6;
                    bl = false;
                }
                TextUtils.recycle(cArray);
                return bl;
            }
            ++n5;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public static <T> T[] removeEmptySpans(T[] TArray, Spanned spanned, Class<T> clazz) {
        Object[] objectArray = null;
        int n = 0;
        for (int i = 0; i < TArray.length; ++i) {
            T t = TArray[i];
            if (spanned.getSpanStart(t) == spanned.getSpanEnd(t)) {
                if (objectArray != null) continue;
                objectArray = (Object[])Array.newInstance(clazz, -1 + TArray.length);
                System.arraycopy(TArray, 0, objectArray, 0, i);
                n = i;
                continue;
            }
            if (objectArray == null) continue;
            objectArray[n] = t;
            ++n;
        }
        if (objectArray != null) {
            Object[] objectArray2 = (Object[])Array.newInstance(clazz, n);
            System.arraycopy(objectArray, 0, objectArray2, 0, n);
            return objectArray2;
        }
        return TArray;
    }

    public static CharSequence replace(CharSequence charSequence, String[] stringArray, CharSequence[] charSequenceArray) {
        SpannableStringBuilder spannableStringBuilder = new SpannableStringBuilder(charSequence);
        for (int i = 0; i < stringArray.length; ++i) {
            int n = TextUtils.indexOf((CharSequence)spannableStringBuilder, stringArray[i]);
            if (n < 0) continue;
            spannableStringBuilder.setSpan(stringArray[i], n, n + stringArray[i].length(), 33);
        }
        for (int i = 0; i < stringArray.length; ++i) {
            int n = spannableStringBuilder.getSpanStart(stringArray[i]);
            int n2 = spannableStringBuilder.getSpanEnd(stringArray[i]);
            if (n < 0) continue;
            spannableStringBuilder.replace(n, n2, charSequenceArray[i]);
        }
        return spannableStringBuilder;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static float setPara(MeasuredText measuredText, TextPaint textPaint, CharSequence charSequence, int n, int n2, TextDirectionHeuristic textDirectionHeuristic) {
        measuredText.setPara(charSequence, n, n2, textDirectionHeuristic);
        Spanned spanned = charSequence instanceof Spanned ? (Spanned)charSequence : null;
        int n3 = n2 - n;
        if (spanned == null) {
            return measuredText.addStyleRun(textPaint, n3, null);
        }
        float f = 0.0f;
        int n4 = 0;
        while (n4 < n3) {
            int n5 = spanned.nextSpanTransition(n4, n3, MetricAffectingSpan.class);
            f += measuredText.addStyleRun(textPaint, TextUtils.removeEmptySpans(spanned.getSpans(n4, n5, MetricAffectingSpan.class), spanned, MetricAffectingSpan.class), n5 - n4, null);
            n4 = n5;
        }
        return f;
    }

    public static String[] split(String string2, String string3) {
        if (string2.length() == 0) {
            return EMPTY_STRING_ARRAY;
        }
        return string2.split(string3, -1);
    }

    public static String[] split(String string2, Pattern pattern) {
        if (string2.length() == 0) {
            return EMPTY_STRING_ARRAY;
        }
        return pattern.split(string2, -1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CharSequence stringOrSpannedString(CharSequence charSequence) {
        if (charSequence == null) {
            return null;
        }
        if (charSequence instanceof SpannedString) return charSequence;
        if (!(charSequence instanceof Spanned)) return charSequence.toString();
        return new SpannedString(charSequence);
    }

    public static String substring(CharSequence charSequence, int n, int n2) {
        if (charSequence instanceof String) {
            return ((String)charSequence).substring(n, n2);
        }
        if (charSequence instanceof StringBuilder) {
            return ((StringBuilder)charSequence).substring(n, n2);
        }
        if (charSequence instanceof StringBuffer) {
            return ((StringBuffer)charSequence).substring(n, n2);
        }
        char[] cArray = TextUtils.obtain(n2 - n);
        TextUtils.getChars(charSequence, n, n2, cArray, 0);
        String string2 = new String(cArray, 0, n2 - n);
        TextUtils.recycle(cArray);
        return string2;
    }

    public static int unpackRangeEndFromLong(long l) {
        return (int)(0xFFFFFFFFL & l);
    }

    public static int unpackRangeStartFromLong(long l) {
        return (int)(l >>> 32);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void writeToParcel(CharSequence charSequence, Parcel parcel, int n) {
        if (!(charSequence instanceof Spanned)) {
            parcel.writeInt(1);
            if (charSequence != null) {
                parcel.writeString(charSequence.toString());
                return;
            }
            parcel.writeString(null);
            return;
        }
        parcel.writeInt(0);
        parcel.writeString(charSequence.toString());
        Spanned spanned = (Spanned)charSequence;
        Object[] objectArray = spanned.getSpans(0, charSequence.length(), Object.class);
        int n2 = 0;
        while (true) {
            if (n2 >= objectArray.length) {
                parcel.writeInt(0);
                return;
            }
            Object object = objectArray[n2];
            Object object2 = objectArray[n2];
            if (object2 instanceof CharacterStyle) {
                object2 = ((CharacterStyle)object2).getUnderlying();
            }
            if (object2 instanceof ParcelableSpan) {
                ParcelableSpan parcelableSpan = (ParcelableSpan)object2;
                int n3 = parcelableSpan.getSpanTypeId();
                if (n3 < 1 || n3 > 24) {
                    Log.e(TAG, "external class \"" + parcelableSpan.getClass().getSimpleName() + "\" is attempting to use the frameworks-only ParcelableSpan" + " interface");
                } else {
                    parcel.writeInt(n3);
                    parcelableSpan.writeToParcel(parcel, n);
                    TextUtils.writeWhere(parcel, spanned, object);
                }
            }
            ++n2;
        }
    }

    private static void writeWhere(Parcel parcel, Spanned spanned, Object object) {
        parcel.writeInt(spanned.getSpanStart(object));
        parcel.writeInt(spanned.getSpanEnd(object));
        parcel.writeInt(spanned.getSpanFlags(object));
    }

    public static interface EllipsizeCallback {
        public void ellipsized(int var1, int var2);
    }

    private static class Reverser
    implements CharSequence,
    GetChars {
        private int mEnd;
        private CharSequence mSource;
        private int mStart;

        public Reverser(CharSequence charSequence, int n, int n2) {
            this.mSource = charSequence;
            this.mStart = n;
            this.mEnd = n2;
        }

        @Override
        public char charAt(int n) {
            return AndroidCharacter.getMirror(this.mSource.charAt(-1 + this.mEnd - n));
        }

        @Override
        public void getChars(int n, int n2, char[] cArray, int n3) {
            TextUtils.getChars(this.mSource, n + this.mStart, n2 + this.mStart, cArray, n3);
            AndroidCharacter.mirror(cArray, 0, n2 - n);
            int n4 = n2 - n;
            int n5 = (n2 - n) / 2;
            for (int i = 0; i < n5; ++i) {
                char c = cArray[n3 + i];
                cArray[n3 + i] = cArray[-1 + (n3 + n4 - i)];
                cArray[-1 + (n3 + n4 - i)] = c;
            }
        }

        @Override
        public int length() {
            return this.mEnd - this.mStart;
        }

        @Override
        public CharSequence subSequence(int n, int n2) {
            char[] cArray = new char[n2 - n];
            this.getChars(n, n2, cArray, 0);
            return new String(cArray);
        }

        @Override
        public String toString() {
            return this.subSequence(0, this.length()).toString();
        }
    }

    public static class SimpleStringSplitter
    implements StringSplitter,
    Iterator<String> {
        private char mDelimiter;
        private int mLength;
        private int mPosition;
        private String mString;

        public SimpleStringSplitter(char c) {
            this.mDelimiter = c;
        }

        @Override
        public boolean hasNext() {
            return this.mPosition < this.mLength;
        }

        @Override
        public Iterator<String> iterator() {
            return this;
        }

        @Override
        public String next() {
            int n = this.mString.indexOf(this.mDelimiter, this.mPosition);
            if (n == -1) {
                n = this.mLength;
            }
            String string2 = this.mString.substring(this.mPosition, n);
            this.mPosition = n + 1;
            return string2;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setString(String string2) {
            this.mString = string2;
            this.mPosition = 0;
            this.mLength = this.mString.length();
        }
    }

    public static interface StringSplitter
    extends Iterable<String> {
        public void setString(String var1);
    }

    public static final class TruncateAt
    extends Enum<TruncateAt> {
        private static final /* synthetic */ TruncateAt[] $VALUES;
        public static final /* enum */ TruncateAt END;
        public static final /* enum */ TruncateAt END_SMALL;
        public static final /* enum */ TruncateAt MARQUEE;
        public static final /* enum */ TruncateAt MIDDLE;
        public static final /* enum */ TruncateAt START;

        static {
            START = new TruncateAt();
            MIDDLE = new TruncateAt();
            END = new TruncateAt();
            MARQUEE = new TruncateAt();
            END_SMALL = new TruncateAt();
            TruncateAt[] truncateAtArray = new TruncateAt[]{START, MIDDLE, END, MARQUEE, END_SMALL};
            $VALUES = truncateAtArray;
        }

        public static TruncateAt valueOf(String string2) {
            return Enum.valueOf(TruncateAt.class, string2);
        }

        public static TruncateAt[] values() {
            return (TruncateAt[])$VALUES.clone();
        }
    }
}

