/*
 * Decompiled with CFR 0.152.
 */
package android.text.method;

import android.graphics.Rect;
import android.os.Handler;
import android.os.SystemClock;
import android.text.Editable;
import android.text.GetChars;
import android.text.NoCopySpan;
import android.text.Spannable;
import android.text.Spanned;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.text.method.TextKeyListener;
import android.text.method.TransformationMethod;
import android.text.style.UpdateLayout;
import android.view.View;
import java.lang.ref.WeakReference;

public class PasswordTransformationMethod
implements TransformationMethod,
TextWatcher {
    private static char DOT = (char)8226;
    private static PasswordTransformationMethod sInstance;

    public static PasswordTransformationMethod getInstance() {
        if (sInstance != null) {
            return sInstance;
        }
        sInstance = new PasswordTransformationMethod();
        return sInstance;
    }

    private static void removeVisibleSpans(Spannable spannable) {
        Visible[] visibleArray = spannable.getSpans(0, spannable.length(), Visible.class);
        for (int i = 0; i < visibleArray.length; ++i) {
            spannable.removeSpan(visibleArray[i]);
        }
    }

    @Override
    public void afterTextChanged(Editable editable) {
    }

    @Override
    public void beforeTextChanged(CharSequence charSequence, int n, int n2, int n3) {
    }

    @Override
    public CharSequence getTransformation(CharSequence charSequence, View view) {
        if (charSequence instanceof Spannable) {
            Spannable spannable = (Spannable)charSequence;
            ViewReference[] viewReferenceArray = spannable.getSpans(0, spannable.length(), ViewReference.class);
            for (int i = 0; i < viewReferenceArray.length; ++i) {
                spannable.removeSpan(viewReferenceArray[i]);
            }
            PasswordTransformationMethod.removeVisibleSpans(spannable);
            spannable.setSpan(new ViewReference(view), 0, 0, 34);
        }
        return new PasswordCharSequence(charSequence);
    }

    @Override
    public void onFocusChanged(View view, CharSequence charSequence, boolean bl, int n, Rect rect) {
        if (!bl && charSequence instanceof Spannable) {
            PasswordTransformationMethod.removeVisibleSpans((Spannable)charSequence);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void onTextChanged(CharSequence charSequence, int n, int n2, int n3) {
        Spannable spannable;
        block4: {
            block3: {
                ViewReference[] viewReferenceArray;
                if (!(charSequence instanceof Spannable) || (viewReferenceArray = (spannable = (Spannable)charSequence).getSpans(0, charSequence.length(), ViewReference.class)).length == 0) break block3;
                View view = null;
                for (int i = 0; view == null && i < viewReferenceArray.length; ++i) {
                    view = (View)viewReferenceArray[i].get();
                }
                if (view == null || (8 & TextKeyListener.getInstance().getPrefs(view.getContext())) == 0 || n3 <= 0) break block3;
                PasswordTransformationMethod.removeVisibleSpans(spannable);
                if (n3 == 1) break block4;
            }
            return;
        }
        spannable.setSpan(new Visible(spannable, this), n, n + n3, 33);
    }

    private static class PasswordCharSequence
    implements CharSequence,
    GetChars {
        private CharSequence mSource;

        public PasswordCharSequence(CharSequence charSequence) {
            this.mSource = charSequence;
        }

        @Override
        public char charAt(int n) {
            if (this.mSource instanceof Spanned) {
                Spanned spanned = (Spanned)this.mSource;
                int n2 = spanned.getSpanStart(TextKeyListener.ACTIVE);
                int n3 = spanned.getSpanEnd(TextKeyListener.ACTIVE);
                if (n >= n2 && n < n3) {
                    return this.mSource.charAt(n);
                }
                Visible[] visibleArray = spanned.getSpans(0, spanned.length(), Visible.class);
                for (int i = 0; i < visibleArray.length; ++i) {
                    if (spanned.getSpanStart(visibleArray[i].mTransformer) < 0) continue;
                    int n4 = spanned.getSpanStart(visibleArray[i]);
                    int n5 = spanned.getSpanEnd(visibleArray[i]);
                    if (n < n4 || n >= n5) continue;
                    return this.mSource.charAt(n);
                }
            }
            return DOT;
        }

        @Override
        public void getChars(int n, int n2, char[] cArray, int n3) {
            TextUtils.getChars(this.mSource, n, n2, cArray, n3);
            int n4 = -1;
            int n5 = -1;
            boolean bl = this.mSource instanceof Spanned;
            int[] nArray = null;
            int n6 = 0;
            int[] nArray2 = null;
            if (bl) {
                Spanned spanned = (Spanned)this.mSource;
                n4 = spanned.getSpanStart(TextKeyListener.ACTIVE);
                n5 = spanned.getSpanEnd(TextKeyListener.ACTIVE);
                Visible[] visibleArray = spanned.getSpans(0, spanned.length(), Visible.class);
                n6 = visibleArray.length;
                nArray2 = new int[n6];
                nArray = new int[n6];
                for (int i = 0; i < n6; ++i) {
                    if (spanned.getSpanStart(visibleArray[i].mTransformer) < 0) continue;
                    nArray2[i] = spanned.getSpanStart(visibleArray[i]);
                    nArray[i] = spanned.getSpanEnd(visibleArray[i]);
                }
            }
            block1: for (int i = n; i < n2; ++i) {
                if (i >= n4 && i < n5) continue;
                int n7 = 0;
                while (true) {
                    block8: {
                        boolean bl2;
                        block7: {
                            bl2 = false;
                            if (n7 >= n6) break block7;
                            if (i < nArray2[n7] || i >= nArray[n7]) break block8;
                            bl2 = true;
                        }
                        if (bl2) continue block1;
                        cArray[n3 + (i - n)] = DOT;
                        continue block1;
                    }
                    ++n7;
                }
            }
        }

        @Override
        public int length() {
            return this.mSource.length();
        }

        @Override
        public CharSequence subSequence(int n, int n2) {
            char[] cArray = new char[n2 - n];
            this.getChars(n, n2, cArray, 0);
            return new String(cArray);
        }

        @Override
        public String toString() {
            return this.subSequence(0, this.length()).toString();
        }
    }

    private static class ViewReference
    extends WeakReference<View>
    implements NoCopySpan {
        public ViewReference(View view) {
            super(view);
        }
    }

    private static class Visible
    extends Handler
    implements UpdateLayout,
    Runnable {
        private Spannable mText;
        private PasswordTransformationMethod mTransformer;

        public Visible(Spannable spannable, PasswordTransformationMethod passwordTransformationMethod) {
            this.mText = spannable;
            this.mTransformer = passwordTransformationMethod;
            this.postAtTime(this, 1500L + SystemClock.uptimeMillis());
        }

        @Override
        public void run() {
            this.mText.removeSpan(this);
        }
    }
}

