/*
 * Decompiled with CFR 0.152.
 */
package android.text.method;

import android.text.Layout;
import android.text.NoCopySpan;
import android.text.Spannable;
import android.text.method.MetaKeyKeyListener;
import android.view.MotionEvent;
import android.view.ViewConfiguration;
import android.widget.TextView;

public class Touch {
    private Touch() {
    }

    public static int getInitialScrollX(TextView textView, Spannable spannable) {
        DragState[] dragStateArray = spannable.getSpans(0, spannable.length(), DragState.class);
        if (dragStateArray.length > 0) {
            return dragStateArray[0].mScrollX;
        }
        return -1;
    }

    public static int getInitialScrollY(TextView textView, Spannable spannable) {
        DragState[] dragStateArray = spannable.getSpans(0, spannable.length(), DragState.class);
        if (dragStateArray.length > 0) {
            return dragStateArray[0].mScrollY;
        }
        return -1;
    }

    static boolean isActivelySelecting(Spannable spannable) {
        DragState[] dragStateArray = spannable.getSpans(0, spannable.length(), DragState.class);
        int n = dragStateArray.length;
        boolean bl = false;
        if (n > 0) {
            boolean bl2 = dragStateArray[0].mIsActivelySelecting;
            bl = false;
            if (bl2) {
                bl = true;
            }
        }
        return bl;
    }

    static boolean isSelectionStarted(Spannable spannable) {
        DragState[] dragStateArray = spannable.getSpans(0, spannable.length(), DragState.class);
        int n = dragStateArray.length;
        boolean bl = false;
        if (n > 0) {
            boolean bl2 = dragStateArray[0].mIsSelectionStarted;
            bl = false;
            if (bl2) {
                bl = true;
            }
        }
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static boolean onTouchEvent(TextView textView, Spannable spannable, MotionEvent motionEvent) {
        float f;
        float f2;
        boolean bl;
        DragState[] dragStateArray;
        switch (motionEvent.getActionMasked()) {
            default: {
                return false;
            }
            case 0: {
                DragState[] dragStateArray2 = spannable.getSpans(0, spannable.length(), DragState.class);
                int n = 0;
                while (true) {
                    if (n >= dragStateArray2.length) {
                        spannable.setSpan(new DragState(motionEvent.getX(), motionEvent.getY(), textView.getScrollX(), textView.getScrollY()), 0, 0, 17);
                        return true;
                    }
                    spannable.removeSpan(dragStateArray2[n]);
                    ++n;
                }
            }
            case 1: {
                DragState[] dragStateArray3 = spannable.getSpans(0, spannable.length(), DragState.class);
                for (int i = 0; i < dragStateArray3.length; ++i) {
                    spannable.removeSpan(dragStateArray3[i]);
                }
                return dragStateArray3.length > 0 && dragStateArray3[0].mUsed;
            }
            case 2: {
                dragStateArray = spannable.getSpans(0, spannable.length(), DragState.class);
                if (dragStateArray.length <= 0) return false;
                dragStateArray[0].mIsSelectionStarted = false;
                if (!dragStateArray[0].mFarEnough) {
                    int n = ViewConfiguration.get(textView.getContext()).getScaledTouchSlop();
                    if (Math.abs(motionEvent.getX() - dragStateArray[0].mX) >= (float)n || Math.abs(motionEvent.getY() - dragStateArray[0].mY) >= (float)n) {
                        dragStateArray[0].mFarEnough = true;
                        if (motionEvent.isButtonPressed(1)) {
                            dragStateArray[0].mIsActivelySelecting = true;
                            dragStateArray[0].mIsSelectionStarted = true;
                        }
                    }
                }
                if (!dragStateArray[0].mFarEnough) return false;
                dragStateArray[0].mUsed = true;
                bl = (1 & motionEvent.getMetaState()) != 0 || MetaKeyKeyListener.getMetaState((CharSequence)spannable, 1) == 1 || MetaKeyKeyListener.getMetaState((CharSequence)spannable, 2048) != 0;
            }
        }
        if (!motionEvent.isButtonPressed(1)) {
            dragStateArray[0].mIsActivelySelecting = false;
        }
        if (bl && motionEvent.isButtonPressed(1)) {
            f2 = motionEvent.getX() - dragStateArray[0].mX;
            f = motionEvent.getY() - dragStateArray[0].mY;
        } else {
            f2 = dragStateArray[0].mX - motionEvent.getX();
            f = dragStateArray[0].mY - motionEvent.getY();
        }
        dragStateArray[0].mX = motionEvent.getX();
        dragStateArray[0].mY = motionEvent.getY();
        int n = textView.getScrollX() + (int)f2;
        int n2 = textView.getScrollY() + (int)f;
        int n3 = textView.getTotalPaddingTop() + textView.getTotalPaddingBottom();
        Layout layout2 = textView.getLayout();
        int n4 = Math.max(Math.min(n2, layout2.getHeight() - (textView.getHeight() - n3)), 0);
        int n5 = textView.getScrollX();
        int n6 = textView.getScrollY();
        if (!motionEvent.isButtonPressed(1)) {
            Touch.scrollTo(textView, layout2, n, n4);
        }
        if (n5 == textView.getScrollX() && n6 == textView.getScrollY()) return true;
        textView.cancelLongPress();
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void scrollTo(TextView textView, Layout layout2, int n, int n2) {
        int n3;
        int n4;
        int n5;
        int n6 = textView.getTotalPaddingLeft() + textView.getTotalPaddingRight();
        int n7 = textView.getWidth() - n6;
        int n8 = layout2.getLineForVertical(n2);
        Layout.Alignment alignment = layout2.getParagraphAlignment(n8);
        boolean bl = layout2.getParagraphDirection(n8) > 0;
        if (textView.getHorizontallyScrolling()) {
            int n9 = textView.getTotalPaddingTop() + textView.getTotalPaddingBottom();
            int n10 = layout2.getLineForVertical(n2 + textView.getHeight() - n9);
            n5 = Integer.MAX_VALUE;
            n4 = 0;
            for (int i = n8; i <= n10; ++i) {
                n5 = (int)Math.min((float)n5, layout2.getLineLeft(i));
                n4 = (int)Math.max((float)n4, layout2.getLineRight(i));
            }
        } else {
            n5 = 0;
            n4 = n7;
        }
        int n11 = (n3 = n4 - n5) < n7 ? (alignment == Layout.Alignment.ALIGN_CENTER ? n5 - (n7 - n3) / 2 : (bl && alignment == Layout.Alignment.ALIGN_OPPOSITE || !bl && alignment == Layout.Alignment.ALIGN_NORMAL || alignment == Layout.Alignment.ALIGN_RIGHT ? n5 - (n7 - n3) : n5)) : Math.max(Math.min(n, n4 - n7), n5);
        textView.scrollTo(n11, n2);
    }

    private static class DragState
    implements NoCopySpan {
        public boolean mFarEnough;
        public boolean mIsActivelySelecting;
        public boolean mIsSelectionStarted;
        public int mScrollX;
        public int mScrollY;
        public boolean mUsed;
        public float mX;
        public float mY;

        public DragState(float f, float f2, int n, int n2) {
            this.mX = f;
            this.mY = f2;
            this.mScrollX = n;
            this.mScrollY = n2;
        }
    }
}

