/*
 * Decompiled with CFR 0.152.
 */
package android.text.style;

import android.os.Parcel;
import android.text.ParcelableSpan;
import android.text.TextPaint;
import android.text.style.MetricAffectingSpan;

public class AbsoluteSizeSpan
extends MetricAffectingSpan
implements ParcelableSpan {
    private boolean mDip;
    private final int mSize;

    public AbsoluteSizeSpan(int n) {
        this.mSize = n;
    }

    public AbsoluteSizeSpan(int n, boolean bl) {
        this.mSize = n;
        this.mDip = bl;
    }

    /*
     * Enabled aggressive block sorting
     */
    public AbsoluteSizeSpan(Parcel parcel) {
        this.mSize = parcel.readInt();
        boolean bl = parcel.readInt() != 0;
        this.mDip = bl;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public boolean getDip() {
        return this.mDip;
    }

    public int getSize() {
        return this.mSize;
    }

    @Override
    public int getSpanTypeId() {
        return 16;
    }

    @Override
    public void updateDrawState(TextPaint textPaint) {
        if (this.mDip) {
            textPaint.setTextSize((float)this.mSize * textPaint.density);
            return;
        }
        textPaint.setTextSize(this.mSize);
    }

    @Override
    public void updateMeasureState(TextPaint textPaint) {
        if (this.mDip) {
            textPaint.setTextSize((float)this.mSize * textPaint.density);
            return;
        }
        textPaint.setTextSize(this.mSize);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void writeToParcel(Parcel parcel, int n) {
        parcel.writeInt(this.mSize);
        int n2 = this.mDip ? 1 : 0;
        parcel.writeInt(n2);
    }
}

