/*
 * Decompiled with CFR 0.152.
 */
package android.text.style;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.text.style.DynamicDrawableSpan;
import android.util.Log;

public class ImageSpan
extends DynamicDrawableSpan {
    private Uri mContentUri;
    private Context mContext;
    private Drawable mDrawable;
    private int mResourceId;
    private String mSource;

    public ImageSpan(Context context, int n) {
        this(context, n, 0);
    }

    public ImageSpan(Context context, int n, int n2) {
        super(n2);
        this.mContext = context;
        this.mResourceId = n;
    }

    public ImageSpan(Context context, Bitmap bitmap) {
        this(context, bitmap, 0);
    }

    /*
     * Enabled aggressive block sorting
     */
    public ImageSpan(Context context, Bitmap bitmap, int n) {
        super(n);
        this.mContext = context;
        BitmapDrawable bitmapDrawable = context != null ? new BitmapDrawable(context.getResources(), bitmap) : new BitmapDrawable(bitmap);
        this.mDrawable = bitmapDrawable;
        int n2 = this.mDrawable.getIntrinsicWidth();
        int n3 = this.mDrawable.getIntrinsicHeight();
        Drawable drawable2 = this.mDrawable;
        if (n2 <= 0) {
            n2 = 0;
        }
        if (n3 <= 0) {
            n3 = 0;
        }
        drawable2.setBounds(0, 0, n2, n3);
    }

    public ImageSpan(Context context, Uri uri) {
        this(context, uri, 0);
    }

    public ImageSpan(Context context, Uri uri, int n) {
        super(n);
        this.mContext = context;
        this.mContentUri = uri;
        this.mSource = uri.toString();
    }

    @Deprecated
    public ImageSpan(Bitmap bitmap) {
        this(null, bitmap, 0);
    }

    @Deprecated
    public ImageSpan(Bitmap bitmap, int n) {
        this(null, bitmap, n);
    }

    public ImageSpan(Drawable drawable2) {
        this(drawable2, 0);
    }

    public ImageSpan(Drawable drawable2, int n) {
        super(n);
        this.mDrawable = drawable2;
    }

    public ImageSpan(Drawable drawable2, String string2) {
        this(drawable2, string2, 0);
    }

    public ImageSpan(Drawable drawable2, String string2, int n) {
        super(n);
        this.mDrawable = drawable2;
        this.mSource = string2;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public Drawable getDrawable() {
        var1_1 = null;
        if (this.mDrawable != null) {
            return this.mDrawable;
        }
        if (this.mContentUri != null) {
            try {
                var6_2 = this.mContext.getContentResolver().openInputStream(this.mContentUri);
                var7_3 = BitmapFactory.decodeStream(var6_2);
                var8_4 = new BitmapDrawable(this.mContext.getResources(), var7_3);
            }
            catch (Exception var4_5) lbl-1000:
            // 2 sources

            {
                while (true) {
                    Log.e("sms", "Failed to loaded content " + this.mContentUri, (Throwable)var4_6);
                    return var1_1;
                }
            }
            var8_4.setBounds(0, 0, var8_4.getIntrinsicWidth(), var8_4.getIntrinsicHeight());
            var6_2.close();
            return var8_4;
        }
        try {
            var1_1 = this.mContext.getDrawable(this.mResourceId);
            var1_1.setBounds(0, 0, var1_1.getIntrinsicWidth(), var1_1.getIntrinsicHeight());
            return var1_1;
        }
        catch (Exception var2_8) {
            Log.e("sms", "Unable to find resource: " + this.mResourceId);
            return var1_1;
        }
        catch (Exception var4_7) {
            var1_1 = var8_4;
            ** continue;
        }
    }

    public String getSource() {
        return this.mSource;
    }
}

