/*
 * Decompiled with CFR 0.152.
 */
package android.text.style;

import android.graphics.Paint;
import android.os.Parcel;
import android.text.ParcelableSpan;
import android.text.TextPaint;
import android.text.style.MetricAffectingSpan;
import java.util.Locale;

public class LocaleSpan
extends MetricAffectingSpan
implements ParcelableSpan {
    private final Locale mLocale;

    public LocaleSpan(Parcel parcel) {
        this.mLocale = new Locale(parcel.readString(), parcel.readString(), parcel.readString());
    }

    public LocaleSpan(Locale locale) {
        this.mLocale = locale;
    }

    private static void apply(Paint paint, Locale locale) {
        paint.setTextLocale(locale);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public Locale getLocale() {
        return this.mLocale;
    }

    @Override
    public int getSpanTypeId() {
        return 23;
    }

    @Override
    public void updateDrawState(TextPaint textPaint) {
        LocaleSpan.apply(textPaint, this.mLocale);
    }

    @Override
    public void updateMeasureState(TextPaint textPaint) {
        LocaleSpan.apply(textPaint, this.mLocale);
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        parcel.writeString(this.mLocale.getLanguage());
        parcel.writeString(this.mLocale.getCountry());
        parcel.writeString(this.mLocale.getVariant());
    }
}

