/*
 * Decompiled with CFR 0.152.
 */
package android.util;

import com.android.internal.os.RuntimeInit;
import com.android.internal.util.FastPrintWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.UnknownHostException;

public final class Log {
    public static final int ASSERT = 7;
    public static final int DEBUG = 3;
    public static final int ERROR = 6;
    public static final int INFO = 4;
    public static final int LOG_ID_CRASH = 4;
    public static final int LOG_ID_EVENTS = 2;
    public static final int LOG_ID_MAIN = 0;
    public static final int LOG_ID_RADIO = 1;
    public static final int LOG_ID_SYSTEM = 3;
    public static final int VERBOSE = 2;
    public static final int WARN = 5;
    private static TerribleFailureHandler sWtfHandler = new TerribleFailureHandler(){

        @Override
        public void onTerribleFailure(String string2, TerribleFailure terribleFailure, boolean bl) {
            RuntimeInit.wtf(string2, terribleFailure, bl);
        }
    };

    private Log() {
    }

    public static int d(String string2, String string3) {
        return Log.println_native(0, 3, string2, string3);
    }

    public static int d(String string2, String string3, Throwable throwable) {
        return Log.println_native(0, 3, string2, string3 + '\n' + Log.getStackTraceString(throwable));
    }

    public static int e(String string2, String string3) {
        return Log.println_native(0, 6, string2, string3);
    }

    public static int e(String string2, String string3, Throwable throwable) {
        return Log.println_native(0, 6, string2, string3 + '\n' + Log.getStackTraceString(throwable));
    }

    public static String getStackTraceString(Throwable throwable) {
        if (throwable == null) {
            return "";
        }
        for (Throwable throwable2 = throwable; throwable2 != null; throwable2 = throwable2.getCause()) {
            if (!(throwable2 instanceof UnknownHostException)) continue;
            return "";
        }
        StringWriter stringWriter = new StringWriter();
        FastPrintWriter fastPrintWriter = new FastPrintWriter(stringWriter, false, 256);
        throwable.printStackTrace(fastPrintWriter);
        ((PrintWriter)fastPrintWriter).flush();
        return stringWriter.toString();
    }

    public static int i(String string2, String string3) {
        return Log.println_native(0, 4, string2, string3);
    }

    public static int i(String string2, String string3, Throwable throwable) {
        return Log.println_native(0, 4, string2, string3 + '\n' + Log.getStackTraceString(throwable));
    }

    public static native boolean isLoggable(String var0, int var1);

    public static int println(int n, String string2, String string3) {
        return Log.println_native(0, n, string2, string3);
    }

    public static native int println_native(int var0, int var1, String var2, String var3);

    public static TerribleFailureHandler setWtfHandler(TerribleFailureHandler terribleFailureHandler) {
        if (terribleFailureHandler == null) {
            throw new NullPointerException("handler == null");
        }
        TerribleFailureHandler terribleFailureHandler2 = sWtfHandler;
        sWtfHandler = terribleFailureHandler;
        return terribleFailureHandler2;
    }

    public static int v(String string2, String string3) {
        return Log.println_native(0, 2, string2, string3);
    }

    public static int v(String string2, String string3, Throwable throwable) {
        return Log.println_native(0, 2, string2, string3 + '\n' + Log.getStackTraceString(throwable));
    }

    public static int w(String string2, String string3) {
        return Log.println_native(0, 5, string2, string3);
    }

    public static int w(String string2, String string3, Throwable throwable) {
        return Log.println_native(0, 5, string2, string3 + '\n' + Log.getStackTraceString(throwable));
    }

    public static int w(String string2, Throwable throwable) {
        return Log.println_native(0, 5, string2, Log.getStackTraceString(throwable));
    }

    static int wtf(int n, String string2, String string3, Throwable throwable, boolean bl, boolean bl2) {
        TerribleFailure terribleFailure = new TerribleFailure(string3, throwable);
        StringBuilder stringBuilder = new StringBuilder().append(string3).append('\n');
        if (bl) {
            throwable = terribleFailure;
        }
        int n2 = Log.println_native(n, 7, string2, stringBuilder.append(Log.getStackTraceString(throwable)).toString());
        sWtfHandler.onTerribleFailure(string2, terribleFailure, bl2);
        return n2;
    }

    public static int wtf(String string2, String string3) {
        return Log.wtf(0, string2, string3, null, false, false);
    }

    public static int wtf(String string2, String string3, Throwable throwable) {
        return Log.wtf(0, string2, string3, throwable, false, false);
    }

    public static int wtf(String string2, Throwable throwable) {
        return Log.wtf(0, string2, throwable.getMessage(), throwable, false, false);
    }

    public static int wtfStack(String string2, String string3) {
        return Log.wtf(0, string2, string3, null, true, false);
    }

    private static class TerribleFailure
    extends Exception {
        TerribleFailure(String string2, Throwable throwable) {
            super(string2, throwable);
        }
    }

    public static interface TerribleFailureHandler {
        public void onTerribleFailure(String var1, TerribleFailure var2, boolean var3);
    }
}

