/*
 * Decompiled with CFR 0.152.
 */
package android.util;

import android.util.ContainerHelpers;
import com.android.internal.util.ArrayUtils;
import com.android.internal.util.GrowingArrayUtils;
import libcore.util.EmptyArray;

public class LongSparseLongArray
implements Cloneable {
    private long[] mKeys;
    private int mSize;
    private long[] mValues;

    public LongSparseLongArray() {
        this(10);
    }

    /*
     * Enabled aggressive block sorting
     */
    public LongSparseLongArray(int n) {
        if (n == 0) {
            this.mKeys = EmptyArray.LONG;
            this.mValues = EmptyArray.LONG;
        } else {
            this.mKeys = ArrayUtils.newUnpaddedLongArray(n);
            this.mValues = new long[this.mKeys.length];
        }
        this.mSize = 0;
    }

    public void append(long l, long l2) {
        if (this.mSize != 0 && l <= this.mKeys[-1 + this.mSize]) {
            this.put(l, l2);
            return;
        }
        this.mKeys = GrowingArrayUtils.append(this.mKeys, this.mSize, l);
        this.mValues = GrowingArrayUtils.append(this.mValues, this.mSize, l2);
        this.mSize = 1 + this.mSize;
    }

    public void clear() {
        this.mSize = 0;
    }

    public LongSparseLongArray clone() {
        LongSparseLongArray longSparseLongArray = null;
        try {
            longSparseLongArray = (LongSparseLongArray)super.clone();
            longSparseLongArray.mKeys = (long[])this.mKeys.clone();
            longSparseLongArray.mValues = (long[])this.mValues.clone();
            return longSparseLongArray;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return longSparseLongArray;
        }
    }

    public void delete(long l) {
        int n = ContainerHelpers.binarySearch(this.mKeys, this.mSize, l);
        if (n >= 0) {
            this.removeAt(n);
        }
    }

    public long get(long l) {
        return this.get(l, 0L);
    }

    public long get(long l, long l2) {
        int n = ContainerHelpers.binarySearch(this.mKeys, this.mSize, l);
        if (n < 0) {
            return l2;
        }
        return this.mValues[n];
    }

    public int indexOfKey(long l) {
        return ContainerHelpers.binarySearch(this.mKeys, this.mSize, l);
    }

    public int indexOfValue(long l) {
        for (int i = 0; i < this.mSize; ++i) {
            if (this.mValues[i] != l) continue;
            return i;
        }
        return -1;
    }

    public long keyAt(int n) {
        return this.mKeys[n];
    }

    public void put(long l, long l2) {
        int n = ContainerHelpers.binarySearch(this.mKeys, this.mSize, l);
        if (n >= 0) {
            this.mValues[n] = l2;
            return;
        }
        int n2 = ~n;
        this.mKeys = GrowingArrayUtils.insert(this.mKeys, this.mSize, n2, l);
        this.mValues = GrowingArrayUtils.insert(this.mValues, this.mSize, n2, l2);
        this.mSize = 1 + this.mSize;
    }

    public void removeAt(int n) {
        System.arraycopy((long[])this.mKeys, (int)(n + 1), (long[])this.mKeys, (int)n, (int)(this.mSize - (n + 1)));
        System.arraycopy((long[])this.mValues, (int)(n + 1), (long[])this.mValues, (int)n, (int)(this.mSize - (n + 1)));
        this.mSize = -1 + this.mSize;
    }

    public int size() {
        return this.mSize;
    }

    public String toString() {
        if (this.size() <= 0) {
            return "{}";
        }
        StringBuilder stringBuilder = new StringBuilder(28 * this.mSize);
        stringBuilder.append('{');
        for (int i = 0; i < this.mSize; ++i) {
            if (i > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(this.keyAt(i));
            stringBuilder.append('=');
            stringBuilder.append(this.valueAt(i));
        }
        stringBuilder.append('}');
        return stringBuilder.toString();
    }

    public long valueAt(int n) {
        return this.mValues[n];
    }
}

