/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.graphics.Point;
import android.graphics.Rect;
import android.graphics.Region;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.Process;
import android.os.RemoteException;
import android.util.LongSparseArray;
import android.view.MagnificationSpec;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.ViewRootImpl;
import android.view.accessibility.AccessibilityInteractionClient;
import android.view.accessibility.AccessibilityNodeInfo;
import android.view.accessibility.AccessibilityNodeProvider;
import android.view.accessibility.IAccessibilityInteractionConnectionCallback;
import com.android.internal.os.SomeArgs;
import com.android.internal.util.Predicate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;

final class AccessibilityInteractionController {
    private static final boolean ENFORCE_NODE_TREE_CONSISTENT;
    private AddNodeInfosForViewId mAddNodeInfosForViewId;
    private final Handler mHandler;
    private final long mMyLooperThreadId;
    private final int mMyProcessId;
    private final AccessibilityNodePrefetcher mPrefetcher;
    private final ArrayList<AccessibilityNodeInfo> mTempAccessibilityNodeInfoList = new ArrayList();
    private final ArrayList<View> mTempArrayList = new ArrayList();
    private final Point mTempPoint = new Point();
    private final Rect mTempRect = new Rect();
    private final Rect mTempRect1 = new Rect();
    private final Rect mTempRect2 = new Rect();
    private final ViewRootImpl mViewRootImpl;

    public AccessibilityInteractionController(ViewRootImpl viewRootImpl) {
        Looper looper = viewRootImpl.mHandler.getLooper();
        this.mMyLooperThreadId = looper.getThread().getId();
        this.mMyProcessId = Process.myPid();
        this.mHandler = new PrivateHandler(looper);
        this.mViewRootImpl = viewRootImpl;
        this.mPrefetcher = new AccessibilityNodePrefetcher();
    }

    /*
     * Enabled aggressive block sorting
     */
    private void adjustIsVisibleToUserIfNeeded(AccessibilityNodeInfo accessibilityNodeInfo, Region region) {
        block3: {
            block2: {
                if (region == null || accessibilityNodeInfo == null) break block2;
                Rect rect = this.mTempRect;
                accessibilityNodeInfo.getBoundsInScreen(rect);
                if (region.quickReject(rect)) break block3;
            }
            return;
        }
        accessibilityNodeInfo.setVisibleToUser(false);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void adjustIsVisibleToUserIfNeeded(List<AccessibilityNodeInfo> list, Region region) {
        if (region != null && list != null) {
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                this.adjustIsVisibleToUserIfNeeded(list.get(i), region);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void applyAppScaleAndMagnificationSpecIfNeeded(Point point, MagnificationSpec magnificationSpec) {
        block5: {
            block4: {
                float f = this.mViewRootImpl.mAttachInfo.mApplicationScale;
                if (!this.shouldApplyAppScaleAndMagnificationSpec(f, magnificationSpec)) break block4;
                if (f != 1.0f) {
                    point.x = (int)(f * (float)point.x);
                    point.y = (int)(f * (float)point.y);
                }
                if (magnificationSpec != null) break block5;
            }
            return;
        }
        point.x = (int)((float)point.x * magnificationSpec.scale);
        point.y = (int)((float)point.y * magnificationSpec.scale);
        point.x += (int)magnificationSpec.offsetX;
        point.y += (int)magnificationSpec.offsetY;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void applyAppScaleAndMagnificationSpecIfNeeded(AccessibilityNodeInfo accessibilityNodeInfo, MagnificationSpec magnificationSpec) {
        block6: {
            block5: {
                float f;
                if (accessibilityNodeInfo == null || !this.shouldApplyAppScaleAndMagnificationSpec(f = this.mViewRootImpl.mAttachInfo.mApplicationScale, magnificationSpec)) break block5;
                Rect rect = this.mTempRect;
                Rect rect2 = this.mTempRect1;
                accessibilityNodeInfo.getBoundsInParent(rect);
                accessibilityNodeInfo.getBoundsInScreen(rect2);
                if (f != 1.0f) {
                    rect.scale(f);
                    rect2.scale(f);
                }
                if (magnificationSpec != null) {
                    rect.scale(magnificationSpec.scale);
                    rect2.scale(magnificationSpec.scale);
                    rect2.offset((int)magnificationSpec.offsetX, (int)magnificationSpec.offsetY);
                }
                accessibilityNodeInfo.setBoundsInParent(rect);
                accessibilityNodeInfo.setBoundsInScreen(rect2);
                if (magnificationSpec == null) break block5;
                View.AttachInfo attachInfo = this.mViewRootImpl.mAttachInfo;
                if (attachInfo.mDisplay == null) break block5;
                float f2 = attachInfo.mApplicationScale * magnificationSpec.scale;
                Rect rect3 = this.mTempRect1;
                rect3.left = (int)(f2 * (float)attachInfo.mWindowLeft + magnificationSpec.offsetX);
                rect3.top = (int)(f2 * (float)attachInfo.mWindowTop + magnificationSpec.offsetY);
                rect3.right = (int)((float)rect3.left + f2 * (float)this.mViewRootImpl.mWidth);
                rect3.bottom = (int)((float)rect3.top + f2 * (float)this.mViewRootImpl.mHeight);
                attachInfo.mDisplay.getRealSize(this.mTempPoint);
                int n = this.mTempPoint.x;
                int n2 = this.mTempPoint.y;
                Rect rect4 = this.mTempRect2;
                rect4.set(0, 0, n, n2);
                rect3.intersect(rect4);
                if (!rect3.intersects(rect2.left, rect2.top, rect2.right, rect2.bottom)) break block6;
            }
            return;
        }
        accessibilityNodeInfo.setVisibleToUser(false);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void applyAppScaleAndMagnificationSpecIfNeeded(List<AccessibilityNodeInfo> list, MagnificationSpec magnificationSpec) {
        if (list != null && this.shouldApplyAppScaleAndMagnificationSpec(this.mViewRootImpl.mAttachInfo.mApplicationScale, magnificationSpec)) {
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                this.applyAppScaleAndMagnificationSpecIfNeeded(list.get(i), magnificationSpec);
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private void computeClickPointInScreenUiThread(Message var1_1) {
        block28: {
            block29: {
                block26: {
                    block27: {
                        var2_2 = (SomeArgs)var1_1.obj;
                        var3_3 = var2_2.argi1;
                        var4_4 = var2_2.argi2;
                        var5_5 = var2_2.argi3;
                        var6_6 = (IAccessibilityInteractionConnectionCallback)var2_2.arg1;
                        var7_7 = (MagnificationSpec)var2_2.arg2;
                        var8_8 = (Region)var2_2.arg3;
                        var2_2.recycle();
                        var9_9 = false;
                        var10_10 = this.mTempPoint;
                        if (this.mViewRootImpl.mView != null && (var16_11 = this.mViewRootImpl.mAttachInfo) != null) break block26;
                        var14_12 = null;
                        if (!false) break block27;
                        this.applyAppScaleAndMagnificationSpecIfNeeded(var10_10, var7_7);
                        var14_12 = var10_10;
                    }
                    var6_6.setComputeClickPointInScreenActionResult(var14_12, var5_5);
                    return;
                }
                if (var3_3 == 0x7FFFFFFF) break block29;
                var17_13 = this.findViewByAccessibilityId(var3_3);
lbl26:
                // 2 sources

                while (true) {
                    var9_9 = false;
                    if (var17_13 == null) ** GOTO lbl48
                    var18_14 = this.isShown(var17_13);
                    var9_9 = false;
                    if (!var18_14) ** GOTO lbl48
                    var19_15 = var17_13.getAccessibilityNodeProvider();
                    if (var19_15 == null) break block28;
                    var9_9 = false;
                    if (var4_4 == 0x7FFFFFFF) ** GOTO lbl63
                    var20_16 = var19_15.createAccessibilityNodeInfo(var4_4);
lbl40:
                    // 2 sources

                    while (true) {
                        var9_9 = false;
                        if (var20_16 != null) {
                            var9_9 = true;
                            var23_17 = this.mTempRect;
                            var20_16.getBoundsInScreen(var23_17);
                            var10_10.set(var23_17.centerX(), var23_17.centerY());
                        }
lbl48:
                        // 7 sources

                        while (true) {
                            var21_18 = null;
                            if (var9_9) {
                                this.applyAppScaleAndMagnificationSpecIfNeeded(var10_10, var7_7);
                                var21_18 = var10_10;
                            }
                            try {
                                var6_6.setComputeClickPointInScreenActionResult(var21_18, var5_5);
                                return;
                            }
                            catch (RemoteException var22_19) {
                                return;
                            }
                            break;
                        }
                        break;
                    }
                    break;
                }
            }
            var17_13 = this.mViewRootImpl.mView;
            ** continue;
lbl63:
            // 1 sources

            var20_16 = var19_15.createAccessibilityNodeInfo(-1);
            ** continue;
        }
        var9_9 = false;
        if (var4_4 != 0x7FFFFFFF) ** GOTO lbl48
        try {
            var9_9 = var24_20 = var17_13.computeClickPointInScreenForAccessibility(var8_8, var10_10);
            ** continue;
        }
        catch (Throwable var11_21) {
            var12_22 = null;
            if (var9_9) {
                this.applyAppScaleAndMagnificationSpecIfNeeded(var10_10, var7_7);
                var12_22 = var10_10;
            }
            try {
                var6_6.setComputeClickPointInScreenActionResult(var12_22, var5_5);
            }
            catch (RemoteException var13_23) {
                ** continue;
            }
lbl81:
            // 2 sources

            throw var11_21;
        }
        catch (RemoteException var15_24) {
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void findAccessibilityNodeInfoByAccessibilityIdUiThread(Message message) {
        ArrayList<AccessibilityNodeInfo> arrayList;
        Region region;
        MagnificationSpec magnificationSpec;
        IAccessibilityInteractionConnectionCallback iAccessibilityInteractionConnectionCallback;
        int n;
        block16: {
            View view;
            int n2;
            int n3;
            int n4;
            block15: {
                n4 = message.arg1;
                SomeArgs someArgs = (SomeArgs)message.obj;
                n3 = someArgs.argi1;
                n2 = someArgs.argi2;
                n = someArgs.argi3;
                iAccessibilityInteractionConnectionCallback = (IAccessibilityInteractionConnectionCallback)someArgs.arg1;
                magnificationSpec = (MagnificationSpec)someArgs.arg2;
                region = (Region)someArgs.arg3;
                someArgs.recycle();
                arrayList = this.mTempAccessibilityNodeInfoList;
                arrayList.clear();
                try {
                    View.AttachInfo attachInfo;
                    if (this.mViewRootImpl.mView != null && (attachInfo = this.mViewRootImpl.mAttachInfo) != null) break block15;
                }
                catch (Throwable throwable) {
                    try {
                        this.mViewRootImpl.mAttachInfo.mAccessibilityFetchFlags = 0;
                        this.applyAppScaleAndMagnificationSpecIfNeeded(arrayList, magnificationSpec);
                        if (magnificationSpec != null) {
                            magnificationSpec.recycle();
                        }
                        this.adjustIsVisibleToUserIfNeeded(arrayList, region);
                        iAccessibilityInteractionConnectionCallback.setFindAccessibilityNodeInfosResult(arrayList, n);
                        arrayList.clear();
                    }
                    catch (RemoteException remoteException) {
                        throw throwable;
                    }
                    throw throwable;
                }
                try {
                    this.mViewRootImpl.mAttachInfo.mAccessibilityFetchFlags = 0;
                    this.applyAppScaleAndMagnificationSpecIfNeeded(arrayList, magnificationSpec);
                    if (magnificationSpec != null) {
                        magnificationSpec.recycle();
                    }
                    this.adjustIsVisibleToUserIfNeeded(arrayList, region);
                    iAccessibilityInteractionConnectionCallback.setFindAccessibilityNodeInfosResult(arrayList, n);
                    arrayList.clear();
                    return;
                }
                catch (RemoteException remoteException) {
                    return;
                }
            }
            this.mViewRootImpl.mAttachInfo.mAccessibilityFetchFlags = n4;
            if (n3 == Integer.MAX_VALUE) {
                view = this.mViewRootImpl.mView;
            } else {
                View view2;
                view = view2 = this.findViewByAccessibilityId(n3);
            }
            if (view == null || !this.isShown(view)) break block16;
            this.mPrefetcher.prefetchAccessibilityNodeInfos(view, n2, n4, arrayList);
        }
        try {
            this.mViewRootImpl.mAttachInfo.mAccessibilityFetchFlags = 0;
            this.applyAppScaleAndMagnificationSpecIfNeeded(arrayList, magnificationSpec);
            if (magnificationSpec != null) {
                magnificationSpec.recycle();
            }
            this.adjustIsVisibleToUserIfNeeded(arrayList, region);
            iAccessibilityInteractionConnectionCallback.setFindAccessibilityNodeInfosResult(arrayList, n);
            arrayList.clear();
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    /*
     * Unable to fully structure code
     */
    private void findAccessibilityNodeInfosByTextUiThread(Message var1_1) {
        block30: {
            block29: {
                block27: {
                    block26: {
                        var2_2 = var1_1.arg1;
                        var3_3 = (SomeArgs)var1_1.obj;
                        var4_4 = (String)var3_3.arg1;
                        var5_5 = (IAccessibilityInteractionConnectionCallback)var3_3.arg2;
                        var6_6 = (MagnificationSpec)var3_3.arg3;
                        var7_7 = var3_3.argi1;
                        var8_8 = var3_3.argi2;
                        var9_9 = var3_3.argi3;
                        var10_10 = (Region)var3_3.arg4;
                        var3_3.recycle();
                        var11_11 = null;
                        if (this.mViewRootImpl.mView != null && (var15_12 = this.mViewRootImpl.mAttachInfo) != null) break block26;
                        this.mViewRootImpl.mAttachInfo.mAccessibilityFetchFlags = 0;
                        this.applyAppScaleAndMagnificationSpecIfNeeded((List<AccessibilityNodeInfo>)null, var6_6);
                        if (var6_6 == null) ** GOTO lbl20
                        var6_6.recycle();
lbl20:
                        // 2 sources

                        this.adjustIsVisibleToUserIfNeeded((List<AccessibilityNodeInfo>)null, var10_10);
                        var5_5.setFindAccessibilityNodeInfosResult(null, var9_9);
                        return;
                    }
                    this.mViewRootImpl.mAttachInfo.mAccessibilityFetchFlags = var2_2;
                    if (var7_7 == 0x7FFFFFFF) break block27;
                    var16_13 = this.findViewByAccessibilityId(var7_7);
lbl29:
                    // 2 sources

                    while (true) {
                        block28: {
                            var11_11 = null;
                            if (var16_13 == null) break block28;
                            var17_14 = this.isShown(var16_13);
                            var11_11 = null;
                            if (!var17_14) break block28;
                            var18_15 = var16_13.getAccessibilityNodeProvider();
                            if (var18_15 == null) break block29;
                            if (var8_8 == 0x7FFFFFFF) ** GOTO lbl59
                            var11_11 = var29_16 = var18_15.findAccessibilityNodeInfosByText(var4_4, var8_8);
                        }
lbl43:
                        // 5 sources

                        while (true) {
                            try {
                                this.mViewRootImpl.mAttachInfo.mAccessibilityFetchFlags = 0;
                                this.applyAppScaleAndMagnificationSpecIfNeeded(var11_11, var6_6);
                                if (var6_6 == null) ** GOTO lbl52
                            }
                            catch (RemoteException var28_17) {
                                return;
                            }
                            var6_6.recycle();
lbl52:
                            // 2 sources

                            this.adjustIsVisibleToUserIfNeeded(var11_11, var10_10);
                            var5_5.setFindAccessibilityNodeInfosResult(var11_11, var9_9);
                            return;
                            break;
                        }
                        break;
                    }
                }
                var16_13 = this.mViewRootImpl.mView;
                ** continue;
lbl59:
                // 1 sources

                var11_11 = var18_15.findAccessibilityNodeInfosByText(var4_4, -1);
                ** GOTO lbl43
            }
            var11_11 = null;
            if (var8_8 != 0x7FFFFFFF) ** GOTO lbl43
            var19_18 = this.mTempArrayList;
            var19_18.clear();
            var16_13.findViewsWithText(var19_18, var4_4, 7);
            var20_19 = var19_18.isEmpty();
            var11_11 = null;
            if (var20_19) ** GOTO lbl43
            var11_11 = this.mTempAccessibilityNodeInfoList;
            var11_11.clear();
            var21_20 = var19_18.size();
            var22_21 = 0;
lbl76:
            // 2 sources

            while (true) {
                if (var22_21 < var21_20) ** break;
                ** continue;
                try {
                    var23_22 = var19_18.get(var22_21);
                    if (!this.isShown(var23_22)) break block30;
                    var24_23 = var23_22.getAccessibilityNodeProvider();
                    if (var24_23 == null) ** GOTO lbl104
                }
                catch (Throwable var12_25) {
                    this.mViewRootImpl.mAttachInfo.mAccessibilityFetchFlags = 0;
                    this.applyAppScaleAndMagnificationSpecIfNeeded(var11_11, var6_6);
                    if (var6_6 == null) ** GOTO lbl91
                    try {
                        var6_6.recycle();
lbl91:
                        // 2 sources

                        this.adjustIsVisibleToUserIfNeeded(var11_11, var10_10);
                        var5_5.setFindAccessibilityNodeInfosResult(var11_11, var9_9);
                    }
                    catch (RemoteException var13_26) {
                        ** continue;
                    }
lbl95:
                    // 2 sources

                    throw var12_25;
                }
                var25_24 = var24_23.findAccessibilityNodeInfosByText(var4_4, -1);
                if (var25_24 == null) break block30;
                var11_11.addAll(var25_24);
                break block30;
lbl104:
                // 1 sources

                var11_11.add(var23_22.createAccessibilityNodeInfo());
                break block30;
                break;
            }
            catch (RemoteException var14_27) {
                return;
            }
        }
        ++var22_21;
        ** while (true)
    }

    /*
     * Unable to fully structure code
     */
    private void findAccessibilityNodeInfosByViewIdUiThread(Message var1_1) {
        block23: {
            block22: {
                block21: {
                    var2_2 = var1_1.arg1;
                    var3_3 = var1_1.arg2;
                    var4_4 = (SomeArgs)var1_1.obj;
                    var5_5 = var4_4.argi1;
                    var6_6 = (IAccessibilityInteractionConnectionCallback)var4_4.arg1;
                    var7_7 = (MagnificationSpec)var4_4.arg2;
                    var8_8 = (String)var4_4.arg3;
                    var9_9 = (Region)var4_4.arg4;
                    var4_4.recycle();
                    var10_10 = this.mTempAccessibilityNodeInfoList;
                    var10_10.clear();
                    if (this.mViewRootImpl.mView != null && (var14_11 = this.mViewRootImpl.mAttachInfo) != null) break block21;
                    this.mViewRootImpl.mAttachInfo.mAccessibilityFetchFlags = 0;
                    this.applyAppScaleAndMagnificationSpecIfNeeded(var10_10, var7_7);
                    if (var7_7 == null) ** GOTO lbl20
                    var7_7.recycle();
lbl20:
                    // 2 sources

                    this.adjustIsVisibleToUserIfNeeded(var10_10, var9_9);
                    var6_6.setFindAccessibilityNodeInfosResult(var10_10, var5_5);
                    return;
                }
                this.mViewRootImpl.mAttachInfo.mAccessibilityFetchFlags = var2_2;
                if (var3_3 == 0x7FFFFFFF) break block22;
                var15_12 = this.findViewByAccessibilityId(var3_3);
lbl29:
                // 2 sources

                while (var15_12 != null) {
                    var16_13 = var15_12.getContext().getResources().getIdentifier(var8_8, null, null);
                    if (var16_13 > 0) ** GOTO lbl49
                    try {
                        this.mViewRootImpl.mAttachInfo.mAccessibilityFetchFlags = 0;
                        this.applyAppScaleAndMagnificationSpecIfNeeded(var10_10, var7_7);
                        if (var7_7 == null) ** GOTO lbl41
                    }
                    catch (RemoteException var19_14) {
                        return;
                    }
                    var7_7.recycle();
lbl41:
                    // 2 sources

                    this.adjustIsVisibleToUserIfNeeded(var10_10, var9_9);
                    var6_6.setFindAccessibilityNodeInfosResult(var10_10, var5_5);
                    return;
                }
                break block23;
            }
            var15_12 = this.mViewRootImpl.mView;
            ** GOTO lbl29
lbl49:
            // 1 sources

            if (this.mAddNodeInfosForViewId == null) {
                this.mAddNodeInfosForViewId = new AddNodeInfosForViewId();
            }
            this.mAddNodeInfosForViewId.init(var16_13, var10_10);
            var15_12.findViewByPredicate(this.mAddNodeInfosForViewId);
            this.mAddNodeInfosForViewId.reset();
        }
        try {
            this.mViewRootImpl.mAttachInfo.mAccessibilityFetchFlags = 0;
            this.applyAppScaleAndMagnificationSpecIfNeeded(var10_10, var7_7);
            if (var7_7 == null) ** GOTO lbl64
        }
        catch (RemoteException var18_15) {
            return;
        }
        var7_7.recycle();
lbl64:
        // 2 sources

        this.adjustIsVisibleToUserIfNeeded(var10_10, var9_9);
        var6_6.setFindAccessibilityNodeInfosResult(var10_10, var5_5);
        return;
        catch (Throwable var11_16) {
            this.mViewRootImpl.mAttachInfo.mAccessibilityFetchFlags = 0;
            this.applyAppScaleAndMagnificationSpecIfNeeded(var10_10, var7_7);
            if (var7_7 == null) ** GOTO lbl74
            try {
                var7_7.recycle();
lbl74:
                // 2 sources

                this.adjustIsVisibleToUserIfNeeded(var10_10, var9_9);
                var6_6.setFindAccessibilityNodeInfosResult(var10_10, var5_5);
            }
            catch (RemoteException var12_17) {
                ** continue;
            }
lbl78:
            // 2 sources

            throw var11_16;
        }
        catch (RemoteException var13_18) {
            return;
        }
    }

    /*
     * Exception decompiling
     */
    private void findFocusUiThread(Message var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 9[TRYBLOCK] [11 : 305->326)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private View findViewByAccessibilityId(int n) {
        View view = this.mViewRootImpl.mView;
        if (view == null) {
            return null;
        }
        View view2 = view.findViewByAccessibilityId(n);
        if (view2 == null) return view2;
        if (this.isShown(view2)) return view2;
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void focusSearchUiThread(Message message) {
        AccessibilityNodeInfo accessibilityNodeInfo;
        Region region;
        MagnificationSpec magnificationSpec;
        IAccessibilityInteractionConnectionCallback iAccessibilityInteractionConnectionCallback;
        int n;
        block16: {
            AccessibilityNodeInfo accessibilityNodeInfo2;
            View view;
            int n2;
            int n3;
            int n4;
            block15: {
                n4 = message.arg1;
                n3 = message.arg2;
                SomeArgs someArgs = (SomeArgs)message.obj;
                n2 = someArgs.argi2;
                n = someArgs.argi3;
                iAccessibilityInteractionConnectionCallback = (IAccessibilityInteractionConnectionCallback)someArgs.arg1;
                magnificationSpec = (MagnificationSpec)someArgs.arg2;
                region = (Region)someArgs.arg3;
                someArgs.recycle();
                try {
                    View.AttachInfo attachInfo;
                    if (this.mViewRootImpl.mView != null && (attachInfo = this.mViewRootImpl.mAttachInfo) != null) break block15;
                }
                catch (Throwable throwable) {
                    try {
                        this.mViewRootImpl.mAttachInfo.mAccessibilityFetchFlags = 0;
                        this.applyAppScaleAndMagnificationSpecIfNeeded((AccessibilityNodeInfo)null, magnificationSpec);
                        if (magnificationSpec != null) {
                            magnificationSpec.recycle();
                        }
                        this.adjustIsVisibleToUserIfNeeded((AccessibilityNodeInfo)null, region);
                        iAccessibilityInteractionConnectionCallback.setFindAccessibilityNodeInfoResult(null, n);
                    }
                    catch (RemoteException remoteException) {
                        throw throwable;
                    }
                    throw throwable;
                }
                try {
                    this.mViewRootImpl.mAttachInfo.mAccessibilityFetchFlags = 0;
                    this.applyAppScaleAndMagnificationSpecIfNeeded((AccessibilityNodeInfo)null, magnificationSpec);
                    if (magnificationSpec != null) {
                        magnificationSpec.recycle();
                    }
                    this.adjustIsVisibleToUserIfNeeded((AccessibilityNodeInfo)null, region);
                    iAccessibilityInteractionConnectionCallback.setFindAccessibilityNodeInfoResult(null, n);
                    return;
                }
                catch (RemoteException remoteException) {
                    return;
                }
            }
            this.mViewRootImpl.mAttachInfo.mAccessibilityFetchFlags = n4;
            if (n3 != Integer.MAX_VALUE) {
                view = this.findViewByAccessibilityId(n3);
            } else {
                view = this.mViewRootImpl.mView;
            }
            accessibilityNodeInfo = null;
            if (view == null) break block16;
            boolean bl = this.isShown(view);
            accessibilityNodeInfo = null;
            if (!bl) break block16;
            View view2 = view.focusSearch(n2);
            accessibilityNodeInfo = null;
            if (view2 == null) break block16;
            accessibilityNodeInfo = accessibilityNodeInfo2 = view2.createAccessibilityNodeInfo();
        }
        try {
            this.mViewRootImpl.mAttachInfo.mAccessibilityFetchFlags = 0;
            this.applyAppScaleAndMagnificationSpecIfNeeded(accessibilityNodeInfo, magnificationSpec);
            if (magnificationSpec != null) {
                magnificationSpec.recycle();
            }
            this.adjustIsVisibleToUserIfNeeded(accessibilityNodeInfo, region);
            iAccessibilityInteractionConnectionCallback.setFindAccessibilityNodeInfoResult(accessibilityNodeInfo, n);
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    private boolean isShown(View view) {
        return view.mAttachInfo != null && view.mAttachInfo.mWindowVisibility == 0 && view.isShown();
    }

    /*
     * Unable to fully structure code
     */
    private void perfromAccessibilityActionUiThread(Message var1_1) {
        block22: {
            block20: {
                block19: {
                    var2_2 = var1_1.arg1;
                    var3_3 = var1_1.arg2;
                    var4_4 = (SomeArgs)var1_1.obj;
                    var5_5 = var4_4.argi1;
                    var6_6 = var4_4.argi2;
                    var7_7 = var4_4.argi3;
                    var8_8 = (IAccessibilityInteractionConnectionCallback)var4_4.arg1;
                    var9_9 = (Bundle)var4_4.arg2;
                    var4_4.recycle();
                    if (this.mViewRootImpl.mView != null && (var13_10 = this.mViewRootImpl.mAttachInfo) != null) break block19;
                    this.mViewRootImpl.mAttachInfo.mAccessibilityFetchFlags = 0;
                    var8_8.setPerformAccessibilityActionResult(false, var7_7);
                    return;
                }
                this.mViewRootImpl.mAttachInfo.mAccessibilityFetchFlags = var2_2;
                if (var3_3 == 0x7FFFFFFF) break block20;
                var14_11 = this.findViewByAccessibilityId(var3_3);
lbl22:
                // 2 sources

                while (true) {
                    block21: {
                        var15_12 = false;
                        if (var14_11 == null) break block21;
                        var16_13 = this.isShown(var14_11);
                        var15_12 = false;
                        if (!var16_13) break block21;
                        var17_14 = var14_11.getAccessibilityNodeProvider();
                        if (var17_14 == null) break block22;
                        if (var5_5 == 0x7FFFFFFF) ** GOTO lbl47
                        var15_12 = var20_15 = var17_14.performAction(var5_5, var6_6, var9_9);
                    }
lbl36:
                    // 4 sources

                    while (true) {
                        try {
                            this.mViewRootImpl.mAttachInfo.mAccessibilityFetchFlags = 0;
                            var8_8.setPerformAccessibilityActionResult(var15_12, var7_7);
                            return;
                        }
                        catch (RemoteException var19_16) {
                            return;
                        }
                        break;
                    }
                    break;
                }
            }
            var14_11 = this.mViewRootImpl.mView;
            ** continue;
lbl47:
            // 1 sources

            var15_12 = var17_14.performAction(-1, var6_6, var9_9);
            ** GOTO lbl36
        }
        var15_12 = false;
        if (var5_5 != 0x7FFFFFFF) ** GOTO lbl36
        try {
            var15_12 = var18_17 = var14_11.performAccessibilityAction(var6_6, var9_9);
            ** continue;
        }
        catch (Throwable var10_18) {
            try {
                this.mViewRootImpl.mAttachInfo.mAccessibilityFetchFlags = 0;
                var8_8.setPerformAccessibilityActionResult(false, var7_7);
            }
            catch (RemoteException var11_19) {
                ** continue;
            }
lbl61:
            // 2 sources

            throw var10_18;
        }
        catch (RemoteException var12_20) {
            return;
        }
    }

    private boolean shouldApplyAppScaleAndMagnificationSpec(float f, MagnificationSpec magnificationSpec) {
        return f != 1.0f || magnificationSpec != null && !magnificationSpec.isNop();
    }

    public void computeClickPointInScreenClientThread(long l, Region region, int n, IAccessibilityInteractionConnectionCallback iAccessibilityInteractionConnectionCallback, int n2, long l2, MagnificationSpec magnificationSpec) {
        Message message = this.mHandler.obtainMessage();
        message.what = 7;
        SomeArgs someArgs = SomeArgs.obtain();
        someArgs.argi1 = AccessibilityNodeInfo.getAccessibilityViewId(l);
        someArgs.argi2 = AccessibilityNodeInfo.getVirtualDescendantId(l);
        someArgs.argi3 = n;
        someArgs.arg1 = iAccessibilityInteractionConnectionCallback;
        someArgs.arg2 = magnificationSpec;
        someArgs.arg3 = region;
        message.obj = someArgs;
        if (n2 == this.mMyProcessId && l2 == this.mMyLooperThreadId) {
            AccessibilityInteractionClient.getInstanceForThread(l2).setSameThreadMessage(message);
            return;
        }
        this.mHandler.sendMessage(message);
    }

    public void findAccessibilityNodeInfoByAccessibilityIdClientThread(long l, Region region, int n, IAccessibilityInteractionConnectionCallback iAccessibilityInteractionConnectionCallback, int n2, int n3, long l2, MagnificationSpec magnificationSpec) {
        Message message = this.mHandler.obtainMessage();
        message.what = 2;
        message.arg1 = n2;
        SomeArgs someArgs = SomeArgs.obtain();
        someArgs.argi1 = AccessibilityNodeInfo.getAccessibilityViewId(l);
        someArgs.argi2 = AccessibilityNodeInfo.getVirtualDescendantId(l);
        someArgs.argi3 = n;
        someArgs.arg1 = iAccessibilityInteractionConnectionCallback;
        someArgs.arg2 = magnificationSpec;
        someArgs.arg3 = region;
        message.obj = someArgs;
        if (n3 == this.mMyProcessId && l2 == this.mMyLooperThreadId) {
            AccessibilityInteractionClient.getInstanceForThread(l2).setSameThreadMessage(message);
            return;
        }
        this.mHandler.sendMessage(message);
    }

    public void findAccessibilityNodeInfosByTextClientThread(long l, String string2, Region region, int n, IAccessibilityInteractionConnectionCallback iAccessibilityInteractionConnectionCallback, int n2, int n3, long l2, MagnificationSpec magnificationSpec) {
        Message message = this.mHandler.obtainMessage();
        message.what = 4;
        message.arg1 = n2;
        SomeArgs someArgs = SomeArgs.obtain();
        someArgs.arg1 = string2;
        someArgs.arg2 = iAccessibilityInteractionConnectionCallback;
        someArgs.arg3 = magnificationSpec;
        someArgs.argi1 = AccessibilityNodeInfo.getAccessibilityViewId(l);
        someArgs.argi2 = AccessibilityNodeInfo.getVirtualDescendantId(l);
        someArgs.argi3 = n;
        someArgs.arg4 = region;
        message.obj = someArgs;
        if (n3 == this.mMyProcessId && l2 == this.mMyLooperThreadId) {
            AccessibilityInteractionClient.getInstanceForThread(l2).setSameThreadMessage(message);
            return;
        }
        this.mHandler.sendMessage(message);
    }

    public void findAccessibilityNodeInfosByViewIdClientThread(long l, String string2, Region region, int n, IAccessibilityInteractionConnectionCallback iAccessibilityInteractionConnectionCallback, int n2, int n3, long l2, MagnificationSpec magnificationSpec) {
        Message message = this.mHandler.obtainMessage();
        message.what = 3;
        message.arg1 = n2;
        message.arg2 = AccessibilityNodeInfo.getAccessibilityViewId(l);
        SomeArgs someArgs = SomeArgs.obtain();
        someArgs.argi1 = n;
        someArgs.arg1 = iAccessibilityInteractionConnectionCallback;
        someArgs.arg2 = magnificationSpec;
        someArgs.arg3 = string2;
        someArgs.arg4 = region;
        message.obj = someArgs;
        if (n3 == this.mMyProcessId && l2 == this.mMyLooperThreadId) {
            AccessibilityInteractionClient.getInstanceForThread(l2).setSameThreadMessage(message);
            return;
        }
        this.mHandler.sendMessage(message);
    }

    public void findFocusClientThread(long l, int n, Region region, int n2, IAccessibilityInteractionConnectionCallback iAccessibilityInteractionConnectionCallback, int n3, int n4, long l2, MagnificationSpec magnificationSpec) {
        Message message = this.mHandler.obtainMessage();
        message.what = 5;
        message.arg1 = n3;
        message.arg2 = n;
        SomeArgs someArgs = SomeArgs.obtain();
        someArgs.argi1 = n2;
        someArgs.argi2 = AccessibilityNodeInfo.getAccessibilityViewId(l);
        someArgs.argi3 = AccessibilityNodeInfo.getVirtualDescendantId(l);
        someArgs.arg1 = iAccessibilityInteractionConnectionCallback;
        someArgs.arg2 = magnificationSpec;
        someArgs.arg3 = region;
        message.obj = someArgs;
        if (n4 == this.mMyProcessId && l2 == this.mMyLooperThreadId) {
            AccessibilityInteractionClient.getInstanceForThread(l2).setSameThreadMessage(message);
            return;
        }
        this.mHandler.sendMessage(message);
    }

    public void focusSearchClientThread(long l, int n, Region region, int n2, IAccessibilityInteractionConnectionCallback iAccessibilityInteractionConnectionCallback, int n3, int n4, long l2, MagnificationSpec magnificationSpec) {
        Message message = this.mHandler.obtainMessage();
        message.what = 6;
        message.arg1 = n3;
        message.arg2 = AccessibilityNodeInfo.getAccessibilityViewId(l);
        SomeArgs someArgs = SomeArgs.obtain();
        someArgs.argi2 = n;
        someArgs.argi3 = n2;
        someArgs.arg1 = iAccessibilityInteractionConnectionCallback;
        someArgs.arg2 = magnificationSpec;
        someArgs.arg3 = region;
        message.obj = someArgs;
        if (n4 == this.mMyProcessId && l2 == this.mMyLooperThreadId) {
            AccessibilityInteractionClient.getInstanceForThread(l2).setSameThreadMessage(message);
            return;
        }
        this.mHandler.sendMessage(message);
    }

    public void performAccessibilityActionClientThread(long l, int n, Bundle bundle, int n2, IAccessibilityInteractionConnectionCallback iAccessibilityInteractionConnectionCallback, int n3, int n4, long l2) {
        Message message = this.mHandler.obtainMessage();
        message.what = 1;
        message.arg1 = n3;
        message.arg2 = AccessibilityNodeInfo.getAccessibilityViewId(l);
        SomeArgs someArgs = SomeArgs.obtain();
        someArgs.argi1 = AccessibilityNodeInfo.getVirtualDescendantId(l);
        someArgs.argi2 = n;
        someArgs.argi3 = n2;
        someArgs.arg1 = iAccessibilityInteractionConnectionCallback;
        someArgs.arg2 = bundle;
        message.obj = someArgs;
        if (n4 == this.mMyProcessId && l2 == this.mMyLooperThreadId) {
            AccessibilityInteractionClient.getInstanceForThread(l2).setSameThreadMessage(message);
            return;
        }
        this.mHandler.sendMessage(message);
    }

    private class AccessibilityNodePrefetcher {
        private static final int MAX_ACCESSIBILITY_NODE_INFO_BATCH_SIZE = 50;
        private final ArrayList<View> mTempViewList = new ArrayList();

        private AccessibilityNodePrefetcher() {
        }

        private void enforceNodeTreeConsistent(List<AccessibilityNodeInfo> list) {
            AccessibilityNodeInfo accessibilityNodeInfo;
            LongSparseArray<AccessibilityNodeInfo> longSparseArray = new LongSparseArray<AccessibilityNodeInfo>();
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                AccessibilityNodeInfo accessibilityNodeInfo2 = list.get(i);
                longSparseArray.put(accessibilityNodeInfo2.getSourceNodeId(), accessibilityNodeInfo2);
            }
            AccessibilityNodeInfo accessibilityNodeInfo3 = accessibilityNodeInfo = (AccessibilityNodeInfo)longSparseArray.valueAt(0);
            while (accessibilityNodeInfo3 != null) {
                accessibilityNodeInfo = accessibilityNodeInfo3;
                accessibilityNodeInfo3 = (AccessibilityNodeInfo)longSparseArray.get(accessibilityNodeInfo3.getParentNodeId());
            }
            AccessibilityNodeInfo accessibilityNodeInfo4 = null;
            AccessibilityNodeInfo accessibilityNodeInfo5 = null;
            HashSet<AccessibilityNodeInfo> hashSet = new HashSet<AccessibilityNodeInfo>();
            LinkedList<AccessibilityNodeInfo> linkedList = new LinkedList<AccessibilityNodeInfo>();
            linkedList.add(accessibilityNodeInfo);
            while (!linkedList.isEmpty()) {
                AccessibilityNodeInfo accessibilityNodeInfo6 = (AccessibilityNodeInfo)linkedList.poll();
                if (!hashSet.add(accessibilityNodeInfo6)) {
                    throw new IllegalStateException("Duplicate node: " + accessibilityNodeInfo6 + " in window:" + ((AccessibilityInteractionController)AccessibilityInteractionController.this).mViewRootImpl.mAttachInfo.mAccessibilityWindowId);
                }
                if (accessibilityNodeInfo6.isAccessibilityFocused()) {
                    if (accessibilityNodeInfo4 != null) {
                        throw new IllegalStateException("Duplicate accessibility focus:" + accessibilityNodeInfo6 + " in window:" + ((AccessibilityInteractionController)AccessibilityInteractionController.this).mViewRootImpl.mAttachInfo.mAccessibilityWindowId);
                    }
                    accessibilityNodeInfo4 = accessibilityNodeInfo6;
                }
                if (accessibilityNodeInfo6.isFocused()) {
                    if (accessibilityNodeInfo5 != null) {
                        throw new IllegalStateException("Duplicate input focus: " + accessibilityNodeInfo6 + " in window:" + ((AccessibilityInteractionController)AccessibilityInteractionController.this).mViewRootImpl.mAttachInfo.mAccessibilityWindowId);
                    }
                    accessibilityNodeInfo5 = accessibilityNodeInfo6;
                }
                int n2 = accessibilityNodeInfo6.getChildCount();
                for (int i = 0; i < n2; ++i) {
                    AccessibilityNodeInfo accessibilityNodeInfo7 = (AccessibilityNodeInfo)longSparseArray.get(accessibilityNodeInfo6.getChildId(i));
                    if (accessibilityNodeInfo7 == null) continue;
                    linkedList.add(accessibilityNodeInfo7);
                }
            }
            for (int i = -1 + longSparseArray.size(); i >= 0; --i) {
                AccessibilityNodeInfo accessibilityNodeInfo8 = (AccessibilityNodeInfo)longSparseArray.valueAt(i);
                if (hashSet.contains(accessibilityNodeInfo8)) continue;
                throw new IllegalStateException("Disconnected node: " + accessibilityNodeInfo8);
            }
        }

        /*
         * Unable to fully structure code
         */
        private void prefetchDescendantsOfRealNode(View var1_1, List<AccessibilityNodeInfo> var2_2) {
            if (!(var1_1 instanceof ViewGroup)) lbl-1000:
            // 3 sources

            {
                return;
            }
            var3_3 = new HashMap<View, AccessibilityNodeInfo>();
            var4_4 = this.mTempViewList;
            var4_4.clear();
            var1_1.addChildrenForAccessibility(var4_4);
            var6_5 = var4_4.size();
            var7_6 = 0;
            while (true) {
                block13: {
                    block14: {
                        block12: {
                            if (var7_6 >= var6_5) break block14;
                            try {
                                var8_7 = var2_2.size();
                                if (var8_7 < 50) break block12;
                                var4_4.clear();
                                return;
                            }
                            catch (Throwable var5_12) {
                                var4_4.clear();
                                throw var5_12;
                            }
                        }
                        var9_8 = var4_4.get(var7_6);
                        if (!AccessibilityInteractionController.access$300(AccessibilityInteractionController.this, var9_8)) break block13;
                        var10_9 = var9_8.getAccessibilityNodeProvider();
                        if (var10_9 != null) ** GOTO lbl36
                        var11_10 = var9_8.createAccessibilityNodeInfo();
                        if (var11_10 == null) break block13;
                        var2_2.add(var11_10);
                        var3_3.put(var9_8, null);
                        break block13;
lbl36:
                        // 1 sources

                        var14_11 = var10_9.createAccessibilityNodeInfo(-1);
                        if (var14_11 == null) break block13;
                        var2_2.add(var14_11);
                        var3_3.put(var9_8, var14_11);
                    }
                    var4_4.clear();
                    if (var2_2.size() >= 50) ** GOTO lbl-1000
                    var17_13 = var3_3.entrySet().iterator();
                    while (true) {
                        if (var17_13.hasNext()) ** break;
                        ** continue;
                        var18_14 = var17_13.next();
                        var19_15 = (View)var18_14.getKey();
                        var20_16 = (AccessibilityNodeInfo)var18_14.getValue();
                        if (var20_16 == null) {
                            this.prefetchDescendantsOfRealNode(var19_15, var2_2);
                            continue;
                        }
                        this.prefetchDescendantsOfVirtualNode(var20_16, var19_15.getAccessibilityNodeProvider(), var2_2);
                    }
                }
                ++var7_6;
            }
        }

        /*
         * Enabled aggressive block sorting
         */
        private void prefetchDescendantsOfVirtualNode(AccessibilityNodeInfo accessibilityNodeInfo, AccessibilityNodeProvider accessibilityNodeProvider, List<AccessibilityNodeInfo> list) {
            int n = list.size();
            int n2 = accessibilityNodeInfo.getChildCount();
            for (int i = 0; i < n2; ++i) {
                if (list.size() >= 50) return;
                AccessibilityNodeInfo accessibilityNodeInfo2 = accessibilityNodeProvider.createAccessibilityNodeInfo(AccessibilityNodeInfo.getVirtualDescendantId(accessibilityNodeInfo.getChildId(i)));
                if (accessibilityNodeInfo2 == null) continue;
                list.add(accessibilityNodeInfo2);
            }
            if (list.size() >= 50) return;
            int n3 = list.size() - n;
            for (int i = 0; i < n3; ++i) {
                this.prefetchDescendantsOfVirtualNode(list.get(n + i), accessibilityNodeProvider, list);
            }
        }

        private void prefetchPredecessorsOfRealNode(View view, List<AccessibilityNodeInfo> list) {
            ViewParent viewParent = view.getParentForAccessibility();
            while (viewParent instanceof View && list.size() < 50) {
                AccessibilityNodeInfo accessibilityNodeInfo = ((View)((Object)viewParent)).createAccessibilityNodeInfo();
                if (accessibilityNodeInfo != null) {
                    list.add(accessibilityNodeInfo);
                }
                viewParent = viewParent.getParentForAccessibility();
            }
        }

        /*
         * Enabled aggressive block sorting
         */
        private void prefetchPredecessorsOfVirtualNode(AccessibilityNodeInfo accessibilityNodeInfo, View view, AccessibilityNodeProvider accessibilityNodeProvider, List<AccessibilityNodeInfo> list) {
            long l = accessibilityNodeInfo.getParentNodeId();
            int n = AccessibilityNodeInfo.getAccessibilityViewId(l);
            while (n != Integer.MAX_VALUE && list.size() < 50) {
                int n2 = AccessibilityNodeInfo.getVirtualDescendantId(l);
                if (n2 == Integer.MAX_VALUE && n != view.getAccessibilityViewId()) {
                    this.prefetchPredecessorsOfRealNode(view, list);
                    return;
                }
                AccessibilityNodeInfo accessibilityNodeInfo2 = n2 != Integer.MAX_VALUE ? accessibilityNodeProvider.createAccessibilityNodeInfo(n2) : accessibilityNodeProvider.createAccessibilityNodeInfo(-1);
                if (accessibilityNodeInfo2 != null) {
                    list.add(accessibilityNodeInfo2);
                }
                l = accessibilityNodeInfo2.getParentNodeId();
                n = AccessibilityNodeInfo.getAccessibilityViewId(l);
            }
            return;
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void prefetchSiblingsOfRealNode(View var1_1, List<AccessibilityNodeInfo> var2_2) {
            block7: {
                block6: {
                    var3_3 = var1_1.getParentForAccessibility();
                    if (!(var3_3 instanceof ViewGroup)) return;
                    var4_4 = (ViewGroup)var3_3;
                    var5_5 = this.mTempViewList;
                    var5_5.clear();
                    try {
                        var4_4.addChildrenForAccessibility(var5_5);
                        var7_6 = var5_5.size();
                        var8_7 = 0;
lbl10:
                        // 2 sources

                        while (true) {
                            if (var8_7 >= var7_6) break block6;
                            var9_8 = var2_2.size();
                            if (var9_8 >= 50) {
                                var5_5.clear();
                                return;
                            }
                            break;
                        }
                    }
                    catch (Throwable var6_13) {
                        var5_5.clear();
                        throw var6_13;
                    }
                    {
                        var10_9 = var5_5.get(var8_7);
                        if (var10_9.getAccessibilityViewId() != var1_1.getAccessibilityViewId() && AccessibilityInteractionController.access$300(AccessibilityInteractionController.this, var10_9) && (var12_11 = (var11_10 = var10_9.getAccessibilityNodeProvider()) == null ? var10_9.createAccessibilityNodeInfo() : (var14_12 = var11_10.createAccessibilityNodeInfo(-1))) != null) {
                            var2_2.add(var12_11);
                        }
                        break block7;
                    }
                }
                var5_5.clear();
                return;
            }
            ++var8_7;
            ** while (true)
        }

        /*
         * Enabled aggressive block sorting
         */
        private void prefetchSiblingsOfVirtualNode(AccessibilityNodeInfo accessibilityNodeInfo, View view, AccessibilityNodeProvider accessibilityNodeProvider, List<AccessibilityNodeInfo> list) {
            long l = accessibilityNodeInfo.getParentNodeId();
            int n = AccessibilityNodeInfo.getAccessibilityViewId(l);
            int n2 = AccessibilityNodeInfo.getVirtualDescendantId(l);
            if (n2 == Integer.MAX_VALUE && n != view.getAccessibilityViewId()) {
                this.prefetchSiblingsOfRealNode(view, list);
                return;
            }
            AccessibilityNodeInfo accessibilityNodeInfo2 = n2 != Integer.MAX_VALUE ? accessibilityNodeProvider.createAccessibilityNodeInfo(n2) : accessibilityNodeProvider.createAccessibilityNodeInfo(-1);
            if (accessibilityNodeInfo2 != null) {
                int n3 = accessibilityNodeInfo2.getChildCount();
                for (int i = 0; i < n3 && list.size() < 50; ++i) {
                    AccessibilityNodeInfo accessibilityNodeInfo3;
                    long l2 = accessibilityNodeInfo2.getChildId(i);
                    if (l2 == accessibilityNodeInfo.getSourceNodeId() || (accessibilityNodeInfo3 = accessibilityNodeProvider.createAccessibilityNodeInfo(AccessibilityNodeInfo.getVirtualDescendantId(l2))) == null) continue;
                    list.add(accessibilityNodeInfo3);
                }
            }
        }

        /*
         * Enabled aggressive block sorting
         */
        public void prefetchAccessibilityNodeInfos(View view, int n, int n2, List<AccessibilityNodeInfo> list) {
            AccessibilityNodeProvider accessibilityNodeProvider = view.getAccessibilityNodeProvider();
            if (accessibilityNodeProvider == null) {
                AccessibilityNodeInfo accessibilityNodeInfo = view.createAccessibilityNodeInfo();
                if (accessibilityNodeInfo == null) return;
                list.add(accessibilityNodeInfo);
                if ((n2 & 1) != 0) {
                    this.prefetchPredecessorsOfRealNode(view, list);
                }
                if ((n2 & 2) != 0) {
                    this.prefetchSiblingsOfRealNode(view, list);
                }
                if ((n2 & 4) == 0) return;
                this.prefetchDescendantsOfRealNode(view, list);
                return;
            }
            AccessibilityNodeInfo accessibilityNodeInfo = n != Integer.MAX_VALUE ? accessibilityNodeProvider.createAccessibilityNodeInfo(n) : accessibilityNodeProvider.createAccessibilityNodeInfo(-1);
            if (accessibilityNodeInfo == null) return;
            list.add(accessibilityNodeInfo);
            if ((n2 & 1) != 0) {
                this.prefetchPredecessorsOfVirtualNode(accessibilityNodeInfo, view, accessibilityNodeProvider, list);
            }
            if ((n2 & 2) != 0) {
                this.prefetchSiblingsOfVirtualNode(accessibilityNodeInfo, view, accessibilityNodeProvider, list);
            }
            if ((n2 & 4) == 0) return;
            this.prefetchDescendantsOfVirtualNode(accessibilityNodeInfo, accessibilityNodeProvider, list);
        }
    }

    private final class AddNodeInfosForViewId
    implements Predicate<View> {
        private List<AccessibilityNodeInfo> mInfos;
        private int mViewId = -1;

        private AddNodeInfosForViewId() {
        }

        @Override
        public boolean apply(View view) {
            if (view.getId() == this.mViewId && AccessibilityInteractionController.this.isShown(view)) {
                this.mInfos.add(view.createAccessibilityNodeInfo());
            }
            return false;
        }

        public void init(int n, List<AccessibilityNodeInfo> list) {
            this.mViewId = n;
            this.mInfos = list;
        }

        public void reset() {
            this.mViewId = -1;
            this.mInfos = null;
        }
    }

    private class PrivateHandler
    extends Handler {
        private static final int MSG_COMPUTE_CLICK_POINT_IN_SCREEN = 7;
        private static final int MSG_FIND_ACCESSIBILITY_NODE_INFOS_BY_VIEW_ID = 3;
        private static final int MSG_FIND_ACCESSIBILITY_NODE_INFO_BY_ACCESSIBILITY_ID = 2;
        private static final int MSG_FIND_ACCESSIBILITY_NODE_INFO_BY_TEXT = 4;
        private static final int MSG_FIND_FOCUS = 5;
        private static final int MSG_FOCUS_SEARCH = 6;
        private static final int MSG_PERFORM_ACCESSIBILITY_ACTION = 1;

        public PrivateHandler(Looper looper) {
            super(looper);
        }

        @Override
        public String getMessageName(Message message) {
            int n = message.what;
            switch (n) {
                default: {
                    throw new IllegalArgumentException("Unknown message type: " + n);
                }
                case 1: {
                    return "MSG_PERFORM_ACCESSIBILITY_ACTION";
                }
                case 2: {
                    return "MSG_FIND_ACCESSIBILITY_NODE_INFO_BY_ACCESSIBILITY_ID";
                }
                case 3: {
                    return "MSG_FIND_ACCESSIBILITY_NODE_INFOS_BY_VIEW_ID";
                }
                case 4: {
                    return "MSG_FIND_ACCESSIBILITY_NODE_INFO_BY_TEXT";
                }
                case 5: {
                    return "MSG_FIND_FOCUS";
                }
                case 6: {
                    return "MSG_FOCUS_SEARCH";
                }
                case 7: 
            }
            return "MSG_COMPUTE_CLICK_POINT_IN_SCREEN";
        }

        @Override
        public void handleMessage(Message message) {
            int n = message.what;
            switch (n) {
                default: {
                    throw new IllegalArgumentException("Unknown message type: " + n);
                }
                case 2: {
                    AccessibilityInteractionController.this.findAccessibilityNodeInfoByAccessibilityIdUiThread(message);
                    return;
                }
                case 1: {
                    AccessibilityInteractionController.this.perfromAccessibilityActionUiThread(message);
                    return;
                }
                case 3: {
                    AccessibilityInteractionController.this.findAccessibilityNodeInfosByViewIdUiThread(message);
                    return;
                }
                case 4: {
                    AccessibilityInteractionController.this.findAccessibilityNodeInfosByTextUiThread(message);
                    return;
                }
                case 5: {
                    AccessibilityInteractionController.this.findFocusUiThread(message);
                    return;
                }
                case 6: {
                    AccessibilityInteractionController.this.focusSearchUiThread(message);
                    return;
                }
                case 7: 
            }
            AccessibilityInteractionController.this.computeClickPointInScreenUiThread(message);
        }
    }
}

