/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.content.res.CompatibilityInfo;
import android.graphics.Point;
import android.graphics.Rect;
import android.hardware.display.DisplayManagerGlobal;
import android.os.SystemClock;
import android.util.DisplayMetrics;
import android.view.DisplayAdjustments;
import android.view.DisplayInfo;
import java.util.Arrays;

public final class Display {
    private static final int CACHED_APP_SIZE_DURATION_MILLIS = 20;
    private static final boolean DEBUG = false;
    public static final int DEFAULT_DISPLAY = 0;
    public static final int FLAG_PRESENTATION = 8;
    public static final int FLAG_PRIVATE = 4;
    public static final int FLAG_SECURE = 2;
    public static final int FLAG_SUPPORTS_PROTECTED_BUFFERS = 1;
    public static final int STATE_DOZE = 3;
    public static final int STATE_DOZE_SUSPEND = 4;
    public static final int STATE_OFF = 1;
    public static final int STATE_ON = 2;
    public static final int STATE_UNKNOWN = 0;
    private static final String TAG = "Display";
    public static final int TYPE_BUILT_IN = 1;
    public static final int TYPE_HDMI = 2;
    public static final int TYPE_OVERLAY = 4;
    public static final int TYPE_PCLINK = 6;
    public static final int TYPE_UNKNOWN = 0;
    public static final int TYPE_VIRTUAL = 5;
    public static final int TYPE_WIFI = 3;
    private final String mAddress;
    private int mCachedAppHeightCompat;
    private int mCachedAppWidthCompat;
    private final DisplayAdjustments mDisplayAdjustments;
    private final int mDisplayId;
    private DisplayInfo mDisplayInfo;
    private final int mFlags;
    private final DisplayManagerGlobal mGlobal;
    private boolean mIsValid;
    private long mLastCachedAppSizeUpdate;
    private final int mLayerStack;
    private final String mOwnerPackageName;
    private final int mOwnerUid;
    private final DisplayMetrics mTempMetrics = new DisplayMetrics();
    private final int mType;

    public Display(DisplayManagerGlobal displayManagerGlobal, int n, DisplayInfo displayInfo, DisplayAdjustments displayAdjustments) {
        this.mGlobal = displayManagerGlobal;
        this.mDisplayId = n;
        this.mDisplayInfo = displayInfo;
        this.mDisplayAdjustments = new DisplayAdjustments(displayAdjustments);
        this.mIsValid = true;
        this.mLayerStack = displayInfo.layerStack;
        this.mFlags = displayInfo.flags;
        this.mType = displayInfo.type;
        this.mAddress = displayInfo.address;
        this.mOwnerUid = displayInfo.ownerUid;
        this.mOwnerPackageName = displayInfo.ownerPackageName;
    }

    public static boolean hasAccess(int n, int n2, int n3) {
        return (n2 & 4) == 0 || n == n3 || n == 1000 || n == 0;
    }

    public static boolean isSuspendedState(int n) {
        return n == 1 || n == 4;
    }

    public static String stateToString(int n) {
        switch (n) {
            default: {
                return Integer.toString(n);
            }
            case 0: {
                return "UNKNOWN";
            }
            case 1: {
                return "OFF";
            }
            case 2: {
                return "ON";
            }
            case 3: {
                return "DOZE";
            }
            case 4: 
        }
        return "DOZE_SUSPEND";
    }

    public static String typeToString(int n) {
        switch (n) {
            default: {
                return Integer.toString(n);
            }
            case 0: {
                return "UNKNOWN";
            }
            case 1: {
                return "BUILT_IN";
            }
            case 2: {
                return "HDMI";
            }
            case 3: {
                return "WIFI";
            }
            case 4: {
                return "OVERLAY";
            }
            case 5: 
        }
        return "VIRTUAL";
    }

    private void updateCachedAppSizeIfNeededLocked() {
        long l = SystemClock.uptimeMillis();
        if (l > 20L + this.mLastCachedAppSizeUpdate) {
            this.updateDisplayInfoLocked();
            this.mDisplayInfo.getAppMetrics(this.mTempMetrics, this.mDisplayAdjustments);
            this.mCachedAppWidthCompat = this.mTempMetrics.widthPixels;
            this.mCachedAppHeightCompat = this.mTempMetrics.heightPixels;
            this.mLastCachedAppSizeUpdate = l;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void updateDisplayInfoLocked() {
        DisplayInfo displayInfo = this.mGlobal.getDisplayInfo(this.mDisplayId);
        if (displayInfo == null) {
            if (!this.mIsValid) return;
            this.mIsValid = false;
            return;
        }
        this.mDisplayInfo = displayInfo;
        if (this.mIsValid) return;
        this.mIsValid = true;
    }

    public String getAddress() {
        return this.mAddress;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long getAppVsyncOffsetNanos() {
        synchronized (this) {
            this.updateDisplayInfoLocked();
            return this.mDisplayInfo.appVsyncOffsetNanos;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void getCurrentSizeRange(Point point, Point point2) {
        synchronized (this) {
            this.updateDisplayInfoLocked();
            point.x = this.mDisplayInfo.smallestNominalAppWidth;
            point.y = this.mDisplayInfo.smallestNominalAppHeight;
            point2.x = this.mDisplayInfo.largestNominalAppWidth;
            point2.y = this.mDisplayInfo.largestNominalAppHeight;
            return;
        }
    }

    public DisplayAdjustments getDisplayAdjustments() {
        return this.mDisplayAdjustments;
    }

    public int getDisplayId() {
        return this.mDisplayId;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean getDisplayInfo(DisplayInfo displayInfo) {
        synchronized (this) {
            this.updateDisplayInfoLocked();
            displayInfo.copyFrom(this.mDisplayInfo);
            return this.mIsValid;
        }
    }

    public int getFlags() {
        return this.mFlags;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Deprecated
    public int getHeight() {
        synchronized (this) {
            this.updateCachedAppSizeIfNeededLocked();
            return this.mCachedAppHeightCompat;
        }
    }

    public int getLayerStack() {
        return this.mLayerStack;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getMaximumSizeDimension() {
        synchronized (this) {
            this.updateDisplayInfoLocked();
            return Math.max(this.mDisplayInfo.logicalWidth, this.mDisplayInfo.logicalHeight);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void getMetrics(DisplayMetrics displayMetrics) {
        synchronized (this) {
            this.updateDisplayInfoLocked();
            this.mDisplayInfo.getAppMetrics(displayMetrics, this.mDisplayAdjustments);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getName() {
        synchronized (this) {
            this.updateDisplayInfoLocked();
            return this.mDisplayInfo.name;
        }
    }

    @Deprecated
    public int getOrientation() {
        return this.getRotation();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void getOverscanInsets(Rect rect) {
        synchronized (this) {
            this.updateDisplayInfoLocked();
            rect.set(this.mDisplayInfo.overscanLeft, this.mDisplayInfo.overscanTop, this.mDisplayInfo.overscanRight, this.mDisplayInfo.overscanBottom);
            return;
        }
    }

    public String getOwnerPackageName() {
        return this.mOwnerPackageName;
    }

    public int getOwnerUid() {
        return this.mOwnerUid;
    }

    @Deprecated
    public int getPixelFormat() {
        return 1;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long getPresentationDeadlineNanos() {
        synchronized (this) {
            this.updateDisplayInfoLocked();
            return this.mDisplayInfo.presentationDeadlineNanos;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void getRealMetrics(DisplayMetrics displayMetrics) {
        synchronized (this) {
            this.updateDisplayInfoLocked();
            this.mDisplayInfo.getLogicalMetrics(displayMetrics, CompatibilityInfo.DEFAULT_COMPATIBILITY_INFO, this.mDisplayAdjustments.getActivityToken());
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void getRealSize(Point point) {
        synchronized (this) {
            this.updateDisplayInfoLocked();
            point.x = this.mDisplayInfo.logicalWidth;
            point.y = this.mDisplayInfo.logicalHeight;
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void getRectSize(Rect rect) {
        synchronized (this) {
            this.updateDisplayInfoLocked();
            this.mDisplayInfo.getAppMetrics(this.mTempMetrics, this.mDisplayAdjustments);
            rect.set(0, 0, this.mTempMetrics.widthPixels, this.mTempMetrics.heightPixels);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public float getRefreshRate() {
        synchronized (this) {
            this.updateDisplayInfoLocked();
            return this.mDisplayInfo.refreshRate;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getRotation() {
        synchronized (this) {
            this.updateDisplayInfoLocked();
            return this.mDisplayInfo.rotation;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void getSize(Point point) {
        synchronized (this) {
            this.updateDisplayInfoLocked();
            this.mDisplayInfo.getAppMetrics(this.mTempMetrics, this.mDisplayAdjustments);
            point.x = this.mTempMetrics.widthPixels;
            point.y = this.mTempMetrics.heightPixels;
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getState() {
        synchronized (this) {
            this.updateDisplayInfoLocked();
            if (!this.mIsValid) return 0;
            return this.mDisplayInfo.state;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public float[] getSupportedRefreshRates() {
        synchronized (this) {
            this.updateDisplayInfoLocked();
            float[] fArray = this.mDisplayInfo.supportedRefreshRates;
            return Arrays.copyOf(fArray, fArray.length);
        }
    }

    public int getType() {
        return this.mType;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Deprecated
    public int getWidth() {
        synchronized (this) {
            this.updateCachedAppSizeIfNeededLocked();
            return this.mCachedAppWidthCompat;
        }
    }

    public boolean hasAccess(int n) {
        return Display.hasAccess(n, this.mFlags, this.mOwnerUid);
    }

    public boolean isPublicPresentation() {
        return (0xC & this.mFlags) == 8;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isValid() {
        synchronized (this) {
            this.updateDisplayInfoLocked();
            return this.mIsValid;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String toString() {
        synchronized (this) {
            this.updateDisplayInfoLocked();
            this.mDisplayInfo.getAppMetrics(this.mTempMetrics, this.mDisplayAdjustments);
            return "Display id " + this.mDisplayId + ": " + this.mDisplayInfo + ", " + this.mTempMetrics + ", isValid=" + this.mIsValid;
        }
    }
}

