/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.graphics.Canvas;
import android.graphics.Matrix;
import android.view.HardwareCanvas;
import android.view.RenderNode;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewGroupOverlay;
import android.view.ViewOverlay;
import android.view.ViewParent;
import android.widget.FrameLayout;
import java.util.ArrayList;

public class GhostView
extends View {
    private boolean mBeingMoved;
    private int mReferences;
    private final View mView;

    private GhostView(View view) {
        super(view.getContext());
        this.mView = view;
        this.mView.mGhostView = this;
        ViewGroup viewGroup = (ViewGroup)this.mView.getParent();
        this.setGhostedVisibility(4);
        viewGroup.mRecreateDisplayList = true;
        viewGroup.getDisplayList();
    }

    public static GhostView addGhost(View view, ViewGroup viewGroup) {
        return GhostView.addGhost(view, viewGroup, null);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static GhostView addGhost(View view, ViewGroup viewGroup, Matrix matrix) {
        if (!(view.getParent() instanceof ViewGroup)) {
            throw new IllegalArgumentException("Ghosted views must be parented by a ViewGroup");
        }
        ViewGroupOverlay viewGroupOverlay = viewGroup.getOverlay();
        ViewOverlay.OverlayViewGroup overlayViewGroup = viewGroupOverlay.mOverlayViewGroup;
        GhostView ghostView = view.mGhostView;
        int n = 0;
        if (ghostView != null) {
            View view2 = (View)((Object)ghostView.getParent());
            ViewGroup viewGroup2 = (ViewGroup)view2.getParent();
            n = 0;
            if (viewGroup2 != overlayViewGroup) {
                n = ghostView.mReferences;
                viewGroup2.removeView(view2);
                ghostView = null;
            }
        }
        if (ghostView == null) {
            if (matrix == null) {
                matrix = new Matrix();
                GhostView.calculateMatrix(view, viewGroup, matrix);
            }
            ghostView = new GhostView(view);
            ghostView.setMatrix(matrix);
            FrameLayout frameLayout = new FrameLayout(view.getContext());
            frameLayout.setClipChildren(false);
            GhostView.copySize(viewGroup, frameLayout);
            GhostView.copySize(viewGroup, ghostView);
            frameLayout.addView(ghostView);
            ArrayList<View> arrayList = new ArrayList<View>();
            int n2 = GhostView.moveGhostViewsToTop(viewGroupOverlay.mOverlayViewGroup, arrayList);
            GhostView.insertIntoOverlay(viewGroupOverlay.mOverlayViewGroup, frameLayout, ghostView, arrayList, n2);
            ghostView.mReferences = n;
        } else if (matrix != null) {
            ghostView.setMatrix(matrix);
        }
        ghostView.mReferences = 1 + ghostView.mReferences;
        return ghostView;
    }

    public static void calculateMatrix(View view, ViewGroup viewGroup, Matrix matrix) {
        ViewGroup viewGroup2 = (ViewGroup)view.getParent();
        matrix.reset();
        viewGroup2.transformMatrixToGlobal(matrix);
        matrix.preTranslate(-viewGroup2.getScrollX(), -viewGroup2.getScrollY());
        viewGroup.transformMatrixToLocal(matrix);
    }

    private static void copySize(View view, View view2) {
        view2.setLeft(0);
        view2.setTop(0);
        view2.setRight(view.getWidth());
        view2.setBottom(view.getHeight());
    }

    public static GhostView getGhost(View view) {
        return view.mGhostView;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static int getInsertIndex(ViewGroup viewGroup, ArrayList<View> arrayList, ArrayList<View> arrayList2, int n) {
        int n2 = n;
        int n3 = -1 + viewGroup.getChildCount();
        while (n2 <= n3) {
            int n4 = (n2 + n3) / 2;
            GhostView.getParents(((GhostView)((ViewGroup)viewGroup.getChildAt((int)n4)).getChildAt((int)0)).mView, arrayList2);
            if (GhostView.isOnTop(arrayList, arrayList2)) {
                n2 = n4 + 1;
            } else {
                n3 = n4 - 1;
            }
            arrayList2.clear();
        }
        return n2;
    }

    private static void getParents(View view, ArrayList<View> arrayList) {
        ViewParent viewParent = view.getParent();
        if (viewParent != null && viewParent instanceof ViewGroup) {
            GhostView.getParents((View)((Object)viewParent), arrayList);
        }
        arrayList.add(view);
    }

    private static void insertIntoOverlay(ViewGroup viewGroup, ViewGroup viewGroup2, GhostView ghostView, ArrayList<View> arrayList, int n) {
        if (n == -1) {
            viewGroup.addView(viewGroup2);
            return;
        }
        ArrayList<View> arrayList2 = new ArrayList<View>();
        GhostView.getParents(ghostView.mView, arrayList2);
        int n2 = GhostView.getInsertIndex(viewGroup, arrayList2, arrayList, n);
        if (n2 < 0 || n2 >= viewGroup.getChildCount()) {
            viewGroup.addView(viewGroup2);
            return;
        }
        viewGroup.addView((View)viewGroup2, n2);
    }

    private static boolean isGhostWrapper(View view) {
        boolean bl = view instanceof FrameLayout;
        boolean bl2 = false;
        if (bl) {
            FrameLayout frameLayout = (FrameLayout)view;
            int n = frameLayout.getChildCount();
            bl2 = false;
            if (n == 1) {
                bl2 = frameLayout.getChildAt(0) instanceof GhostView;
            }
        }
        return bl2;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static boolean isOnTop(View view, View view2) {
        ViewGroup viewGroup = (ViewGroup)view.getParent();
        int n = viewGroup.getChildCount();
        ArrayList<View> arrayList = viewGroup.buildOrderedChildList();
        boolean bl = arrayList == null && viewGroup.isChildrenDrawingOrderEnabled();
        boolean bl2 = true;
        for (int i = 0; i < n; ++i) {
            int n2 = bl ? viewGroup.getChildDrawingOrder(n, i) : i;
            View view3 = arrayList == null ? viewGroup.getChildAt(n2) : arrayList.get(n2);
            if (view3 == view) {
                bl2 = false;
                break;
            }
            if (view3 != view2) continue;
            bl2 = true;
            break;
        }
        if (arrayList != null) {
            arrayList.clear();
        }
        return bl2;
    }

    private static boolean isOnTop(ArrayList<View> arrayList, ArrayList<View> arrayList2) {
        if (arrayList.isEmpty() || arrayList2.isEmpty() || arrayList.get(0) != arrayList2.get(0)) {
            return true;
        }
        int n = Math.min(arrayList.size(), arrayList2.size());
        for (int i = 1; i < n; ++i) {
            View view;
            View view2 = arrayList.get(i);
            if (view2 == (view = arrayList2.get(i))) continue;
            return GhostView.isOnTop(view2, view);
        }
        return arrayList2.size() == n;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static int moveGhostViewsToTop(ViewGroup viewGroup, ArrayList<View> arrayList) {
        int n = viewGroup.getChildCount();
        if (n == 0) {
            return -1;
        }
        if (GhostView.isGhostWrapper(viewGroup.getChildAt(n - 1))) {
            int n2 = n - 1;
            int n3 = n - 2;
            while (n3 >= 0) {
                if (!GhostView.isGhostWrapper(viewGroup.getChildAt(n3))) return n2;
                n2 = n3--;
            }
            return n2;
        }
        for (int i = n - 2; i >= 0; --i) {
            View view = viewGroup.getChildAt(i);
            if (!GhostView.isGhostWrapper(view)) continue;
            arrayList.add(view);
            GhostView ghostView = (GhostView)((ViewGroup)view).getChildAt(0);
            ghostView.mBeingMoved = true;
            viewGroup.removeViewAt(i);
            ghostView.mBeingMoved = false;
        }
        if (arrayList.isEmpty()) {
            return -1;
        }
        int n4 = viewGroup.getChildCount();
        for (int i = -1 + arrayList.size(); i >= 0; --i) {
            viewGroup.addView(arrayList.get(i));
        }
        arrayList.clear();
        return n4;
    }

    public static void removeGhost(View view) {
        GhostView ghostView = view.mGhostView;
        if (ghostView != null) {
            ghostView.mReferences = -1 + ghostView.mReferences;
            if (ghostView.mReferences == 0) {
                ViewGroup viewGroup = (ViewGroup)ghostView.getParent();
                ((ViewGroup)viewGroup.getParent()).removeView(viewGroup);
            }
        }
    }

    private void setGhostedVisibility(int n) {
        this.mView.mViewFlags = n | 0xFFFFFFF3 & this.mView.mViewFlags;
    }

    @Override
    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (!this.mBeingMoved) {
            this.setGhostedVisibility(0);
            this.mView.mGhostView = null;
            ViewGroup viewGroup = (ViewGroup)this.mView.getParent();
            if (viewGroup != null) {
                viewGroup.mRecreateDisplayList = true;
                viewGroup.getDisplayList();
            }
        }
    }

    @Override
    protected void onDraw(Canvas canvas) {
        if (canvas instanceof HardwareCanvas) {
            HardwareCanvas hardwareCanvas = (HardwareCanvas)canvas;
            this.mView.mRecreateDisplayList = true;
            RenderNode renderNode = this.mView.getDisplayList();
            if (renderNode.isValid()) {
                hardwareCanvas.insertReorderBarrier();
                hardwareCanvas.drawRenderNode(renderNode);
                hardwareCanvas.insertInorderBarrier();
            }
        }
    }

    public void setMatrix(Matrix matrix) {
        this.mRenderNode.setAnimationMatrix(matrix);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void setVisibility(int n) {
        super.setVisibility(n);
        if (this.mView.mGhostView == this) {
            int n2 = n == 0 ? 4 : 0;
            this.setGhostedVisibility(n2);
        }
    }
}

