/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.IBinder;
import android.os.Process;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.SystemProperties;
import android.os.Trace;
import android.util.Log;
import android.util.LongSparseArray;
import android.view.Choreographer;
import android.view.GraphicBuffer;
import android.view.HardwareCanvas;
import android.view.HardwareLayer;
import android.view.HardwareRenderer;
import android.view.IAssetAtlas;
import android.view.RenderNode;
import android.view.Surface;
import android.view.View;
import android.view.ViewGroup;
import com.android.internal.R;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.HashSet;

public class ThreadedRenderer
extends HardwareRenderer {
    private static final String LOGTAG = "ThreadedRenderer";
    private static final int SYNC_INVALIDATE_REQUIRED = 1;
    private static final int SYNC_OK;
    private static final String[] VISUALIZERS;
    private final int mAmbientShadowAlpha;
    private Choreographer mChoreographer;
    private boolean mHasInsets;
    private int mHeight;
    private boolean mInitialized = false;
    private int mInsetLeft;
    private int mInsetTop;
    private final float mLightRadius;
    private final float mLightY;
    private final float mLightZ;
    private long mNativeProxy;
    private boolean mProfilingEnabled;
    private RenderNode mRootNode;
    private boolean mRootNodeNeedsUpdate;
    private final int mSpotShadowAlpha;
    private int mSurfaceHeight;
    private int mSurfaceWidth;
    private int mWidth;

    static {
        VISUALIZERS = new String[]{"visual_bars"};
    }

    ThreadedRenderer(Context context, boolean bl) {
        TypedArray typedArray = context.obtainStyledAttributes(null, R.styleable.Lighting, 0, 0);
        this.mLightY = typedArray.getDimension(2, 0.0f);
        this.mLightZ = typedArray.getDimension(3, 0.0f);
        this.mLightRadius = typedArray.getDimension(4, 0.0f);
        this.mAmbientShadowAlpha = (int)(0.5f + 255.0f * typedArray.getFloat(0, 0.0f));
        this.mSpotShadowAlpha = (int)(0.5f + 255.0f * typedArray.getFloat(1, 0.0f));
        typedArray.recycle();
        long l = ThreadedRenderer.nCreateRootRenderNode();
        this.mRootNode = RenderNode.adopt(l);
        this.mRootNode.setClipToBounds(false);
        this.mNativeProxy = ThreadedRenderer.nCreateProxy(bl, l);
        AtlasInitializer.sInstance.init(context, this.mNativeProxy);
        this.mChoreographer = Choreographer.getInstance();
        ThreadedRenderer.nSetFrameInterval(this.mNativeProxy, this.mChoreographer.getFrameIntervalNanos());
        this.loadSystemProperties();
    }

    private static boolean checkIfProfilingRequested() {
        String string2 = SystemProperties.get("debug.hwui.profile");
        return ThreadedRenderer.search(VISUALIZERS, string2) >= 0 || Boolean.parseBoolean(string2);
    }

    private static void destroyResources(View view) {
        view.destroyHardwareResources();
        if (view instanceof ViewGroup) {
            ViewGroup viewGroup = (ViewGroup)view;
            int n = viewGroup.getChildCount();
            for (int i = 0; i < n; ++i) {
                ThreadedRenderer.destroyResources(viewGroup.getChildAt(i));
            }
        }
    }

    static void invokeFunctor(long l, boolean bl) {
        ThreadedRenderer.nInvokeFunctor(l, bl);
    }

    private static native void nBuildLayer(long var0, long var2);

    private static native void nCancelLayerUpdate(long var0, long var2);

    private static native boolean nCopyLayerInto(long var0, long var2, long var4);

    private static native long nCreateProxy(boolean var0, long var1);

    private static native long nCreateRootRenderNode();

    private static native long nCreateTextureLayer(long var0);

    private static native void nDeleteProxy(long var0);

    private static native void nDestroy(long var0);

    private static native void nDestroyHardwareResources(long var0);

    private static native void nDetachSurfaceTexture(long var0, long var2);

    private static native void nDumpProfileInfo(long var0, FileDescriptor var2);

    private static native void nFence(long var0);

    private static native boolean nInitialize(long var0, Surface var2);

    private static native void nInvokeFunctor(long var0, boolean var2);

    private static native boolean nLoadSystemProperties(long var0);

    private static native void nNotifyFramePending(long var0);

    private static native void nPauseSurface(long var0, Surface var2);

    private static native void nPushLayerUpdate(long var0, long var2);

    private static native void nRegisterAnimatingRenderNode(long var0, long var2);

    private static native void nSetAtlas(long var0, GraphicBuffer var2, long[] var3);

    private static native void nSetFrameInterval(long var0, long var2);

    private static native void nSetOpaque(long var0, boolean var2);

    private static native void nSetup(long var0, int var2, int var3, float var4, float var5, float var6, float var7, int var8, int var9);

    private static native void nStopDrawing(long var0);

    private static native int nSyncAndDrawFrame(long var0, long var2, long var4, float var6);

    private static native void nTrimMemory(int var0);

    private static native void nUpdateSurface(long var0, Surface var2);

    private static int search(String[] stringArray, String string2) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals(string2)) continue;
            return i;
        }
        return -1;
    }

    static native void setupShadersDiskCache(String var0);

    static void trimMemory(int n) {
        ThreadedRenderer.nTrimMemory(n);
    }

    private void updateEnabledState(Surface surface) {
        if (surface == null || !surface.isValid()) {
            this.setEnabled(false);
            return;
        }
        this.setEnabled(this.mInitialized);
    }

    private void updateRootDisplayList(View view, HardwareRenderer.HardwareDrawCallbacks hardwareDrawCallbacks) {
        HardwareCanvas hardwareCanvas;
        Trace.traceBegin(8L, "getDisplayList");
        this.updateViewTreeDisplayList(view);
        if (this.mRootNodeNeedsUpdate || !this.mRootNode.isValid()) {
            hardwareCanvas = this.mRootNode.start(this.mSurfaceWidth, this.mSurfaceHeight);
            int n = hardwareCanvas.save();
            hardwareCanvas.translate(this.mInsetLeft, this.mInsetTop);
            hardwareDrawCallbacks.onHardwarePreDraw(hardwareCanvas);
            hardwareCanvas.insertReorderBarrier();
            hardwareCanvas.drawRenderNode(view.getDisplayList());
            hardwareCanvas.insertInorderBarrier();
            hardwareDrawCallbacks.onHardwarePostDraw(hardwareCanvas);
            hardwareCanvas.restoreToCount(n);
            this.mRootNodeNeedsUpdate = false;
        }
        Trace.traceEnd(8L);
        return;
        finally {
            this.mRootNode.end(hardwareCanvas);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void updateViewTreeDisplayList(View view) {
        view.mPrivateFlags = 0x20 | view.mPrivateFlags;
        boolean bl = (Integer.MIN_VALUE & view.mPrivateFlags) == Integer.MIN_VALUE;
        view.mRecreateDisplayList = bl;
        view.mPrivateFlags = Integer.MAX_VALUE & view.mPrivateFlags;
        view.getDisplayList();
        view.mRecreateDisplayList = false;
    }

    @Override
    void buildLayer(RenderNode renderNode) {
        ThreadedRenderer.nBuildLayer(this.mNativeProxy, renderNode.getNativeDisplayList());
    }

    @Override
    boolean copyLayerInto(HardwareLayer hardwareLayer, Bitmap bitmap) {
        return ThreadedRenderer.nCopyLayerInto(this.mNativeProxy, hardwareLayer.getDeferredLayerUpdater(), bitmap.mNativeBitmap);
    }

    @Override
    HardwareLayer createTextureLayer() {
        return HardwareLayer.adoptTextureLayer(this, ThreadedRenderer.nCreateTextureLayer(this.mNativeProxy));
    }

    @Override
    void destroy() {
        this.mInitialized = false;
        this.updateEnabledState(null);
        ThreadedRenderer.nDestroy(this.mNativeProxy);
    }

    @Override
    void destroyHardwareResources(View view) {
        ThreadedRenderer.destroyResources(view);
        ThreadedRenderer.nDestroyHardwareResources(this.mNativeProxy);
    }

    @Override
    void detachSurfaceTexture(long l) {
        ThreadedRenderer.nDetachSurfaceTexture(this.mNativeProxy, l);
    }

    @Override
    void draw(View view, View.AttachInfo attachInfo, HardwareRenderer.HardwareDrawCallbacks hardwareDrawCallbacks) {
        attachInfo.mIgnoreDirtyState = true;
        long l = this.mChoreographer.getFrameTimeNanos();
        attachInfo.mDrawingTime = l / 1000000L;
        long l2 = 0L;
        if (this.mProfilingEnabled) {
            l2 = System.nanoTime();
        }
        this.updateRootDisplayList(view, hardwareDrawCallbacks);
        if (this.mProfilingEnabled) {
            l2 = System.nanoTime() - l2;
        }
        attachInfo.mIgnoreDirtyState = false;
        if (attachInfo.mPendingAnimatingRenderNodes != null) {
            int n = attachInfo.mPendingAnimatingRenderNodes.size();
            for (int i = 0; i < n; ++i) {
                this.registerAnimatingRenderNode(attachInfo.mPendingAnimatingRenderNodes.get(i));
            }
            attachInfo.mPendingAnimatingRenderNodes.clear();
            attachInfo.mPendingAnimatingRenderNodes = null;
        }
        if ((1 & ThreadedRenderer.nSyncAndDrawFrame(this.mNativeProxy, l, l2, view.getResources().getDisplayMetrics().density)) != 0) {
            attachInfo.mViewRootImpl.invalidate();
        }
    }

    @Override
    void dumpGfxInfo(PrintWriter printWriter, FileDescriptor fileDescriptor) {
        printWriter.flush();
        ThreadedRenderer.nDumpProfileInfo(this.mNativeProxy, fileDescriptor);
    }

    @Override
    void fence() {
        ThreadedRenderer.nFence(this.mNativeProxy);
    }

    protected void finalize() throws Throwable {
        try {
            ThreadedRenderer.nDeleteProxy(this.mNativeProxy);
            this.mNativeProxy = 0L;
            return;
        }
        finally {
            super.finalize();
        }
    }

    @Override
    int getHeight() {
        return this.mHeight;
    }

    @Override
    int getWidth() {
        return this.mWidth;
    }

    @Override
    boolean initialize(Surface surface) throws Surface.OutOfResourcesException {
        this.mInitialized = true;
        this.updateEnabledState(surface);
        boolean bl = ThreadedRenderer.nInitialize(this.mNativeProxy, surface);
        surface.allocateBuffers();
        return bl;
    }

    @Override
    void invalidate(Surface surface) {
        this.updateSurface(surface);
    }

    @Override
    void invalidateRoot() {
        this.mRootNodeNeedsUpdate = true;
    }

    @Override
    boolean loadSystemProperties() {
        boolean bl = ThreadedRenderer.nLoadSystemProperties(this.mNativeProxy);
        boolean bl2 = ThreadedRenderer.checkIfProfilingRequested();
        if (bl2 != this.mProfilingEnabled) {
            this.mProfilingEnabled = bl2;
            bl = true;
        }
        return bl;
    }

    @Override
    public void notifyFramePending() {
        ThreadedRenderer.nNotifyFramePending(this.mNativeProxy);
    }

    @Override
    void onLayerDestroyed(HardwareLayer hardwareLayer) {
        ThreadedRenderer.nCancelLayerUpdate(this.mNativeProxy, hardwareLayer.getDeferredLayerUpdater());
    }

    @Override
    void pauseSurface(Surface surface) {
        ThreadedRenderer.nPauseSurface(this.mNativeProxy, surface);
    }

    @Override
    void pushLayerUpdate(HardwareLayer hardwareLayer) {
        ThreadedRenderer.nPushLayerUpdate(this.mNativeProxy, hardwareLayer.getDeferredLayerUpdater());
    }

    @Override
    void registerAnimatingRenderNode(RenderNode renderNode) {
        ThreadedRenderer.nRegisterAnimatingRenderNode(this.mRootNode.mNativeRenderNode, renderNode.mNativeRenderNode);
    }

    @Override
    void setName(String string2) {
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    void setOpaque(boolean bl) {
        long l = this.mNativeProxy;
        boolean bl2 = bl && !this.mHasInsets;
        ThreadedRenderer.nSetOpaque(l, bl2);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    void setup(int n, int n2, Rect rect) {
        float f = (float)n / 2.0f;
        this.mWidth = n;
        this.mHeight = n2;
        if (rect != null && !rect.isEmpty()) {
            this.mHasInsets = true;
            this.mInsetLeft = rect.left;
            this.mInsetTop = rect.top;
            this.mSurfaceWidth = n + this.mInsetLeft + rect.right;
            this.mSurfaceHeight = n2 + this.mInsetTop + rect.bottom;
            this.setOpaque(false);
        } else {
            this.mHasInsets = false;
            this.mInsetLeft = 0;
            this.mInsetTop = 0;
            this.mSurfaceWidth = n;
            this.mSurfaceHeight = n2;
        }
        this.mRootNode.setLeftTopRightBottom(-this.mInsetLeft, -this.mInsetTop, this.mSurfaceWidth, this.mSurfaceHeight);
        ThreadedRenderer.nSetup(this.mNativeProxy, this.mSurfaceWidth, this.mSurfaceHeight, f, this.mLightY, this.mLightZ, this.mLightRadius, this.mAmbientShadowAlpha, this.mSpotShadowAlpha);
    }

    @Override
    void stopDrawing() {
        ThreadedRenderer.nStopDrawing(this.mNativeProxy);
    }

    @Override
    void updateSurface(Surface surface) throws Surface.OutOfResourcesException {
        this.updateEnabledState(surface);
        ThreadedRenderer.nUpdateSurface(this.mNativeProxy, surface);
    }

    private static class AtlasInitializer {
        static AtlasInitializer sInstance = new AtlasInitializer();
        private boolean mInitialized = false;

        private AtlasInitializer() {
        }

        private static void validateMap(Context context, long[] lArray) {
            Log.d("Atlas", "Validating map...");
            HashSet<Long> hashSet = new HashSet<Long>();
            LongSparseArray<Drawable.ConstantState> longSparseArray = context.getResources().getPreloadedDrawables();
            int n = longSparseArray.size();
            for (int i = 0; i < n; ++i) {
                Bitmap bitmap = longSparseArray.valueAt(i).getBitmap();
                if (bitmap == null || bitmap.getConfig() != Bitmap.Config.ARGB_8888) continue;
                hashSet.add(bitmap.mNativeBitmap);
            }
            for (int i = 0; i < lArray.length; i += 4) {
                if (hashSet.contains(lArray[i])) continue;
                Object[] objectArray = new Object[]{lArray[i]};
                Log.w("Atlas", String.format("Pointer 0x%X, not in getPreloadedDrawables?", objectArray));
                lArray[i] = 0L;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        void init(Context context, long l) {
            synchronized (this) {
                block8: {
                    IBinder iBinder;
                    boolean bl = this.mInitialized;
                    if (!bl && (iBinder = ServiceManager.getService("assetatlas")) != null) {
                        IAssetAtlas iAssetAtlas = IAssetAtlas.Stub.asInterface(iBinder);
                        try {
                            GraphicBuffer graphicBuffer;
                            if (!iAssetAtlas.isCompatible(Process.myPpid()) || (graphicBuffer = iAssetAtlas.getBuffer()) == null) break block8;
                            long[] lArray = iAssetAtlas.getMap();
                            if (lArray != null) {
                                AtlasInitializer.validateMap(context, lArray);
                                ThreadedRenderer.nSetAtlas(l, graphicBuffer, lArray);
                                this.mInitialized = true;
                            }
                            if (iAssetAtlas.getClass() != iBinder.getClass()) {
                                graphicBuffer.destroy();
                            }
                        }
                        catch (RemoteException remoteException) {
                            Log.w("HardwareRenderer", "Could not acquire atlas", remoteException);
                        }
                    }
                }
                return;
            }
        }
    }
}

