/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.graphics.Rect;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;

public class TouchDelegate {
    public static final int ABOVE = 1;
    public static final int BELOW = 2;
    public static final int TO_LEFT = 4;
    public static final int TO_RIGHT = 8;
    private Rect mBounds;
    private boolean mDelegateTargeted;
    private View mDelegateView;
    private int mSlop;
    private Rect mSlopBounds;

    public TouchDelegate(Rect rect, View view) {
        this.mBounds = rect;
        this.mSlop = ViewConfiguration.get(view.getContext()).getScaledTouchSlop();
        this.mSlopBounds = new Rect(rect);
        this.mSlopBounds.inset(-this.mSlop, -this.mSlop);
        this.mDelegateView = view;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean onTouchEvent(MotionEvent motionEvent) {
        int n = (int)motionEvent.getX();
        int n2 = (int)motionEvent.getY();
        boolean bl = true;
        int n3 = motionEvent.getAction();
        boolean bl2 = false;
        switch (n3) {
            case 0: {
                boolean bl3 = this.mBounds.contains(n, n2);
                bl2 = false;
                if (!bl3) break;
                this.mDelegateTargeted = true;
                bl2 = true;
                break;
            }
            case 1: 
            case 2: {
                bl2 = this.mDelegateTargeted;
                if (!bl2 || this.mSlopBounds.contains(n, n2)) break;
                bl = false;
                break;
            }
            case 3: {
                bl2 = this.mDelegateTargeted;
                this.mDelegateTargeted = false;
            }
        }
        boolean bl4 = false;
        if (!bl2) return bl4;
        View view = this.mDelegateView;
        if (bl) {
            motionEvent.setLocation(view.getWidth() / 2, view.getHeight() / 2);
            return view.dispatchTouchEvent(motionEvent);
        } else {
            int n4 = this.mSlop;
            motionEvent.setLocation(-(n4 * 2), -(n4 * 2));
        }
        return view.dispatchTouchEvent(motionEvent);
    }
}

