/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.animation.TimeInterpolator;
import android.view.RenderNodeAnimator;
import android.view.View;
import android.view.ViewPropertyAnimator;
import android.view.animation.Interpolator;
import android.view.animation.LinearInterpolator;
import com.android.internal.view.animation.FallbackLUTInterpolator;
import java.util.ArrayList;

class ViewPropertyAnimatorRT {
    private static final Interpolator sLinearInterpolator = new LinearInterpolator();
    private RenderNodeAnimator[] mAnimators = new RenderNodeAnimator[12];
    private final View mView;

    ViewPropertyAnimatorRT(View view) {
        this.mView = view;
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean canHandleAnimator(ViewPropertyAnimator viewPropertyAnimator) {
        return viewPropertyAnimator.getUpdateListener() == null && viewPropertyAnimator.getListener() == null && this.mView.isHardwareAccelerated() && !viewPropertyAnimator.hasActions();
    }

    private void cancelAnimators(ArrayList<ViewPropertyAnimator.NameValuesHolder> arrayList) {
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            int n2 = RenderNodeAnimator.mapViewPropertyToRenderProperty(arrayList.get((int)i).mNameConstant);
            if (this.mAnimators[n2] == null) continue;
            this.mAnimators[n2].cancel();
            this.mAnimators[n2] = null;
        }
    }

    private void doStartAnimation(ViewPropertyAnimator viewPropertyAnimator) {
        int n = viewPropertyAnimator.mPendingAnimations.size();
        long l = viewPropertyAnimator.getStartDelay();
        long l2 = viewPropertyAnimator.getDuration();
        TimeInterpolator timeInterpolator = viewPropertyAnimator.getInterpolator();
        if (timeInterpolator == null) {
            timeInterpolator = sLinearInterpolator;
        }
        if (!RenderNodeAnimator.isNativeInterpolator(timeInterpolator)) {
            timeInterpolator = new FallbackLUTInterpolator(timeInterpolator, l2);
        }
        for (int i = 0; i < n; ++i) {
            ViewPropertyAnimator.NameValuesHolder nameValuesHolder = viewPropertyAnimator.mPendingAnimations.get(i);
            int n2 = RenderNodeAnimator.mapViewPropertyToRenderProperty(nameValuesHolder.mNameConstant);
            RenderNodeAnimator renderNodeAnimator = new RenderNodeAnimator(n2, nameValuesHolder.mFromValue + nameValuesHolder.mDeltaValue);
            renderNodeAnimator.setStartDelay(l);
            renderNodeAnimator.setDuration(l2);
            renderNodeAnimator.setInterpolator(timeInterpolator);
            renderNodeAnimator.setTarget(this.mView);
            renderNodeAnimator.start();
            this.mAnimators[n2] = renderNodeAnimator;
        }
        viewPropertyAnimator.mPendingAnimations.clear();
    }

    public void cancelAll() {
        for (int i = 0; i < this.mAnimators.length; ++i) {
            if (this.mAnimators[i] == null) continue;
            this.mAnimators[i].cancel();
            this.mAnimators[i] = null;
        }
    }

    public boolean startAnimation(ViewPropertyAnimator viewPropertyAnimator) {
        this.cancelAnimators(viewPropertyAnimator.mPendingAnimations);
        if (!this.canHandleAnimator(viewPropertyAnimator)) {
            return false;
        }
        this.doStartAnimation(viewPropertyAnimator);
        return true;
    }
}

