/*
 * Decompiled with CFR 0.152.
 */
package android.view.accessibility;

import android.os.Build;
import android.util.ArraySet;
import android.util.Log;
import android.util.LongArray;
import android.util.LongSparseArray;
import android.util.SparseArray;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityNodeInfo;
import android.view.accessibility.AccessibilityWindowInfo;
import java.util.ArrayList;
import java.util.List;

final class AccessibilityCache {
    private static final boolean CHECK_INTEGRITY = false;
    private static final boolean DEBUG = false;
    private static final String LOG_TAG = "AccessibilityCache";
    private final Object mLock = new Object();
    private final SparseArray<LongSparseArray<AccessibilityNodeInfo>> mNodeCache;
    private final SparseArray<AccessibilityWindowInfo> mTempWindowArray;
    private final SparseArray<AccessibilityWindowInfo> mWindowCache = new SparseArray();

    static {
        CHECK_INTEGRITY = "eng".equals(Build.TYPE);
    }

    AccessibilityCache() {
        this.mNodeCache = new SparseArray();
        this.mTempWindowArray = new SparseArray();
    }

    private void clearNodesForWindowLocked(int n) {
        LongSparseArray<AccessibilityNodeInfo> longSparseArray = this.mNodeCache.get(n);
        if (longSparseArray == null) {
            return;
        }
        for (int i = -1 + longSparseArray.size(); i >= 0; --i) {
            AccessibilityNodeInfo accessibilityNodeInfo = longSparseArray.valueAt(i);
            longSparseArray.removeAt(i);
            accessibilityNodeInfo.recycle();
        }
        this.mNodeCache.remove(n);
    }

    private void clearSubTreeLocked(int n, long l) {
        LongSparseArray<AccessibilityNodeInfo> longSparseArray = this.mNodeCache.get(n);
        if (longSparseArray != null) {
            this.clearSubTreeRecursiveLocked(longSparseArray, l);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void clearSubTreeRecursiveLocked(LongSparseArray<AccessibilityNodeInfo> longSparseArray, long l) {
        AccessibilityNodeInfo accessibilityNodeInfo = longSparseArray.get(l);
        if (accessibilityNodeInfo != null) {
            longSparseArray.remove(l);
            int n = accessibilityNodeInfo.getChildCount();
            for (int i = 0; i < n; ++i) {
                this.clearSubTreeRecursiveLocked(longSparseArray, accessibilityNodeInfo.getChildId(i));
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void refreshCachedNodeLocked(int n, long l) {
        AccessibilityNodeInfo accessibilityNodeInfo;
        LongSparseArray<AccessibilityNodeInfo> longSparseArray = this.mNodeCache.get(n);
        if (longSparseArray == null || (accessibilityNodeInfo = longSparseArray.get(l)) == null || accessibilityNodeInfo.refresh(true)) {
            return;
        }
        this.clearSubTreeLocked(n, l);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void add(AccessibilityNodeInfo accessibilityNodeInfo) {
        Object object = this.mLock;
        synchronized (object) {
            long l;
            AccessibilityNodeInfo accessibilityNodeInfo2;
            int n = accessibilityNodeInfo.getWindowId();
            LongSparseArray<AccessibilityNodeInfo> longSparseArray = this.mNodeCache.get(n);
            if (longSparseArray == null) {
                longSparseArray = new LongSparseArray();
                this.mNodeCache.put(n, longSparseArray);
            }
            if ((accessibilityNodeInfo2 = longSparseArray.get(l = accessibilityNodeInfo.getSourceNodeId())) != null) {
                LongArray longArray = accessibilityNodeInfo.getChildNodeIds();
                int n2 = accessibilityNodeInfo2.getChildCount();
                int n3 = 0;
                while (true) {
                    if (n3 < n2) {
                        long l2 = accessibilityNodeInfo2.getChildId(n3);
                        if (longArray == null || longArray.indexOf(l2) < 0) {
                            this.clearSubTreeLocked(n, l2);
                        }
                    } else {
                        long l3 = accessibilityNodeInfo2.getParentNodeId();
                        if (accessibilityNodeInfo.getParentNodeId() == l3) break;
                        this.clearSubTreeLocked(n, l3);
                        break;
                    }
                    ++n3;
                }
            }
            longSparseArray.put(l, AccessibilityNodeInfo.obtain(accessibilityNodeInfo));
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void addWindow(AccessibilityWindowInfo accessibilityWindowInfo) {
        Object object = this.mLock;
        synchronized (object) {
            int n = accessibilityWindowInfo.getId();
            AccessibilityWindowInfo accessibilityWindowInfo2 = this.mWindowCache.get(n);
            if (accessibilityWindowInfo2 != null) {
                accessibilityWindowInfo2.recycle();
            }
            this.mWindowCache.put(n, AccessibilityWindowInfo.obtain(accessibilityWindowInfo));
            return;
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void checkIntegrity() {
        var1_1 = this.mLock;
        synchronized (var1_1) {
            if (this.mWindowCache.size() <= 0 && this.mNodeCache.size() == 0) {
                return;
            }
            var3_2 = null;
            var4_3 = null;
            var5_4 = this.mWindowCache.size();
            var6_5 = 0;
            while (true) {
                if (var6_5 >= var5_4) break;
                var7_6 = this.mWindowCache.valueAt(var6_5);
                if (var7_6.isActive()) {
                    if (var4_3 != null) {
                        Log.e("AccessibilityCache", "Duplicate active window:" + var7_6);
                    } else {
                        var4_3 = var7_6;
                    }
                }
                if (var7_6.isFocused()) {
                    if (var3_2 != null) {
                        Log.e("AccessibilityCache", "Duplicate focused window:" + var7_6);
                    } else {
                        var3_2 = var7_6;
                    }
                }
                ++var6_5;
            }
            var10_7 = null;
            var11_8 = null;
            var12_9 = this.mNodeCache.size();
            var13_10 = 0;
            block3: while (true) {
                if (var13_10 >= var12_9) {
                    return;
                }
                var14_11 = this.mNodeCache.valueAt(var13_10);
                if (var14_11.size() <= 0) ** GOTO lbl83
                var15_12 = new ArraySet<AccessibilityNodeInfo>();
                var16_13 = this.mNodeCache.keyAt(var13_10);
                var17_14 = var14_11.size();
                var18_15 = 0;
                while (true) {
                    block27: {
                        block25: {
                            block26: {
                                if (var18_15 >= var17_14) break block25;
                                var19_16 = var14_11.valueAt(var18_15);
                                if (var15_12.add(var19_16)) break block26;
                                Log.e("AccessibilityCache", "Duplicate node: " + var19_16 + " in window:" + var16_13);
                                break block27;
                            }
                            if (var19_16.isAccessibilityFocused()) {
                                if (var10_7 != null) {
                                    Log.e("AccessibilityCache", "Duplicate accessibility focus:" + var19_16 + " in window:" + var16_13);
                                } else {
                                    var10_7 = var19_16;
                                }
                            }
                            if (var19_16.isFocused()) {
                                if (var11_8 != null) {
                                    Log.e("AccessibilityCache", "Duplicate input focus: " + var19_16 + " in window:" + var16_13);
                                } else {
                                    var11_8 = var19_16;
                                }
                            }
                            if ((var22_17 = var14_11.get(var19_16.getParentNodeId())) == null) ** GOTO lbl71
                            var23_18 = var22_17.getChildCount();
                            var24_19 = 0;
                            while (true) {
                                block29: {
                                    block28: {
                                        var25_20 = false;
                                        if (var24_19 >= var23_18) break block28;
                                        if (var14_11.get(var22_17.getChildId(var24_19)) != var19_16) break block29;
                                        var25_20 = true;
                                    }
                                    if (!var25_20) {
                                        Log.e("AccessibilityCache", "Invalid parent-child relation between parent: " + var22_17 + " and child: " + var19_16);
                                    }
lbl71:
                                    // 4 sources

                                    var27_21 = var19_16.getChildCount();
                                    break;
                                }
                                ++var24_19;
                            }
                            for (var28_22 = 0; var28_22 < var27_21; ++var28_22) {
                                var29_23 = var14_11.get(var19_16.getChildId(var28_22));
                                if (var29_23 == null || var14_11.get(var29_23.getParentNodeId()) == var19_16) continue;
                                Log.e("AccessibilityCache", "Invalid child-parent relation between child: " + var19_16 + " and parent: " + var22_17);
                            }
                            break block27;
                        }
                        ++var13_10;
                        continue block3;
                    }
                    ++var18_15;
                }
                break;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void clear() {
        Object object = this.mLock;
        synchronized (object) {
            for (int i = -1 + this.mWindowCache.size(); i >= 0; --i) {
                this.mWindowCache.valueAt(i).recycle();
                this.mWindowCache.removeAt(i);
            }
            int n = this.mNodeCache.size();
            int n2 = 0;
            while (n2 < n) {
                this.clearNodesForWindowLocked(this.mNodeCache.keyAt(n2));
                ++n2;
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public AccessibilityNodeInfo getNode(int n, long l) {
        Object object = this.mLock;
        synchronized (object) {
            LongSparseArray<AccessibilityNodeInfo> longSparseArray = this.mNodeCache.get(n);
            if (longSparseArray == null) {
                return null;
            }
            AccessibilityNodeInfo accessibilityNodeInfo = longSparseArray.get(l);
            if (accessibilityNodeInfo == null) return accessibilityNodeInfo;
            return AccessibilityNodeInfo.obtain(accessibilityNodeInfo);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public AccessibilityWindowInfo getWindow(int n) {
        Object object = this.mLock;
        synchronized (object) {
            AccessibilityWindowInfo accessibilityWindowInfo = this.mWindowCache.get(n);
            if (accessibilityWindowInfo == null) return null;
            return AccessibilityWindowInfo.obtain(accessibilityWindowInfo);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<AccessibilityWindowInfo> getWindows() {
        Object object = this.mLock;
        synchronized (object) {
            int n = this.mWindowCache.size();
            if (n <= 0) {
                return null;
            }
            SparseArray<AccessibilityWindowInfo> sparseArray = this.mTempWindowArray;
            sparseArray.clear();
            for (int i = 0; i < n; ++i) {
                AccessibilityWindowInfo accessibilityWindowInfo = this.mWindowCache.valueAt(i);
                sparseArray.put(accessibilityWindowInfo.getLayer(), accessibilityWindowInfo);
            }
            ArrayList<AccessibilityWindowInfo> arrayList = new ArrayList<AccessibilityWindowInfo>(n);
            int n2 = n - 1;
            while (n2 >= 0) {
                arrayList.add(AccessibilityWindowInfo.obtain(sparseArray.valueAt(n2)));
                sparseArray.removeAt(n2);
                --n2;
            }
            return arrayList;
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void onAccessibilityEvent(AccessibilityEvent var1_1) {
        var2_2 = this.mLock;
        synchronized (var2_2) {
            block18: {
                switch (var1_1.getEventType()) {
                    case 4: 
                    case 8: 
                    case 16: 
                    case 8192: 
                    case 32768: 
                    case 65536: {
                        this.refreshCachedNodeLocked(var1_1.getWindowId(), var1_1.getSourceNodeId());
                        ** break;
                    }
                    case 2048: {
                        var4_3 = this.mLock;
                        synchronized (var4_3) {
                            var6_4 = var1_1.getWindowId();
                            var7_5 = var1_1.getSourceNodeId();
                            if ((1 & var1_1.getContentChangeTypes()) != 0) {
                                this.clearSubTreeLocked(var6_4, var7_5);
                            } else {
                                this.refreshCachedNodeLocked(var6_4, var7_5);
                            }
                            ** break;
                        }
                    }
                    case 4096: {
                        this.clearSubTreeLocked(var1_1.getWindowId(), var1_1.getSourceNodeId());
                    }
lbl19:
                    // 5 sources

                    default: {
                        break block18;
                    }
                    case 32: 
                    case 0x400000: 
                }
                this.clear();
            }
            ** if (!AccessibilityCache.CHECK_INTEGRITY) goto lbl26
        }
lbl-1000:
        // 1 sources

        {
            this.checkIntegrity();
        }
lbl26:
        // 2 sources

    }
}

