/*
 * Decompiled with CFR 0.152.
 */
package android.view.animation;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.RectF;
import android.util.AttributeSet;
import android.view.animation.Animation;
import android.view.animation.Interpolator;
import android.view.animation.Transformation;
import com.android.internal.R;
import java.util.ArrayList;
import java.util.List;

public class AnimationSet
extends Animation {
    private static final int PROPERTY_CHANGE_BOUNDS_MASK = 128;
    private static final int PROPERTY_DURATION_MASK = 32;
    private static final int PROPERTY_FILL_AFTER_MASK = 1;
    private static final int PROPERTY_FILL_BEFORE_MASK = 2;
    private static final int PROPERTY_MORPH_MATRIX_MASK = 64;
    private static final int PROPERTY_REPEAT_MODE_MASK = 4;
    private static final int PROPERTY_SHARE_INTERPOLATOR_MASK = 16;
    private static final int PROPERTY_START_OFFSET_MASK = 8;
    private ArrayList<Animation> mAnimations = new ArrayList();
    private boolean mDirty;
    private int mFlags = 0;
    private boolean mHasAlpha;
    private long mLastEnd;
    private long[] mStoredOffsets;
    private Transformation mTempTransformation = new Transformation();

    public AnimationSet(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        TypedArray typedArray = context.obtainStyledAttributes(attributeSet, R.styleable.AnimationSet);
        this.setFlag(16, typedArray.getBoolean(1, true));
        this.init();
        if (context.getApplicationInfo().targetSdkVersion >= 14) {
            if (typedArray.hasValue(0)) {
                this.mFlags = 0x20 | this.mFlags;
            }
            if (typedArray.hasValue(2)) {
                this.mFlags = 2 | this.mFlags;
            }
            if (typedArray.hasValue(3)) {
                this.mFlags = 1 | this.mFlags;
            }
            if (typedArray.hasValue(5)) {
                this.mFlags = 4 | this.mFlags;
            }
            if (typedArray.hasValue(4)) {
                this.mFlags = 8 | this.mFlags;
            }
        }
        typedArray.recycle();
    }

    public AnimationSet(boolean bl) {
        this.setFlag(16, bl);
        this.init();
    }

    private void init() {
        this.mStartTime = 0L;
    }

    private void setFlag(int n, boolean bl) {
        if (bl) {
            this.mFlags = n | this.mFlags;
            return;
        }
        this.mFlags &= ~n;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void addAnimation(Animation animation) {
        this.mAnimations.add(animation);
        boolean bl = (0x40 & this.mFlags) == 0;
        if (bl && animation.willChangeTransformationMatrix()) {
            this.mFlags = 0x40 | this.mFlags;
        }
        int n = 0x80 & this.mFlags;
        boolean bl2 = false;
        if (n == 0) {
            bl2 = true;
        }
        if (bl2 && animation.willChangeBounds()) {
            this.mFlags = 0x80 | this.mFlags;
        }
        if ((0x20 & this.mFlags) == 32) {
            this.mLastEnd = this.mStartOffset + this.mDuration;
        } else if (this.mAnimations.size() == 1) {
            this.mDuration = animation.getStartOffset() + animation.getDuration();
            this.mLastEnd = this.mStartOffset + this.mDuration;
        } else {
            this.mLastEnd = Math.max(this.mLastEnd, animation.getStartOffset() + animation.getDuration());
            this.mDuration = this.mLastEnd - this.mStartOffset;
        }
        this.mDirty = true;
    }

    @Override
    protected AnimationSet clone() throws CloneNotSupportedException {
        AnimationSet animationSet = (AnimationSet)super.clone();
        animationSet.mTempTransformation = new Transformation();
        animationSet.mAnimations = new ArrayList();
        int n = this.mAnimations.size();
        ArrayList<Animation> arrayList = this.mAnimations;
        for (int i = 0; i < n; ++i) {
            animationSet.mAnimations.add(arrayList.get(i).clone());
        }
        return animationSet;
    }

    @Override
    public long computeDurationHint() {
        long l = 0L;
        int n = this.mAnimations.size();
        ArrayList<Animation> arrayList = this.mAnimations;
        for (int i = n - 1; i >= 0; --i) {
            long l2 = arrayList.get(i).computeDurationHint();
            if (l2 <= l) continue;
            l = l2;
        }
        return l;
    }

    public List<Animation> getAnimations() {
        return this.mAnimations;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public long getDuration() {
        ArrayList<Animation> arrayList = this.mAnimations;
        int n = arrayList.size();
        long l = 0L;
        boolean bl = (0x20 & this.mFlags) == 32;
        if (bl) {
            return this.mDuration;
        }
        int n2 = 0;
        while (n2 < n) {
            l = Math.max(l, arrayList.get(n2).getDuration());
            ++n2;
        }
        return l;
    }

    @Override
    public long getStartTime() {
        long l = Long.MAX_VALUE;
        int n = this.mAnimations.size();
        ArrayList<Animation> arrayList = this.mAnimations;
        for (int i = 0; i < n; ++i) {
            l = Math.min(l, arrayList.get(i).getStartTime());
        }
        return l;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean getTransformation(long l, Transformation transformation) {
        int n = this.mAnimations.size();
        ArrayList<Animation> arrayList = this.mAnimations;
        Transformation transformation2 = this.mTempTransformation;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = true;
        transformation.clear();
        for (int i = n - 1; i >= 0; --i) {
            Animation animation = arrayList.get(i);
            transformation2.clear();
            bl = animation.getTransformation(l, transformation2, this.getScaleFactor()) || bl;
            transformation.compose(transformation2);
            bl2 = bl2 || animation.hasStarted();
            bl3 = animation.hasEnded() && bl3;
        }
        if (bl2 && !this.mStarted) {
            if (this.mListener != null) {
                this.mListener.onAnimationStart(this);
            }
            this.mStarted = true;
        }
        if (bl3 != this.mEnded) {
            if (this.mListener != null) {
                this.mListener.onAnimationEnd(this);
            }
            this.mEnded = bl3;
        }
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean hasAlpha() {
        if (!this.mDirty) return this.mHasAlpha;
        this.mHasAlpha = false;
        this.mDirty = false;
        int n = this.mAnimations.size();
        ArrayList<Animation> arrayList = this.mAnimations;
        int n2 = 0;
        while (n2 < n) {
            if (arrayList.get(n2).hasAlpha()) {
                this.mHasAlpha = true;
                return this.mHasAlpha;
            }
            ++n2;
        }
        return this.mHasAlpha;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void initialize(int n, int n2, int n3, int n4) {
        super.initialize(n, n2, n3, n4);
        boolean bl = (0x20 & this.mFlags) == 32;
        boolean bl2 = (1 & this.mFlags) == 1;
        boolean bl3 = (2 & this.mFlags) == 2;
        boolean bl4 = (4 & this.mFlags) == 4;
        boolean bl5 = (0x10 & this.mFlags) == 16;
        boolean bl6 = (8 & this.mFlags) == 8;
        if (bl5) {
            this.ensureInterpolator();
        }
        ArrayList<Animation> arrayList = this.mAnimations;
        int n5 = arrayList.size();
        long l = this.mDuration;
        boolean bl7 = this.mFillAfter;
        boolean bl8 = this.mFillBefore;
        int n6 = this.mRepeatMode;
        Interpolator interpolator2 = this.mInterpolator;
        long l2 = this.mStartOffset;
        long[] lArray = this.mStoredOffsets;
        if (bl6) {
            if (lArray == null || lArray.length != n5) {
                this.mStoredOffsets = lArray = new long[n5];
            }
        } else if (lArray != null) {
            this.mStoredOffsets = null;
            lArray = null;
        }
        int n7 = 0;
        while (n7 < n5) {
            Animation animation = arrayList.get(n7);
            if (bl) {
                animation.setDuration(l);
            }
            if (bl2) {
                animation.setFillAfter(bl7);
            }
            if (bl3) {
                animation.setFillBefore(bl8);
            }
            if (bl4) {
                animation.setRepeatMode(n6);
            }
            if (bl5) {
                animation.setInterpolator(interpolator2);
            }
            if (bl6) {
                long l3 = animation.getStartOffset();
                animation.setStartOffset(l3 + l2);
                lArray[n7] = l3;
            }
            animation.initialize(n, n2, n3, n4);
            ++n7;
        }
        return;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void initializeInvalidateRegion(int n, int n2, int n3, int n4) {
        RectF rectF = this.mPreviousRegion;
        rectF.set(n, n2, n3, n4);
        rectF.inset(-1.0f, -1.0f);
        if (this.mFillBefore) {
            int n5 = this.mAnimations.size();
            ArrayList<Animation> arrayList = this.mAnimations;
            Transformation transformation = this.mTempTransformation;
            Transformation transformation2 = this.mPreviousTransformation;
            for (int i = n5 - 1; i >= 0; --i) {
                Animation animation = arrayList.get(i);
                if (animation.isFillEnabled() && !animation.getFillBefore() && animation.getStartOffset() != 0L) continue;
                transformation.clear();
                Interpolator interpolator2 = animation.mInterpolator;
                float f = interpolator2 != null ? interpolator2.getInterpolation(0.0f) : 0.0f;
                animation.applyTransformation(f, transformation);
                transformation2.compose(transformation);
            }
        }
    }

    @Override
    public void reset() {
        super.reset();
        this.restoreChildrenStartOffset();
    }

    /*
     * Enabled aggressive block sorting
     */
    void restoreChildrenStartOffset() {
        long[] lArray = this.mStoredOffsets;
        if (lArray != null) {
            ArrayList<Animation> arrayList = this.mAnimations;
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                arrayList.get(i).setStartOffset(lArray[i]);
            }
        }
    }

    @Override
    public void restrictDuration(long l) {
        super.restrictDuration(l);
        ArrayList<Animation> arrayList = this.mAnimations;
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            arrayList.get(i).restrictDuration(l);
        }
    }

    @Override
    public void scaleCurrentDuration(float f) {
        ArrayList<Animation> arrayList = this.mAnimations;
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            arrayList.get(i).scaleCurrentDuration(f);
        }
    }

    @Override
    public void setDuration(long l) {
        this.mFlags = 0x20 | this.mFlags;
        super.setDuration(l);
        this.mLastEnd = this.mStartOffset + this.mDuration;
    }

    @Override
    public void setFillAfter(boolean bl) {
        this.mFlags = 1 | this.mFlags;
        super.setFillAfter(bl);
    }

    @Override
    public void setFillBefore(boolean bl) {
        this.mFlags = 2 | this.mFlags;
        super.setFillBefore(bl);
    }

    @Override
    public void setRepeatMode(int n) {
        this.mFlags = 4 | this.mFlags;
        super.setRepeatMode(n);
    }

    @Override
    public void setStartOffset(long l) {
        this.mFlags = 8 | this.mFlags;
        super.setStartOffset(l);
    }

    @Override
    public void setStartTime(long l) {
        super.setStartTime(l);
        int n = this.mAnimations.size();
        ArrayList<Animation> arrayList = this.mAnimations;
        for (int i = 0; i < n; ++i) {
            arrayList.get(i).setStartTime(l);
        }
    }

    @Override
    public boolean willChangeBounds() {
        return (0x80 & this.mFlags) == 128;
    }

    @Override
    public boolean willChangeTransformationMatrix() {
        return (0x40 & this.mFlags) == 64;
    }
}

