/*
 * Decompiled with CFR 0.152.
 */
package android.view.textservice;

import android.os.Binder;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Message;
import android.os.RemoteException;
import android.util.Log;
import android.view.textservice.SentenceSuggestionsInfo;
import android.view.textservice.SpellCheckerInfo;
import android.view.textservice.SpellCheckerSubtype;
import android.view.textservice.SuggestionsInfo;
import android.view.textservice.TextInfo;
import com.android.internal.textservice.ISpellCheckerSession;
import com.android.internal.textservice.ISpellCheckerSessionListener;
import com.android.internal.textservice.ITextServicesManager;
import com.android.internal.textservice.ITextServicesSessionListener;
import java.util.LinkedList;
import java.util.Queue;

public class SpellCheckerSession {
    private static final boolean DBG = false;
    private static final int MSG_ON_GET_SUGGESTION_MULTIPLE = 1;
    private static final int MSG_ON_GET_SUGGESTION_MULTIPLE_FOR_SENTENCE = 2;
    public static final String SERVICE_META_DATA = "android.view.textservice.scs";
    private static final String TAG = SpellCheckerSession.class.getSimpleName();
    private final Handler mHandler = new Handler(){

        @Override
        public void handleMessage(Message message) {
            switch (message.what) {
                default: {
                    return;
                }
                case 1: {
                    SpellCheckerSession.this.handleOnGetSuggestionsMultiple((SuggestionsInfo[])message.obj);
                    return;
                }
                case 2: 
            }
            SpellCheckerSession.this.handleOnGetSentenceSuggestionsMultiple((SentenceSuggestionsInfo[])message.obj);
        }
    };
    private final InternalListener mInternalListener;
    private boolean mIsUsed;
    private final SpellCheckerInfo mSpellCheckerInfo;
    private SpellCheckerSessionListener mSpellCheckerSessionListener;
    private final SpellCheckerSessionListenerImpl mSpellCheckerSessionListenerImpl;
    private final SpellCheckerSubtype mSubtype;
    private final ITextServicesManager mTextServicesManager;

    public SpellCheckerSession(SpellCheckerInfo spellCheckerInfo, ITextServicesManager iTextServicesManager, SpellCheckerSessionListener spellCheckerSessionListener, SpellCheckerSubtype spellCheckerSubtype) {
        if (spellCheckerInfo == null || spellCheckerSessionListener == null || iTextServicesManager == null) {
            throw new NullPointerException();
        }
        this.mSpellCheckerInfo = spellCheckerInfo;
        this.mSpellCheckerSessionListenerImpl = new SpellCheckerSessionListenerImpl(this.mHandler);
        this.mInternalListener = new InternalListener(this.mSpellCheckerSessionListenerImpl);
        this.mTextServicesManager = iTextServicesManager;
        this.mIsUsed = true;
        this.mSpellCheckerSessionListener = spellCheckerSessionListener;
        this.mSubtype = spellCheckerSubtype;
    }

    private void handleOnGetSentenceSuggestionsMultiple(SentenceSuggestionsInfo[] sentenceSuggestionsInfoArray) {
        this.mSpellCheckerSessionListener.onGetSentenceSuggestions(sentenceSuggestionsInfoArray);
    }

    private void handleOnGetSuggestionsMultiple(SuggestionsInfo[] suggestionsInfoArray) {
        this.mSpellCheckerSessionListener.onGetSuggestions(suggestionsInfoArray);
    }

    public void cancel() {
        this.mSpellCheckerSessionListenerImpl.cancel();
    }

    public void close() {
        this.mIsUsed = false;
        try {
            this.mSpellCheckerSessionListenerImpl.close();
            this.mTextServicesManager.finishSpellCheckerService(this.mSpellCheckerSessionListenerImpl);
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.mIsUsed) {
            Log.e(TAG, "SpellCheckerSession was not finished properly.You should call finishShession() when you finished to use a spell checker.");
            this.close();
        }
    }

    public void getSentenceSuggestions(TextInfo[] textInfoArray, int n) {
        this.mSpellCheckerSessionListenerImpl.getSentenceSuggestionsMultiple(textInfoArray, n);
    }

    public SpellCheckerInfo getSpellChecker() {
        return this.mSpellCheckerInfo;
    }

    public ISpellCheckerSessionListener getSpellCheckerSessionListener() {
        return this.mSpellCheckerSessionListenerImpl;
    }

    @Deprecated
    public void getSuggestions(TextInfo textInfo, int n) {
        this.getSuggestions(new TextInfo[]{textInfo}, n, false);
    }

    @Deprecated
    public void getSuggestions(TextInfo[] textInfoArray, int n, boolean bl) {
        this.mSpellCheckerSessionListenerImpl.getSuggestionsMultiple(textInfoArray, n, bl);
    }

    public ITextServicesSessionListener getTextServicesSessionListener() {
        return this.mInternalListener;
    }

    public boolean isSessionDisconnected() {
        return this.mSpellCheckerSessionListenerImpl.isDisconnected();
    }

    private static class InternalListener
    extends ITextServicesSessionListener.Stub {
        private final SpellCheckerSessionListenerImpl mParentSpellCheckerSessionListenerImpl;

        public InternalListener(SpellCheckerSessionListenerImpl spellCheckerSessionListenerImpl) {
            this.mParentSpellCheckerSessionListenerImpl = spellCheckerSessionListenerImpl;
        }

        @Override
        public void onServiceConnected(ISpellCheckerSession iSpellCheckerSession) {
            this.mParentSpellCheckerSessionListenerImpl.onServiceConnected(iSpellCheckerSession);
        }
    }

    public static interface SpellCheckerSessionListener {
        public void onGetSentenceSuggestions(SentenceSuggestionsInfo[] var1);

        public void onGetSuggestions(SuggestionsInfo[] var1);
    }

    private static class SpellCheckerSessionListenerImpl
    extends ISpellCheckerSessionListener.Stub {
        private static final int TASK_CANCEL = 1;
        private static final int TASK_CLOSE = 3;
        private static final int TASK_GET_SUGGESTIONS_MULTIPLE = 2;
        private static final int TASK_GET_SUGGESTIONS_MULTIPLE_FOR_SENTENCE = 4;
        private Handler mAsyncHandler;
        private Handler mHandler;
        private ISpellCheckerSession mISpellCheckerSession;
        private boolean mOpened = false;
        private final Queue<SpellCheckerParams> mPendingTasks = new LinkedList<SpellCheckerParams>();
        private HandlerThread mThread;

        public SpellCheckerSessionListenerImpl(Handler handler) {
            this.mHandler = handler;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void processOrEnqueueTask(SpellCheckerParams spellCheckerParams) {
            synchronized (this) {
                ISpellCheckerSession iSpellCheckerSession = this.mISpellCheckerSession;
                if (iSpellCheckerSession != null) {
                    // MONITOREXIT @DISABLED, blocks:[2, 6] lbl4 : MonitorExitStatement: MONITOREXIT : this
                    this.processTask(iSpellCheckerSession, spellCheckerParams, false);
                    return;
                }
                int n = spellCheckerParams.mWhat;
                SpellCheckerParams spellCheckerParams2 = null;
                if (n == 1) {
                    while (!this.mPendingTasks.isEmpty()) {
                        SpellCheckerParams spellCheckerParams3 = this.mPendingTasks.poll();
                        if (spellCheckerParams3.mWhat != 3) continue;
                        spellCheckerParams2 = spellCheckerParams3;
                    }
                }
                this.mPendingTasks.offer(spellCheckerParams);
                if (spellCheckerParams2 != null) {
                    this.mPendingTasks.offer(spellCheckerParams2);
                }
                return;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void processTask(ISpellCheckerSession iSpellCheckerSession, SpellCheckerParams spellCheckerParams, boolean bl) {
            if (bl || this.mAsyncHandler == null) {
                switch (spellCheckerParams.mWhat) {
                    case 1: {
                        try {
                            iSpellCheckerSession.onCancel();
                        }
                        catch (RemoteException remoteException) {
                            Log.e(TAG, "Failed to cancel " + remoteException);
                        }
                        break;
                    }
                    case 2: {
                        try {
                            iSpellCheckerSession.onGetSuggestionsMultiple(spellCheckerParams.mTextInfos, spellCheckerParams.mSuggestionsLimit, spellCheckerParams.mSequentialWords);
                        }
                        catch (RemoteException remoteException) {
                            Log.e(TAG, "Failed to get suggestions " + remoteException);
                        }
                        break;
                    }
                    case 4: {
                        try {
                            iSpellCheckerSession.onGetSentenceSuggestionsMultiple(spellCheckerParams.mTextInfos, spellCheckerParams.mSuggestionsLimit);
                        }
                        catch (RemoteException remoteException) {
                            Log.e(TAG, "Failed to get suggestions " + remoteException);
                        }
                        break;
                    }
                    case 3: {
                        try {
                            iSpellCheckerSession.onClose();
                        }
                        catch (RemoteException remoteException) {
                            Log.e(TAG, "Failed to close " + remoteException);
                        }
                        break;
                    }
                }
            } else {
                spellCheckerParams.mSession = iSpellCheckerSession;
                this.mAsyncHandler.sendMessage(Message.obtain(this.mAsyncHandler, 1, spellCheckerParams));
            }
            if (spellCheckerParams.mWhat == 3) {
                synchronized (this) {
                    this.mISpellCheckerSession = null;
                    this.mHandler = null;
                    if (this.mThread != null) {
                        this.mThread.quit();
                    }
                    this.mThread = null;
                    this.mAsyncHandler = null;
                }
            }
        }

        public void cancel() {
            this.processOrEnqueueTask(new SpellCheckerParams(1, null, 0, false));
        }

        public void close() {
            this.processOrEnqueueTask(new SpellCheckerParams(3, null, 0, false));
        }

        public void getSentenceSuggestionsMultiple(TextInfo[] textInfoArray, int n) {
            this.processOrEnqueueTask(new SpellCheckerParams(4, textInfoArray, n, false));
        }

        public void getSuggestionsMultiple(TextInfo[] textInfoArray, int n, boolean bl) {
            this.processOrEnqueueTask(new SpellCheckerParams(2, textInfoArray, n, bl));
        }

        public boolean isDisconnected() {
            return this.mOpened && this.mISpellCheckerSession == null;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void onGetSentenceSuggestions(SentenceSuggestionsInfo[] sentenceSuggestionsInfoArray) {
            synchronized (this) {
                if (this.mHandler != null) {
                    this.mHandler.sendMessage(Message.obtain(this.mHandler, 2, sentenceSuggestionsInfoArray));
                }
                return;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void onGetSuggestions(SuggestionsInfo[] suggestionsInfoArray) {
            synchronized (this) {
                if (this.mHandler != null) {
                    this.mHandler.sendMessage(Message.obtain(this.mHandler, 1, suggestionsInfoArray));
                }
                return;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        public void onServiceConnected(ISpellCheckerSession iSpellCheckerSession) {
            // MONITORENTER : this
            // MONITORENTER : this
            this.mISpellCheckerSession = iSpellCheckerSession;
            if (iSpellCheckerSession.asBinder() instanceof Binder && this.mThread == null) {
                this.mThread = new HandlerThread("SpellCheckerSession", 10);
                this.mThread.start();
                this.mAsyncHandler = new Handler(this.mThread.getLooper()){

                    @Override
                    public void handleMessage(Message message) {
                        SpellCheckerParams spellCheckerParams = (SpellCheckerParams)message.obj;
                        SpellCheckerSessionListenerImpl.this.processTask(spellCheckerParams.mSession, spellCheckerParams, true);
                    }
                };
            }
            this.mOpened = true;
            // MONITOREXIT : this
            while (true) {
                if (this.mPendingTasks.isEmpty()) {
                    // MONITOREXIT : this
                    return;
                }
                this.processTask(iSpellCheckerSession, this.mPendingTasks.poll(), false);
            }
        }

        private static class SpellCheckerParams {
            public final boolean mSequentialWords;
            public ISpellCheckerSession mSession;
            public final int mSuggestionsLimit;
            public final TextInfo[] mTextInfos;
            public final int mWhat;

            public SpellCheckerParams(int n, TextInfo[] textInfoArray, int n2, boolean bl) {
                this.mWhat = n;
                this.mTextInfos = textInfoArray;
                this.mSuggestionsLimit = n2;
                this.mSequentialWords = bl;
            }
        }
    }
}

