/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.content.Context;
import android.content.res.Configuration;
import android.util.AttributeSet;
import android.view.ContextThemeWrapper;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewDebug;
import android.view.ViewGroup;
import android.view.accessibility.AccessibilityEvent;
import android.widget.ActionMenuPresenter;
import android.widget.LinearLayout;
import com.android.internal.view.menu.ActionMenuItemView;
import com.android.internal.view.menu.MenuBuilder;
import com.android.internal.view.menu.MenuItemImpl;
import com.android.internal.view.menu.MenuPresenter;
import com.android.internal.view.menu.MenuView;

public class ActionMenuView
extends LinearLayout
implements MenuBuilder.ItemInvoker,
MenuView {
    static final int GENERATED_ITEM_PADDING = 4;
    static final int MIN_CELL_SIZE = 56;
    private static final String TAG = "ActionMenuView";
    private MenuPresenter.Callback mActionMenuPresenterCallback;
    private boolean mFormatItems;
    private int mFormatItemsWidth;
    private int mGeneratedItemPadding;
    private MenuBuilder mMenu;
    private MenuBuilder.Callback mMenuBuilderCallback;
    private int mMinCellSize;
    private OnMenuItemClickListener mOnMenuItemClickListener;
    private Context mPopupContext;
    private int mPopupTheme;
    private ActionMenuPresenter mPresenter;
    private boolean mReserveOverflow;

    public ActionMenuView(Context context) {
        this(context, null);
    }

    public ActionMenuView(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.setBaselineAligned(false);
        float f = context.getResources().getDisplayMetrics().density;
        this.mMinCellSize = (int)(56.0f * f);
        this.mGeneratedItemPadding = (int)(4.0f * f);
        this.mPopupContext = context;
        this.mPopupTheme = 0;
    }

    /*
     * Enabled aggressive block sorting
     */
    static int measureChildForCells(View view, int n, int n2, int n3, int n4) {
        int n5;
        boolean bl;
        int n6;
        LayoutParams layoutParams;
        block5: {
            block6: {
                layoutParams = (LayoutParams)view.getLayoutParams();
                n6 = View.MeasureSpec.makeMeasureSpec(View.MeasureSpec.getSize(n3) - n4, View.MeasureSpec.getMode(n3));
                ActionMenuItemView actionMenuItemView = view instanceof ActionMenuItemView ? (ActionMenuItemView)view : null;
                bl = actionMenuItemView != null && actionMenuItemView.hasText();
                n5 = 0;
                if (n2 <= 0) break block5;
                if (!bl) break block6;
                n5 = 0;
                if (n2 < 2) break block5;
            }
            view.measure(View.MeasureSpec.makeMeasureSpec(n * n2, Integer.MIN_VALUE), n6);
            int n7 = view.getMeasuredWidth();
            n5 = n7 / n;
            if (n7 % n != 0) {
                ++n5;
            }
            if (bl && n5 < 2) {
                n5 = 2;
            }
        }
        boolean bl2 = !layoutParams.isOverflowButton && bl;
        layoutParams.expandable = bl2;
        layoutParams.cellsUsed = n5;
        view.measure(View.MeasureSpec.makeMeasureSpec(n5 * n, 0x40000000), n6);
        return n5;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void onMeasureExactFormat(int n, int n2) {
        int n3;
        int n4;
        int n5;
        int n6;
        block22: {
            n6 = View.MeasureSpec.getMode(n2);
            int n7 = View.MeasureSpec.getSize(n);
            n5 = View.MeasureSpec.getSize(n2);
            int n8 = this.getPaddingLeft() + this.getPaddingRight();
            int n9 = this.getPaddingTop() + this.getPaddingBottom();
            int n10 = ActionMenuView.getChildMeasureSpec(n2, n9, -2);
            n4 = n7 - n8;
            int n11 = n4 / this.mMinCellSize;
            int n12 = n4 % this.mMinCellSize;
            if (n11 == 0) {
                this.setMeasuredDimension(n4, 0);
                return;
            }
            int n13 = this.mMinCellSize + n12 / n11;
            int n14 = n11;
            n3 = 0;
            int n15 = 0;
            int n16 = 0;
            int n17 = 0;
            boolean bl = false;
            long l = 0L;
            int n18 = this.getChildCount();
            for (int i = 0; i < n18; ++i) {
                View view = this.getChildAt(i);
                if (view.getVisibility() == 8) continue;
                boolean bl2 = view instanceof ActionMenuItemView;
                ++n17;
                if (bl2) {
                    view.setPadding(this.mGeneratedItemPadding, 0, this.mGeneratedItemPadding, 0);
                }
                LayoutParams layoutParams = (LayoutParams)view.getLayoutParams();
                layoutParams.expanded = false;
                layoutParams.extraPixels = 0;
                layoutParams.cellsUsed = 0;
                layoutParams.expandable = false;
                layoutParams.leftMargin = 0;
                layoutParams.rightMargin = 0;
                boolean bl3 = bl2 && ((ActionMenuItemView)view).hasText();
                layoutParams.preventEdgeOffset = bl3;
                int n19 = layoutParams.isOverflowButton ? 1 : n14;
                int n20 = ActionMenuView.measureChildForCells(view, n13, n19, n10, n9);
                n15 = Math.max(n15, n20);
                if (layoutParams.expandable) {
                    ++n16;
                }
                if (layoutParams.isOverflowButton) {
                    bl = true;
                }
                n14 -= n20;
                int n21 = view.getMeasuredHeight();
                n3 = Math.max(n3, n21);
                if (n20 != 1) continue;
                l |= (long)(1 << i);
            }
            boolean bl4 = bl && n17 == 2;
            boolean bl5 = false;
            while (true) {
                int n22;
                long l2;
                block27: {
                    block25: {
                        int n23;
                        block26: {
                            int n24;
                            block24: {
                                block23: {
                                    if (n16 <= 0 || n14 <= 0) break block23;
                                    n24 = Integer.MAX_VALUE;
                                    l2 = 0L;
                                    int n25 = 0;
                                    for (int i = 0; i < n18; ++i) {
                                        LayoutParams layoutParams = (LayoutParams)this.getChildAt(i).getLayoutParams();
                                        if (!layoutParams.expandable) continue;
                                        if (layoutParams.cellsUsed < n24) {
                                            n24 = layoutParams.cellsUsed;
                                            l2 = 1 << i;
                                            n25 = 1;
                                            continue;
                                        }
                                        if (layoutParams.cellsUsed != n24) continue;
                                        l2 |= (long)(1 << i);
                                        ++n25;
                                    }
                                    l |= l2;
                                    if (n25 <= n14) break block24;
                                }
                                boolean bl6 = !bl && n17 == 1;
                                if (n14 <= 0 || l == 0L || n14 >= n17 - 1 && !bl6 && n15 <= true) break block25;
                                float f = Long.bitCount(l);
                                if (!bl6) {
                                    if ((1L & l) != 0L && !((LayoutParams)this.getChildAt((int)0).getLayoutParams()).preventEdgeOffset) {
                                        f -= 0.5f;
                                    }
                                    if ((l & (long)(1 << n18 - 1)) != 0L && !((LayoutParams)this.getChildAt((int)(n18 - 1)).getLayoutParams()).preventEdgeOffset) {
                                        f -= 0.5f;
                                    }
                                }
                                n23 = f > 0.0f ? (int)((float)(n14 * n13) / f) : 0;
                                break block26;
                            }
                            n22 = n24 + 1;
                            break block27;
                        }
                        for (int i = 0; i < n18; ++i) {
                            int n26;
                            if ((l & (long)(1 << i)) == 0L) continue;
                            View view = this.getChildAt(i);
                            LayoutParams layoutParams = (LayoutParams)view.getLayoutParams();
                            if (view instanceof ActionMenuItemView) {
                                layoutParams.extraPixels = n23;
                                layoutParams.expanded = true;
                                if (i == 0 && !layoutParams.preventEdgeOffset) {
                                    layoutParams.leftMargin = -n23 / 2;
                                }
                                bl5 = true;
                                continue;
                            }
                            if (layoutParams.isOverflowButton) {
                                layoutParams.extraPixels = n23;
                                layoutParams.expanded = true;
                                layoutParams.rightMargin = -n23 / 2;
                                bl5 = true;
                                continue;
                            }
                            if (i != 0) {
                                layoutParams.leftMargin = n23 / 2;
                            }
                            if (i == (n26 = n18 - 1)) continue;
                            layoutParams.rightMargin = n23 / 2;
                        }
                    }
                    if (bl5) {
                        break;
                    }
                    break block22;
                }
                for (int i = 0; i < n18; ++i) {
                    View view = this.getChildAt(i);
                    LayoutParams layoutParams = (LayoutParams)view.getLayoutParams();
                    if ((l2 & (long)(1 << i)) == 0L) {
                        if (layoutParams.cellsUsed != n22) continue;
                        l |= (long)(1 << i);
                        continue;
                    }
                    if (bl4 && layoutParams.preventEdgeOffset && n14 == 1) {
                        view.setPadding(n13 + this.mGeneratedItemPadding, 0, this.mGeneratedItemPadding, 0);
                    }
                    layoutParams.cellsUsed = 1 + layoutParams.cellsUsed;
                    layoutParams.expanded = true;
                    --n14;
                }
                bl5 = true;
            }
            for (int i = 0; i < n18; ++i) {
                View view = this.getChildAt(i);
                LayoutParams layoutParams = (LayoutParams)view.getLayoutParams();
                if (!layoutParams.expanded) continue;
                view.measure(View.MeasureSpec.makeMeasureSpec(n13 * layoutParams.cellsUsed + layoutParams.extraPixels, 0x40000000), n10);
            }
        }
        if (n6 != 0x40000000) {
            n5 = n3;
        }
        this.setMeasuredDimension(n4, n5);
    }

    @Override
    protected boolean checkLayoutParams(ViewGroup.LayoutParams layoutParams) {
        return layoutParams != null && layoutParams instanceof LayoutParams;
    }

    public void dismissPopupMenus() {
        if (this.mPresenter != null) {
            this.mPresenter.dismissPopupMenus();
        }
    }

    @Override
    public boolean dispatchPopulateAccessibilityEvent(AccessibilityEvent accessibilityEvent) {
        return false;
    }

    @Override
    protected LayoutParams generateDefaultLayoutParams() {
        LayoutParams layoutParams = new LayoutParams(-2, -2);
        layoutParams.gravity = 16;
        return layoutParams;
    }

    @Override
    public LayoutParams generateLayoutParams(AttributeSet attributeSet) {
        return new LayoutParams(this.getContext(), attributeSet);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected LayoutParams generateLayoutParams(ViewGroup.LayoutParams layoutParams) {
        if (layoutParams == null) {
            return this.generateDefaultLayoutParams();
        }
        LayoutParams layoutParams2 = layoutParams instanceof LayoutParams ? new LayoutParams((LayoutParams)layoutParams) : new LayoutParams(layoutParams);
        if (layoutParams2.gravity <= 0) {
            layoutParams2.gravity = 16;
        }
        return layoutParams2;
    }

    public LayoutParams generateOverflowButtonLayoutParams() {
        ViewGroup.LayoutParams layoutParams = this.generateDefaultLayoutParams();
        ((LayoutParams)layoutParams).isOverflowButton = true;
        return layoutParams;
    }

    /*
     * Enabled aggressive block sorting
     */
    public Menu getMenu() {
        if (this.mMenu == null) {
            Context context = this.getContext();
            this.mMenu = new MenuBuilder(context);
            this.mMenu.setCallback(new MenuBuilderCallback());
            this.mPresenter = new ActionMenuPresenter(context);
            this.mPresenter.setReserveOverflow(true);
            ActionMenuPresenter actionMenuPresenter = this.mPresenter;
            MenuPresenter.Callback callback = this.mActionMenuPresenterCallback != null ? this.mActionMenuPresenterCallback : new ActionMenuPresenterCallback();
            actionMenuPresenter.setCallback(callback);
            this.mMenu.addMenuPresenter(this.mPresenter, this.mPopupContext);
            this.mPresenter.setMenuView(this);
        }
        return this.mMenu;
    }

    public int getPopupTheme() {
        return this.mPopupTheme;
    }

    @Override
    public int getWindowAnimations() {
        return 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected boolean hasDividerBeforeChildAt(int n) {
        if (n == 0) {
            return false;
        }
        View view = this.getChildAt(n - 1);
        View view2 = this.getChildAt(n);
        int n2 = this.getChildCount();
        boolean bl = false;
        if (n < n2) {
            boolean bl2 = view instanceof ActionMenuChildView;
            bl = false;
            if (bl2) {
                bl = false | ((ActionMenuChildView)((Object)view)).needsDividerAfter();
            }
        }
        if (n <= 0) return bl;
        if (!(view2 instanceof ActionMenuChildView)) return bl;
        return bl | ((ActionMenuChildView)((Object)view2)).needsDividerBefore();
    }

    public boolean hideOverflowMenu() {
        return this.mPresenter != null && this.mPresenter.hideOverflowMenu();
    }

    @Override
    public void initialize(MenuBuilder menuBuilder) {
        this.mMenu = menuBuilder;
    }

    @Override
    public boolean invokeItem(MenuItemImpl menuItemImpl) {
        return this.mMenu.performItemAction(menuItemImpl, 0);
    }

    public boolean isOverflowMenuShowPending() {
        return this.mPresenter != null && this.mPresenter.isOverflowMenuShowPending();
    }

    public boolean isOverflowMenuShowing() {
        return this.mPresenter != null && this.mPresenter.isOverflowMenuShowing();
    }

    public boolean isOverflowReserved() {
        return this.mReserveOverflow;
    }

    @Override
    public void onConfigurationChanged(Configuration configuration) {
        super.onConfigurationChanged(configuration);
        this.mPresenter.updateMenuView(false);
        if (this.mPresenter != null && this.mPresenter.isOverflowMenuShowing()) {
            this.mPresenter.hideOverflowMenu();
            this.mPresenter.showOverflowMenu();
        }
    }

    @Override
    public void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.dismissPopupMenus();
    }

    /*
     * Enabled aggressive block sorting
     * Lifted jumps to return sites
     */
    @Override
    protected void onLayout(boolean bl, int n, int n2, int n3, int n4) {
        if (!this.mFormatItems) {
            super.onLayout(bl, n, n2, n3, n4);
            return;
        }
        int n5 = this.getChildCount();
        int n6 = (n2 + n4) / 2;
        int n7 = this.getDividerWidth();
        int n8 = 0;
        int n9 = 0;
        int n10 = n3 - n - this.getPaddingRight() - this.getPaddingLeft();
        boolean bl2 = false;
        boolean bl3 = this.isLayoutRtl();
        for (int i = 0; i < n5; ++i) {
            View view = this.getChildAt(i);
            if (view.getVisibility() == 8) continue;
            LayoutParams layoutParams = (LayoutParams)view.getLayoutParams();
            if (layoutParams.isOverflowButton) {
                int n11;
                int n12;
                int n13 = view.getMeasuredWidth();
                if (this.hasDividerBeforeChildAt(i)) {
                    n13 += n7;
                }
                int n14 = view.getMeasuredHeight();
                if (bl3) {
                    n12 = this.getPaddingLeft() + layoutParams.leftMargin;
                    n11 = n12 + n13;
                } else {
                    n11 = this.getWidth() - this.getPaddingRight() - layoutParams.rightMargin;
                    n12 = n11 - n13;
                }
                int n15 = n6 - n14 / 2;
                int n16 = n15 + n14;
                view.layout(n12, n15, n11, n16);
                n10 -= n13;
                bl2 = true;
                continue;
            }
            int n17 = view.getMeasuredWidth() + layoutParams.leftMargin + layoutParams.rightMargin;
            n8 += n17;
            n10 -= n17;
            if (this.hasDividerBeforeChildAt(i)) {
                n8 += n7;
            }
            ++n9;
        }
        if (n5 == 1 && !bl2) {
            View view = this.getChildAt(0);
            int n18 = view.getMeasuredWidth();
            int n19 = view.getMeasuredHeight();
            int n20 = (n3 - n) / 2 - n18 / 2;
            int n21 = n6 - n19 / 2;
            view.layout(n20, n21, n20 + n18, n21 + n19);
            return;
        }
        int n22 = bl2 ? 0 : 1;
        int n23 = n9 - n22;
        int n24 = n23 > 0 ? n10 / n23 : 0;
        int n25 = Math.max(0, n24);
        if (bl3) {
            int n26 = this.getWidth() - this.getPaddingRight();
            int n27 = 0;
            while (n27 < n5) {
                View view = this.getChildAt(n27);
                LayoutParams layoutParams = (LayoutParams)view.getLayoutParams();
                if (view.getVisibility() != 8 && !layoutParams.isOverflowButton) {
                    int n28 = n26 - layoutParams.rightMargin;
                    int n29 = view.getMeasuredWidth();
                    int n30 = view.getMeasuredHeight();
                    int n31 = n6 - n30 / 2;
                    view.layout(n28 - n29, n31, n28, n31 + n30);
                    n26 = n28 - (n25 + (n29 + layoutParams.leftMargin));
                }
                ++n27;
            }
            return;
        }
        int n32 = this.getPaddingLeft();
        int n33 = 0;
        while (n33 < n5) {
            View view = this.getChildAt(n33);
            LayoutParams layoutParams = (LayoutParams)view.getLayoutParams();
            if (view.getVisibility() != 8 && !layoutParams.isOverflowButton) {
                int n34 = n32 + layoutParams.leftMargin;
                int n35 = view.getMeasuredWidth();
                int n36 = view.getMeasuredHeight();
                int n37 = n6 - n36 / 2;
                view.layout(n34, n37, n34 + n35, n37 + n36);
                n32 = n34 + (n25 + (n35 + layoutParams.rightMargin));
            }
            ++n33;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void onMeasure(int n, int n2) {
        boolean bl = this.mFormatItems;
        boolean bl2 = View.MeasureSpec.getMode(n) == 0x40000000;
        this.mFormatItems = bl2;
        if (bl != this.mFormatItems) {
            this.mFormatItemsWidth = 0;
        }
        int n3 = View.MeasureSpec.getSize(n);
        if (this.mFormatItems && this.mMenu != null && n3 != this.mFormatItemsWidth) {
            this.mFormatItemsWidth = n3;
            this.mMenu.onItemsChanged(true);
        }
        int n4 = this.getChildCount();
        if (this.mFormatItems && n4 > 0) {
            this.onMeasureExactFormat(n, n2);
            return;
        }
        int n5 = 0;
        while (true) {
            if (n5 >= n4) {
                super.onMeasure(n, n2);
                return;
            }
            LayoutParams layoutParams = (LayoutParams)this.getChildAt(n5).getLayoutParams();
            layoutParams.rightMargin = 0;
            layoutParams.leftMargin = 0;
            ++n5;
        }
    }

    public MenuBuilder peekMenu() {
        return this.mMenu;
    }

    public void setExpandedActionViewsExclusive(boolean bl) {
        this.mPresenter.setExpandedActionViewsExclusive(bl);
    }

    public void setMenuCallbacks(MenuPresenter.Callback callback, MenuBuilder.Callback callback2) {
        this.mActionMenuPresenterCallback = callback;
        this.mMenuBuilderCallback = callback2;
    }

    public void setOnMenuItemClickListener(OnMenuItemClickListener onMenuItemClickListener) {
        this.mOnMenuItemClickListener = onMenuItemClickListener;
    }

    public void setOverflowReserved(boolean bl) {
        this.mReserveOverflow = bl;
    }

    public void setPopupTheme(int n) {
        block3: {
            block2: {
                if (this.mPopupTheme == n) break block2;
                this.mPopupTheme = n;
                if (n != 0) break block3;
                this.mPopupContext = this.mContext;
            }
            return;
        }
        this.mPopupContext = new ContextThemeWrapper(this.mContext, n);
    }

    public void setPresenter(ActionMenuPresenter actionMenuPresenter) {
        this.mPresenter = actionMenuPresenter;
        this.mPresenter.setMenuView(this);
    }

    public boolean showOverflowMenu() {
        return this.mPresenter != null && this.mPresenter.showOverflowMenu();
    }

    public static interface ActionMenuChildView {
        public boolean needsDividerAfter();

        public boolean needsDividerBefore();
    }

    private class ActionMenuPresenterCallback
    implements MenuPresenter.Callback {
        private ActionMenuPresenterCallback() {
        }

        @Override
        public void onCloseMenu(MenuBuilder menuBuilder, boolean bl) {
        }

        @Override
        public boolean onOpenSubMenu(MenuBuilder menuBuilder) {
            return false;
        }
    }

    public static class LayoutParams
    extends LinearLayout.LayoutParams {
        @ViewDebug.ExportedProperty(category="layout")
        public int cellsUsed;
        @ViewDebug.ExportedProperty(category="layout")
        public boolean expandable;
        public boolean expanded;
        @ViewDebug.ExportedProperty(category="layout")
        public int extraPixels;
        @ViewDebug.ExportedProperty(category="layout")
        public boolean isOverflowButton;
        @ViewDebug.ExportedProperty(category="layout")
        public boolean preventEdgeOffset;

        public LayoutParams(int n, int n2) {
            super(n, n2);
            this.isOverflowButton = false;
        }

        public LayoutParams(int n, int n2, boolean bl) {
            super(n, n2);
            this.isOverflowButton = bl;
        }

        public LayoutParams(Context context, AttributeSet attributeSet) {
            super(context, attributeSet);
        }

        public LayoutParams(ViewGroup.LayoutParams layoutParams) {
            super(layoutParams);
        }

        public LayoutParams(LayoutParams layoutParams) {
            super(layoutParams);
            this.isOverflowButton = layoutParams.isOverflowButton;
        }
    }

    private class MenuBuilderCallback
    implements MenuBuilder.Callback {
        private MenuBuilderCallback() {
        }

        @Override
        public boolean onMenuItemSelected(MenuBuilder menuBuilder, MenuItem menuItem) {
            return ActionMenuView.this.mOnMenuItemClickListener != null && ActionMenuView.this.mOnMenuItemClickListener.onMenuItemClick(menuItem);
        }

        @Override
        public void onMenuModeChange(MenuBuilder menuBuilder) {
            if (ActionMenuView.this.mMenuBuilderCallback != null) {
                ActionMenuView.this.mMenuBuilderCallback.onMenuModeChange(menuBuilder);
            }
        }
    }

    public static interface OnMenuItemClickListener {
        public boolean onMenuItemClick(MenuItem var1);
    }
}

