/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Rect;
import android.util.FloatMath;
import android.view.animation.AnimationUtils;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import com.android.internal.R;

public class EdgeEffect {
    private static final double ANGLE = 0.5235987755982988;
    private static final float COS = 0.0f;
    private static final float EPSILON = 0.001f;
    private static final float MAX_ALPHA = 0.5f;
    private static final float MAX_GLOW_SCALE = 2.0f;
    private static final int MAX_VELOCITY = 10000;
    private static final int MIN_VELOCITY = 100;
    private static final int PULL_DECAY_TIME = 2000;
    private static final float PULL_DISTANCE_ALPHA_GLOW_FACTOR = 0.8f;
    private static final float PULL_GLOW_BEGIN = 0.0f;
    private static final int PULL_TIME = 167;
    private static final int RECEDE_TIME = 600;
    private static final float SIN = 0.0f;
    private static final int STATE_ABSORB = 2;
    private static final int STATE_IDLE = 0;
    private static final int STATE_PULL = 1;
    private static final int STATE_PULL_DECAY = 4;
    private static final int STATE_RECEDE = 3;
    private static final String TAG = "EdgeEffect";
    private static final int VELOCITY_GLOW_FACTOR = 6;
    private float mBaseGlowScale;
    private final Rect mBounds = new Rect();
    private float mDisplacement = 0.5f;
    private float mDuration;
    private float mGlowAlpha;
    private float mGlowAlphaFinish;
    private float mGlowAlphaStart;
    private float mGlowScaleY;
    private float mGlowScaleYFinish;
    private float mGlowScaleYStart;
    private final Interpolator mInterpolator;
    private final Paint mPaint = new Paint();
    private float mPullDistance;
    private float mRadius;
    private long mStartTime;
    private int mState = 0;
    private float mTargetDisplacement = 0.5f;

    static {
        SIN = (float)Math.sin(0.5235987755982988);
        COS = (float)Math.cos(0.5235987755982988);
    }

    public EdgeEffect(Context context) {
        this.mPaint.setAntiAlias(true);
        TypedArray typedArray = context.obtainStyledAttributes(R.styleable.EdgeEffect);
        int n = typedArray.getColor(0, -10066330);
        typedArray.recycle();
        this.mPaint.setColor(0x33000000 | 0xFFFFFF & n);
        this.mPaint.setStyle(Paint.Style.FILL);
        this.mPaint.setXfermode(new PorterDuffXfermode(PorterDuff.Mode.SRC_ATOP));
        this.mInterpolator = new DecelerateInterpolator();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void update() {
        float f = Math.min((float)(AnimationUtils.currentAnimationTimeMillis() - this.mStartTime) / this.mDuration, 1.0f);
        float f2 = this.mInterpolator.getInterpolation(f);
        this.mGlowAlpha = this.mGlowAlphaStart + f2 * (this.mGlowAlphaFinish - this.mGlowAlphaStart);
        this.mGlowScaleY = this.mGlowScaleYStart + f2 * (this.mGlowScaleYFinish - this.mGlowScaleYStart);
        this.mDisplacement = (this.mDisplacement + this.mTargetDisplacement) / 2.0f;
        if (!(f >= 0.999f)) return;
        switch (this.mState) {
            default: {
                return;
            }
            case 2: {
                this.mState = 3;
                this.mStartTime = AnimationUtils.currentAnimationTimeMillis();
                this.mDuration = 600.0f;
                this.mGlowAlphaStart = this.mGlowAlpha;
                this.mGlowScaleYStart = this.mGlowScaleY;
                this.mGlowAlphaFinish = 0.0f;
                this.mGlowScaleYFinish = 0.0f;
                return;
            }
            case 1: {
                this.mState = 4;
                this.mStartTime = AnimationUtils.currentAnimationTimeMillis();
                this.mDuration = 2000.0f;
                this.mGlowAlphaStart = this.mGlowAlpha;
                this.mGlowScaleYStart = this.mGlowScaleY;
                this.mGlowAlphaFinish = 0.0f;
                this.mGlowScaleYFinish = 0.0f;
                return;
            }
            case 4: {
                this.mState = 3;
                return;
            }
            case 3: 
        }
        this.mState = 0;
    }

    public boolean draw(Canvas canvas) {
        boolean bl;
        block6: {
            block5: {
                this.update();
                int n = canvas.save();
                float f = this.mBounds.centerX();
                float f2 = (float)this.mBounds.height() - this.mRadius;
                canvas.scale(1.0f, Math.min(this.mGlowScaleY, 1.0f) * this.mBaseGlowScale, f, 0.0f);
                float f3 = (Math.max(0.0f, Math.min(this.mDisplacement, 1.0f)) - 0.5f) * (float)this.mBounds.width() / 2.0f;
                canvas.clipRect(this.mBounds);
                canvas.translate(f3, 0.0f);
                this.mPaint.setAlpha((int)(255.0f * this.mGlowAlpha));
                canvas.drawCircle(f, f2, this.mRadius, this.mPaint);
                canvas.restoreToCount(n);
                int n2 = this.mState;
                boolean bl2 = false;
                if (n2 == 3) {
                    float f4 = this.mGlowScaleY - 0.0f;
                    float f5 = f4 == 0.0f ? 0 : (f4 > 0.0f ? 1 : -1);
                    bl2 = false;
                    if (f5 == false) {
                        this.mState = 0;
                        bl2 = true;
                    }
                }
                if (this.mState != 0) break block5;
                bl = false;
                if (!bl2) break block6;
            }
            bl = true;
        }
        return bl;
    }

    public void finish() {
        this.mState = 0;
    }

    public int getColor() {
        return this.mPaint.getColor();
    }

    public int getMaxHeight() {
        return (int)(0.5f + 2.0f * (float)this.mBounds.height());
    }

    public boolean isFinished() {
        return this.mState == 0;
    }

    public void onAbsorb(int n) {
        this.mState = 2;
        int n2 = Math.min(Math.max(100, Math.abs(n)), 10000);
        this.mStartTime = AnimationUtils.currentAnimationTimeMillis();
        this.mDuration = 0.15f + 0.02f * (float)n2;
        this.mGlowAlphaStart = 0.3f;
        this.mGlowScaleYStart = Math.max(this.mGlowScaleY, 0.0f);
        this.mGlowScaleYFinish = Math.min(0.025f + 1.5E-4f * (float)(n2 * (n2 / 100)) / 2.0f, 1.0f);
        this.mGlowAlphaFinish = Math.max(this.mGlowAlphaStart, Math.min(1.0E-5f * (float)(n2 * 6), 0.5f));
        this.mTargetDisplacement = 0.5f;
    }

    public void onPull(float f) {
        this.onPull(f, 0.5f);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void onPull(float f, float f2) {
        float f3;
        long l = AnimationUtils.currentAnimationTimeMillis();
        this.mTargetDisplacement = f2;
        if (this.mState == 4 && (float)(l - this.mStartTime) < this.mDuration) {
            return;
        }
        if (this.mState != 1) {
            this.mGlowScaleY = Math.max(0.0f, this.mGlowScaleY);
        }
        this.mState = 1;
        this.mStartTime = l;
        this.mDuration = 167.0f;
        this.mPullDistance = f + this.mPullDistance;
        float f4 = Math.abs(f);
        this.mGlowAlphaStart = f3 = Math.min(0.5f, this.mGlowAlpha + 0.8f * f4);
        this.mGlowAlpha = f3;
        if (this.mPullDistance == 0.0f) {
            this.mGlowScaleYStart = 0.0f;
            this.mGlowScaleY = 0.0f;
        } else {
            float f5;
            this.mGlowScaleYStart = f5 = Math.max(0.0f, 1.0f - 1.0f / FloatMath.sqrt(Math.abs(this.mPullDistance) * (float)this.mBounds.height()) - 0.3f) / 0.7f;
            this.mGlowScaleY = f5;
        }
        this.mGlowAlphaFinish = this.mGlowAlpha;
        this.mGlowScaleYFinish = this.mGlowScaleY;
    }

    public void onRelease() {
        this.mPullDistance = 0.0f;
        if (this.mState != 1 && this.mState != 4) {
            return;
        }
        this.mState = 3;
        this.mGlowAlphaStart = this.mGlowAlpha;
        this.mGlowScaleYStart = this.mGlowScaleY;
        this.mGlowAlphaFinish = 0.0f;
        this.mGlowScaleYFinish = 0.0f;
        this.mStartTime = AnimationUtils.currentAnimationTimeMillis();
        this.mDuration = 600.0f;
    }

    public void setColor(int n) {
        this.mPaint.setColor(n);
    }

    public void setSize(int n, int n2) {
        float f = 1.0f;
        float f2 = 0.75f * (float)n / SIN;
        float f3 = f2 - f2 * COS;
        float f4 = 0.75f * (float)n2 / SIN;
        float f5 = f4 - f4 * COS;
        this.mRadius = f2;
        if (f3 > 0.0f) {
            f = Math.min(f5 / f3, f);
        }
        this.mBaseGlowScale = f;
        this.mBounds.set(this.mBounds.left, this.mBounds.top, n, (int)Math.min((float)n2, f3));
    }
}

