/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.content.AsyncQueryHandler;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.res.TypedArray;
import android.database.Cursor;
import android.graphics.Canvas;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Bundle;
import android.provider.ContactsContract;
import android.util.AttributeSet;
import android.view.View;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityNodeInfo;
import android.widget.ImageView;
import com.android.internal.R;

public class QuickContactBadge
extends ImageView
implements View.OnClickListener {
    static final int EMAIL_ID_COLUMN_INDEX = 0;
    static final String[] EMAIL_LOOKUP_PROJECTION = new String[]{"contact_id", "lookup"};
    static final int EMAIL_LOOKUP_STRING_COLUMN_INDEX = 1;
    private static final String EXTRA_URI_CONTENT = "uri_content";
    static final int PHONE_ID_COLUMN_INDEX = 0;
    static final String[] PHONE_LOOKUP_PROJECTION = new String[]{"_id", "lookup"};
    static final int PHONE_LOOKUP_STRING_COLUMN_INDEX = 1;
    private static final int TOKEN_EMAIL_LOOKUP = 0;
    private static final int TOKEN_EMAIL_LOOKUP_AND_TRIGGER = 2;
    private static final int TOKEN_PHONE_LOOKUP = 1;
    private static final int TOKEN_PHONE_LOOKUP_AND_TRIGGER = 3;
    private String mContactEmail;
    private String mContactPhone;
    private Uri mContactUri;
    private Drawable mDefaultAvatar;
    protected String[] mExcludeMimes = null;
    private Bundle mExtras = null;
    private Drawable mOverlay;
    private QueryHandler mQueryHandler;

    public QuickContactBadge(Context context) {
        this(context, null);
    }

    public QuickContactBadge(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0);
    }

    public QuickContactBadge(Context context, AttributeSet attributeSet, int n) {
        this(context, attributeSet, n, 0);
    }

    public QuickContactBadge(Context context, AttributeSet attributeSet, int n, int n2) {
        super(context, attributeSet, n, n2);
        TypedArray typedArray = this.mContext.obtainStyledAttributes(R.styleable.Theme);
        this.mOverlay = typedArray.getDrawable(242);
        typedArray.recycle();
        if (!this.isInEditMode()) {
            this.mQueryHandler = new QueryHandler(this.mContext.getContentResolver());
        }
        this.setOnClickListener(this);
    }

    static /* synthetic */ Uri access$002(QuickContactBadge quickContactBadge, Uri uri) {
        quickContactBadge.mContactUri = uri;
        return uri;
    }

    static /* synthetic */ void access$100(QuickContactBadge quickContactBadge) {
        quickContactBadge.onContactUriChanged();
    }

    private boolean isAssigned() {
        return this.mContactUri != null || this.mContactEmail != null || this.mContactPhone != null;
    }

    private void onContactUriChanged() {
        this.setEnabled(this.isAssigned());
    }

    public void assignContactFromEmail(String string2, boolean bl) {
        this.assignContactFromEmail(string2, bl, null);
    }

    public void assignContactFromEmail(String string2, boolean bl, Bundle bundle) {
        this.mContactEmail = string2;
        this.mExtras = bundle;
        if (!bl && this.mQueryHandler != null) {
            this.mQueryHandler.startQuery(0, null, Uri.withAppendedPath(ContactsContract.CommonDataKinds.Email.CONTENT_LOOKUP_URI, Uri.encode(this.mContactEmail)), EMAIL_LOOKUP_PROJECTION, null, null, null);
            return;
        }
        this.mContactUri = null;
        this.onContactUriChanged();
    }

    public void assignContactFromPhone(String string2, boolean bl) {
        this.assignContactFromPhone(string2, bl, new Bundle());
    }

    public void assignContactFromPhone(String string2, boolean bl, Bundle bundle) {
        this.mContactPhone = string2;
        this.mExtras = bundle;
        if (!bl && this.mQueryHandler != null) {
            this.mQueryHandler.startQuery(1, null, Uri.withAppendedPath(ContactsContract.PhoneLookup.CONTENT_FILTER_URI, this.mContactPhone), PHONE_LOOKUP_PROJECTION, null, null, null);
            return;
        }
        this.mContactUri = null;
        this.onContactUriChanged();
    }

    public void assignContactUri(Uri uri) {
        this.mContactUri = uri;
        this.mContactEmail = null;
        this.mContactPhone = null;
        this.onContactUriChanged();
    }

    @Override
    public void drawableHotspotChanged(float f, float f2) {
        super.drawableHotspotChanged(f, f2);
        if (this.mOverlay != null) {
            this.mOverlay.setHotspot(f, f2);
        }
    }

    @Override
    protected void drawableStateChanged() {
        super.drawableStateChanged();
        if (this.mOverlay != null && this.mOverlay.isStateful()) {
            this.mOverlay.setState(this.getDrawableState());
            this.invalidate();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void onClick(View view) {
        Bundle bundle = this.mExtras == null ? new Bundle() : this.mExtras;
        if (this.mContactUri != null) {
            ContactsContract.QuickContact.showQuickContact(this.getContext(), this, this.mContactUri, 3, this.mExcludeMimes);
            return;
        } else {
            if (this.mContactEmail != null && this.mQueryHandler != null) {
                bundle.putString(EXTRA_URI_CONTENT, this.mContactEmail);
                this.mQueryHandler.startQuery(2, bundle, Uri.withAppendedPath(ContactsContract.CommonDataKinds.Email.CONTENT_LOOKUP_URI, Uri.encode(this.mContactEmail)), EMAIL_LOOKUP_PROJECTION, null, null, null);
                return;
            }
            if (this.mContactPhone == null || this.mQueryHandler == null) return;
            bundle.putString(EXTRA_URI_CONTENT, this.mContactPhone);
            this.mQueryHandler.startQuery(3, bundle, Uri.withAppendedPath(ContactsContract.PhoneLookup.CONTENT_FILTER_URI, this.mContactPhone), PHONE_LOOKUP_PROJECTION, null, null, null);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (!this.isEnabled() || this.mOverlay == null || this.mOverlay.getIntrinsicWidth() == 0 || this.mOverlay.getIntrinsicHeight() == 0) {
            return;
        }
        this.mOverlay.setBounds(0, 0, this.getWidth(), this.getHeight());
        if (this.mPaddingTop == 0 && this.mPaddingLeft == 0) {
            this.mOverlay.draw(canvas);
            return;
        }
        int n = canvas.getSaveCount();
        canvas.save();
        canvas.translate(this.mPaddingLeft, this.mPaddingTop);
        this.mOverlay.draw(canvas);
        canvas.restoreToCount(n);
    }

    @Override
    public void onInitializeAccessibilityEvent(AccessibilityEvent accessibilityEvent) {
        super.onInitializeAccessibilityEvent(accessibilityEvent);
        accessibilityEvent.setClassName(QuickContactBadge.class.getName());
    }

    @Override
    public void onInitializeAccessibilityNodeInfo(AccessibilityNodeInfo accessibilityNodeInfo) {
        super.onInitializeAccessibilityNodeInfo(accessibilityNodeInfo);
        accessibilityNodeInfo.setClassName(QuickContactBadge.class.getName());
    }

    public void setExcludeMimes(String[] stringArray) {
        this.mExcludeMimes = stringArray;
    }

    public void setImageToDefault() {
        if (this.mDefaultAvatar == null) {
            this.mDefaultAvatar = this.mContext.getDrawable(17302574);
        }
        this.setImageDrawable(this.mDefaultAvatar);
    }

    public void setMode(int n) {
    }

    public void setOverlay(Drawable drawable2) {
        this.mOverlay = drawable2;
    }

    private class QueryHandler
    extends AsyncQueryHandler {
        public QueryHandler(ContentResolver contentResolver) {
            super(contentResolver);
        }

        /*
         * Unable to fully structure code
         */
        @Override
        protected void onQueryComplete(int var1_1, Object var2_2, Cursor var3_3) {
            if (var2_2 == null) ** GOTO lbl16
            var4_4 = (Bundle)var2_2;
            block14: while (true) {
                var5_5 = null;
                var6_6 = null;
                var7_7 = false;
                switch (var1_1) lbl-1000:
                // 7 sources

                {
                    default: {
                        QuickContactBadge.access$002(QuickContactBadge.this, var5_5);
                        QuickContactBadge.access$100(QuickContactBadge.this);
                        if (!var7_7 || var5_5 == null) break block14;
                        ContactsContract.QuickContact.showQuickContact(QuickContactBadge.this.getContext(), QuickContactBadge.this, var5_5, 3, QuickContactBadge.this.mExcludeMimes);
lbl14:
                        // 2 sources

                        return;
                    }
lbl16:
                    // 1 sources

                    var4_4 = new Bundle();
                    continue block14;
                    case 3: {
                        var7_7 = true;
                        var6_6 = Uri.fromParts("tel", var4_4.getString("uri_content"), null);
                    }
                    case 1: {
                        var5_5 = null;
                        if (var3_3 == null) ** GOTO lbl-1000
                        var14_8 = var3_3.moveToFirst();
                        var5_5 = null;
                        if (!var14_8) ** GOTO lbl-1000
                        var5_5 = ContactsContract.Contacts.getLookupUri(var3_3.getLong(0), var3_3.getString(1));
                        ** GOTO lbl-1000
                    }
                    case 2: {
                        var7_7 = true;
                        var6_6 = Uri.fromParts("mailto", var4_4.getString("uri_content"), null);
                    }
                    case 0: {
                        var5_5 = null;
                        if (var3_3 == null) ** GOTO lbl-1000
                        var9_9 = var3_3.moveToFirst();
                        var5_5 = null;
                        if (!var9_9) ** GOTO lbl-1000
                        var5_5 = var10_10 = ContactsContract.Contacts.getLookupUri(var3_3.getLong(0), var3_3.getString(1));
                        ** GOTO lbl-1000
                    }
                    {
                        finally {
                            if (var3_3 != null) {
                                var3_3.close();
                            }
                        }
                    }
                }
                break;
            }
            ** while (var6_6 == null)
lbl53:
            // 1 sources

            var12_12 = new Intent("com.android.contacts.action.SHOW_OR_CREATE_CONTACT", var6_6);
            if (var4_4 != null) {
                var4_4.remove("uri_content");
                var12_12.putExtras(var4_4);
            }
            QuickContactBadge.this.getContext().startActivity(var12_12);
        }
    }
}

