/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.app.Service;
import android.content.Intent;
import android.os.IBinder;
import android.widget.RemoteViews;
import com.android.internal.widget.IRemoteViewsFactory;
import java.util.HashMap;

public abstract class RemoteViewsService
extends Service {
    private static final String LOG_TAG = "RemoteViewsService";
    private static final Object sLock;
    private static final HashMap<Intent.FilterComparison, RemoteViewsFactory> sRemoteViewFactories;

    static {
        sRemoteViewFactories = new HashMap();
        sLock = new Object();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public IBinder onBind(Intent intent) {
        Object object = sLock;
        synchronized (object) {
            boolean bl;
            RemoteViewsFactory remoteViewsFactory;
            Intent.FilterComparison filterComparison = new Intent.FilterComparison(intent);
            if (!sRemoteViewFactories.containsKey(filterComparison)) {
                remoteViewsFactory = this.onGetViewFactory(intent);
                sRemoteViewFactories.put(filterComparison, remoteViewsFactory);
                remoteViewsFactory.onCreate();
                bl = false;
                return new RemoteViewsFactoryAdapter(remoteViewsFactory, bl);
            } else {
                remoteViewsFactory = sRemoteViewFactories.get(filterComparison);
                bl = true;
            }
            return new RemoteViewsFactoryAdapter(remoteViewsFactory, bl);
        }
    }

    public abstract RemoteViewsFactory onGetViewFactory(Intent var1);

    public static interface RemoteViewsFactory {
        public int getCount();

        public long getItemId(int var1);

        public RemoteViews getLoadingView();

        public RemoteViews getViewAt(int var1);

        public int getViewTypeCount();

        public boolean hasStableIds();

        public void onCreate();

        public void onDataSetChanged();

        public void onDestroy();
    }

    private static class RemoteViewsFactoryAdapter
    extends IRemoteViewsFactory.Stub {
        private RemoteViewsFactory mFactory;
        private boolean mIsCreated;

        public RemoteViewsFactoryAdapter(RemoteViewsFactory remoteViewsFactory, boolean bl) {
            this.mFactory = remoteViewsFactory;
            this.mIsCreated = bl;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public int getCount() {
            synchronized (this) {
                try {
                    int n = this.mFactory.getCount();
                    return n;
                }
                catch (Exception exception) {
                    Thread thread = Thread.currentThread();
                    Thread.getDefaultUncaughtExceptionHandler().uncaughtException(thread, exception);
                    return 0;
                }
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public long getItemId(int n) {
            synchronized (this) {
                long l = 0L;
                try {
                    long l2;
                    l = l2 = this.mFactory.getItemId(n);
                    return l;
                }
                catch (Exception exception) {
                    Thread thread = Thread.currentThread();
                    Thread.getDefaultUncaughtExceptionHandler().uncaughtException(thread, exception);
                    return l;
                }
                finally {
                }
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public RemoteViews getLoadingView() {
            synchronized (this) {
                try {
                    RemoteViews remoteViews = this.mFactory.getLoadingView();
                    return remoteViews;
                }
                catch (Exception exception) {
                    Thread thread = Thread.currentThread();
                    Thread.getDefaultUncaughtExceptionHandler().uncaughtException(thread, exception);
                    return null;
                }
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public RemoteViews getViewAt(int n) {
            synchronized (this) {
                RemoteViews remoteViews = null;
                try {
                    remoteViews = this.mFactory.getViewAt(n);
                    if (remoteViews != null) {
                        remoteViews.setIsWidgetCollectionChild(true);
                    }
                }
                catch (Exception exception) {
                    Thread thread = Thread.currentThread();
                    Thread.getDefaultUncaughtExceptionHandler().uncaughtException(thread, exception);
                }
                return remoteViews;
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public int getViewTypeCount() {
            synchronized (this) {
                try {
                    int n = this.mFactory.getViewTypeCount();
                    return n;
                }
                catch (Exception exception) {
                    Thread thread = Thread.currentThread();
                    Thread.getDefaultUncaughtExceptionHandler().uncaughtException(thread, exception);
                    return 0;
                }
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean hasStableIds() {
            synchronized (this) {
                try {
                    boolean bl = this.mFactory.hasStableIds();
                    return bl;
                }
                catch (Exception exception) {
                    Thread thread = Thread.currentThread();
                    Thread.getDefaultUncaughtExceptionHandler().uncaughtException(thread, exception);
                    return false;
                }
            }
        }

        @Override
        public boolean isCreated() {
            synchronized (this) {
                boolean bl = this.mIsCreated;
                return bl;
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void onDataSetChanged() {
            synchronized (this) {
                try {
                    this.mFactory.onDataSetChanged();
                    return;
                }
                catch (Exception exception) {
                    Thread thread = Thread.currentThread();
                    Thread.getDefaultUncaughtExceptionHandler().uncaughtException(thread, exception);
                    return;
                }
                finally {
                }
            }
        }

        @Override
        public void onDataSetChangedAsync() {
            synchronized (this) {
                this.onDataSetChanged();
                return;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void onDestroy(Intent intent) {
            Object object = sLock;
            synchronized (object) {
                Intent.FilterComparison filterComparison = new Intent.FilterComparison(intent);
                if (sRemoteViewFactories.containsKey(filterComparison)) {
                    RemoteViewsFactory remoteViewsFactory = (RemoteViewsFactory)sRemoteViewFactories.get(filterComparison);
                    try {
                        remoteViewsFactory.onDestroy();
                    }
                    catch (Exception exception) {
                        Thread thread = Thread.currentThread();
                        Thread.getDefaultUncaughtExceptionHandler().uncaughtException(thread, exception);
                    }
                    sRemoteViewFactories.remove(filterComparison);
                }
                return;
            }
        }
    }
}

