/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.app.PendingIntent;
import android.app.SearchableInfo;
import android.content.ActivityNotFoundException;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ResolveInfo;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.database.Cursor;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Bundle;
import android.text.Editable;
import android.text.SpannableStringBuilder;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.text.style.DynamicDrawableSpan;
import android.text.style.ImageSpan;
import android.text.style.LineHeightSpan;
import android.util.AttributeSet;
import android.util.Log;
import android.view.CollapsibleActionView;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityNodeInfo;
import android.view.inputmethod.InputMethodManager;
import android.widget.AdapterView;
import android.widget.AutoCompleteTextView;
import android.widget.CursorAdapter;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.SuggestionsAdapter;
import android.widget.TextView;
import com.android.internal.R;
import java.util.WeakHashMap;

public class SearchView
extends LinearLayout
implements CollapsibleActionView {
    private static final boolean DBG = false;
    private static final int DECORATED_HINT_AUTO = 1;
    private static final int DECORATED_HINT_DEFAULT = 0;
    private static final String IME_OPTION_NO_MICROPHONE = "nm";
    private static final String LOG_TAG = "SearchView";
    private Bundle mAppSearchData;
    private boolean mClearingFocus;
    private final ImageView mCloseButton;
    private int mCollapsedImeOptions;
    private int mDecoratedHint;
    private boolean mDefaultDecoratedHint = true;
    private final View mDropDownAnchor;
    private Drawable mEditTextBackground;
    private boolean mExpandedInActionView;
    private boolean mIconified;
    private boolean mIconifiedByDefault;
    private int mMaxWidth;
    private Drawable mOldEditTextBackground;
    private CharSequence mOldQueryText;
    private final View.OnClickListener mOnClickListener;
    private OnCloseListener mOnCloseListener;
    private final TextView.OnEditorActionListener mOnEditorActionListener;
    private final AdapterView.OnItemClickListener mOnItemClickListener;
    private final AdapterView.OnItemSelectedListener mOnItemSelectedListener;
    private OnQueryTextListener mOnQueryChangeListener;
    private View.OnFocusChangeListener mOnQueryTextFocusChangeListener;
    private View.OnClickListener mOnSearchClickListener;
    private OnSuggestionListener mOnSuggestionListener;
    private final WeakHashMap<String, Drawable.ConstantState> mOutsideDrawablesCache;
    private CharSequence mQueryHint;
    private boolean mQueryRefinement;
    private final SearchAutoComplete mQueryTextView;
    private Runnable mReleaseCursorRunnable;
    private final ImageView mSearchButton;
    private final View mSearchEditFrame;
    private final ImageView mSearchHintIcon;
    private final int mSearchIconResId;
    private final View mSearchPlate;
    private SearchableInfo mSearchable;
    private Runnable mShowImeRunnable = new Runnable(){

        @Override
        public void run() {
            InputMethodManager inputMethodManager = (InputMethodManager)SearchView.this.getContext().getSystemService("input_method");
            if (inputMethodManager != null) {
                inputMethodManager.showSoftInputUnchecked(0, null);
            }
        }
    };
    private final View mSubmitArea;
    private final ImageView mSubmitButton;
    private boolean mSubmitButtonEnabled;
    private final int mSuggestionCommitIconResId;
    private final int mSuggestionRowLayout;
    private CursorAdapter mSuggestionsAdapter;
    View.OnKeyListener mTextKeyListener;
    private TextWatcher mTextWatcher;
    private Runnable mUpdateDrawableStateRunnable = new Runnable(){

        @Override
        public void run() {
            SearchView.this.updateFocusedState();
        }
    };
    private CharSequence mUserQuery;
    private final Intent mVoiceAppSearchIntent;
    private final ImageView mVoiceButton;
    private boolean mVoiceButtonEnabled;
    private final Intent mVoiceWebSearchIntent;

    public SearchView(Context context) {
        this(context, null);
    }

    public SearchView(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 16843904);
    }

    public SearchView(Context context, AttributeSet attributeSet, int n) {
        this(context, attributeSet, n, 0);
    }

    /*
     * Enabled aggressive block sorting
     */
    public SearchView(Context context, AttributeSet attributeSet, int n, int n2) {
        super(context, attributeSet, n, n2);
        int n3;
        int n4;
        CharSequence charSequence;
        this.mReleaseCursorRunnable = new Runnable(){

            @Override
            public void run() {
                if (SearchView.this.mSuggestionsAdapter != null && SearchView.this.mSuggestionsAdapter instanceof SuggestionsAdapter) {
                    SearchView.this.mSuggestionsAdapter.changeCursor(null);
                }
            }
        };
        this.mOutsideDrawablesCache = new WeakHashMap();
        this.mOnClickListener = new View.OnClickListener(){

            /*
             * Enabled aggressive block sorting
             */
            @Override
            public void onClick(View view) {
                if (view == SearchView.this.mSearchButton) {
                    SearchView.this.onSearchClicked();
                    return;
                } else {
                    if (view == SearchView.this.mCloseButton) {
                        SearchView.this.onCloseClicked();
                        return;
                    }
                    if (view == SearchView.this.mSubmitButton) {
                        SearchView.this.onSubmitQuery();
                        return;
                    }
                    if (view == SearchView.this.mVoiceButton) {
                        SearchView.this.onVoiceClicked();
                        return;
                    }
                    if (view != SearchView.this.mQueryTextView) return;
                    SearchView.this.forceSuggestionQuery();
                    return;
                }
            }
        };
        this.mTextKeyListener = new View.OnKeyListener(){

            /*
             * Enabled aggressive block sorting
             */
            @Override
            public boolean onKey(View view, int n, KeyEvent keyEvent) {
                SearchableInfo.ActionKeyInfo actionKeyInfo;
                block6: {
                    block5: {
                        if (SearchView.this.mSearchable == null) break block5;
                        if (SearchView.this.mQueryTextView.isPopupShowing() && SearchView.this.mQueryTextView.getListSelection() != -1) {
                            return SearchView.this.onSuggestionsKey(view, n, keyEvent);
                        }
                        if (SearchView.this.mQueryTextView.isEmpty() || !keyEvent.hasNoModifiers()) break block5;
                        if (keyEvent.getAction() == 1 && n == 66) {
                            view.cancelLongPress();
                            SearchView.this.launchQuerySearch(0, null, SearchView.this.mQueryTextView.getText().toString());
                            return true;
                        }
                        if (keyEvent.getAction() == 0 && (actionKeyInfo = SearchView.this.mSearchable.findActionKey(n)) != null && actionKeyInfo.getQueryActionMsg() != null) break block6;
                    }
                    return false;
                }
                SearchView.this.launchQuerySearch(n, actionKeyInfo.getQueryActionMsg(), SearchView.this.mQueryTextView.getText().toString());
                return true;
            }
        };
        this.mOnEditorActionListener = new TextView.OnEditorActionListener(){

            @Override
            public boolean onEditorAction(TextView textView, int n, KeyEvent keyEvent) {
                SearchView.this.onSubmitQuery();
                return true;
            }
        };
        this.mOnItemClickListener = new AdapterView.OnItemClickListener(){

            @Override
            public void onItemClick(AdapterView<?> adapterView, View view, int n, long l) {
                SearchView.this.onItemClicked(n, 0, null);
            }
        };
        this.mOnItemSelectedListener = new AdapterView.OnItemSelectedListener(){

            @Override
            public void onItemSelected(AdapterView<?> adapterView, View view, int n, long l) {
                SearchView.this.onItemSelected(n);
            }

            @Override
            public void onNothingSelected(AdapterView<?> adapterView) {
            }
        };
        this.mTextWatcher = new TextWatcher(){

            @Override
            public void afterTextChanged(Editable editable) {
            }

            @Override
            public void beforeTextChanged(CharSequence charSequence, int n, int n2, int n3) {
            }

            @Override
            public void onTextChanged(CharSequence charSequence, int n, int n2, int n3) {
                SearchView.this.onTextChanged(charSequence);
            }
        };
        TypedArray typedArray = context.obtainStyledAttributes(attributeSet, R.styleable.SearchView, n, n2);
        ((LayoutInflater)context.getSystemService("layout_inflater")).inflate(typedArray.getResourceId(1, 17367258), (ViewGroup)this, true);
        this.mQueryTextView = (SearchAutoComplete)this.findViewById(16909083);
        this.mQueryTextView.setSearchView(this);
        this.mSearchEditFrame = this.findViewById(16909080);
        this.mSearchPlate = this.findViewById(16909082);
        this.mSubmitArea = this.findViewById(16909085);
        this.mSearchButton = (ImageView)this.findViewById(16909079);
        this.mSubmitButton = (ImageView)this.findViewById(16909086);
        this.mCloseButton = (ImageView)this.findViewById(16909084);
        this.mVoiceButton = (ImageView)this.findViewById(16909087);
        this.mSearchHintIcon = (ImageView)this.findViewById(16909081);
        this.mSearchPlate.setBackground(typedArray.getDrawable(13));
        this.mSubmitArea.setBackground(typedArray.getDrawable(14));
        this.mSearchIconResId = typedArray.getResourceId(9, 0);
        this.mSearchButton.setImageResource(this.mSearchIconResId);
        this.mSubmitButton.setImageDrawable(typedArray.getDrawable(8));
        this.mCloseButton.setImageDrawable(typedArray.getDrawable(7));
        this.mVoiceButton.setImageDrawable(typedArray.getDrawable(10));
        this.mSearchHintIcon.setImageDrawable(typedArray.getDrawable(9));
        this.mSuggestionRowLayout = typedArray.getResourceId(12, 17367257);
        this.mSuggestionCommitIconResId = typedArray.getResourceId(11, 0);
        this.mSearchButton.setOnClickListener(this.mOnClickListener);
        this.mCloseButton.setOnClickListener(this.mOnClickListener);
        this.mSubmitButton.setOnClickListener(this.mOnClickListener);
        this.mVoiceButton.setOnClickListener(this.mOnClickListener);
        this.mQueryTextView.setOnClickListener(this.mOnClickListener);
        this.mQueryTextView.addTextChangedListener(this.mTextWatcher);
        this.mQueryTextView.setOnEditorActionListener(this.mOnEditorActionListener);
        this.mQueryTextView.setOnItemClickListener(this.mOnItemClickListener);
        this.mQueryTextView.setOnItemSelectedListener(this.mOnItemSelectedListener);
        this.mQueryTextView.setOnKeyListener(this.mTextKeyListener);
        this.mQueryTextView.setOnFocusChangeListener(new View.OnFocusChangeListener(){

            @Override
            public void onFocusChange(View view, boolean bl) {
                if (SearchView.this.mOnQueryTextFocusChangeListener != null) {
                    SearchView.this.mOnQueryTextFocusChangeListener.onFocusChange(SearchView.this, bl);
                }
            }
        });
        this.mDecoratedHint = typedArray.getInt(15, 0);
        boolean bl = this.mDecoratedHint == 0;
        this.mDefaultDecoratedHint = bl;
        this.mEditTextBackground = typedArray.getDrawable(16);
        if (this.mEditTextBackground != null) {
            this.mOldEditTextBackground = this.mSearchPlate.getBackground();
        }
        this.setIconifiedByDefault(typedArray.getBoolean(5, true));
        int n5 = typedArray.getDimensionPixelSize(2, -1);
        if (n5 != -1) {
            this.setMaxWidth(n5);
        }
        if (!TextUtils.isEmpty(charSequence = typedArray.getText(6))) {
            this.setQueryHint(charSequence);
        }
        if ((n4 = typedArray.getInt(4, -1)) != -1) {
            this.setImeOptions(n4);
        }
        if ((n3 = typedArray.getInt(3, -1)) != -1) {
            this.setInputType(n3);
        }
        this.setFocusable(typedArray.getBoolean(0, true));
        typedArray.recycle();
        this.mVoiceWebSearchIntent = new Intent("android.speech.action.WEB_SEARCH");
        this.mVoiceWebSearchIntent.addFlags(0x10000000);
        this.mVoiceWebSearchIntent.putExtra("android.speech.extra.LANGUAGE_MODEL", "web_search");
        this.mVoiceAppSearchIntent = new Intent("android.speech.action.RECOGNIZE_SPEECH");
        this.mVoiceAppSearchIntent.addFlags(0x10000000);
        this.mDropDownAnchor = this.findViewById(this.mQueryTextView.getDropDownAnchor());
        if (this.mDropDownAnchor != null) {
            this.mDropDownAnchor.addOnLayoutChangeListener(new View.OnLayoutChangeListener(){

                @Override
                public void onLayoutChange(View view, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
                    SearchView.this.adjustDropDownSizeAndPosition();
                }
            });
        }
        this.updateViewsVisibility(this.mIconifiedByDefault);
        this.updateQueryHint();
    }

    /*
     * Enabled aggressive block sorting
     */
    private void adjustDropDownSizeAndPosition() {
        if (this.mDropDownAnchor.getWidth() > 1) {
            Resources resources = this.getContext().getResources();
            int n = this.mSearchPlate.getPaddingLeft();
            Rect rect = new Rect();
            boolean bl = this.isLayoutRtl();
            int n2 = this.mIconifiedByDefault ? resources.getDimensionPixelSize(17104969) + resources.getDimensionPixelSize(17104967) : 0;
            this.mQueryTextView.getDropDownBackground().getPadding(rect);
            int n3 = bl ? -rect.left : n - (n2 + rect.left);
            this.mQueryTextView.setDropDownHorizontalOffset(n3);
            int n4 = n2 + (this.mDropDownAnchor.getWidth() + rect.left + rect.right) - n;
            this.mQueryTextView.setDropDownWidth(n4);
        }
    }

    private Intent createIntent(String string2, Uri uri, String string3, String string4, int n, String string5) {
        Intent intent = new Intent(string2);
        intent.addFlags(0x10000000);
        if (uri != null) {
            intent.setData(uri);
        }
        intent.putExtra("user_query", this.mUserQuery);
        if (string4 != null) {
            intent.putExtra("query", string4);
        }
        if (string3 != null) {
            intent.putExtra("intent_extra_data_key", string3);
        }
        if (this.mAppSearchData != null) {
            intent.putExtra("app_data", this.mAppSearchData);
        }
        if (n != 0) {
            intent.putExtra("action_key", n);
            intent.putExtra("action_msg", string5);
        }
        intent.setComponent(this.mSearchable.getSearchActivity());
        return intent;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Intent createIntentFromSuggestion(Cursor cursor, int n, String string2) {
        Uri uri;
        String string3;
        String string4;
        String string5;
        try {
            string5 = SuggestionsAdapter.getColumnString(cursor, "suggest_intent_action");
            if (string5 == null) {
                string5 = this.mSearchable.getSuggestIntentAction();
            }
        }
        catch (RuntimeException runtimeException) {
            int n2;
            try {
                int n3;
                n2 = n3 = cursor.getPosition();
            }
            catch (RuntimeException runtimeException2) {
                n2 = -1;
            }
            Log.w(LOG_TAG, "Search suggestions cursor at row " + n2 + " returned exception.", runtimeException);
            return null;
        }
        if (string5 == null) {
            string5 = "android.intent.action.SEARCH";
        }
        if ((string4 = SuggestionsAdapter.getColumnString(cursor, "suggest_intent_data")) == null) {
            string4 = this.mSearchable.getSuggestIntentData();
        }
        if (string4 != null && (string3 = SuggestionsAdapter.getColumnString(cursor, "suggest_intent_data_id")) != null) {
            string4 = string4 + "/" + Uri.encode(string3);
        }
        Uri uri2 = string4 == null ? null : (uri = Uri.parse(string4));
        String string6 = SuggestionsAdapter.getColumnString(cursor, "suggest_intent_query");
        return this.createIntent(string5, uri2, SuggestionsAdapter.getColumnString(cursor, "suggest_intent_extra_data"), string6, n, string2);
    }

    /*
     * Enabled aggressive block sorting
     */
    private Intent createVoiceAppSearchIntent(Intent intent, SearchableInfo searchableInfo) {
        ComponentName componentName = searchableInfo.getSearchActivity();
        Intent intent2 = new Intent("android.intent.action.SEARCH");
        intent2.setComponent(componentName);
        PendingIntent pendingIntent = PendingIntent.getActivity(this.getContext(), 0, intent2, 0x40000000);
        Bundle bundle = new Bundle();
        if (this.mAppSearchData != null) {
            bundle.putParcelable("app_data", this.mAppSearchData);
        }
        Intent intent3 = new Intent(intent);
        String string2 = "free_form";
        int n = 1;
        Resources resources = this.getResources();
        if (searchableInfo.getVoiceLanguageModeId() != 0) {
            string2 = resources.getString(searchableInfo.getVoiceLanguageModeId());
        }
        int n2 = searchableInfo.getVoicePromptTextId();
        String string3 = null;
        if (n2 != 0) {
            string3 = resources.getString(searchableInfo.getVoicePromptTextId());
        }
        int n3 = searchableInfo.getVoiceLanguageId();
        String string4 = null;
        if (n3 != 0) {
            string4 = resources.getString(searchableInfo.getVoiceLanguageId());
        }
        if (searchableInfo.getVoiceMaxResults() != 0) {
            n = searchableInfo.getVoiceMaxResults();
        }
        intent3.putExtra("android.speech.extra.LANGUAGE_MODEL", string2);
        intent3.putExtra("android.speech.extra.PROMPT", string3);
        intent3.putExtra("android.speech.extra.LANGUAGE", string4);
        intent3.putExtra("android.speech.extra.MAX_RESULTS", n);
        String string5 = componentName == null ? null : componentName.flattenToShortString();
        intent3.putExtra("calling_package", string5);
        intent3.putExtra("android.speech.extra.RESULTS_PENDINGINTENT", pendingIntent);
        intent3.putExtra("android.speech.extra.RESULTS_PENDINGINTENT_BUNDLE", bundle);
        return intent3;
    }

    /*
     * Enabled aggressive block sorting
     */
    private Intent createVoiceWebSearchIntent(Intent intent, SearchableInfo searchableInfo) {
        Intent intent2 = new Intent(intent);
        ComponentName componentName = searchableInfo.getSearchActivity();
        String string2 = componentName == null ? null : componentName.flattenToShortString();
        intent2.putExtra("calling_package", string2);
        return intent2;
    }

    private void dismissSuggestions() {
        this.mQueryTextView.dismissDropDown();
    }

    private void forceSuggestionQuery() {
        this.mQueryTextView.doBeforeTextChanged();
        this.mQueryTextView.doAfterTextChanged();
    }

    private static String getActionKeyMessage(Cursor cursor, SearchableInfo.ActionKeyInfo actionKeyInfo) {
        String string2 = actionKeyInfo.getSuggestActionMsgColumn();
        String string3 = null;
        if (string2 != null) {
            string3 = SuggestionsAdapter.getColumnString(cursor, string2);
        }
        if (string3 == null) {
            string3 = actionKeyInfo.getSuggestActionMsg();
        }
        return string3;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private CharSequence getDecoratedHint(CharSequence charSequence) {
        void var6_6;
        if (this.mDefaultDecoratedHint && !this.mIconifiedByDefault) {
            return charSequence;
        }
        Drawable drawable2 = this.getContext().getDrawable(this.mSearchIconResId);
        int n = (int)(1.25 * (double)this.mQueryTextView.getTextSize());
        drawable2.setBounds(0, 0, n, n);
        SpannableStringBuilder spannableStringBuilder = new SpannableStringBuilder("   ");
        spannableStringBuilder.append(charSequence);
        if (this.mDefaultDecoratedHint) {
            ImageSpan imageSpan = new ImageSpan(drawable2);
        } else {
            MinimumLineHeightImageSpan minimumLineHeightImageSpan = new MinimumLineHeightImageSpan(drawable2);
        }
        spannableStringBuilder.setSpan(var6_6, 1, 2, 33);
        return spannableStringBuilder;
    }

    private int getPreferredWidth() {
        return this.getContext().getResources().getDimensionPixelSize(17104946);
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean hasVoiceSearch() {
        Intent intent;
        SearchableInfo searchableInfo = this.mSearchable;
        boolean bl = false;
        if (searchableInfo == null) return bl;
        boolean bl2 = this.mSearchable.getVoiceSearchEnabled();
        bl = false;
        if (!bl2) return bl;
        if (this.mSearchable.getVoiceSearchLaunchWebSearch()) {
            intent = this.mVoiceWebSearchIntent;
        } else {
            boolean bl3 = this.mSearchable.getVoiceSearchLaunchRecognizer();
            intent = null;
            if (bl3) {
                intent = this.mVoiceAppSearchIntent;
            }
        }
        bl = false;
        if (intent == null) return bl;
        ResolveInfo resolveInfo = this.getContext().getPackageManager().resolveActivity(intent, 65536);
        bl = false;
        if (resolveInfo == null) return bl;
        return true;
    }

    static boolean isLandscapeMode(Context context) {
        return context.getResources().getConfiguration().orientation == 2;
    }

    private boolean isSubmitAreaEnabled() {
        return (this.mSubmitButtonEnabled || this.mVoiceButtonEnabled) && !this.isIconified();
    }

    private void launchIntent(Intent intent) {
        if (intent == null) {
            return;
        }
        try {
            this.getContext().startActivity(intent);
            return;
        }
        catch (RuntimeException runtimeException) {
            Log.e(LOG_TAG, "Failed launch activity: " + intent, runtimeException);
            return;
        }
    }

    private void launchQuerySearch(int n, String string2, String string3) {
        Intent intent = this.createIntent("android.intent.action.SEARCH", null, null, string3, n, string2);
        this.getContext().startActivity(intent);
    }

    private boolean launchSuggestion(int n, int n2, String string2) {
        Cursor cursor = this.mSuggestionsAdapter.getCursor();
        if (cursor != null && cursor.moveToPosition(n)) {
            this.launchIntent(this.createIntentFromSuggestion(cursor, n2, string2));
            return true;
        }
        return false;
    }

    private void onCloseClicked() {
        if (TextUtils.isEmpty(this.mQueryTextView.getText())) {
            if (this.mIconifiedByDefault && (this.mOnCloseListener == null || !this.mOnCloseListener.onClose())) {
                this.clearFocus();
                this.updateViewsVisibility(true);
            }
            return;
        }
        this.mQueryTextView.setText("");
        this.mQueryTextView.requestFocus();
        this.setImeVisibility(true);
    }

    private boolean onItemClicked(int n, int n2, String string2) {
        boolean bl;
        block3: {
            block2: {
                if (this.mOnSuggestionListener == null) break block2;
                boolean bl2 = this.mOnSuggestionListener.onSuggestionClick(n);
                bl = false;
                if (bl2) break block3;
            }
            this.launchSuggestion(n, 0, null);
            this.setImeVisibility(false);
            this.dismissSuggestions();
            bl = true;
        }
        return bl;
    }

    private boolean onItemSelected(int n) {
        if (this.mOnSuggestionListener == null || !this.mOnSuggestionListener.onSuggestionSelect(n)) {
            this.rewriteQueryFromSuggestion(n);
            return true;
        }
        return false;
    }

    private void onSearchClicked() {
        this.updateViewsVisibility(false);
        this.mQueryTextView.requestFocus();
        this.setImeVisibility(true);
        if (this.mOnSearchClickListener != null) {
            this.mOnSearchClickListener.onClick(this);
        }
    }

    private void onSubmitQuery() {
        Editable editable = this.mQueryTextView.getText();
        if (!(editable == null || TextUtils.getTrimmedLength(editable) <= 0 || this.mOnQueryChangeListener != null && this.mOnQueryChangeListener.onQueryTextSubmit(editable.toString()))) {
            if (this.mSearchable != null) {
                this.launchQuerySearch(0, null, editable.toString());
            }
            this.setImeVisibility(false);
            this.dismissSuggestions();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean onSuggestionsKey(View view, int n, KeyEvent keyEvent) {
        String string2;
        int n2;
        block6: {
            block5: {
                Cursor cursor;
                SearchableInfo.ActionKeyInfo actionKeyInfo;
                if (this.mSearchable == null || this.mSuggestionsAdapter == null || keyEvent.getAction() != 0 || !keyEvent.hasNoModifiers()) break block5;
                if (n == 66 || n == 84 || n == 61) {
                    return this.onItemClicked(this.mQueryTextView.getListSelection(), 0, null);
                }
                if (n == 21 || n == 22) {
                    int n3 = n == 21 ? 0 : this.mQueryTextView.length();
                    this.mQueryTextView.setSelection(n3);
                    this.mQueryTextView.setListSelection(0);
                    this.mQueryTextView.clearListSelection();
                    this.mQueryTextView.ensureImeVisible(true);
                    return true;
                }
                if (!(n == 19 && this.mQueryTextView.getListSelection() == 0 || (actionKeyInfo = this.mSearchable.findActionKey(n)) == null || actionKeyInfo.getSuggestActionMsg() == null && actionKeyInfo.getSuggestActionMsgColumn() == null || (n2 = this.mQueryTextView.getListSelection()) == -1 || !(cursor = this.mSuggestionsAdapter.getCursor()).moveToPosition(n2) || (string2 = SearchView.getActionKeyMessage(cursor, actionKeyInfo)) == null) && string2.length() > 0) break block6;
            }
            return false;
        }
        return this.onItemClicked(n2, n, string2);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void onTextChanged(CharSequence charSequence) {
        boolean bl = true;
        Editable editable = this.mQueryTextView.getText();
        this.mUserQuery = editable;
        boolean bl2 = !TextUtils.isEmpty(editable) ? bl : false;
        this.updateSubmitButton(bl2);
        if (bl2) {
            bl = false;
        }
        this.updateVoiceButton(bl);
        this.updateCloseButton();
        this.updateSubmitArea();
        if (this.mOnQueryChangeListener != null && !TextUtils.equals(charSequence, this.mOldQueryText)) {
            this.mOnQueryChangeListener.onQueryTextChange(charSequence.toString());
        }
        this.mOldQueryText = charSequence.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void onVoiceClicked() {
        SearchableInfo searchableInfo;
        block6: {
            block5: {
                if (this.mSearchable != null) {
                    searchableInfo = this.mSearchable;
                    try {
                        if (searchableInfo.getVoiceSearchLaunchWebSearch()) {
                            Intent intent = this.createVoiceWebSearchIntent(this.mVoiceWebSearchIntent, searchableInfo);
                            this.getContext().startActivity(intent);
                            return;
                        }
                        if (!searchableInfo.getVoiceSearchLaunchRecognizer()) break block5;
                        break block6;
                    }
                    catch (ActivityNotFoundException activityNotFoundException) {
                        Log.w(LOG_TAG, "Could not find voice search activity");
                        return;
                    }
                }
            }
            return;
        }
        Intent intent = this.createVoiceAppSearchIntent(this.mVoiceAppSearchIntent, searchableInfo);
        this.getContext().startActivity(intent);
    }

    private void postUpdateFocusedState() {
        this.post(this.mUpdateDrawableStateRunnable);
    }

    private void rewriteQueryFromSuggestion(int n) {
        Editable editable = this.mQueryTextView.getText();
        Cursor cursor = this.mSuggestionsAdapter.getCursor();
        if (cursor == null) {
            return;
        }
        if (cursor.moveToPosition(n)) {
            CharSequence charSequence = this.mSuggestionsAdapter.convertToString(cursor);
            if (charSequence != null) {
                this.setQuery(charSequence);
                return;
            }
            this.setQuery(editable);
            return;
        }
        this.setQuery(editable);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void setImeVisibility(boolean bl) {
        if (bl) {
            this.post(this.mShowImeRunnable);
            return;
        } else {
            this.removeCallbacks(this.mShowImeRunnable);
            InputMethodManager inputMethodManager = (InputMethodManager)this.getContext().getSystemService("input_method");
            if (inputMethodManager == null) return;
            inputMethodManager.hideSoftInputFromWindow(this.getWindowToken(), 0);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void setQuery(CharSequence charSequence) {
        this.mQueryTextView.setText(charSequence, true);
        SearchAutoComplete searchAutoComplete = this.mQueryTextView;
        int n = TextUtils.isEmpty(charSequence) ? 0 : charSequence.length();
        searchAutoComplete.setSelection(n);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void updateCloseButton() {
        boolean bl = true;
        boolean bl2 = !TextUtils.isEmpty(this.mQueryTextView.getText()) ? bl : false;
        if (!(bl2 || this.mIconifiedByDefault && !this.mExpandedInActionView)) {
            bl = false;
        }
        ImageView imageView = this.mCloseButton;
        int n = 0;
        if (!bl) {
            n = 8;
        }
        imageView.setVisibility(n);
        Drawable drawable2 = this.mCloseButton.getDrawable();
        int[] nArray = bl2 ? ENABLED_STATE_SET : EMPTY_STATE_SET;
        drawable2.setState(nArray);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void updateFocusedState() {
        if (this.mEditTextBackground != null) {
            Drawable drawable2 = this.mSubmitArea.getVisibility() != 0 ? this.mEditTextBackground : this.mOldEditTextBackground;
            if (this.mSearchPlate.getBackground() != drawable2) {
                this.mSearchPlate.setBackground(drawable2);
            }
        }
        boolean bl = this.mQueryTextView.hasFocus();
        Drawable drawable3 = this.mSearchPlate.getBackground();
        int[] nArray = bl ? FOCUSED_STATE_SET : EMPTY_STATE_SET;
        drawable3.setState(nArray);
        Drawable drawable4 = this.mSubmitArea.getBackground();
        int[] nArray2 = bl ? FOCUSED_STATE_SET : EMPTY_STATE_SET;
        drawable4.setState(nArray2);
        this.invalidate();
    }

    /*
     * Enabled aggressive block sorting
     */
    private void updateQueryHint() {
        if (this.mQueryHint != null) {
            this.mQueryTextView.setHint(this.getDecoratedHint(this.mQueryHint));
            return;
        } else {
            if (this.mSearchable == null) {
                this.mQueryTextView.setHint(this.getDecoratedHint(""));
                return;
            }
            int n = this.mSearchable.getHintId();
            String string2 = null;
            if (n != 0) {
                string2 = this.getContext().getString(n);
            }
            if (string2 == null) return;
            this.mQueryTextView.setHint(this.getDecoratedHint(string2));
            return;
        }
    }

    private void updateSearchAutoComplete() {
        int n = 1;
        this.mQueryTextView.setDropDownAnimationStyle(0);
        this.mQueryTextView.setThreshold(this.mSearchable.getSuggestThreshold());
        this.mQueryTextView.setImeOptions(this.mSearchable.getImeOptions());
        int n2 = this.mSearchable.getInputType();
        if ((n2 & 0xF) == n) {
            n2 &= 0xFFFEFFFF;
            if (this.mSearchable.getSuggestAuthority() != null) {
                n2 = 0x80000 | (n2 | 0x10000);
            }
        }
        this.mQueryTextView.setInputType(n2);
        if (this.mSuggestionsAdapter != null) {
            this.mSuggestionsAdapter.changeCursor(null);
        }
        if (this.mSearchable.getSuggestAuthority() != null) {
            this.mSuggestionsAdapter = new SuggestionsAdapter(this.getContext(), this, this.mSearchable, this.mOutsideDrawablesCache);
            this.mQueryTextView.setAdapter(this.mSuggestionsAdapter);
            SuggestionsAdapter suggestionsAdapter = (SuggestionsAdapter)this.mSuggestionsAdapter;
            if (this.mQueryRefinement) {
                n = 2;
            }
            suggestionsAdapter.setQueryRefinement(n);
        }
    }

    private void updateSubmitArea() {
        int n = 8;
        int n2 = this.mSubmitArea.getVisibility();
        if (this.isSubmitAreaEnabled() && (this.mSubmitButton.getVisibility() == 0 || this.mVoiceButton.getVisibility() == 0)) {
            n = 0;
        }
        this.mSubmitArea.setVisibility(n);
        if (n2 != n) {
            this.updateFocusedState();
        }
    }

    private void updateSubmitButton(boolean bl) {
        int n = 8;
        if (this.mSubmitButtonEnabled && this.isSubmitAreaEnabled() && this.hasFocus() && (bl || !this.mVoiceButtonEnabled)) {
            n = 0;
        }
        this.mSubmitButton.setVisibility(n);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void updateViewsVisibility(boolean bl) {
        boolean bl2 = true;
        int n = 8;
        this.mIconified = bl;
        int n2 = bl ? 0 : n;
        boolean bl3 = !TextUtils.isEmpty(this.mQueryTextView.getText()) ? bl2 : false;
        this.mSearchButton.setVisibility(n2);
        this.updateSubmitButton(bl3);
        View view = this.mSearchEditFrame;
        int n3 = bl ? n : 0;
        view.setVisibility(n3);
        ImageView imageView = this.mSearchHintIcon;
        if (this.mDefaultDecoratedHint && !this.mIconifiedByDefault) {
            n = 0;
        }
        imageView.setVisibility(n);
        this.updateCloseButton();
        if (bl3) {
            bl2 = false;
        }
        this.updateVoiceButton(bl2);
        this.updateSubmitArea();
    }

    private void updateVoiceButton(boolean bl) {
        int n = 8;
        if (this.mVoiceButtonEnabled && !this.isIconified() && bl) {
            n = 0;
            this.mSubmitButton.setVisibility(8);
        }
        this.mVoiceButton.setVisibility(n);
    }

    @Override
    public void clearFocus() {
        this.mClearingFocus = true;
        this.setImeVisibility(false);
        super.clearFocus();
        this.mQueryTextView.clearFocus();
        this.mClearingFocus = false;
    }

    public int getImeOptions() {
        return this.mQueryTextView.getImeOptions();
    }

    public int getInputType() {
        return this.mQueryTextView.getInputType();
    }

    public int getMaxWidth() {
        return this.mMaxWidth;
    }

    public CharSequence getQuery() {
        return this.mQueryTextView.getText();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public CharSequence getQueryHint() {
        if (this.mQueryHint != null) {
            return this.mQueryHint;
        }
        if (this.mSearchable == null) return null;
        int n = this.mSearchable.getHintId();
        CharSequence charSequence = null;
        if (n == 0) return charSequence;
        return this.getContext().getString(n);
    }

    int getSuggestionCommitIconResId() {
        return this.mSuggestionCommitIconResId;
    }

    int getSuggestionRowLayout() {
        return this.mSuggestionRowLayout;
    }

    public CursorAdapter getSuggestionsAdapter() {
        return this.mSuggestionsAdapter;
    }

    public boolean isIconfiedByDefault() {
        return this.mIconifiedByDefault;
    }

    public boolean isIconified() {
        return this.mIconified;
    }

    public boolean isQueryRefinementEnabled() {
        return this.mQueryRefinement;
    }

    public boolean isSubmitButtonEnabled() {
        return this.mSubmitButtonEnabled;
    }

    @Override
    public void onActionViewCollapsed() {
        this.setQuery("", false);
        this.clearFocus();
        this.updateViewsVisibility(true);
        this.mQueryTextView.setImeOptions(this.mCollapsedImeOptions);
        this.mExpandedInActionView = false;
    }

    @Override
    public void onActionViewExpanded() {
        if (this.mExpandedInActionView) {
            return;
        }
        this.mExpandedInActionView = true;
        this.mCollapsedImeOptions = this.mQueryTextView.getImeOptions();
        this.mQueryTextView.setImeOptions(0x2000000 | this.mCollapsedImeOptions);
        this.mQueryTextView.setText("");
        this.setIconified(false);
    }

    @Override
    protected void onDetachedFromWindow() {
        this.removeCallbacks(this.mUpdateDrawableStateRunnable);
        this.post(this.mReleaseCursorRunnable);
        super.onDetachedFromWindow();
    }

    @Override
    public void onInitializeAccessibilityEvent(AccessibilityEvent accessibilityEvent) {
        super.onInitializeAccessibilityEvent(accessibilityEvent);
        accessibilityEvent.setClassName(SearchView.class.getName());
    }

    @Override
    public void onInitializeAccessibilityNodeInfo(AccessibilityNodeInfo accessibilityNodeInfo) {
        super.onInitializeAccessibilityNodeInfo(accessibilityNodeInfo);
        accessibilityNodeInfo.setClassName(SearchView.class.getName());
    }

    @Override
    public boolean onKeyDown(int n, KeyEvent keyEvent) {
        if (this.mSearchable == null) {
            return false;
        }
        SearchableInfo.ActionKeyInfo actionKeyInfo = this.mSearchable.findActionKey(n);
        if (actionKeyInfo != null && actionKeyInfo.getQueryActionMsg() != null) {
            this.launchQuerySearch(n, actionKeyInfo.getQueryActionMsg(), this.mQueryTextView.getText().toString());
            return true;
        }
        return super.onKeyDown(n, keyEvent);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void onMeasure(int n, int n2) {
        if (this.isIconified()) {
            super.onMeasure(n, n2);
            return;
        }
        int n3 = View.MeasureSpec.getMode(n);
        int n4 = View.MeasureSpec.getSize(n);
        switch (n3) {
            case -2147483648: {
                if (this.mMaxWidth > 0) {
                    n4 = Math.min(this.mMaxWidth, n4);
                    break;
                }
                n4 = Math.min(this.getPreferredWidth(), n4);
                break;
            }
            case 0x40000000: {
                if (this.mMaxWidth <= 0) break;
                n4 = Math.min(this.mMaxWidth, n4);
                break;
            }
            case 0: {
                if (this.mMaxWidth > 0) {
                    n4 = this.mMaxWidth;
                    break;
                }
                n4 = this.getPreferredWidth();
                break;
            }
        }
        super.onMeasure(View.MeasureSpec.makeMeasureSpec(n4, 0x40000000), n2);
    }

    void onQueryRefine(CharSequence charSequence) {
        this.setQuery(charSequence);
    }

    void onTextFocusChanged() {
        this.updateViewsVisibility(this.isIconified());
        this.postUpdateFocusedState();
        if (this.mQueryTextView.hasFocus()) {
            this.forceSuggestionQuery();
        }
    }

    @Override
    public void onWindowFocusChanged(boolean bl) {
        super.onWindowFocusChanged(bl);
        this.postUpdateFocusedState();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean requestFocus(int n, Rect rect) {
        if (this.mClearingFocus) {
            return false;
        }
        if (!this.isFocusable()) {
            return false;
        }
        if (this.isIconified()) return super.requestFocus(n, rect);
        boolean bl = this.mQueryTextView.requestFocus(n, rect);
        if (!bl) return bl;
        this.updateViewsVisibility(false);
        return bl;
    }

    public void setAppSearchData(Bundle bundle) {
        this.mAppSearchData = bundle;
    }

    public void setIconified(boolean bl) {
        if (bl) {
            this.onCloseClicked();
            return;
        }
        this.onSearchClicked();
    }

    public void setIconifiedByDefault(boolean bl) {
        if (this.mIconifiedByDefault == bl) {
            return;
        }
        this.mIconifiedByDefault = bl;
        this.updateViewsVisibility(bl);
        this.updateQueryHint();
    }

    public void setImeOptions(int n) {
        this.mQueryTextView.setImeOptions(n);
    }

    public void setInputType(int n) {
        this.mQueryTextView.setInputType(n);
    }

    public void setMaxWidth(int n) {
        this.mMaxWidth = n;
        this.requestLayout();
    }

    public void setOnCloseListener(OnCloseListener onCloseListener) {
        this.mOnCloseListener = onCloseListener;
    }

    public void setOnQueryTextFocusChangeListener(View.OnFocusChangeListener onFocusChangeListener) {
        this.mOnQueryTextFocusChangeListener = onFocusChangeListener;
    }

    public void setOnQueryTextListener(OnQueryTextListener onQueryTextListener) {
        this.mOnQueryChangeListener = onQueryTextListener;
    }

    public void setOnSearchClickListener(View.OnClickListener onClickListener) {
        this.mOnSearchClickListener = onClickListener;
    }

    public void setOnSuggestionListener(OnSuggestionListener onSuggestionListener) {
        this.mOnSuggestionListener = onSuggestionListener;
    }

    public void setQuery(CharSequence charSequence, boolean bl) {
        this.mQueryTextView.setText(charSequence);
        if (charSequence != null) {
            this.mQueryTextView.setSelection(this.mQueryTextView.length());
            this.mUserQuery = charSequence;
        }
        if (bl && !TextUtils.isEmpty(charSequence)) {
            this.onSubmitQuery();
        }
    }

    public void setQueryHint(CharSequence charSequence) {
        this.mQueryHint = charSequence;
        this.updateQueryHint();
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setQueryRefinementEnabled(boolean bl) {
        this.mQueryRefinement = bl;
        if (this.mSuggestionsAdapter instanceof SuggestionsAdapter) {
            SuggestionsAdapter suggestionsAdapter = (SuggestionsAdapter)this.mSuggestionsAdapter;
            int n = bl ? 2 : 1;
            suggestionsAdapter.setQueryRefinement(n);
        }
    }

    public void setSearchableInfo(SearchableInfo searchableInfo) {
        this.mSearchable = searchableInfo;
        if (this.mSearchable != null) {
            this.updateSearchAutoComplete();
            this.updateQueryHint();
        }
        this.mVoiceButtonEnabled = this.hasVoiceSearch();
        if (this.mVoiceButtonEnabled) {
            this.mQueryTextView.setPrivateImeOptions(IME_OPTION_NO_MICROPHONE);
        }
        this.updateViewsVisibility(this.isIconified());
    }

    public void setSubmitButtonEnabled(boolean bl) {
        this.mSubmitButtonEnabled = bl;
        this.updateViewsVisibility(this.isIconified());
    }

    public void setSuggestionsAdapter(CursorAdapter cursorAdapter) {
        this.mSuggestionsAdapter = cursorAdapter;
        this.mQueryTextView.setAdapter(this.mSuggestionsAdapter);
    }

    private class MinimumLineHeightImageSpan
    extends DynamicDrawableSpan
    implements LineHeightSpan {
        private Drawable mDrawable;
        private int mWidth;

        public MinimumLineHeightImageSpan(Drawable drawable2) {
            this.mDrawable = drawable2;
            this.mWidth = drawable2.getBounds().right;
        }

        @Override
        public void chooseHeight(CharSequence charSequence, int n, int n2, int n3, int n4, Paint.FontMetricsInt fontMetricsInt) {
            fontMetricsInt.ascent = fontMetricsInt.top;
            fontMetricsInt.descent = fontMetricsInt.bottom;
        }

        @Override
        public Drawable getDrawable() {
            return this.mDrawable;
        }

        @Override
        public int getSize(Paint paint, CharSequence charSequence, int n, int n2, Paint.FontMetricsInt fontMetricsInt) {
            return this.mWidth;
        }
    }

    public static interface OnCloseListener {
        public boolean onClose();
    }

    public static interface OnQueryTextListener {
        public boolean onQueryTextChange(String var1);

        public boolean onQueryTextSubmit(String var1);
    }

    public static interface OnSuggestionListener {
        public boolean onSuggestionClick(int var1);

        public boolean onSuggestionSelect(int var1);
    }

    public static class SearchAutoComplete
    extends AutoCompleteTextView {
        private SearchView mSearchView;
        private int mThreshold = this.getThreshold();

        public SearchAutoComplete(Context context) {
            super(context);
        }

        public SearchAutoComplete(Context context, AttributeSet attributeSet) {
            super(context, attributeSet);
        }

        public SearchAutoComplete(Context context, AttributeSet attributeSet, int n) {
            super(context, attributeSet, n);
        }

        public SearchAutoComplete(Context context, AttributeSet attributeSet, int n, int n2) {
            super(context, attributeSet, n, n2);
        }

        private boolean isEmpty() {
            return TextUtils.getTrimmedLength(this.getText()) == 0;
        }

        @Override
        public boolean enoughToFilter() {
            return this.mThreshold <= 0 || super.enoughToFilter();
        }

        @Override
        protected void onFocusChanged(boolean bl, int n, Rect rect) {
            super.onFocusChanged(bl, n, rect);
            this.mSearchView.onTextFocusChanged();
        }

        @Override
        public boolean onKeyPreIme(int n, KeyEvent keyEvent) {
            if (n == 4) {
                if (keyEvent.getAction() == 0 && keyEvent.getRepeatCount() == 0) {
                    KeyEvent.DispatcherState dispatcherState = this.getKeyDispatcherState();
                    if (dispatcherState != null) {
                        dispatcherState.startTracking(keyEvent, this);
                    }
                    return true;
                }
                if (keyEvent.getAction() == 1) {
                    KeyEvent.DispatcherState dispatcherState = this.getKeyDispatcherState();
                    if (dispatcherState != null) {
                        dispatcherState.handleUpEvent(keyEvent);
                    }
                    if (keyEvent.isTracking() && !keyEvent.isCanceled()) {
                        this.mSearchView.clearFocus();
                        this.mSearchView.setImeVisibility(false);
                        return true;
                    }
                }
            }
            return super.onKeyPreIme(n, keyEvent);
        }

        @Override
        public void onWindowFocusChanged(boolean bl) {
            super.onWindowFocusChanged(bl);
            if (bl && this.mSearchView.hasFocus() && this.getVisibility() == 0) {
                ((InputMethodManager)this.getContext().getSystemService("input_method")).showSoftInput(this, 0);
                if (SearchView.isLandscapeMode(this.getContext())) {
                    this.ensureImeVisible(true);
                }
            }
        }

        @Override
        public void performCompletion() {
        }

        @Override
        protected void replaceText(CharSequence charSequence) {
        }

        void setSearchView(SearchView searchView) {
            this.mSearchView = searchView;
        }

        @Override
        public void setThreshold(int n) {
            super.setThreshold(n);
            this.mThreshold = n;
        }
    }
}

