/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseExpandableListAdapter;
import android.widget.TextView;
import java.util.List;
import java.util.Map;

public class SimpleExpandableListAdapter
extends BaseExpandableListAdapter {
    private List<? extends List<? extends Map<String, ?>>> mChildData;
    private String[] mChildFrom;
    private int mChildLayout;
    private int[] mChildTo;
    private int mCollapsedGroupLayout;
    private int mExpandedGroupLayout;
    private List<? extends Map<String, ?>> mGroupData;
    private String[] mGroupFrom;
    private int[] mGroupTo;
    private LayoutInflater mInflater;
    private int mLastChildLayout;

    public SimpleExpandableListAdapter(Context context, List<? extends Map<String, ?>> list, int n, int n2, String[] stringArray, int[] nArray, List<? extends List<? extends Map<String, ?>>> list2, int n3, int n4, String[] stringArray2, int[] nArray2) {
        this.mGroupData = list;
        this.mExpandedGroupLayout = n;
        this.mCollapsedGroupLayout = n2;
        this.mGroupFrom = stringArray;
        this.mGroupTo = nArray;
        this.mChildData = list2;
        this.mChildLayout = n3;
        this.mLastChildLayout = n4;
        this.mChildFrom = stringArray2;
        this.mChildTo = nArray2;
        this.mInflater = (LayoutInflater)context.getSystemService("layout_inflater");
    }

    public SimpleExpandableListAdapter(Context context, List<? extends Map<String, ?>> list, int n, int n2, String[] stringArray, int[] nArray, List<? extends List<? extends Map<String, ?>>> list2, int n3, String[] stringArray2, int[] nArray2) {
        this(context, list, n, n2, stringArray, nArray, list2, n3, n3, stringArray2, nArray2);
    }

    public SimpleExpandableListAdapter(Context context, List<? extends Map<String, ?>> list, int n, String[] stringArray, int[] nArray, List<? extends List<? extends Map<String, ?>>> list2, int n2, String[] stringArray2, int[] nArray2) {
        this(context, list, n, n, stringArray, nArray, list2, n2, n2, stringArray2, nArray2);
    }

    private void bindView(View view, Map<String, ?> map, String[] stringArray, int[] nArray) {
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            TextView textView = (TextView)view.findViewById(nArray[i]);
            if (textView == null) continue;
            textView.setText((String)map.get(stringArray[i]));
        }
    }

    @Override
    public Object getChild(int n, int n2) {
        return this.mChildData.get(n).get(n2);
    }

    @Override
    public long getChildId(int n, int n2) {
        return n2;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public View getChildView(int n, int n2, boolean bl, View view, ViewGroup viewGroup) {
        View view2 = view == null ? this.newChildView(bl, viewGroup) : view;
        this.bindView(view2, this.mChildData.get(n).get(n2), this.mChildFrom, this.mChildTo);
        return view2;
    }

    @Override
    public int getChildrenCount(int n) {
        return this.mChildData.get(n).size();
    }

    @Override
    public Object getGroup(int n) {
        return this.mGroupData.get(n);
    }

    @Override
    public int getGroupCount() {
        return this.mGroupData.size();
    }

    @Override
    public long getGroupId(int n) {
        return n;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public View getGroupView(int n, boolean bl, View view, ViewGroup viewGroup) {
        View view2 = view == null ? this.newGroupView(bl, viewGroup) : view;
        this.bindView(view2, this.mGroupData.get(n), this.mGroupFrom, this.mGroupTo);
        return view2;
    }

    @Override
    public boolean hasStableIds() {
        return true;
    }

    @Override
    public boolean isChildSelectable(int n, int n2) {
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public View newChildView(boolean bl, ViewGroup viewGroup) {
        int n;
        LayoutInflater layoutInflater = this.mInflater;
        if (bl) {
            n = this.mLastChildLayout;
            return layoutInflater.inflate(n, viewGroup, false);
        }
        n = this.mChildLayout;
        return layoutInflater.inflate(n, viewGroup, false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public View newGroupView(boolean bl, ViewGroup viewGroup) {
        int n;
        LayoutInflater layoutInflater = this.mInflater;
        if (bl) {
            n = this.mExpandedGroupLayout;
            return layoutInflater.inflate(n, viewGroup, false);
        }
        n = this.mCollapsedGroupLayout;
        return layoutInflater.inflate(n, viewGroup, false);
    }
}

