/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.R;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.os.Handler;
import android.os.Message;
import android.os.SystemClock;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.VelocityTracker;
import android.view.View;
import android.view.ViewGroup;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityNodeInfo;

@Deprecated
public class SlidingDrawer
extends ViewGroup {
    private static final int ANIMATION_FRAME_DURATION = 16;
    private static final int COLLAPSED_FULL_CLOSED = -10002;
    private static final int EXPANDED_FULL_OPEN = -10001;
    private static final float MAXIMUM_ACCELERATION = 2000.0f;
    private static final float MAXIMUM_MAJOR_VELOCITY = 200.0f;
    private static final float MAXIMUM_MINOR_VELOCITY = 150.0f;
    private static final float MAXIMUM_TAP_VELOCITY = 100.0f;
    private static final int MSG_ANIMATE = 1000;
    public static final int ORIENTATION_HORIZONTAL = 0;
    public static final int ORIENTATION_VERTICAL = 1;
    private static final int TAP_THRESHOLD = 6;
    private static final int VELOCITY_UNITS = 1000;
    private boolean mAllowSingleTap;
    private boolean mAnimateOnClick;
    private float mAnimatedAcceleration;
    private float mAnimatedVelocity;
    private boolean mAnimating;
    private long mAnimationLastTime;
    private float mAnimationPosition;
    private int mBottomOffset;
    private View mContent;
    private final int mContentId;
    private long mCurrentAnimationTime;
    private boolean mExpanded;
    private final Rect mFrame = new Rect();
    private View mHandle;
    private int mHandleHeight;
    private final int mHandleId;
    private int mHandleWidth;
    private final Handler mHandler;
    private final Rect mInvalidate = new Rect();
    private boolean mLocked;
    private final int mMaximumAcceleration;
    private final int mMaximumMajorVelocity;
    private final int mMaximumMinorVelocity;
    private final int mMaximumTapVelocity;
    private OnDrawerCloseListener mOnDrawerCloseListener;
    private OnDrawerOpenListener mOnDrawerOpenListener;
    private OnDrawerScrollListener mOnDrawerScrollListener;
    private final int mTapThreshold;
    private int mTopOffset;
    private int mTouchDelta;
    private boolean mTracking;
    private VelocityTracker mVelocityTracker;
    private final int mVelocityUnits;
    private boolean mVertical;

    public SlidingDrawer(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0);
    }

    public SlidingDrawer(Context context, AttributeSet attributeSet, int n) {
        this(context, attributeSet, n, 0);
    }

    /*
     * Enabled aggressive block sorting
     */
    public SlidingDrawer(Context context, AttributeSet attributeSet, int n, int n2) {
        super(context, attributeSet, n, n2);
        this.mHandler = new SlidingHandler();
        TypedArray typedArray = context.obtainStyledAttributes(attributeSet, R.styleable.SlidingDrawer, n, n2);
        boolean bl = typedArray.getInt(0, 1) == 1;
        this.mVertical = bl;
        this.mBottomOffset = (int)typedArray.getDimension(1, 0.0f);
        this.mTopOffset = (int)typedArray.getDimension(2, 0.0f);
        this.mAllowSingleTap = typedArray.getBoolean(3, true);
        this.mAnimateOnClick = typedArray.getBoolean(6, true);
        int n3 = typedArray.getResourceId(4, 0);
        if (n3 == 0) {
            throw new IllegalArgumentException("The handle attribute is required and must refer to a valid child.");
        }
        int n4 = typedArray.getResourceId(5, 0);
        if (n4 == 0) {
            throw new IllegalArgumentException("The content attribute is required and must refer to a valid child.");
        }
        if (n3 == n4) {
            throw new IllegalArgumentException("The content and handle attributes must refer to different children.");
        }
        this.mHandleId = n3;
        this.mContentId = n4;
        float f = this.getResources().getDisplayMetrics().density;
        this.mTapThreshold = (int)(0.5f + 6.0f * f);
        this.mMaximumTapVelocity = (int)(0.5f + 100.0f * f);
        this.mMaximumMinorVelocity = (int)(0.5f + 150.0f * f);
        this.mMaximumMajorVelocity = (int)(0.5f + 200.0f * f);
        this.mMaximumAcceleration = (int)(0.5f + 2000.0f * f);
        this.mVelocityUnits = (int)(0.5f + 1000.0f * f);
        typedArray.recycle();
        this.setAlwaysDrawnWithCacheEnabled(false);
    }

    private void animateClose(int n) {
        this.prepareTracking(n);
        this.performFling(n, this.mMaximumAcceleration, true);
    }

    private void animateOpen(int n) {
        this.prepareTracking(n);
        this.performFling(n, -this.mMaximumAcceleration, true);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void closeDrawer() {
        block3: {
            block2: {
                this.moveHandle(-10002);
                this.mContent.setVisibility(8);
                this.mContent.destroyDrawingCache();
                if (!this.mExpanded) break block2;
                this.mExpanded = false;
                if (this.mOnDrawerCloseListener != null) break block3;
            }
            return;
        }
        this.mOnDrawerCloseListener.onDrawerClosed();
    }

    /*
     * Enabled aggressive block sorting
     */
    private void doAnimation() {
        block5: {
            block4: {
                if (!this.mAnimating) break block4;
                this.incrementAnimation();
                float f = this.mAnimationPosition;
                int n = this.mBottomOffset;
                int n2 = this.mVertical ? this.getHeight() : this.getWidth();
                if (!(f >= (float)(-1 + (n2 + n)))) break block5;
                this.mAnimating = false;
                this.closeDrawer();
            }
            return;
        }
        if (this.mAnimationPosition < (float)this.mTopOffset) {
            this.mAnimating = false;
            this.openDrawer();
            return;
        }
        this.moveHandle((int)this.mAnimationPosition);
        this.mCurrentAnimationTime = 16L + this.mCurrentAnimationTime;
        this.mHandler.sendMessageAtTime(this.mHandler.obtainMessage(1000), this.mCurrentAnimationTime);
    }

    private void incrementAnimation() {
        long l = SystemClock.uptimeMillis();
        float f = (float)(l - this.mAnimationLastTime) / 1000.0f;
        float f2 = this.mAnimationPosition;
        float f3 = this.mAnimatedVelocity;
        float f4 = this.mAnimatedAcceleration;
        this.mAnimationPosition = f2 + f3 * f + f * (f * (0.5f * f4));
        this.mAnimatedVelocity = f3 + f4 * f;
        this.mAnimationLastTime = l;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void moveHandle(int n) {
        View view = this.mHandle;
        if (this.mVertical) {
            if (n == -10001) {
                view.offsetTopAndBottom(this.mTopOffset - view.getTop());
                this.invalidate();
                return;
            }
            if (n == -10002) {
                view.offsetTopAndBottom(this.mBottomOffset + this.mBottom - this.mTop - this.mHandleHeight - view.getTop());
                this.invalidate();
                return;
            }
            int n2 = view.getTop();
            int n3 = n - n2;
            if (n < this.mTopOffset) {
                n3 = this.mTopOffset - n2;
            } else if (n3 > this.mBottomOffset + this.mBottom - this.mTop - this.mHandleHeight - n2) {
                n3 = this.mBottomOffset + this.mBottom - this.mTop - this.mHandleHeight - n2;
            }
            view.offsetTopAndBottom(n3);
            Rect rect = this.mFrame;
            Rect rect2 = this.mInvalidate;
            view.getHitRect(rect);
            rect2.set(rect);
            rect2.union(rect.left, rect.top - n3, rect.right, rect.bottom - n3);
            rect2.union(0, rect.bottom - n3, this.getWidth(), rect.bottom - n3 + this.mContent.getHeight());
            this.invalidate(rect2);
            return;
        }
        if (n == -10001) {
            view.offsetLeftAndRight(this.mTopOffset - view.getLeft());
            this.invalidate();
            return;
        }
        if (n == -10002) {
            view.offsetLeftAndRight(this.mBottomOffset + this.mRight - this.mLeft - this.mHandleWidth - view.getLeft());
            this.invalidate();
            return;
        }
        int n4 = view.getLeft();
        int n5 = n - n4;
        if (n < this.mTopOffset) {
            n5 = this.mTopOffset - n4;
        } else if (n5 > this.mBottomOffset + this.mRight - this.mLeft - this.mHandleWidth - n4) {
            n5 = this.mBottomOffset + this.mRight - this.mLeft - this.mHandleWidth - n4;
        }
        view.offsetLeftAndRight(n5);
        Rect rect = this.mFrame;
        Rect rect3 = this.mInvalidate;
        view.getHitRect(rect);
        rect3.set(rect);
        rect3.union(rect.left - n5, rect.top, rect.right - n5, rect.bottom);
        rect3.union(rect.right - n5, 0, rect.right - n5 + this.mContent.getWidth(), this.getHeight());
        this.invalidate(rect3);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void openDrawer() {
        block3: {
            block2: {
                this.moveHandle(-10001);
                this.mContent.setVisibility(0);
                if (this.mExpanded) break block2;
                this.mExpanded = true;
                if (this.mOnDrawerOpenListener != null) break block3;
            }
            return;
        }
        this.mOnDrawerOpenListener.onDrawerOpened();
    }

    /*
     * Enabled aggressive block sorting
     */
    private void performFling(int n, float f, boolean bl) {
        long l;
        block9: {
            int n2;
            block8: {
                int n3;
                int n4;
                this.mAnimationPosition = n;
                this.mAnimatedVelocity = f;
                if (!this.mExpanded) break block8;
                if (bl || f > (float)this.mMaximumMajorVelocity || n > (n4 = this.mVertical ? this.mHandleHeight : this.mHandleWidth) + (n3 = this.mTopOffset) && f > (float)(-this.mMaximumMajorVelocity)) {
                    this.mAnimatedAcceleration = this.mMaximumAcceleration;
                    if (f < 0.0f) {
                        this.mAnimatedVelocity = 0.0f;
                    }
                    break block9;
                } else {
                    this.mAnimatedAcceleration = -this.mMaximumAcceleration;
                    if (f > 0.0f) {
                        this.mAnimatedVelocity = 0.0f;
                    }
                }
                break block9;
            }
            if (!bl && (f > (float)this.mMaximumMajorVelocity || n > (n2 = this.mVertical ? this.getHeight() : this.getWidth()) / 2 && f > (float)(-this.mMaximumMajorVelocity))) {
                this.mAnimatedAcceleration = this.mMaximumAcceleration;
                if (f < 0.0f) {
                    this.mAnimatedVelocity = 0.0f;
                }
            } else {
                this.mAnimatedAcceleration = -this.mMaximumAcceleration;
                if (f > 0.0f) {
                    this.mAnimatedVelocity = 0.0f;
                }
            }
        }
        this.mAnimationLastTime = l = SystemClock.uptimeMillis();
        this.mCurrentAnimationTime = 16L + l;
        this.mAnimating = true;
        this.mHandler.removeMessages(1000);
        this.mHandler.sendMessageAtTime(this.mHandler.obtainMessage(1000), this.mCurrentAnimationTime);
        this.stopTracking();
    }

    /*
     * Enabled aggressive block sorting
     */
    private void prepareContent() {
        if (this.mAnimating) {
            return;
        }
        View view = this.mContent;
        if (view.isLayoutRequested()) {
            if (this.mVertical) {
                int n = this.mHandleHeight;
                int n2 = this.mBottom - this.mTop - n - this.mTopOffset;
                view.measure(View.MeasureSpec.makeMeasureSpec(this.mRight - this.mLeft, 0x40000000), View.MeasureSpec.makeMeasureSpec(n2, 0x40000000));
                view.layout(0, n + this.mTopOffset, view.getMeasuredWidth(), n + this.mTopOffset + view.getMeasuredHeight());
            } else {
                int n = this.mHandle.getWidth();
                view.measure(View.MeasureSpec.makeMeasureSpec(this.mRight - this.mLeft - n - this.mTopOffset, 0x40000000), View.MeasureSpec.makeMeasureSpec(this.mBottom - this.mTop, 0x40000000));
                view.layout(n + this.mTopOffset, 0, n + this.mTopOffset + view.getMeasuredWidth(), view.getMeasuredHeight());
            }
        }
        view.getViewTreeObserver().dispatchOnPreDraw();
        if (!view.isHardwareAccelerated()) {
            view.buildDrawingCache();
        }
        view.setVisibility(8);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void prepareTracking(int n) {
        this.mTracking = true;
        this.mVelocityTracker = VelocityTracker.obtain();
        boolean bl = !this.mExpanded;
        if (bl) {
            long l;
            this.mAnimatedAcceleration = this.mMaximumAcceleration;
            this.mAnimatedVelocity = this.mMaximumMajorVelocity;
            int n2 = this.mBottomOffset;
            int n3 = this.mVertical ? this.getHeight() - this.mHandleHeight : this.getWidth() - this.mHandleWidth;
            this.mAnimationPosition = n3 + n2;
            this.moveHandle((int)this.mAnimationPosition);
            this.mAnimating = true;
            this.mHandler.removeMessages(1000);
            this.mAnimationLastTime = l = SystemClock.uptimeMillis();
            this.mCurrentAnimationTime = 16L + l;
            this.mAnimating = true;
            return;
        }
        if (this.mAnimating) {
            this.mAnimating = false;
            this.mHandler.removeMessages(1000);
        }
        this.moveHandle(n);
    }

    private void stopTracking() {
        this.mHandle.setPressed(false);
        this.mTracking = false;
        if (this.mOnDrawerScrollListener != null) {
            this.mOnDrawerScrollListener.onScrollEnded();
        }
        if (this.mVelocityTracker != null) {
            this.mVelocityTracker.recycle();
            this.mVelocityTracker = null;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void animateClose() {
        this.prepareContent();
        OnDrawerScrollListener onDrawerScrollListener = this.mOnDrawerScrollListener;
        if (onDrawerScrollListener != null) {
            onDrawerScrollListener.onScrollStarted();
        }
        int n = this.mVertical ? this.mHandle.getTop() : this.mHandle.getLeft();
        this.animateClose(n);
        if (onDrawerScrollListener != null) {
            onDrawerScrollListener.onScrollEnded();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void animateOpen() {
        this.prepareContent();
        OnDrawerScrollListener onDrawerScrollListener = this.mOnDrawerScrollListener;
        if (onDrawerScrollListener != null) {
            onDrawerScrollListener.onScrollStarted();
        }
        int n = this.mVertical ? this.mHandle.getTop() : this.mHandle.getLeft();
        this.animateOpen(n);
        this.sendAccessibilityEvent(32);
        if (onDrawerScrollListener != null) {
            onDrawerScrollListener.onScrollEnded();
        }
    }

    public void animateToggle() {
        if (!this.mExpanded) {
            this.animateOpen();
            return;
        }
        this.animateClose();
    }

    public void close() {
        this.closeDrawer();
        this.invalidate();
        this.requestLayout();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void dispatchDraw(Canvas canvas) {
        long l = this.getDrawingTime();
        View view = this.mHandle;
        boolean bl = this.mVertical;
        this.drawChild(canvas, view, l);
        if (this.mTracking || this.mAnimating) {
            Bitmap bitmap = this.mContent.getDrawingCache();
            if (bitmap != null) {
                if (!bl) {
                    canvas.drawBitmap(bitmap, view.getRight(), 0.0f, null);
                    return;
                }
                canvas.drawBitmap(bitmap, 0.0f, view.getBottom(), null);
                return;
            } else {
                canvas.save();
                float f = bl ? 0.0f : (float)(view.getLeft() - this.mTopOffset);
                float f2 = 0.0f;
                if (bl) {
                    f2 = view.getTop() - this.mTopOffset;
                }
                canvas.translate(f, f2);
                this.drawChild(canvas, this.mContent, l);
                canvas.restore();
                return;
            }
        }
        if (!this.mExpanded) return;
        this.drawChild(canvas, this.mContent, l);
    }

    public View getContent() {
        return this.mContent;
    }

    public View getHandle() {
        return this.mHandle;
    }

    public boolean isMoving() {
        return this.mTracking || this.mAnimating;
    }

    public boolean isOpened() {
        return this.mExpanded;
    }

    public void lock() {
        this.mLocked = true;
    }

    @Override
    protected void onFinishInflate() {
        this.mHandle = this.findViewById(this.mHandleId);
        if (this.mHandle == null) {
            throw new IllegalArgumentException("The handle attribute is must refer to an existing child.");
        }
        this.mHandle.setOnClickListener(new DrawerToggler());
        this.mContent = this.findViewById(this.mContentId);
        if (this.mContent == null) {
            throw new IllegalArgumentException("The content attribute is must refer to an existing child.");
        }
        this.mContent.setVisibility(8);
    }

    @Override
    public void onInitializeAccessibilityEvent(AccessibilityEvent accessibilityEvent) {
        super.onInitializeAccessibilityEvent(accessibilityEvent);
        accessibilityEvent.setClassName(SlidingDrawer.class.getName());
    }

    @Override
    public void onInitializeAccessibilityNodeInfo(AccessibilityNodeInfo accessibilityNodeInfo) {
        super.onInitializeAccessibilityNodeInfo(accessibilityNodeInfo);
        accessibilityNodeInfo.setClassName(SlidingDrawer.class.getName());
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean onInterceptTouchEvent(MotionEvent motionEvent) {
        View view;
        float f;
        float f2;
        int n;
        block8: {
            block7: {
                if (this.mLocked) break block7;
                n = motionEvent.getAction();
                f2 = motionEvent.getX();
                f = motionEvent.getY();
                Rect rect = this.mFrame;
                view = this.mHandle;
                view.getHitRect(rect);
                if (this.mTracking || rect.contains((int)f2, (int)f)) break block8;
            }
            return false;
        }
        if (n == 0) {
            this.mTracking = true;
            view.setPressed(true);
            this.prepareContent();
            if (this.mOnDrawerScrollListener != null) {
                this.mOnDrawerScrollListener.onScrollStarted();
            }
            if (this.mVertical) {
                int n2 = this.mHandle.getTop();
                this.mTouchDelta = (int)f - n2;
                this.prepareTracking(n2);
            } else {
                int n3 = this.mHandle.getLeft();
                this.mTouchDelta = (int)f2 - n3;
                this.prepareTracking(n3);
            }
            this.mVelocityTracker.addMovement(motionEvent);
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void onLayout(boolean bl, int n, int n2, int n3, int n4) {
        int n5;
        int n6;
        if (this.mTracking) {
            return;
        }
        int n7 = n3 - n;
        int n8 = n4 - n2;
        View view = this.mHandle;
        int n9 = view.getMeasuredWidth();
        int n10 = view.getMeasuredHeight();
        View view2 = this.mContent;
        if (this.mVertical) {
            n6 = (n7 - n9) / 2;
            n5 = this.mExpanded ? this.mTopOffset : n8 - n10 + this.mBottomOffset;
            view2.layout(0, n10 + this.mTopOffset, view2.getMeasuredWidth(), n10 + this.mTopOffset + view2.getMeasuredHeight());
        } else {
            n6 = this.mExpanded ? this.mTopOffset : n7 - n9 + this.mBottomOffset;
            n5 = (n8 - n10) / 2;
            view2.layout(n9 + this.mTopOffset, 0, n9 + this.mTopOffset + view2.getMeasuredWidth(), view2.getMeasuredHeight());
        }
        view.layout(n6, n5, n6 + n9, n5 + n10);
        this.mHandleHeight = view.getHeight();
        this.mHandleWidth = view.getWidth();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void onMeasure(int n, int n2) {
        int n3 = View.MeasureSpec.getMode(n);
        int n4 = View.MeasureSpec.getSize(n);
        int n5 = View.MeasureSpec.getMode(n2);
        int n6 = View.MeasureSpec.getSize(n2);
        if (n3 == 0 || n5 == 0) {
            throw new RuntimeException("SlidingDrawer cannot have UNSPECIFIED dimensions");
        }
        View view = this.mHandle;
        this.measureChild(view, n, n2);
        if (this.mVertical) {
            int n7 = n6 - view.getMeasuredHeight() - this.mTopOffset;
            this.mContent.measure(View.MeasureSpec.makeMeasureSpec(n4, 0x40000000), View.MeasureSpec.makeMeasureSpec(n7, 0x40000000));
        } else {
            int n8 = n4 - view.getMeasuredWidth() - this.mTopOffset;
            this.mContent.measure(View.MeasureSpec.makeMeasureSpec(n8, 0x40000000), View.MeasureSpec.makeMeasureSpec(n6, 0x40000000));
        }
        this.setMeasuredDimension(n4, n6);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public boolean onTouchEvent(MotionEvent var1_1) {
        if (this.mLocked) {
            return true;
        }
        if (!this.mTracking) ** GOTO lbl-1000
        this.mVelocityTracker.addMovement(var1_1);
        switch (var1_1.getAction()) lbl-1000:
        // 7 sources

        {
            default: lbl-1000:
            // 2 sources

            {
                return this.mTracking != false || this.mAnimating != false || super.onTouchEvent(var1_1) != false;
            }
            case 2: {
                if (!this.mVertical) ** GOTO lbl14
                var10_2 = var1_1.getY();
lbl11:
                // 2 sources

                while (true) {
                    this.moveHandle((int)var10_2 - this.mTouchDelta);
                    ** GOTO lbl-1000
                    break;
                }
lbl14:
                // 1 sources

                var10_2 = var1_1.getX();
                ** continue;
            }
            case 1: 
            case 3: {
                var2_3 = this.mVelocityTracker;
                var2_3.computeCurrentVelocity(this.mVelocityUnits);
                var3_4 = var2_3.getYVelocity();
                var4_5 = var2_3.getXVelocity();
                var5_6 = this.mVertical;
                if (!var5_6) ** GOTO lbl49
                if (!(var3_4 < 0.0f)) ** GOTO lbl47
                var6_7 = true;
lbl25:
                // 2 sources

                while (true) {
                    if (var4_5 < 0.0f) {
                        var4_5 = -var4_5;
                    }
                    if (var4_5 > (float)this.mMaximumMinorVelocity) {
                        var4_5 = this.mMaximumMinorVelocity;
                    }
lbl30:
                    // 5 sources

                    while (true) {
                        var7_8 = (float)Math.hypot(var4_5, var3_4);
                        if (var6_7) {
                            var7_8 = -var7_8;
                        }
                        var8_9 = this.mHandle.getTop();
                        var9_10 = this.mHandle.getLeft();
                        if (!(Math.abs(var7_8) < (float)this.mMaximumTapVelocity)) ** GOTO lbl80
                        if (!var5_6) ** GOTO lbl59
                        if ((!this.mExpanded || var8_9 >= this.mTapThreshold + this.mTopOffset) && (this.mExpanded || var8_9 <= this.mBottomOffset + this.mBottom - this.mTop - this.mHandleHeight - this.mTapThreshold)) ** GOTO lbl60
lbl39:
                        // 2 sources

                        while (this.mAllowSingleTap) {
                            this.playSoundEffect(0);
                            if (!this.mExpanded) ** GOTO lbl66
                            if (!var5_6) ** GOTO lbl64
lbl43:
                            // 2 sources

                            while (true) {
                                this.animateClose(var8_9);
                                ** GOTO lbl-1000
                                break;
                            }
                        }
                        ** GOTO lbl72
                        break;
                    }
                    break;
                }
lbl47:
                // 1 sources

                var6_7 = false;
                ** continue;
lbl49:
                // 1 sources

                if (!(var4_5 < 0.0f)) ** GOTO lbl57
                var6_7 = true;
lbl51:
                // 2 sources

                while (true) {
                    if (var3_4 < 0.0f) {
                        var3_4 = -var3_4;
                    }
                    if (!(var3_4 > (float)this.mMaximumMinorVelocity)) ** GOTO lbl30
                    var3_4 = this.mMaximumMinorVelocity;
                    ** continue;
                    break;
                }
lbl57:
                // 1 sources

                var6_7 = false;
                ** continue;
lbl59:
                // 1 sources

                if (this.mExpanded && var9_10 < this.mTapThreshold + this.mTopOffset || !this.mExpanded && var9_10 > this.mBottomOffset + this.mRight - this.mLeft - this.mHandleWidth - this.mTapThreshold) ** GOTO lbl39
lbl60:
                // 2 sources

                if (!var5_6) ** GOTO lbl78
lbl61:
                // 2 sources

                while (true) {
                    this.performFling(var8_9, var7_8, false);
                    ** GOTO lbl-1000
                    break;
                }
lbl64:
                // 1 sources

                var8_9 = var9_10;
                ** continue;
lbl66:
                // 1 sources

                if (!var5_6) ** GOTO lbl70
lbl67:
                // 2 sources

                while (true) {
                    this.animateOpen(var8_9);
                    ** GOTO lbl-1000
                    break;
                }
lbl70:
                // 1 sources

                var8_9 = var9_10;
                ** continue;
lbl72:
                // 1 sources

                if (!var5_6) ** GOTO lbl76
lbl73:
                // 2 sources

                while (true) {
                    this.performFling(var8_9, var7_8, false);
                    ** GOTO lbl-1000
                    break;
                }
lbl76:
                // 1 sources

                var8_9 = var9_10;
                ** continue;
lbl78:
                // 1 sources

                var8_9 = var9_10;
                ** continue;
lbl80:
                // 1 sources

                if (!var5_6) ** GOTO lbl84
lbl81:
                // 2 sources

                while (true) {
                    this.performFling(var8_9, var7_8, false);
                    ** GOTO lbl-1000
                    break;
                }
lbl84:
                // 1 sources

                var8_9 = var9_10;
                ** continue;
            }
        }
    }

    public void open() {
        this.openDrawer();
        this.invalidate();
        this.requestLayout();
        this.sendAccessibilityEvent(32);
    }

    public void setOnDrawerCloseListener(OnDrawerCloseListener onDrawerCloseListener) {
        this.mOnDrawerCloseListener = onDrawerCloseListener;
    }

    public void setOnDrawerOpenListener(OnDrawerOpenListener onDrawerOpenListener) {
        this.mOnDrawerOpenListener = onDrawerOpenListener;
    }

    public void setOnDrawerScrollListener(OnDrawerScrollListener onDrawerScrollListener) {
        this.mOnDrawerScrollListener = onDrawerScrollListener;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void toggle() {
        if (!this.mExpanded) {
            this.openDrawer();
        } else {
            this.closeDrawer();
        }
        this.invalidate();
        this.requestLayout();
    }

    public void unlock() {
        this.mLocked = false;
    }

    private class DrawerToggler
    implements View.OnClickListener {
        private DrawerToggler() {
        }

        @Override
        public void onClick(View view) {
            if (SlidingDrawer.this.mLocked) {
                return;
            }
            if (SlidingDrawer.this.mAnimateOnClick) {
                SlidingDrawer.this.animateToggle();
                return;
            }
            SlidingDrawer.this.toggle();
        }
    }

    public static interface OnDrawerCloseListener {
        public void onDrawerClosed();
    }

    public static interface OnDrawerOpenListener {
        public void onDrawerOpened();
    }

    public static interface OnDrawerScrollListener {
        public void onScrollEnded();

        public void onScrollStarted();
    }

    private class SlidingHandler
    extends Handler {
        private SlidingHandler() {
        }

        @Override
        public void handleMessage(Message message) {
            switch (message.what) {
                default: {
                    return;
                }
                case 1000: 
            }
            SlidingDrawer.this.doAnimation();
        }
    }
}

