/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.res.TypedArray;
import android.database.DataSetObserver;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.util.Log;
import android.view.Gravity;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityNodeInfo;
import android.widget.AbsSpinner;
import android.widget.AdapterView;
import android.widget.ListAdapter;
import android.widget.ListPopupWindow;
import android.widget.ListView;
import android.widget.PopupWindow;
import android.widget.SpinnerAdapter;
import com.android.internal.R;

public class Spinner
extends AbsSpinner
implements DialogInterface.OnClickListener {
    private static final int MAX_ITEMS_MEASURED = 15;
    public static final int MODE_DIALOG = 0;
    public static final int MODE_DROPDOWN = 1;
    private static final int MODE_THEME = -1;
    private static final String TAG = "Spinner";
    private boolean mDisableChildrenWhenDisabled;
    int mDropDownWidth;
    private ListPopupWindow.ForwardingListener mForwardingListener;
    private int mGravity;
    private SpinnerPopup mPopup;
    private DropDownAdapter mTempAdapter;
    private Rect mTempRect = new Rect();

    public Spinner(Context context) {
        this(context, null);
    }

    public Spinner(Context context, int n) {
        this(context, null, 0x1010081, n);
    }

    public Spinner(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0x1010081);
    }

    public Spinner(Context context, AttributeSet attributeSet, int n) {
        this(context, attributeSet, n, 0, -1);
    }

    public Spinner(Context context, AttributeSet attributeSet, int n, int n2) {
        this(context, attributeSet, n, 0, n2);
    }

    /*
     * Enabled aggressive block sorting
     */
    public Spinner(Context context, AttributeSet attributeSet, int n, int n2, int n3) {
        super(context, attributeSet, n, n2);
        TypedArray typedArray = context.obtainStyledAttributes(attributeSet, R.styleable.Spinner, n, n2);
        if (n3 == -1) {
            n3 = typedArray.getInt(5, 0);
        }
        switch (n3) {
            case 0: {
                this.mPopup = new DialogPopup();
            }
            default: {
                break;
            }
            case 1: {
                final DropdownPopup dropdownPopup = new DropdownPopup(context, attributeSet, n, n2);
                this.mDropDownWidth = typedArray.getLayoutDimension(4, -2);
                dropdownPopup.setBackgroundDrawable(typedArray.getDrawable(2));
                this.mPopup = dropdownPopup;
                this.mForwardingListener = new ListPopupWindow.ForwardingListener(this){

                    @Override
                    public ListPopupWindow getPopup() {
                        return dropdownPopup;
                    }

                    @Override
                    public boolean onForwardingStarted() {
                        if (!Spinner.this.mPopup.isShowing()) {
                            Spinner.this.mPopup.show(Spinner.this.getTextDirection(), Spinner.this.getTextAlignment());
                        }
                        return true;
                    }
                };
            }
        }
        this.mGravity = typedArray.getInt(0, 17);
        this.mPopup.setPromptText(typedArray.getString(3));
        this.mDisableChildrenWhenDisabled = typedArray.getBoolean(8, false);
        typedArray.recycle();
        if (this.mTempAdapter != null) {
            this.mPopup.setAdapter(this.mTempAdapter);
            this.mTempAdapter = null;
        }
    }

    private View makeView(int n, boolean bl) {
        View view;
        if (!this.mDataChanged && (view = this.mRecycler.get(n)) != null) {
            this.setUpChild(view, bl);
            return view;
        }
        View view2 = this.mAdapter.getView(n, null, this);
        this.setUpChild(view2, bl);
        return view2;
    }

    private void setUpChild(View view, boolean bl) {
        ViewGroup.LayoutParams layoutParams = view.getLayoutParams();
        if (layoutParams == null) {
            layoutParams = this.generateDefaultLayoutParams();
        }
        if (bl) {
            this.addViewInLayout(view, 0, layoutParams);
        }
        view.setSelected(this.hasFocus());
        if (this.mDisableChildrenWhenDisabled) {
            view.setEnabled(this.isEnabled());
        }
        int n = ViewGroup.getChildMeasureSpec(this.mHeightMeasureSpec, this.mSpinnerPadding.top + this.mSpinnerPadding.bottom, layoutParams.height);
        view.measure(ViewGroup.getChildMeasureSpec(this.mWidthMeasureSpec, this.mSpinnerPadding.left + this.mSpinnerPadding.right, layoutParams.width), n);
        int n2 = this.mSpinnerPadding.top + (this.getMeasuredHeight() - this.mSpinnerPadding.bottom - this.mSpinnerPadding.top - view.getMeasuredHeight()) / 2;
        int n3 = n2 + view.getMeasuredHeight();
        view.layout(0, n2, 0 + view.getMeasuredWidth(), n3);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public int getBaseline() {
        View view;
        int n = -1;
        if (this.getChildCount() > 0) {
            view = this.getChildAt(0);
        } else {
            SpinnerAdapter spinnerAdapter = this.mAdapter;
            view = null;
            if (spinnerAdapter != null) {
                int n2 = this.mAdapter.getCount();
                view = null;
                if (n2 > 0) {
                    view = this.makeView(0, false);
                    this.mRecycler.put(0, view);
                }
            }
        }
        if (view == null) return n;
        int n3 = view.getBaseline();
        if (n3 < 0) return n;
        return n3 + view.getTop();
    }

    public int getDropDownHorizontalOffset() {
        return this.mPopup.getHorizontalOffset();
    }

    public int getDropDownVerticalOffset() {
        return this.mPopup.getVerticalOffset();
    }

    public int getDropDownWidth() {
        return this.mDropDownWidth;
    }

    public int getGravity() {
        return this.mGravity;
    }

    public Drawable getPopupBackground() {
        return this.mPopup.getBackground();
    }

    public CharSequence getPrompt() {
        return this.mPopup.getHintText();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    void layout(int n, boolean bl) {
        int n2 = this.mSpinnerPadding.left;
        int n3 = this.mRight - this.mLeft - this.mSpinnerPadding.left - this.mSpinnerPadding.right;
        if (this.mDataChanged) {
            this.handleDataChanged();
        }
        if (this.mItemCount == 0) {
            this.resetList();
            return;
        }
        if (this.mNextSelectedPosition >= 0) {
            this.setSelectedPositionInt(this.mNextSelectedPosition);
        }
        this.recycleAllViews();
        this.removeAllViewsInLayout();
        this.mFirstPosition = this.mSelectedPosition;
        if (this.mAdapter != null) {
            View view = this.makeView(this.mSelectedPosition, true);
            int n4 = view.getMeasuredWidth();
            int n5 = n2;
            int n6 = this.getLayoutDirection();
            switch (7 & Gravity.getAbsoluteGravity(this.mGravity, n6)) {
                case 1: {
                    n5 = n2 + n3 / 2 - n4 / 2;
                }
                default: {
                    break;
                }
                case 5: {
                    n5 = n2 + n3 - n4;
                }
            }
            view.offsetLeftAndRight(n5);
        }
        this.mRecycler.clear();
        this.invalidate();
        this.checkSelectionChanged();
        this.mDataChanged = false;
        this.mNeedSync = false;
        this.setNextSelectedPositionInt(this.mSelectedPosition);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    int measureContentWidth(SpinnerAdapter spinnerAdapter, Drawable drawable2) {
        if (spinnerAdapter == null) {
            return 0;
        }
        int n = 0;
        View view = null;
        int n2 = 0;
        int n3 = View.MeasureSpec.makeMeasureSpec(0, 0);
        int n4 = View.MeasureSpec.makeMeasureSpec(0, 0);
        int n5 = Math.max(0, this.getSelectedItemPosition());
        int n6 = Math.min(spinnerAdapter.getCount(), n5 + 15);
        for (int i = Math.max(0, n5 - (15 - (n6 - n5))); i < n6; ++i) {
            int n7 = spinnerAdapter.getItemViewType(i);
            if (n7 != n2) {
                n2 = n7;
                view = null;
            }
            if ((view = spinnerAdapter.getView(i, view, this)).getLayoutParams() == null) {
                view.setLayoutParams(new ViewGroup.LayoutParams(-2, -2));
            }
            view.measure(n3, n4);
            n = Math.max(n, view.getMeasuredWidth());
        }
        if (drawable2 == null) return n;
        drawable2.getPadding(this.mTempRect);
        return n + (this.mTempRect.left + this.mTempRect.right);
    }

    @Override
    public void onClick(DialogInterface dialogInterface, int n) {
        this.setSelection(n);
        dialogInterface.dismiss();
    }

    @Override
    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.mPopup != null && this.mPopup.isShowing()) {
            this.mPopup.dismiss();
        }
    }

    @Override
    public void onInitializeAccessibilityEvent(AccessibilityEvent accessibilityEvent) {
        super.onInitializeAccessibilityEvent(accessibilityEvent);
        accessibilityEvent.setClassName(Spinner.class.getName());
    }

    @Override
    public void onInitializeAccessibilityNodeInfo(AccessibilityNodeInfo accessibilityNodeInfo) {
        super.onInitializeAccessibilityNodeInfo(accessibilityNodeInfo);
        accessibilityNodeInfo.setClassName(Spinner.class.getName());
        if (this.mAdapter != null) {
            accessibilityNodeInfo.setCanOpenPopup(true);
        }
    }

    @Override
    protected void onLayout(boolean bl, int n, int n2, int n3, int n4) {
        super.onLayout(bl, n, n2, n3, n4);
        this.mInLayout = true;
        this.layout(0, false);
        this.mInLayout = false;
    }

    @Override
    protected void onMeasure(int n, int n2) {
        super.onMeasure(n, n2);
        if (this.mPopup != null && View.MeasureSpec.getMode(n) == Integer.MIN_VALUE) {
            this.setMeasuredDimension(Math.min(Math.max(this.getMeasuredWidth(), this.measureContentWidth((SpinnerAdapter)this.getAdapter(), this.getBackground())), View.MeasureSpec.getSize(n)), this.getMeasuredHeight());
        }
    }

    @Override
    public void onRestoreInstanceState(Parcelable parcelable) {
        ViewTreeObserver viewTreeObserver;
        SavedState savedState = (SavedState)parcelable;
        super.onRestoreInstanceState(savedState.getSuperState());
        if (savedState.showDropdown && (viewTreeObserver = this.getViewTreeObserver()) != null) {
            viewTreeObserver.addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

                @Override
                public void onGlobalLayout() {
                    ViewTreeObserver viewTreeObserver;
                    if (!Spinner.this.mPopup.isShowing()) {
                        Spinner.this.mPopup.show(Spinner.this.getTextDirection(), Spinner.this.getTextAlignment());
                    }
                    if ((viewTreeObserver = Spinner.this.getViewTreeObserver()) != null) {
                        viewTreeObserver.removeOnGlobalLayoutListener(this);
                    }
                }
            });
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public Parcelable onSaveInstanceState() {
        SavedState savedState = new SavedState(super.onSaveInstanceState());
        boolean bl = this.mPopup != null && this.mPopup.isShowing();
        savedState.showDropdown = bl;
        return savedState;
    }

    @Override
    public boolean onTouchEvent(MotionEvent motionEvent) {
        if (this.mForwardingListener != null && this.mForwardingListener.onTouch(this, motionEvent)) {
            return true;
        }
        return super.onTouchEvent(motionEvent);
    }

    @Override
    public boolean performClick() {
        boolean bl = super.performClick();
        if (!bl) {
            bl = true;
            if (!this.mPopup.isShowing()) {
                this.mPopup.show(this.getTextDirection(), this.getTextAlignment());
            }
        }
        return bl;
    }

    @Override
    public void setAdapter(SpinnerAdapter spinnerAdapter) {
        super.setAdapter(spinnerAdapter);
        this.mRecycler.clear();
        if (this.mContext.getApplicationInfo().targetSdkVersion >= 21 && spinnerAdapter != null && spinnerAdapter.getViewTypeCount() != 1) {
            throw new IllegalArgumentException("Spinner adapter view type count must be 1");
        }
        if (this.mPopup != null) {
            this.mPopup.setAdapter(new DropDownAdapter(spinnerAdapter));
            return;
        }
        this.mTempAdapter = new DropDownAdapter(spinnerAdapter);
    }

    public void setDropDownHorizontalOffset(int n) {
        this.mPopup.setHorizontalOffset(n);
    }

    public void setDropDownVerticalOffset(int n) {
        this.mPopup.setVerticalOffset(n);
    }

    public void setDropDownWidth(int n) {
        if (!(this.mPopup instanceof DropdownPopup)) {
            Log.e(TAG, "Cannot set dropdown width for MODE_DIALOG, ignoring");
            return;
        }
        this.mDropDownWidth = n;
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        if (this.mDisableChildrenWhenDisabled) {
            int n = this.getChildCount();
            for (int i = 0; i < n; ++i) {
                this.getChildAt(i).setEnabled(bl);
            }
        }
    }

    public void setGravity(int n) {
        if (this.mGravity != n) {
            if ((n & 7) == 0) {
                n |= 0x800003;
            }
            this.mGravity = n;
            this.requestLayout();
        }
    }

    @Override
    public void setOnItemClickListener(AdapterView.OnItemClickListener onItemClickListener) {
        throw new RuntimeException("setOnItemClickListener cannot be used with a spinner.");
    }

    public void setOnItemClickListenerInt(AdapterView.OnItemClickListener onItemClickListener) {
        super.setOnItemClickListener(onItemClickListener);
    }

    public void setPopupBackgroundDrawable(Drawable drawable2) {
        if (!(this.mPopup instanceof DropdownPopup)) {
            Log.e(TAG, "setPopupBackgroundDrawable: incompatible spinner mode; ignoring...");
            return;
        }
        ((DropdownPopup)this.mPopup).setBackgroundDrawable(drawable2);
    }

    public void setPopupBackgroundResource(int n) {
        this.setPopupBackgroundDrawable(this.getContext().getDrawable(n));
    }

    public void setPrompt(CharSequence charSequence) {
        this.mPopup.setPromptText(charSequence);
    }

    public void setPromptId(int n) {
        this.setPrompt(this.getContext().getText(n));
    }

    private class DialogPopup
    implements SpinnerPopup,
    DialogInterface.OnClickListener {
        private ListAdapter mListAdapter;
        private AlertDialog mPopup;
        private CharSequence mPrompt;

        private DialogPopup() {
        }

        @Override
        public void dismiss() {
            if (this.mPopup != null) {
                this.mPopup.dismiss();
                this.mPopup = null;
            }
        }

        @Override
        public Drawable getBackground() {
            return null;
        }

        @Override
        public CharSequence getHintText() {
            return this.mPrompt;
        }

        @Override
        public int getHorizontalOffset() {
            return 0;
        }

        @Override
        public int getVerticalOffset() {
            return 0;
        }

        @Override
        public boolean isShowing() {
            if (this.mPopup != null) {
                return this.mPopup.isShowing();
            }
            return false;
        }

        @Override
        public void onClick(DialogInterface dialogInterface, int n) {
            Spinner.this.setSelection(n);
            if (Spinner.this.mOnItemClickListener != null) {
                Spinner.this.performItemClick(null, n, this.mListAdapter.getItemId(n));
            }
            this.dismiss();
        }

        @Override
        public void setAdapter(ListAdapter listAdapter) {
            this.mListAdapter = listAdapter;
        }

        @Override
        public void setBackgroundDrawable(Drawable drawable2) {
            Log.e(Spinner.TAG, "Cannot set popup background for MODE_DIALOG, ignoring");
        }

        @Override
        public void setHorizontalOffset(int n) {
            Log.e(Spinner.TAG, "Cannot set horizontal offset for MODE_DIALOG, ignoring");
        }

        @Override
        public void setPromptText(CharSequence charSequence) {
            this.mPrompt = charSequence;
        }

        @Override
        public void setVerticalOffset(int n) {
            Log.e(Spinner.TAG, "Cannot set vertical offset for MODE_DIALOG, ignoring");
        }

        @Override
        public void show(int n, int n2) {
            if (this.mListAdapter == null) {
                return;
            }
            AlertDialog.Builder builder = new AlertDialog.Builder(Spinner.this.getContext());
            if (this.mPrompt != null) {
                builder.setTitle(this.mPrompt);
            }
            this.mPopup = builder.setSingleChoiceItems(this.mListAdapter, Spinner.this.getSelectedItemPosition(), (DialogInterface.OnClickListener)this).create();
            ListView listView = this.mPopup.getListView();
            listView.setTextDirection(n);
            listView.setTextAlignment(n2);
            this.mPopup.show();
        }
    }

    private static class DropDownAdapter
    implements ListAdapter,
    SpinnerAdapter {
        private SpinnerAdapter mAdapter;
        private ListAdapter mListAdapter;

        public DropDownAdapter(SpinnerAdapter spinnerAdapter) {
            this.mAdapter = spinnerAdapter;
            if (spinnerAdapter instanceof ListAdapter) {
                this.mListAdapter = (ListAdapter)((Object)spinnerAdapter);
            }
        }

        @Override
        public boolean areAllItemsEnabled() {
            ListAdapter listAdapter = this.mListAdapter;
            if (listAdapter != null) {
                return listAdapter.areAllItemsEnabled();
            }
            return true;
        }

        @Override
        public int getCount() {
            if (this.mAdapter == null) {
                return 0;
            }
            return this.mAdapter.getCount();
        }

        @Override
        public View getDropDownView(int n, View view, ViewGroup viewGroup) {
            if (this.mAdapter == null) {
                return null;
            }
            return this.mAdapter.getDropDownView(n, view, viewGroup);
        }

        @Override
        public Object getItem(int n) {
            if (this.mAdapter == null) {
                return null;
            }
            return this.mAdapter.getItem(n);
        }

        @Override
        public long getItemId(int n) {
            if (this.mAdapter == null) {
                return -1L;
            }
            return this.mAdapter.getItemId(n);
        }

        @Override
        public int getItemViewType(int n) {
            return 0;
        }

        @Override
        public View getView(int n, View view, ViewGroup viewGroup) {
            return this.getDropDownView(n, view, viewGroup);
        }

        @Override
        public int getViewTypeCount() {
            return 1;
        }

        @Override
        public boolean hasStableIds() {
            return this.mAdapter != null && this.mAdapter.hasStableIds();
        }

        @Override
        public boolean isEmpty() {
            return this.getCount() == 0;
        }

        @Override
        public boolean isEnabled(int n) {
            ListAdapter listAdapter = this.mListAdapter;
            if (listAdapter != null) {
                return listAdapter.isEnabled(n);
            }
            return true;
        }

        @Override
        public void registerDataSetObserver(DataSetObserver dataSetObserver) {
            if (this.mAdapter != null) {
                this.mAdapter.registerDataSetObserver(dataSetObserver);
            }
        }

        @Override
        public void unregisterDataSetObserver(DataSetObserver dataSetObserver) {
            if (this.mAdapter != null) {
                this.mAdapter.unregisterDataSetObserver(dataSetObserver);
            }
        }
    }

    private class DropdownPopup
    extends ListPopupWindow
    implements SpinnerPopup {
        private ListAdapter mAdapter;
        private CharSequence mHintText;

        public DropdownPopup(Context context, AttributeSet attributeSet, int n, int n2) {
            super(context, attributeSet, n, n2);
            this.setAnchorView(Spinner.this);
            this.setModal(true);
            this.setPromptPosition(0);
            this.setOnItemClickListener(new AdapterView.OnItemClickListener(){

                public void onItemClick(AdapterView adapterView, View view, int n, long l) {
                    Spinner.this.setSelection(n);
                    if (Spinner.this.mOnItemClickListener != null) {
                        Spinner.this.performItemClick(view, n, DropdownPopup.this.mAdapter.getItemId(n));
                    }
                    DropdownPopup.this.dismiss();
                }
            });
        }

        /*
         * Enabled aggressive block sorting
         */
        void computeContentWidth() {
            int n;
            Drawable drawable2 = this.getBackground();
            if (drawable2 != null) {
                drawable2.getPadding(Spinner.this.mTempRect);
                n = Spinner.this.isLayoutRtl() ? ((Spinner)Spinner.this).mTempRect.right : -((Spinner)Spinner.this).mTempRect.left;
            } else {
                Rect rect = Spinner.this.mTempRect;
                ((Spinner)Spinner.this).mTempRect.right = 0;
                rect.left = 0;
                n = 0;
            }
            int n2 = Spinner.this.getPaddingLeft();
            int n3 = Spinner.this.getPaddingRight();
            int n4 = Spinner.this.getWidth();
            if (Spinner.this.mDropDownWidth == -2) {
                int n5;
                int n6 = Spinner.this.measureContentWidth((SpinnerAdapter)((Object)this.mAdapter), this.getBackground());
                if (n6 > (n5 = ((Spinner)Spinner.this).mContext.getResources().getDisplayMetrics().widthPixels - ((Spinner)Spinner.this).mTempRect.left - ((Spinner)Spinner.this).mTempRect.right)) {
                    n6 = n5;
                }
                this.setContentWidth(Math.max(n6, n4 - n2 - n3));
            } else if (Spinner.this.mDropDownWidth == -1) {
                this.setContentWidth(n4 - n2 - n3);
            } else {
                this.setContentWidth(Spinner.this.mDropDownWidth);
            }
            int n7 = Spinner.this.isLayoutRtl() ? n + (n4 - n3 - this.getWidth()) : n + n2;
            this.setHorizontalOffset(n7);
        }

        @Override
        public CharSequence getHintText() {
            return this.mHintText;
        }

        @Override
        public void setAdapter(ListAdapter listAdapter) {
            super.setAdapter(listAdapter);
            this.mAdapter = listAdapter;
        }

        @Override
        public void setPromptText(CharSequence charSequence) {
            this.mHintText = charSequence;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void show(int n, int n2) {
            ViewTreeObserver viewTreeObserver;
            boolean bl = this.isShowing();
            this.computeContentWidth();
            this.setInputMethodMode(2);
            super.show();
            ListView listView = this.getListView();
            listView.setChoiceMode(1);
            listView.setTextDirection(n);
            listView.setTextAlignment(n2);
            this.setSelection(Spinner.this.getSelectedItemPosition());
            if (bl || (viewTreeObserver = Spinner.this.getViewTreeObserver()) == null) {
                return;
            }
            final ViewTreeObserver.OnGlobalLayoutListener onGlobalLayoutListener = new ViewTreeObserver.OnGlobalLayoutListener(){

                @Override
                public void onGlobalLayout() {
                    if (!Spinner.this.isVisibleToUser()) {
                        DropdownPopup.this.dismiss();
                        return;
                    }
                    DropdownPopup.this.computeContentWidth();
                    DropdownPopup.super.show();
                }
            };
            viewTreeObserver.addOnGlobalLayoutListener(onGlobalLayoutListener);
            this.setOnDismissListener(new PopupWindow.OnDismissListener(){

                @Override
                public void onDismiss() {
                    ViewTreeObserver viewTreeObserver = Spinner.this.getViewTreeObserver();
                    if (viewTreeObserver != null) {
                        viewTreeObserver.removeOnGlobalLayoutListener(onGlobalLayoutListener);
                    }
                }
            });
        }
    }

    static class SavedState
    extends AbsSpinner.SavedState {
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            @Override
            public SavedState createFromParcel(Parcel parcel) {
                return new SavedState(parcel);
            }

            public SavedState[] newArray(int n) {
                return new SavedState[n];
            }
        };
        boolean showDropdown;

        /*
         * Enabled aggressive block sorting
         */
        private SavedState(Parcel parcel) {
            super(parcel);
            boolean bl = parcel.readByte() != 0;
            this.showDropdown = bl;
        }

        SavedState(Parcelable parcelable) {
            super(parcelable);
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void writeToParcel(Parcel parcel, int n) {
            super.writeToParcel(parcel, n);
            boolean bl = this.showDropdown;
            parcel.writeByte((byte)(bl ? 1 : 0));
        }
    }

    private static interface SpinnerPopup {
        public void dismiss();

        public Drawable getBackground();

        public CharSequence getHintText();

        public int getHorizontalOffset();

        public int getVerticalOffset();

        public boolean isShowing();

        public void setAdapter(ListAdapter var1);

        public void setBackgroundDrawable(Drawable var1);

        public void setHorizontalOffset(int var1);

        public void setPromptText(CharSequence var1);

        public void setVerticalOffset(int var1);

        public void show(int var1, int var2);
    }
}

