/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.app.INotificationManager;
import android.app.ITransientNotification;
import android.content.Context;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.os.Handler;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.view.Gravity;
import android.view.LayoutInflater;
import android.view.View;
import android.view.WindowManager;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityManager;
import android.widget.TextView;

public class Toast {
    public static final int LENGTH_LONG = 1;
    public static final int LENGTH_SHORT = 0;
    static final String TAG = "Toast";
    static final boolean localLOGV;
    private static INotificationManager sService;
    final Context mContext;
    int mDuration;
    View mNextView;
    final TN mTN;

    public Toast(Context context) {
        this.mContext = context;
        this.mTN = new TN();
        this.mTN.mY = context.getResources().getDimensionPixelSize(17104911);
        this.mTN.mGravity = context.getResources().getInteger(17694835);
    }

    private static INotificationManager getService() {
        if (sService != null) {
            return sService;
        }
        sService = INotificationManager.Stub.asInterface(ServiceManager.getService("notification"));
        return sService;
    }

    public static Toast makeText(Context context, int n, int n2) throws Resources.NotFoundException {
        return Toast.makeText(context, context.getResources().getText(n), n2);
    }

    public static Toast makeText(Context context, CharSequence charSequence, int n) {
        Toast toast = new Toast(context);
        View view = ((LayoutInflater)context.getSystemService("layout_inflater")).inflate(17367294, null);
        ((TextView)view.findViewById(16908299)).setText(charSequence);
        toast.mNextView = view;
        toast.mDuration = n;
        return toast;
    }

    public void cancel() {
        this.mTN.hide();
        try {
            Toast.getService().cancelToast(this.mContext.getPackageName(), this.mTN);
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    public int getDuration() {
        return this.mDuration;
    }

    public int getGravity() {
        return this.mTN.mGravity;
    }

    public float getHorizontalMargin() {
        return this.mTN.mHorizontalMargin;
    }

    public float getVerticalMargin() {
        return this.mTN.mVerticalMargin;
    }

    public View getView() {
        return this.mNextView;
    }

    public int getXOffset() {
        return this.mTN.mX;
    }

    public int getYOffset() {
        return this.mTN.mY;
    }

    public void setDuration(int n) {
        this.mDuration = n;
    }

    public void setGravity(int n, int n2, int n3) {
        this.mTN.mGravity = n;
        this.mTN.mX = n2;
        this.mTN.mY = n3;
    }

    public void setMargin(float f, float f2) {
        this.mTN.mHorizontalMargin = f;
        this.mTN.mVerticalMargin = f2;
    }

    public void setText(int n) {
        this.setText(this.mContext.getText(n));
    }

    public void setText(CharSequence charSequence) {
        if (this.mNextView == null) {
            throw new RuntimeException("This Toast was not created with Toast.makeText()");
        }
        TextView textView = (TextView)this.mNextView.findViewById(16908299);
        if (textView == null) {
            throw new RuntimeException("This Toast was not created with Toast.makeText()");
        }
        textView.setText(charSequence);
    }

    public void setView(View view) {
        this.mNextView = view;
    }

    public void show() {
        if (this.mNextView == null) {
            throw new RuntimeException("setView must have been called");
        }
        INotificationManager iNotificationManager = Toast.getService();
        String string2 = this.mContext.getOpPackageName();
        TN tN = this.mTN;
        tN.mNextView = this.mNextView;
        try {
            iNotificationManager.enqueueToast(string2, tN, this.mDuration);
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    private static class TN
    extends ITransientNotification.Stub {
        int mGravity;
        final Handler mHandler;
        final Runnable mHide;
        float mHorizontalMargin;
        View mNextView;
        private final WindowManager.LayoutParams mParams;
        final Runnable mShow = new Runnable(){

            @Override
            public void run() {
                TN.this.handleShow();
            }
        };
        float mVerticalMargin;
        View mView;
        WindowManager mWM;
        int mX;
        int mY;

        TN() {
            this.mHide = new Runnable(){

                @Override
                public void run() {
                    TN.this.handleHide();
                    TN.this.mNextView = null;
                }
            };
            this.mParams = new WindowManager.LayoutParams();
            this.mHandler = new Handler();
            WindowManager.LayoutParams layoutParams = this.mParams;
            layoutParams.height = -2;
            layoutParams.width = -2;
            layoutParams.format = -3;
            layoutParams.windowAnimations = 16973828;
            layoutParams.type = 2005;
            layoutParams.setTitle(Toast.TAG);
            layoutParams.flags = 152;
        }

        private void trySendAccessibilityEvent() {
            AccessibilityManager accessibilityManager = AccessibilityManager.getInstance(this.mView.getContext());
            if (!accessibilityManager.isEnabled()) {
                return;
            }
            AccessibilityEvent accessibilityEvent = AccessibilityEvent.obtain(64);
            accessibilityEvent.setClassName(this.getClass().getName());
            accessibilityEvent.setPackageName(this.mView.getContext().getPackageName());
            this.mView.dispatchPopulateAccessibilityEvent(accessibilityEvent);
            accessibilityManager.sendAccessibilityEvent(accessibilityEvent);
        }

        public void handleHide() {
            if (this.mView != null) {
                if (this.mView.getParent() != null) {
                    this.mWM.removeView(this.mView);
                }
                this.mView = null;
            }
        }

        public void handleShow() {
            if (this.mView != this.mNextView) {
                int n;
                this.handleHide();
                this.mView = this.mNextView;
                Context context = this.mView.getContext().getApplicationContext();
                String string2 = this.mView.getContext().getOpPackageName();
                if (context == null) {
                    context = this.mView.getContext();
                }
                this.mWM = (WindowManager)context.getSystemService("window");
                Configuration configuration = this.mView.getContext().getResources().getConfiguration();
                this.mParams.gravity = n = Gravity.getAbsoluteGravity(this.mGravity, configuration.getLayoutDirection());
                if ((n & 7) == 7) {
                    this.mParams.horizontalWeight = 1.0f;
                }
                if ((n & 0x70) == 112) {
                    this.mParams.verticalWeight = 1.0f;
                }
                this.mParams.x = this.mX;
                this.mParams.y = this.mY;
                this.mParams.verticalMargin = this.mVerticalMargin;
                this.mParams.horizontalMargin = this.mHorizontalMargin;
                this.mParams.packageName = string2;
                if (this.mView.getParent() != null) {
                    this.mWM.removeView(this.mView);
                }
                this.mWM.addView(this.mView, this.mParams);
                this.trySendAccessibilityEvent();
            }
        }

        @Override
        public void hide() {
            this.mHandler.post(this.mHide);
        }

        @Override
        public void show() {
            this.mHandler.post(this.mShow);
        }
    }
}

