/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.RemotableViewMethod;
import android.view.View;
import android.view.ViewGroup;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityNodeInfo;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.widget.FrameLayout;
import com.android.internal.R;

public class ViewAnimator
extends FrameLayout {
    boolean mAnimateFirstTime = true;
    boolean mFirstTime = true;
    Animation mInAnimation;
    Animation mOutAnimation;
    int mWhichChild = 0;

    public ViewAnimator(Context context) {
        super(context);
        this.initViewAnimator(context, null);
    }

    public ViewAnimator(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        int n;
        TypedArray typedArray = context.obtainStyledAttributes(attributeSet, R.styleable.ViewAnimator);
        int n2 = typedArray.getResourceId(0, 0);
        if (n2 > 0) {
            this.setInAnimation(context, n2);
        }
        if ((n = typedArray.getResourceId(1, 0)) > 0) {
            this.setOutAnimation(context, n);
        }
        this.setAnimateFirstView(typedArray.getBoolean(2, true));
        typedArray.recycle();
        this.initViewAnimator(context, attributeSet);
    }

    private void initViewAnimator(Context context, AttributeSet attributeSet) {
        if (attributeSet == null) {
            this.mMeasureAllChildren = true;
            return;
        }
        TypedArray typedArray = context.obtainStyledAttributes(attributeSet, R.styleable.FrameLayout);
        this.setMeasureAllChildren(typedArray.getBoolean(1, true));
        typedArray.recycle();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void addView(View view, int n, ViewGroup.LayoutParams layoutParams) {
        super.addView(view, n, layoutParams);
        if (this.getChildCount() == 1) {
            view.setVisibility(0);
        } else {
            view.setVisibility(8);
        }
        if (n >= 0 && this.mWhichChild >= n) {
            this.setDisplayedChild(1 + this.mWhichChild);
        }
    }

    public boolean getAnimateFirstView() {
        return this.mAnimateFirstTime;
    }

    @Override
    public int getBaseline() {
        if (this.getCurrentView() != null) {
            return this.getCurrentView().getBaseline();
        }
        return super.getBaseline();
    }

    public View getCurrentView() {
        return this.getChildAt(this.mWhichChild);
    }

    public int getDisplayedChild() {
        return this.mWhichChild;
    }

    public Animation getInAnimation() {
        return this.mInAnimation;
    }

    public Animation getOutAnimation() {
        return this.mOutAnimation;
    }

    @Override
    public void onInitializeAccessibilityEvent(AccessibilityEvent accessibilityEvent) {
        super.onInitializeAccessibilityEvent(accessibilityEvent);
        accessibilityEvent.setClassName(ViewAnimator.class.getName());
    }

    @Override
    public void onInitializeAccessibilityNodeInfo(AccessibilityNodeInfo accessibilityNodeInfo) {
        super.onInitializeAccessibilityNodeInfo(accessibilityNodeInfo);
        accessibilityNodeInfo.setClassName(ViewAnimator.class.getName());
    }

    @Override
    public void removeAllViews() {
        super.removeAllViews();
        this.mWhichChild = 0;
        this.mFirstTime = true;
    }

    @Override
    public void removeView(View view) {
        int n = this.indexOfChild(view);
        if (n >= 0) {
            this.removeViewAt(n);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void removeViewAt(int n) {
        super.removeViewAt(n);
        int n2 = this.getChildCount();
        if (n2 == 0) {
            this.mWhichChild = 0;
            this.mFirstTime = true;
            return;
        } else {
            if (this.mWhichChild >= n2) {
                this.setDisplayedChild(n2 - 1);
                return;
            }
            if (this.mWhichChild != n) return;
            this.setDisplayedChild(this.mWhichChild);
            return;
        }
    }

    @Override
    public void removeViewInLayout(View view) {
        this.removeView(view);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void removeViews(int n, int n2) {
        super.removeViews(n, n2);
        if (this.getChildCount() == 0) {
            this.mWhichChild = 0;
            this.mFirstTime = true;
            return;
        } else {
            if (this.mWhichChild < n || this.mWhichChild >= n + n2) return;
            this.setDisplayedChild(this.mWhichChild);
            return;
        }
    }

    @Override
    public void removeViewsInLayout(int n, int n2) {
        this.removeViews(n, n2);
    }

    public void setAnimateFirstView(boolean bl) {
        this.mAnimateFirstTime = bl;
    }

    /*
     * Enabled aggressive block sorting
     */
    @RemotableViewMethod
    public void setDisplayedChild(int n) {
        this.mWhichChild = n;
        if (n >= this.getChildCount()) {
            this.mWhichChild = 0;
        } else if (n < 0) {
            this.mWhichChild = -1 + this.getChildCount();
        }
        View view = this.getFocusedChild();
        boolean bl = false;
        if (view != null) {
            bl = true;
        }
        this.showOnly(this.mWhichChild);
        if (bl) {
            this.requestFocus(2);
        }
    }

    public void setInAnimation(Context context, int n) {
        this.setInAnimation(AnimationUtils.loadAnimation(context, n));
    }

    public void setInAnimation(Animation animation) {
        this.mInAnimation = animation;
    }

    public void setOutAnimation(Context context, int n) {
        this.setOutAnimation(AnimationUtils.loadAnimation(context, n));
    }

    public void setOutAnimation(Animation animation) {
        this.mOutAnimation = animation;
    }

    @RemotableViewMethod
    public void showNext() {
        this.setDisplayedChild(1 + this.mWhichChild);
    }

    /*
     * Enabled aggressive block sorting
     */
    void showOnly(int n) {
        boolean bl = !this.mFirstTime || this.mAnimateFirstTime;
        this.showOnly(n, bl);
    }

    /*
     * Enabled aggressive block sorting
     */
    void showOnly(int n, boolean bl) {
        int n2 = this.getChildCount();
        int n3 = 0;
        while (n3 < n2) {
            View view = this.getChildAt(n3);
            if (n3 == n) {
                if (bl && this.mInAnimation != null) {
                    view.startAnimation(this.mInAnimation);
                }
                view.setVisibility(0);
                this.mFirstTime = false;
            } else {
                if (bl && this.mOutAnimation != null && view.getVisibility() == 0) {
                    view.startAnimation(this.mOutAnimation);
                } else if (view.getAnimation() == this.mInAnimation) {
                    view.clearAnimation();
                }
                view.setVisibility(8);
            }
            ++n3;
        }
        return;
    }

    @RemotableViewMethod
    public void showPrevious() {
        this.setDisplayedChild(-1 + this.mWhichChild);
    }
}

