/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.res.TypedArray;
import android.os.Handler;
import android.os.Message;
import android.os.Process;
import android.util.AttributeSet;
import android.view.RemotableViewMethod;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityNodeInfo;
import android.widget.RemoteViews;
import android.widget.ViewAnimator;
import com.android.internal.R;

@RemoteViews.RemoteView
public class ViewFlipper
extends ViewAnimator {
    private static final int DEFAULT_INTERVAL = 3000;
    private static final boolean LOGD = false;
    private static final String TAG = "ViewFlipper";
    private final int FLIP_MSG;
    private boolean mAutoStart = false;
    private int mFlipInterval = 3000;
    private final Handler mHandler;
    private final BroadcastReceiver mReceiver = new BroadcastReceiver(){

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void onReceive(Context context, Intent intent) {
            String string2 = intent.getAction();
            if ("android.intent.action.SCREEN_OFF".equals(string2)) {
                ViewFlipper.access$002(ViewFlipper.this, false);
                ViewFlipper.this.updateRunning();
                return;
            } else {
                if (!"android.intent.action.USER_PRESENT".equals(string2)) return;
                ViewFlipper.access$002(ViewFlipper.this, true);
                ViewFlipper.this.updateRunning(false);
                return;
            }
        }
    };
    private boolean mRunning = false;
    private boolean mStarted = false;
    private boolean mUserPresent = true;
    private boolean mVisible = false;

    public ViewFlipper(Context context) {
        super(context);
        this.FLIP_MSG = 1;
        this.mHandler = new Handler(){

            @Override
            public void handleMessage(Message message) {
                if (message.what == 1 && ViewFlipper.this.mRunning) {
                    ViewFlipper.this.showNext();
                    this.sendMessageDelayed(this.obtainMessage(1), ViewFlipper.this.mFlipInterval);
                }
            }
        };
    }

    public ViewFlipper(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.FLIP_MSG = 1;
        this.mHandler = new /* invalid duplicate definition of identical inner class */;
        TypedArray typedArray = context.obtainStyledAttributes(attributeSet, R.styleable.ViewFlipper);
        this.mFlipInterval = typedArray.getInt(0, 3000);
        this.mAutoStart = typedArray.getBoolean(1, false);
        typedArray.recycle();
    }

    static /* synthetic */ boolean access$002(ViewFlipper viewFlipper, boolean bl) {
        viewFlipper.mUserPresent = bl;
        return bl;
    }

    private void updateRunning() {
        this.updateRunning(true);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void updateRunning(boolean bl) {
        boolean bl2 = this.mVisible && this.mStarted && this.mUserPresent;
        if (bl2 != this.mRunning) {
            if (bl2) {
                this.showOnly(this.mWhichChild, bl);
                Message message = this.mHandler.obtainMessage(1);
                this.mHandler.sendMessageDelayed(message, this.mFlipInterval);
            } else {
                this.mHandler.removeMessages(1);
            }
            this.mRunning = bl2;
        }
    }

    public boolean isAutoStart() {
        return this.mAutoStart;
    }

    public boolean isFlipping() {
        return this.mStarted;
    }

    @Override
    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction("android.intent.action.SCREEN_OFF");
        intentFilter.addAction("android.intent.action.USER_PRESENT");
        this.getContext().registerReceiverAsUser(this.mReceiver, Process.myUserHandle(), intentFilter, null, this.mHandler);
        if (this.mAutoStart) {
            this.startFlipping();
        }
    }

    @Override
    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.mVisible = false;
        this.getContext().unregisterReceiver(this.mReceiver);
        this.updateRunning();
    }

    @Override
    public void onInitializeAccessibilityEvent(AccessibilityEvent accessibilityEvent) {
        super.onInitializeAccessibilityEvent(accessibilityEvent);
        accessibilityEvent.setClassName(ViewFlipper.class.getName());
    }

    @Override
    public void onInitializeAccessibilityNodeInfo(AccessibilityNodeInfo accessibilityNodeInfo) {
        super.onInitializeAccessibilityNodeInfo(accessibilityNodeInfo);
        accessibilityNodeInfo.setClassName(ViewFlipper.class.getName());
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void onWindowVisibilityChanged(int n) {
        super.onWindowVisibilityChanged(n);
        boolean bl = n == 0;
        this.mVisible = bl;
        this.updateRunning(false);
    }

    public void setAutoStart(boolean bl) {
        this.mAutoStart = bl;
    }

    @RemotableViewMethod
    public void setFlipInterval(int n) {
        this.mFlipInterval = n;
    }

    public void startFlipping() {
        this.mStarted = true;
        this.updateRunning();
    }

    public void stopFlipping() {
        this.mStarted = false;
        this.updateRunning();
    }
}

