/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.app;

import android.content.pm.PackageInfoLite;
import android.content.res.ObbInfo;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import com.android.internal.os.IParcelFileDescriptorFactory;

public interface IMediaContainerService
extends IInterface {
    public long calculateDirectorySize(String var1) throws RemoteException;

    public long calculateInstalledSize(String var1, boolean var2, String var3) throws RemoteException;

    public void clearDirectory(String var1) throws RemoteException;

    public int copyObbsToPrimaryStorage(String var1) throws RemoteException;

    public int copyObbsToSecondaryStorage(String var1) throws RemoteException;

    public int copyPackage(String var1, IParcelFileDescriptorFactory var2) throws RemoteException;

    public String copyPackageToContainer(String var1, String var2, String var3, boolean var4, boolean var5, String var6) throws RemoteException;

    public int deleteObbsInPrimaryStorage(String var1) throws RemoteException;

    public int deleteObbsInSecondaryStorage(String var1) throws RemoteException;

    public long[] getFileSystemStats(String var1) throws RemoteException;

    public PackageInfoLite getMinimalPackageInfo(String var1, int var2, String var3) throws RemoteException;

    public ObbInfo getObbInfo(String var1) throws RemoteException;

    public boolean isExternalStorageAppObbDirectoryExists(String var1) throws RemoteException;

    public boolean isSecondaryExternalObbPackageDirectoryExists(String var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IMediaContainerService {
        private static final String DESCRIPTOR = "com.android.internal.app.IMediaContainerService";
        static final int TRANSACTION_calculateDirectorySize = 5;
        static final int TRANSACTION_calculateInstalledSize = 8;
        static final int TRANSACTION_clearDirectory = 7;
        static final int TRANSACTION_copyObbsToPrimaryStorage = 10;
        static final int TRANSACTION_copyObbsToSecondaryStorage = 9;
        static final int TRANSACTION_copyPackage = 2;
        static final int TRANSACTION_copyPackageToContainer = 1;
        static final int TRANSACTION_deleteObbsInPrimaryStorage = 11;
        static final int TRANSACTION_deleteObbsInSecondaryStorage = 12;
        static final int TRANSACTION_getFileSystemStats = 6;
        static final int TRANSACTION_getMinimalPackageInfo = 3;
        static final int TRANSACTION_getObbInfo = 4;
        static final int TRANSACTION_isExternalStorageAppObbDirectoryExists = 14;
        static final int TRANSACTION_isSecondaryExternalObbPackageDirectoryExists = 13;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static IMediaContainerService asInterface(IBinder iBinder) {
            if (iBinder == null) {
                return null;
            }
            IInterface iInterface = iBinder.queryLocalInterface(DESCRIPTOR);
            if (iInterface != null && iInterface instanceof IMediaContainerService) {
                return (IMediaContainerService)iInterface;
            }
            return new Proxy(iBinder);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public boolean onTransact(int n, Parcel parcel, Parcel parcel2, int n2) throws RemoteException {
            switch (n) {
                default: {
                    return super.onTransact(n, parcel, parcel2, n2);
                }
                case 1598968902: {
                    parcel2.writeString(DESCRIPTOR);
                    return true;
                }
                case 1: {
                    parcel.enforceInterface(DESCRIPTOR);
                    String string2 = parcel.readString();
                    String string3 = parcel.readString();
                    String string4 = parcel.readString();
                    boolean bl = parcel.readInt() != 0;
                    boolean bl2 = parcel.readInt() != 0;
                    String string5 = this.copyPackageToContainer(string2, string3, string4, bl, bl2, parcel.readString());
                    parcel2.writeNoException();
                    parcel2.writeString(string5);
                    return true;
                }
                case 2: {
                    parcel.enforceInterface(DESCRIPTOR);
                    int n3 = this.copyPackage(parcel.readString(), IParcelFileDescriptorFactory.Stub.asInterface(parcel.readStrongBinder()));
                    parcel2.writeNoException();
                    parcel2.writeInt(n3);
                    return true;
                }
                case 3: {
                    parcel.enforceInterface(DESCRIPTOR);
                    PackageInfoLite packageInfoLite = this.getMinimalPackageInfo(parcel.readString(), parcel.readInt(), parcel.readString());
                    parcel2.writeNoException();
                    if (packageInfoLite != null) {
                        parcel2.writeInt(1);
                        packageInfoLite.writeToParcel(parcel2, 1);
                        return true;
                    }
                    parcel2.writeInt(0);
                    return true;
                }
                case 4: {
                    parcel.enforceInterface(DESCRIPTOR);
                    ObbInfo obbInfo = this.getObbInfo(parcel.readString());
                    parcel2.writeNoException();
                    if (obbInfo != null) {
                        parcel2.writeInt(1);
                        obbInfo.writeToParcel(parcel2, 1);
                        return true;
                    }
                    parcel2.writeInt(0);
                    return true;
                }
                case 5: {
                    parcel.enforceInterface(DESCRIPTOR);
                    long l = this.calculateDirectorySize(parcel.readString());
                    parcel2.writeNoException();
                    parcel2.writeLong(l);
                    return true;
                }
                case 6: {
                    parcel.enforceInterface(DESCRIPTOR);
                    long[] lArray = this.getFileSystemStats(parcel.readString());
                    parcel2.writeNoException();
                    parcel2.writeLongArray(lArray);
                    return true;
                }
                case 7: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.clearDirectory(parcel.readString());
                    parcel2.writeNoException();
                    return true;
                }
                case 8: {
                    parcel.enforceInterface(DESCRIPTOR);
                    String string6 = parcel.readString();
                    boolean bl = parcel.readInt() != 0;
                    long l = this.calculateInstalledSize(string6, bl, parcel.readString());
                    parcel2.writeNoException();
                    parcel2.writeLong(l);
                    return true;
                }
                case 9: {
                    parcel.enforceInterface(DESCRIPTOR);
                    int n4 = this.copyObbsToSecondaryStorage(parcel.readString());
                    parcel2.writeNoException();
                    parcel2.writeInt(n4);
                    return true;
                }
                case 10: {
                    parcel.enforceInterface(DESCRIPTOR);
                    int n5 = this.copyObbsToPrimaryStorage(parcel.readString());
                    parcel2.writeNoException();
                    parcel2.writeInt(n5);
                    return true;
                }
                case 11: {
                    parcel.enforceInterface(DESCRIPTOR);
                    int n6 = this.deleteObbsInPrimaryStorage(parcel.readString());
                    parcel2.writeNoException();
                    parcel2.writeInt(n6);
                    return true;
                }
                case 12: {
                    parcel.enforceInterface(DESCRIPTOR);
                    int n7 = this.deleteObbsInSecondaryStorage(parcel.readString());
                    parcel2.writeNoException();
                    parcel2.writeInt(n7);
                    return true;
                }
                case 13: {
                    parcel.enforceInterface(DESCRIPTOR);
                    boolean bl = this.isSecondaryExternalObbPackageDirectoryExists(parcel.readString());
                    parcel2.writeNoException();
                    int n8 = 0;
                    if (bl) {
                        n8 = 1;
                    }
                    parcel2.writeInt(n8);
                    return true;
                }
                case 14: 
            }
            parcel.enforceInterface(DESCRIPTOR);
            boolean bl = this.isExternalStorageAppObbDirectoryExists(parcel.readString());
            parcel2.writeNoException();
            int n9 = 0;
            if (bl) {
                n9 = 1;
            }
            parcel2.writeInt(n9);
            return true;
        }

        private static class Proxy
        implements IMediaContainerService {
            private IBinder mRemote;

            Proxy(IBinder iBinder) {
                this.mRemote = iBinder;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            @Override
            public long calculateDirectorySize(String string2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    this.mRemote.transact(5, parcel, parcel2, 0);
                    parcel2.readException();
                    long l = parcel2.readLong();
                    return l;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public long calculateInstalledSize(String string2, boolean bl, String string3) throws RemoteException {
                int n;
                Parcel parcel;
                Parcel parcel2;
                block4: {
                    parcel2 = Parcel.obtain();
                    parcel = Parcel.obtain();
                    parcel2.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel2.writeString(string2);
                    n = 0;
                    if (!bl) break block4;
                    n = 1;
                }
                try {
                    parcel2.writeInt(n);
                    parcel2.writeString(string3);
                    this.mRemote.transact(8, parcel2, parcel, 0);
                    parcel.readException();
                    long l = parcel.readLong();
                    return l;
                }
                finally {
                    parcel.recycle();
                    parcel2.recycle();
                }
            }

            @Override
            public void clearDirectory(String string2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    this.mRemote.transact(7, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public int copyObbsToPrimaryStorage(String string2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    this.mRemote.transact(10, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    return n;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public int copyObbsToSecondaryStorage(String string2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    this.mRemote.transact(9, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    return n;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public int copyPackage(String string2, IParcelFileDescriptorFactory iParcelFileDescriptorFactory) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    IBinder iBinder = iParcelFileDescriptorFactory != null ? iParcelFileDescriptorFactory.asBinder() : null;
                    parcel.writeStrongBinder(iBinder);
                    this.mRemote.transact(2, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    parcel2.recycle();
                    parcel.recycle();
                    return n;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public String copyPackageToContainer(String string2, String string3, String string4, boolean bl, boolean bl2, String string5) throws RemoteException {
                int n = 1;
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    parcel.writeString(string3);
                    parcel.writeString(string4);
                    int n2 = bl ? n : 0;
                    parcel.writeInt(n2);
                    if (!bl2) {
                        n = 0;
                    }
                    parcel.writeInt(n);
                    parcel.writeString(string5);
                    this.mRemote.transact(1, parcel, parcel2, 0);
                    parcel2.readException();
                    String string6 = parcel2.readString();
                    parcel2.recycle();
                    parcel.recycle();
                    return string6;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            @Override
            public int deleteObbsInPrimaryStorage(String string2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    this.mRemote.transact(11, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    return n;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public int deleteObbsInSecondaryStorage(String string2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    this.mRemote.transact(12, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    return n;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public long[] getFileSystemStats(String string2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    this.mRemote.transact(6, parcel, parcel2, 0);
                    parcel2.readException();
                    long[] lArray = parcel2.createLongArray();
                    return lArray;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public PackageInfoLite getMinimalPackageInfo(String string2, int n, String string3) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    parcel.writeInt(n);
                    parcel.writeString(string3);
                    this.mRemote.transact(3, parcel, parcel2, 0);
                    parcel2.readException();
                    PackageInfoLite packageInfoLite = parcel2.readInt() != 0 ? PackageInfoLite.CREATOR.createFromParcel(parcel2) : null;
                    return packageInfoLite;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public ObbInfo getObbInfo(String string2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    this.mRemote.transact(4, parcel, parcel2, 0);
                    parcel2.readException();
                    ObbInfo obbInfo = parcel2.readInt() != 0 ? ObbInfo.CREATOR.createFromParcel(parcel2) : null;
                    return obbInfo;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public boolean isExternalStorageAppObbDirectoryExists(String string2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    this.mRemote.transact(14, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    boolean bl = false;
                    if (n != 0) {
                        bl = true;
                    }
                    parcel2.recycle();
                    parcel.recycle();
                    return bl;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            @Override
            public boolean isSecondaryExternalObbPackageDirectoryExists(String string2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    this.mRemote.transact(13, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    boolean bl = false;
                    if (n != 0) {
                        bl = true;
                    }
                    parcel2.recycle();
                    parcel.recycle();
                    return bl;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }
        }
    }
}

