/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.content;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.pm.PackageParser;
import android.os.Environment;
import android.os.FileUtils;
import android.os.IBinder;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.storage.IMountService;
import android.os.storage.StorageManager;
import android.provider.Settings;
import android.util.Log;
import com.android.internal.content.NativeLibraryHelper;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Iterator;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import libcore.io.IoUtils;

public class PackageHelper {
    public static final int APP_INSTALL_AUTO = 0;
    public static final int APP_INSTALL_EXTERNAL = 2;
    public static final int APP_INSTALL_INTERNAL = 1;
    public static final int RECOMMEND_FAILED_ALREADY_EXISTS = -4;
    public static final int RECOMMEND_FAILED_INSUFFICIENT_STORAGE = -1;
    public static final int RECOMMEND_FAILED_INVALID_APK = -2;
    public static final int RECOMMEND_FAILED_INVALID_LOCATION = -3;
    public static final int RECOMMEND_FAILED_INVALID_URI = -6;
    public static final int RECOMMEND_FAILED_VERSION_DOWNGRADE = -7;
    public static final int RECOMMEND_INSTALL_EXTERNAL = 2;
    public static final int RECOMMEND_INSTALL_INTERNAL = 1;
    public static final int RECOMMEND_MEDIA_UNAVAILABLE = -5;
    private static final String TAG = "PackageHelper";
    private static final boolean localLOGV;

    public static boolean bindObb(String string2, Boolean bl) {
        block4: {
            int n;
            if (string2 == null) {
                Log.e(TAG, "Unknow package name: " + string2);
                return false;
            }
            try {
                n = PackageHelper.getMountService().bindObb(string2, bl);
                if (n == 0) break block4;
            }
            catch (RemoteException remoteException) {
                Log.e(TAG, "MountService running?");
                return false;
            }
            Log.e(TAG, "Failed to bind " + string2 + " with rc " + n);
            return false;
        }
        return true;
    }

    public static long calculateInstalledSize(PackageParser.PackageLite packageLite, NativeLibraryHelper.Handle handle, boolean bl, String string2) throws IOException {
        long l = 0L;
        Iterator<String> iterator = packageLite.getAllCodePaths().iterator();
        while (iterator.hasNext()) {
            File file = new File(iterator.next());
            l += file.length();
            if (!bl) continue;
            l += PackageHelper.extractPublicFiles(file, null);
        }
        return l + 2L * NativeLibraryHelper.sumNativeBinariesWithOverride(handle, string2);
    }

    public static long calculateInstalledSize(PackageParser.PackageLite packageLite, boolean bl, String string2) throws IOException {
        NativeLibraryHelper.Handle handle = null;
        try {
            handle = NativeLibraryHelper.Handle.create(packageLite);
            long l = PackageHelper.calculateInstalledSize(packageLite, handle, bl, string2);
            return l;
        }
        finally {
            IoUtils.closeQuietly((AutoCloseable)handle);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void copyZipEntry(ZipEntry zipEntry, ZipFile zipFile, ZipOutputStream zipOutputStream) throws IOException {
        byte[] byArray = new byte[4096];
        ZipEntry zipEntry2 = zipEntry.getMethod() == 0 ? new ZipEntry(zipEntry) : new ZipEntry(zipEntry.getName());
        zipOutputStream.putNextEntry(zipEntry2);
        InputStream inputStream = zipFile.getInputStream(zipEntry);
        try {
            int n;
            while ((n = inputStream.read(byArray)) > 0) {
                zipOutputStream.write(byArray, 0, n);
            }
            zipOutputStream.flush();
            return;
        }
        finally {
            IoUtils.closeQuietly((AutoCloseable)inputStream);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String createSdDir(long l, String string2, String string3, int n, boolean bl) {
        int n2 = l > 0L ? 1 + (int)((0x100000L + l) / 0x100000L) : 51;
        try {
            IMountService iMountService = PackageHelper.getMountService();
            if (iMountService.createSecureContainer(string2, n2, "ext4", string3, n, bl) == 0) return iMountService.getSecureContainerPath(string2);
            Log.e(TAG, "Failed to create secure container " + string2);
            return null;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "MountService running?");
            return null;
        }
    }

    public static boolean destroySdDir(String string2) {
        try {
            if (PackageHelper.getMountService().destroySecureContainer(string2, true) != 0) {
                Log.i(TAG, "Failed to destroy container " + string2);
                return false;
            }
            return true;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "Failed to destroy container " + string2 + " with exception " + remoteException);
            return false;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static long extractPublicFiles(File var0, File var1_1) throws IOException {
        if (var1_1 == null) {
            var2_2 = null;
            var3_3 = null;
        } else {
            var2_2 = new FileOutputStream(var1_1);
            var3_3 = new ZipOutputStream(var2_2);
            Log.d("PackageHelper", "Extracting " + var0 + " to " + var1_1);
        }
        var5_4 = 0L;
        var7_5 = new ZipFile(var0.getAbsolutePath());
        try {
            for (ZipEntry var15_8 : Collections.list(var7_5.entries())) {
                var16_7 = var15_8.getName();
                if (!"AndroidManifest.xml".equals(var16_7) && !"resources.arsc".equals(var16_7) && !var16_7.startsWith("res/")) continue;
                var5_4 += var15_8.getSize();
                if (var1_1 == null) continue;
                PackageHelper.copyZipEntry(var15_8, var7_5, var3_3);
            }
            ** GOTO lbl-1000
        }
        catch (Throwable var8_9) {
            try {}
            catch (IOException var9_12) {
                throw var8_9;
            }
            ** GOTO lbl42
            {
                block13: {
                    catch (Throwable var10_10) {
                        IoUtils.closeQuietly((AutoCloseable)var3_3);
                        throw var10_10;
                    }
lbl-1000:
                    // 1 sources

                    {
                        var7_5.close();
                        if (var1_1 == null) break block13;
                    }
                    var3_3.finish();
                    var3_3.flush();
                    FileUtils.sync(var2_2);
                    var3_3.close();
                    FileUtils.setPermissions(var1_1.getAbsolutePath(), 420, -1, -1);
                }
                IoUtils.closeQuietly((AutoCloseable)var3_3);
                return var5_4;
lbl42:
                // 1 sources

                var7_5.close();
                throw var8_9;
            }
        }
    }

    public static boolean finalizeSdDir(String string2) {
        try {
            if (PackageHelper.getMountService().finalizeSecureContainer(string2) != 0) {
                Log.i(TAG, "Failed to finalize container " + string2);
                return false;
            }
            return true;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "Failed to finalize container " + string2 + " with exception " + remoteException);
            return false;
        }
    }

    public static boolean fixSdPermissions(String string2, int n, String string3) {
        try {
            if (PackageHelper.getMountService().fixPermissionsSecureContainer(string2, n, string3) != 0) {
                Log.i(TAG, "Failed to fixperms container " + string2);
                return false;
            }
            return true;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "Failed to fixperms container " + string2 + " with exception " + remoteException);
            return false;
        }
    }

    public static IMountService getMountService() throws RemoteException {
        IBinder iBinder = ServiceManager.getService("mount");
        if (iBinder != null) {
            return IMountService.Stub.asInterface(iBinder);
        }
        Log.e(TAG, "Can't get mount service");
        throw new RemoteException("Could not contact mount service");
    }

    public static String getSdDir(String string2) {
        try {
            String string3 = PackageHelper.getMountService().getSecureContainerPath(string2);
            return string3;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "Failed to get container path for " + string2 + " with exception " + remoteException);
            return null;
        }
    }

    public static String getSdFilesystem(String string2) {
        try {
            String string3 = PackageHelper.getMountService().getSecureContainerFilesystemPath(string2);
            return string3;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "Failed to get container path for " + string2 + " with exception " + remoteException);
            return null;
        }
    }

    public static String[] getSecureContainerList() {
        try {
            String[] stringArray = PackageHelper.getMountService().getSecureContainerList();
            return stringArray;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "Failed to get secure container list with exception" + remoteException);
            return null;
        }
    }

    public static boolean isContainerMounted(String string2) {
        try {
            boolean bl = PackageHelper.getMountService().isSecureContainerMounted(string2);
            return bl;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "Failed to find out if container " + string2 + " mounted");
            return false;
        }
    }

    public static String mountSdDir(String string2, String string3, int n) {
        return PackageHelper.mountSdDir(string2, string3, n, true);
    }

    public static String mountSdDir(String string2, String string3, int n, boolean bl) {
        block4: {
            int n2;
            try {
                n2 = PackageHelper.getMountService().mountSecureContainer(string2, string3, n, bl);
                if (n2 == 0) break block4;
            }
            catch (RemoteException remoteException) {
                Log.e(TAG, "MountService running?");
                return null;
            }
            Log.i(TAG, "Failed to mount container " + string2 + " rc : " + n2);
            return null;
        }
        String string4 = PackageHelper.getMountService().getSecureContainerPath(string2);
        return string4;
    }

    public static boolean renameSdDir(String string2, String string3) {
        block3: {
            int n;
            try {
                n = PackageHelper.getMountService().renameSecureContainer(string2, string3);
                if (n == 0) break block3;
            }
            catch (RemoteException remoteException) {
                Log.i(TAG, "Failed ot rename  " + string2 + " to " + string3 + " with exception : " + remoteException);
                return false;
            }
            Log.e(TAG, "Failed to rename " + string2 + " to " + string3 + "with rc " + n);
            return false;
        }
        return true;
    }

    public static String replaceEnd(String string2, String string3, String string4) {
        if (!string2.endsWith(string3)) {
            throw new IllegalArgumentException("Expected " + string2 + " to end with " + string3);
        }
        return string2.substring(0, string2.length() - string3.length()) + string4;
    }

    public static boolean resizeSdDir(long l, String string2, String string3) {
        int n = 1 + (int)((l + 0x100000L) / 0x100000L);
        try {
            int n2 = PackageHelper.getMountService().resizeSecureContainer(string2, n, string3);
            if (n2 == 0) {
                return true;
            }
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "MountService running?");
        }
        Log.e(TAG, "Failed to create secure container " + string2);
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int resolveInstallLocation(Context context, String string2, int n, long l, int n2) {
        boolean bl;
        boolean bl2;
        boolean bl3;
        boolean bl4;
        int n3;
        block35: {
            StorageManager storageManager;
            block36: {
                block34: {
                    block33: {
                        ApplicationInfo applicationInfo;
                        try {
                            ApplicationInfo applicationInfo2;
                            applicationInfo = applicationInfo2 = context.getPackageManager().getApplicationInfo(string2, 8192);
                        }
                        catch (PackageManager.NameNotFoundException nameNotFoundException) {
                            applicationInfo = null;
                        }
                        int n4 = Settings.Global.getInt(context.getContentResolver(), "default_install_location", 0);
                        if ((n2 & 0x10) != 0) {
                            n3 = 1;
                            bl4 = false;
                        } else if ((n2 & 8) != 0 && (n == 0 || n == 2)) {
                            Log.i(TAG, ">RECOMMEND_INSTALL_EXTERNAL");
                            n3 = 2;
                            bl4 = false;
                        } else if (n == 1) {
                            n3 = 1;
                            bl4 = false;
                        } else if (n == 2) {
                            if (n4 == 2) {
                                Log.i(TAG, ">RECOMMEND_INSTALL_EXTERNAL");
                                n3 = 2;
                                bl4 = true;
                            } else {
                                n3 = 1;
                                bl4 = false;
                            }
                        } else if (n == 0) {
                            n3 = applicationInfo != null ? ((0x40000 & applicationInfo.flags) != 0 ? 2 : 1) : (n4 == 2 ? 2 : 1);
                            bl4 = true;
                        } else {
                            n3 = 1;
                            bl4 = false;
                        }
                        bl3 = Environment.getSecondaryExternalStorageState().equals("mounted");
                        storageManager = StorageManager.from(context);
                        if (bl4) break block33;
                        bl2 = false;
                        if (n3 != 1) break block34;
                    }
                    bl2 = l <= storageManager.getStorageBytesUntilLow(Environment.getDataDirectory());
                }
                bl = false;
                if (!bl3) break block35;
                if (bl4) break block36;
                bl = false;
                if (n3 != 2) break block35;
            }
            bl = l <= storageManager.getStorageBytesUntilLow(Environment.getSecondaryExternalStorageDirectory());
        }
        if (n3 == 1) {
            if (bl2) {
                return 1;
            }
        } else if (bl3 && n3 == 2 && bl) {
            Log.i(TAG, "return RECOMMEND_INSTALL_EXTERNAL (fitsOnExt)");
            return 2;
        }
        if (bl4) {
            if (bl2) {
                return 1;
            }
            if (bl3 && bl) {
                Log.i(TAG, "return RECOMMEND_INSTALL_EXTERNAL (checkBoth)");
                return 2;
            }
        }
        if (bl3 && (bl4 || n3 == 2) && !"mounted".equals(Environment.getExternalStorageState())) {
            return -5;
        }
        return -1;
    }

    public static boolean unMountSdDir(String string2) {
        block3: {
            int n;
            try {
                n = PackageHelper.getMountService().unmountSecureContainer(string2, true);
                if (n == 0) break block3;
            }
            catch (RemoteException remoteException) {
                Log.e(TAG, "MountService running?");
                return false;
            }
            Log.e(TAG, "Failed to unmount " + string2 + " with rc " + n);
            return false;
        }
        return true;
    }

    public static boolean unbindObb(String string2, Boolean bl) {
        block4: {
            int n;
            if (string2 == null) {
                Log.e(TAG, "Unknow package name: " + string2);
                return false;
            }
            try {
                n = PackageHelper.getMountService().unbindObb(string2, bl);
                if (n == 0) break block4;
            }
            catch (RemoteException remoteException) {
                Log.e(TAG, "MountService running?");
                return false;
            }
            Log.e(TAG, "Failed to unbind " + string2 + " with rc " + n);
            return false;
        }
        return true;
    }
}

