/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.inputmethod;

import android.content.Context;
import android.content.pm.PackageManager;
import android.text.TextUtils;
import android.view.inputmethod.InputMethodInfo;
import android.view.inputmethod.InputMethodSubtype;
import com.android.internal.inputmethod.InputMethodUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.TreeMap;

public class InputMethodSubtypeSwitchingController {
    private static final boolean DEBUG = false;
    private static final int NOT_A_SUBTYPE_ID = -1;
    private static final String TAG = InputMethodSubtypeSwitchingController.class.getSimpleName();
    private ControllerImpl mController;
    private final InputMethodUtils.InputMethodSettings mSettings;
    private InputMethodAndSubtypeList mSubtypeList;

    private InputMethodSubtypeSwitchingController(InputMethodUtils.InputMethodSettings inputMethodSettings, Context context) {
        this.mSettings = inputMethodSettings;
        this.resetCircularListLocked(context);
    }

    private static int calculateSubtypeId(InputMethodInfo inputMethodInfo, InputMethodSubtype inputMethodSubtype) {
        if (inputMethodSubtype != null) {
            return InputMethodUtils.getSubtypeIdFromHashCode(inputMethodInfo, inputMethodSubtype.hashCode());
        }
        return -1;
    }

    public static InputMethodSubtypeSwitchingController createInstanceLocked(InputMethodUtils.InputMethodSettings inputMethodSettings, Context context) {
        return new InputMethodSubtypeSwitchingController(inputMethodSettings, context);
    }

    public ImeSubtypeListItem getNextInputMethodLocked(boolean bl, InputMethodInfo inputMethodInfo, InputMethodSubtype inputMethodSubtype) {
        if (this.mController == null) {
            return null;
        }
        return this.mController.getNextInputMethod(bl, inputMethodInfo, inputMethodSubtype);
    }

    public List<ImeSubtypeListItem> getSortedInputMethodAndSubtypeListLocked(boolean bl, boolean bl2, boolean bl3) {
        return this.mSubtypeList.getSortedInputMethodAndSubtypeList(bl, bl2, bl3);
    }

    public void onUserActionLocked(InputMethodInfo inputMethodInfo, InputMethodSubtype inputMethodSubtype) {
        if (this.mController == null) {
            return;
        }
        this.mController.onUserActionLocked(inputMethodInfo, inputMethodSubtype);
    }

    public void resetCircularListLocked(Context context) {
        this.mSubtypeList = new InputMethodAndSubtypeList(context, this.mSettings);
        this.mController = ControllerImpl.createFrom(this.mController, this.mSubtypeList.getSortedInputMethodAndSubtypeList());
    }

    public static class ControllerImpl {
        private final DynamicRotationList mSwitchingAwareRotationList;
        private final StaticRotationList mSwitchingUnawareRotationList;

        private ControllerImpl(DynamicRotationList dynamicRotationList, StaticRotationList staticRotationList) {
            this.mSwitchingAwareRotationList = dynamicRotationList;
            this.mSwitchingUnawareRotationList = staticRotationList;
        }

        public static ControllerImpl createFrom(ControllerImpl controllerImpl, List<ImeSubtypeListItem> list) {
            List<ImeSubtypeListItem> list2 = ControllerImpl.filterImeSubtypeList(list, true);
            DynamicRotationList dynamicRotationList = null;
            if (controllerImpl != null) {
                DynamicRotationList dynamicRotationList2 = controllerImpl.mSwitchingAwareRotationList;
                dynamicRotationList = null;
                if (dynamicRotationList2 != null) {
                    boolean bl = Objects.equals(controllerImpl.mSwitchingAwareRotationList.mImeSubtypeList, list2);
                    dynamicRotationList = null;
                    if (bl) {
                        dynamicRotationList = controllerImpl.mSwitchingAwareRotationList;
                    }
                }
            }
            if (dynamicRotationList == null) {
                dynamicRotationList = new DynamicRotationList(list2);
            }
            List<ImeSubtypeListItem> list3 = ControllerImpl.filterImeSubtypeList(list, false);
            StaticRotationList staticRotationList = null;
            if (controllerImpl != null) {
                StaticRotationList staticRotationList2 = controllerImpl.mSwitchingUnawareRotationList;
                staticRotationList = null;
                if (staticRotationList2 != null) {
                    boolean bl = Objects.equals(controllerImpl.mSwitchingUnawareRotationList.mImeSubtypeList, list3);
                    staticRotationList = null;
                    if (bl) {
                        staticRotationList = controllerImpl.mSwitchingUnawareRotationList;
                    }
                }
            }
            if (staticRotationList == null) {
                staticRotationList = new StaticRotationList(list3);
            }
            return new ControllerImpl(dynamicRotationList, staticRotationList);
        }

        private static List<ImeSubtypeListItem> filterImeSubtypeList(List<ImeSubtypeListItem> list, boolean bl) {
            ArrayList<ImeSubtypeListItem> arrayList = new ArrayList<ImeSubtypeListItem>();
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                ImeSubtypeListItem imeSubtypeListItem = list.get(i);
                if (imeSubtypeListItem.mImi.supportsSwitchingToNextInputMethod() != bl) continue;
                arrayList.add(imeSubtypeListItem);
            }
            return arrayList;
        }

        public ImeSubtypeListItem getNextInputMethod(boolean bl, InputMethodInfo inputMethodInfo, InputMethodSubtype inputMethodSubtype) {
            if (inputMethodInfo == null) {
                return null;
            }
            if (inputMethodInfo.supportsSwitchingToNextInputMethod()) {
                return this.mSwitchingAwareRotationList.getNextInputMethodLocked(bl, inputMethodInfo, inputMethodSubtype);
            }
            return this.mSwitchingUnawareRotationList.getNextInputMethodLocked(bl, inputMethodInfo, inputMethodSubtype);
        }

        /*
         * Enabled aggressive block sorting
         */
        public void onUserActionLocked(InputMethodInfo inputMethodInfo, InputMethodSubtype inputMethodSubtype) {
            if (inputMethodInfo == null || !inputMethodInfo.supportsSwitchingToNextInputMethod()) {
                return;
            }
            this.mSwitchingAwareRotationList.onUserAction(inputMethodInfo, inputMethodSubtype);
        }
    }

    private static class DynamicRotationList {
        private static final String TAG = DynamicRotationList.class.getSimpleName();
        private final List<ImeSubtypeListItem> mImeSubtypeList;
        private final int[] mUsageHistoryOfSubtypeListItemIndex;

        private DynamicRotationList(List<ImeSubtypeListItem> list) {
            this.mImeSubtypeList = list;
            this.mUsageHistoryOfSubtypeListItemIndex = new int[this.mImeSubtypeList.size()];
            int n = this.mImeSubtypeList.size();
            for (int i = 0; i < n; ++i) {
                this.mUsageHistoryOfSubtypeListItemIndex[i] = i;
            }
        }

        private int getUsageRank(InputMethodInfo inputMethodInfo, InputMethodSubtype inputMethodSubtype) {
            int n = InputMethodSubtypeSwitchingController.calculateSubtypeId(inputMethodInfo, inputMethodSubtype);
            int n2 = this.mUsageHistoryOfSubtypeListItemIndex.length;
            for (int i = 0; i < n2; ++i) {
                int n3 = this.mUsageHistoryOfSubtypeListItemIndex[i];
                ImeSubtypeListItem imeSubtypeListItem = this.mImeSubtypeList.get(n3);
                if (!imeSubtypeListItem.mImi.equals(inputMethodInfo) || imeSubtypeListItem.mSubtypeId != n) continue;
                return i;
            }
            return -1;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public ImeSubtypeListItem getNextInputMethodLocked(boolean bl, InputMethodInfo inputMethodInfo, InputMethodSubtype inputMethodSubtype) {
            int n = this.getUsageRank(inputMethodInfo, inputMethodSubtype);
            if (n < 0) {
                return null;
            }
            int n2 = this.mUsageHistoryOfSubtypeListItemIndex.length;
            int n3 = 1;
            while (n3 < n2) {
                int n4 = (n + n3) % n2;
                int n5 = this.mUsageHistoryOfSubtypeListItemIndex[n4];
                ImeSubtypeListItem imeSubtypeListItem = this.mImeSubtypeList.get(n5);
                if (!bl) return imeSubtypeListItem;
                if (inputMethodInfo.equals(imeSubtypeListItem.mImi)) return imeSubtypeListItem;
                ++n3;
            }
            return null;
        }

        public void onUserAction(InputMethodInfo inputMethodInfo, InputMethodSubtype inputMethodSubtype) {
            int n = this.getUsageRank(inputMethodInfo, inputMethodSubtype);
            if (n <= 0) {
                return;
            }
            int n2 = this.mUsageHistoryOfSubtypeListItemIndex[n];
            System.arraycopy((int[])this.mUsageHistoryOfSubtypeListItemIndex, (int)0, (int[])this.mUsageHistoryOfSubtypeListItemIndex, (int)1, (int)n);
            this.mUsageHistoryOfSubtypeListItemIndex[0] = n2;
        }
    }

    public static class ImeSubtypeListItem
    implements Comparable<ImeSubtypeListItem> {
        public final CharSequence mImeName;
        public final InputMethodInfo mImi;
        public final boolean mIsSystemLanguage;
        public final boolean mIsSystemLocale;
        public final int mSubtypeId;
        public final CharSequence mSubtypeName;

        /*
         * Enabled aggressive block sorting
         */
        public ImeSubtypeListItem(CharSequence charSequence, CharSequence charSequence2, InputMethodInfo inputMethodInfo, int n, String string2, String string3) {
            boolean bl = true;
            this.mImeName = charSequence;
            this.mSubtypeName = charSequence2;
            this.mImi = inputMethodInfo;
            this.mSubtypeId = n;
            if (TextUtils.isEmpty(string2)) {
                this.mIsSystemLocale = false;
                this.mIsSystemLanguage = false;
                return;
            }
            this.mIsSystemLocale = string2.equals(string3);
            if (this.mIsSystemLocale) {
                this.mIsSystemLanguage = bl;
                return;
            }
            String string4 = ImeSubtypeListItem.parseLanguageFromLocaleString(string3);
            String string5 = ImeSubtypeListItem.parseLanguageFromLocaleString(string2);
            if (string4.length() < 2 || !string4.equals(string5)) {
                bl = false;
            }
            this.mIsSystemLanguage = bl;
        }

        private static String parseLanguageFromLocaleString(String string2) {
            int n = string2.indexOf(95);
            if (n < 0) {
                return string2;
            }
            return string2.substring(0, n);
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public int compareTo(ImeSubtypeListItem imeSubtypeListItem) {
            block10: {
                block9: {
                    if (TextUtils.isEmpty(this.mImeName)) break block9;
                    if (TextUtils.isEmpty(imeSubtypeListItem.mImeName)) {
                        return -1;
                    }
                    if (!TextUtils.equals(this.mImeName, imeSubtypeListItem.mImeName)) {
                        return this.mImeName.toString().compareTo(imeSubtypeListItem.mImeName.toString());
                    }
                    if (TextUtils.equals(this.mSubtypeName, imeSubtypeListItem.mSubtypeName)) {
                        return 0;
                    }
                    if (this.mIsSystemLocale) {
                        return -1;
                    }
                    if (imeSubtypeListItem.mIsSystemLocale) break block9;
                    if (this.mIsSystemLanguage) {
                        return -1;
                    }
                    if (!imeSubtypeListItem.mIsSystemLanguage && !TextUtils.isEmpty(this.mSubtypeName)) break block10;
                }
                return 1;
            }
            if (TextUtils.isEmpty(imeSubtypeListItem.mSubtypeName)) {
                return -1;
            }
            return this.mSubtypeName.toString().compareTo(imeSubtypeListItem.mSubtypeName.toString());
        }

        /*
         * Enabled aggressive block sorting
         */
        public boolean equals(Object object) {
            block6: {
                block5: {
                    if (object == this) break block5;
                    if (!(object instanceof ImeSubtypeListItem)) {
                        return false;
                    }
                    ImeSubtypeListItem imeSubtypeListItem = (ImeSubtypeListItem)object;
                    if (!Objects.equals(this.mImi, imeSubtypeListItem.mImi)) {
                        return false;
                    }
                    if (this.mSubtypeId != imeSubtypeListItem.mSubtypeId) break block6;
                }
                return true;
            }
            return false;
        }

        public String toString() {
            return "ImeSubtypeListItem{mImeName=" + this.mImeName + " mSubtypeName=" + this.mSubtypeName + " mSubtypeId=" + this.mSubtypeId + " mIsSystemLocale=" + this.mIsSystemLocale + " mIsSystemLanguage=" + this.mIsSystemLanguage + "}";
        }
    }

    private static class InputMethodAndSubtypeList {
        private final Context mContext;
        private final PackageManager mPm;
        private final InputMethodUtils.InputMethodSettings mSettings;
        private final TreeMap<InputMethodInfo, List<InputMethodSubtype>> mSortedImmis = new TreeMap(new Comparator<InputMethodInfo>(){

            @Override
            public int compare(InputMethodInfo inputMethodInfo, InputMethodInfo inputMethodInfo2) {
                if (inputMethodInfo2 == null) {
                    return 0;
                }
                if (inputMethodInfo == null) {
                    return 1;
                }
                if (InputMethodAndSubtypeList.this.mPm == null) {
                    return inputMethodInfo.getId().compareTo(inputMethodInfo2.getId());
                }
                String string2 = inputMethodInfo.loadLabel(InputMethodAndSubtypeList.this.mPm) + "/" + inputMethodInfo.getId();
                String string3 = inputMethodInfo2.loadLabel(InputMethodAndSubtypeList.this.mPm) + "/" + inputMethodInfo2.getId();
                return string2.toString().compareTo(string3.toString());
            }
        });
        private final String mSystemLocaleStr;

        /*
         * Enabled aggressive block sorting
         */
        public InputMethodAndSubtypeList(Context context, InputMethodUtils.InputMethodSettings inputMethodSettings) {
            this.mContext = context;
            this.mSettings = inputMethodSettings;
            this.mPm = context.getPackageManager();
            Locale locale = context.getResources().getConfiguration().locale;
            String string2 = locale != null ? locale.toString() : "";
            this.mSystemLocaleStr = string2;
        }

        public List<ImeSubtypeListItem> getSortedInputMethodAndSubtypeList() {
            return this.getSortedInputMethodAndSubtypeList(true, false, false);
        }

        /*
         * Unable to fully structure code
         */
        public List<ImeSubtypeListItem> getSortedInputMethodAndSubtypeList(boolean var1_1, boolean var2_2, boolean var3_3) {
            var4_4 = new ArrayList<ImeSubtypeListItem>();
            var5_5 = this.mSettings.getExplicitlyOrImplicitlyEnabledInputMethodsAndSubtypeListLocked(this.mContext);
            if (var5_5 == null || var5_5.size() == 0) {
                return Collections.emptyList();
            }
            this.mSortedImmis.clear();
            this.mSortedImmis.putAll(var5_5);
            for (InputMethodInfo var7_7 : this.mSortedImmis.keySet()) {
                if (var7_7 == null) continue;
                var8_8 = var5_5.get(var7_7);
                var9_9 = new HashSet<String>();
                var10_10 = var8_8.iterator();
                while (var10_10.hasNext()) {
                    var9_9.add(String.valueOf(var10_10.next().hashCode()));
                }
                var11_11 = var7_7.loadLabel(this.mPm);
                if (var1_1 && var9_9.size() > 0) {
                    var13_12 = var7_7.getSubtypeCount();
                    block2: for (var14_13 = 0; var14_13 < var13_12; ++var14_13) {
                        var15_14 = var7_7.getSubtypeAt(var14_13);
                        var16_15 = String.valueOf(var15_14.hashCode());
                        if (!var9_9.contains(var16_15) || (!var2_2 || var3_3) && var15_14.isAuxiliary()) continue;
                        if (var15_14.overridesImplicitlyEnabledSubtype()) {
                            var17_16 = null;
lbl25:
                            // 2 sources

                            while (true) {
                                var4_4.add(new ImeSubtypeListItem(var11_11, var17_16, var7_7, var14_13, var15_14.getLocale(), this.mSystemLocaleStr));
                                var9_9.remove(var16_15);
                                continue block2;
                                break;
                            }
                        }
                        var17_16 = var15_14.getDisplayName(this.mContext, var7_7.getPackageName(), var7_7.getServiceInfo().applicationInfo);
                        ** continue;
                    }
                    continue;
                }
                var4_4.add(new ImeSubtypeListItem(var11_11, null, var7_7, -1, null, this.mSystemLocaleStr));
            }
            Collections.sort(var4_4);
            return var4_4;
        }
    }

    private static class StaticRotationList {
        private final List<ImeSubtypeListItem> mImeSubtypeList;

        public StaticRotationList(List<ImeSubtypeListItem> list) {
            this.mImeSubtypeList = list;
        }

        private int getIndex(InputMethodInfo inputMethodInfo, InputMethodSubtype inputMethodSubtype) {
            int n = InputMethodSubtypeSwitchingController.calculateSubtypeId(inputMethodInfo, inputMethodSubtype);
            int n2 = this.mImeSubtypeList.size();
            for (int i = 0; i < n2; ++i) {
                ImeSubtypeListItem imeSubtypeListItem = this.mImeSubtypeList.get(i);
                if (!inputMethodInfo.equals(imeSubtypeListItem.mImi) || imeSubtypeListItem.mSubtypeId != n) continue;
                return i;
            }
            return -1;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public ImeSubtypeListItem getNextInputMethodLocked(boolean bl, InputMethodInfo inputMethodInfo, InputMethodSubtype inputMethodSubtype) {
            if (inputMethodInfo == null) {
                return null;
            }
            if (this.mImeSubtypeList.size() <= 1) {
                return null;
            }
            int n = this.getIndex(inputMethodInfo, inputMethodSubtype);
            if (n < 0) {
                return null;
            }
            int n2 = this.mImeSubtypeList.size();
            int n3 = 1;
            while (n3 < n2) {
                int n4 = (n + n3) % n2;
                ImeSubtypeListItem imeSubtypeListItem = this.mImeSubtypeList.get(n4);
                if (!bl) return imeSubtypeListItem;
                if (inputMethodInfo.equals(imeSubtypeListItem.mImi)) return imeSubtypeListItem;
                ++n3;
            }
            return null;
        }
    }
}

